/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.IMachineContext;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.code.asm.simulator.ICodeResolver;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorVariant;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.concurrent.SafeLockImpl;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

@Ser
public abstract class AbstractProcessor<InsnType extends IInstruction>
implements IProcessor<InsnType> {
    @SerId(value=1)
    private SafeLockImpl lock = new SafeLockImpl();
    @SerId(value=2)
    private int parseCacheLength;
    @SerId(value=3)
    private Endianness endianness;
    @SerId(value=4)
    private int instructionAlignmentMask;
    @SerId(value=5)
    protected Collection<Integer> supportedModes = new HashSet<Integer>();
    @SerId(value=6)
    protected int defaultMode;
    @SerId(value=7)
    protected int mode;
    @SerId(value=8)
    protected Collection<ProcessorVariant> supportedVariants = new ArrayList<ProcessorVariant>();
    @SerId(value=9)
    protected ProcessorVariant variant;
    @SerId(value=10)
    private int parseBufferBefore = 0;

    public AbstractProcessor(int n2, int n3, Endianness endianness, int n4) {
        this.parseCacheLength = n2;
        this.setDefaultMode(n3);
        this.setEndianness(endianness);
        this.setInstructionAlignment(n4);
    }

    public AbstractProcessor(int n2, int n3, IUnitCreator iUnitCreator, int n4) {
        this(n2, n3, iUnitCreator, n4, 0);
    }

    public AbstractProcessor(int n2, int n3, IUnitCreator iUnitCreator, int n4, int n5) {
        this.parseCacheLength = n2;
        this.parseBufferBefore = n5;
        this.setDefaultMode(n3);
        IUnitCreator iUnitCreator2 = iUnitCreator;
        while (iUnitCreator2 != null) {
            if (iUnitCreator instanceof ICodeObjectUnit) {
                this.setEndianness(((ICodeObjectUnit)iUnitCreator2).getLoaderInformation().getEndianness());
                break;
            }
            if (iUnitCreator instanceof INativeCodeUnit) {
                this.setEndianness(((INativeCodeUnit)iUnitCreator2).getEndianness());
                break;
            }
            if (iUnitCreator2 instanceof IUnit) {
                iUnitCreator2 = ((IUnit)iUnitCreator2).getParent();
                continue;
            }
            iUnitCreator2 = null;
        }
        if (this.getEndianness() == null) {
            this.setEndianness(Endianness.LITTLE_ENDIAN);
        }
        this.setInstructionAlignment(n4);
    }

    @Override
    public String getRegisterName(long l2) {
        try {
            RegisterDescriptionEntry registerDescriptionEntry;
            IRegisterBank iRegisterBank = this.getRegisterBank();
            if (iRegisterBank != null && (registerDescriptionEntry = iRegisterBank.getDescriptionEntryById(l2)) != null) {
                return registerDescriptionEntry.getName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    public InsnType parseAt(IVirtualMemory iVirtualMemory, long l2) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            InsnType InsnType;
            if ((l2 & (long)this.instructionAlignmentMask) != 0L) {
                throw new ProcessorException(Strings.ff("Instruction is not aligned at address %Xh", l2));
            }
            int n2 = this.parseBufferBefore;
            byte[] byArray = new byte[this.parseCacheLength + n2];
            int n3 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2 - (long)n2, byArray.length, byArray, 0, 5);
            if (n3 <= 0 && this.parseBufferBefore != 0) {
                n2 = 0;
                byArray = new byte[this.parseCacheLength];
                n3 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, byArray.length, byArray, 0, 5);
            }
            if (n3 <= 0) {
                throw new ProcessorException(Strings.ff("Cannot read instruction bytes at address %Xh", l2));
            }
            try {
                InsnType = this.parseAtInternal(byArray, n2, n3);
            }
            catch (Exception exception) {
                try {
                    int n4 = Math.min(8, n3);
                    String string = Formatter.byteArrayToHexString(byArray, n2, n2 + n4);
                    throw new ProcessorException("Failed parsing for bytes: " + string, exception);
                }
                catch (Exception exception2) {
                    throw new ProcessorException("Failed parsing, more errors: " + exception2.getMessage(), exception);
                }
            }
            return InsnType;
        }
    }

    @Override
    public final InsnType parseAt(byte[] byArray, int n2, int n3) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            InsnType InsnType = this.parseAtInternal(byArray, n2, n3);
            return InsnType;
        }
    }

    protected abstract InsnType parseAtInternal(byte[] var1, int var2, int var3) throws ProcessorException;

    @Override
    public InsnType parseWithContext(IMachineContext iMachineContext) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            InsnType InsnType = this.parseWithContextInternal(iMachineContext);
            return InsnType;
        }
    }

    protected InsnType parseWithContextInternal(IMachineContext iMachineContext) throws ProcessorException {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    @Override
    public ProcessorType getType() {
        return ProcessorType.UNKNOWN;
    }

    @Override
    public IRegisterBank getRegisterBank() {
        return RegisterUtil.getBank(this.getType());
    }

    @Override
    public boolean isRISC() {
        return false;
    }

    @Override
    public Collection<ProcessorVariant> getSupportedVariants() {
        return this.supportedVariants;
    }

    @Override
    public ProcessorVariant getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(ProcessorVariant processorVariant) throws ProcessorException {
        try (ACLock aCLock = this.lock.rw();){
            if (processorVariant != null && !this.supportedVariants.contains(processorVariant)) {
                throw new ProcessorException("Unsupported variant: " + processorVariant);
            }
            this.variant = processorVariant;
        }
    }

    @Override
    public Collection<Integer> getSupportedModes() {
        return this.supportedModes;
    }

    @Override
    public final int getDefaultMode() {
        return this.defaultMode;
    }

    protected final void setDefaultMode(int n2) {
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid processor mode");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("The default processor mode cannot be unknown");
        }
        try (ACLock aCLock = this.lock.rw();){
            if (!this.supportedModes.contains(n2)) {
                this.supportedModes.add(n2);
            }
            this.defaultMode = n2;
            if (this.mode == 0) {
                try {
                    this.setMode(n2);
                }
                catch (ProcessorException processorException) {}
            }
        }
    }

    @Override
    public int getPCRegisterBitsize() {
        return this.defaultMode;
    }

    @Override
    public int getGPRegisterBitsize() {
        return this.defaultMode;
    }

    @Override
    public int setMode(int n2) throws ProcessorException {
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid processor mode");
        }
        try (ACLock aCLock = this.lock.rw();){
            int n3 = this.mode;
            if (n2 == 0) {
                this.mode = this.defaultMode;
            } else {
                if (!this.supportedModes.contains(n2)) {
                    throw new ProcessorException("Unsupported mode: " + n2);
                }
                this.mode = n2;
            }
            int n4 = n3;
            return n4;
        }
    }

    @Override
    public final int getMode() {
        return this.mode;
    }

    @Override
    public final Endianness getEndianness() {
        return this.endianness;
    }

    @Override
    public final void setEndianness(Endianness endianness) {
        if (endianness == null) {
            throw new NullPointerException("Endianness cannot be null");
        }
        try (ACLock aCLock = this.lock.rw();){
            this.endianness = endianness;
        }
    }

    @Override
    public final int getInstructionAlignment() {
        return this.instructionAlignmentMask + 1;
    }

    public int getInstructionAlignmentMask() {
        return this.instructionAlignmentMask;
    }

    @Override
    public final void setInstructionAlignment(int n2) {
        try (ACLock aCLock = this.lock.rw();){
            if (n2 <= 0 || (n2 & n2 - 1) != 0) {
                throw new IllegalArgumentException("Invalid instruction alignment: " + n2);
            }
            this.instructionAlignmentMask = n2 - 1;
        }
    }

    @Override
    public ICodeResolver<InsnType> getResolver() {
        return null;
    }

    @Override
    public CodePointer createEntryPoint(long l2) {
        return this.createEntryPoint(l2, 0);
    }

    @Override
    public CodePointer createEntryPoint(long l2, int n2) {
        return new CodePointer(l2, n2);
    }

    public boolean clearInstructionCache() {
        return false;
    }
}

