/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandList;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Arrays;

@Ser
public abstract class AbstractInstructionOperandList
extends AbstractInstructionOperandGeneric
implements IInstructionOperandList {
    @SerId(value=1)
    private IInstructionOperandGeneric[] operands;
    @SerId(value=2)
    private int flags;
    public static final int NO_FLAG = 0;
    public static final int SURROUND_BRACKETS = 1;
    public static final int SURROUND_BRACES = 2;
    public static final int SURROUND_PARENTHESES = 4;
    public static final int SURROUND_CHEVRONS = 8;
    public static final int SURROUND_QUOTES = 16;
    public static final int SURROUND_DOUBLE_QUOTES = 32;
    public static final int SURROUND_SPACES = 64;
    public static final int SEPARATOR_SPACE = 256;
    public static final int SEPARATOR_COMMA = 512;
    public static final int SEPARATOR_COLON = 1024;
    public static final int SEPARATOR_SEMI_COLON = 2048;
    public static final int SEPARATOR_HYPHEN = 4096;
    public static final int USER_DEFINED_1 = 65536;
    public static final int USER_DEFINED_2 = 131072;
    public static final int USER_DEFINED_3 = 262144;
    public static final int USER_DEFINED_4 = 524288;
    public static final int USER_DEFINED_5 = 0x100000;
    public static final int USER_DEFINED_6 = 0x200000;
    public static final int USER_DEFINED_7 = 0x400000;
    public static final int USER_DEFINED_8 = 0x800000;
    public static final int FLAG_MASK = 0xFFFFFF;

    public AbstractInstructionOperandList(int n2, long l2, int n3, IInstructionOperandGeneric ... iInstructionOperandGenericArray) {
        this(7, n2, l2, n3, iInstructionOperandGenericArray);
    }

    public AbstractInstructionOperandList(int n2, int n3, long l2, int n4, IInstructionOperandGeneric ... iInstructionOperandGenericArray) {
        super(n2, n3, l2);
        this.operands = iInstructionOperandGenericArray;
        this.flags = n4;
    }

    @Override
    protected CharSequence formatOperand(IInstruction iInstruction, long l2) {
        if (this.type == 7) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.operands.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(this.getSeparator());
                }
                IInstructionOperandGeneric iInstructionOperandGeneric = this.operands[i];
                stringBuilder.append(iInstructionOperandGeneric.format(iInstruction, l2));
            }
            return stringBuilder.toString();
        }
        return super.formatOperand(iInstruction, l2);
    }

    @Override
    public String getPrefix(IInstruction iInstruction) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.flags & 1) != 0) {
            stringBuilder.append('[');
        }
        if ((this.flags & 2) != 0) {
            stringBuilder.append('{');
        }
        if ((this.flags & 4) != 0) {
            stringBuilder.append('(');
        }
        if ((this.flags & 8) != 0) {
            stringBuilder.append('<');
        }
        if ((this.flags & 0x10) != 0) {
            stringBuilder.append('\'');
        }
        if ((this.flags & 0x20) != 0) {
            stringBuilder.append('\"');
        }
        if ((this.flags & 0x40) != 0) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSuffix(IInstruction iInstruction) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.flags & 0x40) != 0) {
            stringBuilder.append(' ');
        }
        if ((this.flags & 0x20) != 0) {
            stringBuilder.append('\"');
        }
        if ((this.flags & 0x10) != 0) {
            stringBuilder.append('\'');
        }
        if ((this.flags & 8) != 0) {
            stringBuilder.append('>');
        }
        if ((this.flags & 4) != 0) {
            stringBuilder.append(')');
        }
        if ((this.flags & 2) != 0) {
            stringBuilder.append('}');
        }
        if ((this.flags & 1) != 0) {
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public IInstructionOperand[] getOperands() {
        return this.operands;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getSeparator() {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.flags & 0x200) != 0) {
            stringBuilder.append(',');
        }
        if ((this.flags & 0x400) != 0) {
            stringBuilder.append(':');
        }
        if ((this.flags & 0x800) != 0) {
            stringBuilder.append(';');
        }
        if ((this.flags & 0x100) != 0) {
            stringBuilder.append(' ');
        }
        if ((this.flags & 0x1000) != 0) {
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    @Override
    public IInstructionOperandGeneric merge(long l2) {
        return null;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.flags;
        n2 = 31 * n2 + Arrays.hashCode(this.operands);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractInstructionOperandList abstractInstructionOperandList = (AbstractInstructionOperandList)object;
        if (this.flags != abstractInstructionOperandList.flags) {
            return false;
        }
        return Arrays.equals(this.operands, abstractInstructionOperandList.operands);
    }
}

