/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public abstract class AbstractInstructionOperandGeneric
implements IInstructionOperandGeneric {
    @SerId(value=1)
    protected int type;
    @SerId(value=2)
    protected int size;
    @SerId(value=3)
    protected long value;

    public AbstractInstructionOperandGeneric(int n2, int n3, long l2) {
        this.type = n2;
        this.size = n3;
        this.value = l2;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.size;
        n2 = 31 * n2 + this.type;
        n2 = 31 * n2 + (int)(this.value ^ this.value >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractInstructionOperandGeneric abstractInstructionOperandGeneric = (AbstractInstructionOperandGeneric)object;
        if (this.size != abstractInstructionOperandGeneric.size) {
            return false;
        }
        if (this.type != abstractInstructionOperandGeneric.type) {
            return false;
        }
        return this.value == abstractInstructionOperandGeneric.value;
    }

    @Override
    public int getOperandType() {
        return this.type;
    }

    @Override
    public int getOperandBitsize() {
        return this.size;
    }

    @Override
    public long getOperandValue() {
        return this.value;
    }

    @Override
    public long getOperandValue(long l2) {
        if (this.type == 3) {
            return this.getOperandValue() + l2;
        }
        return this.getOperandValue();
    }

    @Override
    public String format(IInstruction iInstruction, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getPrefix(iInstruction);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(this.formatOperand(iInstruction, l2));
        String string2 = this.getSuffix(iInstruction);
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    protected CharSequence formatOperand(IInstruction iInstruction, long l2) {
        long l3 = this.getOperandValue(l2);
        switch (this.type) {
            case 0: {
                return Strings.safe(this.getRegisterName(l3));
            }
            case 1: 
            case 9: {
                if (l3 >= 0L && l3 < 10L) {
                    return Long.toString(l3);
                }
                if (this.getOperandBitsize() <= 16) {
                    return Formatter.toHexString((short)l3, true, 2) + "h";
                }
                if (this.getOperandBitsize() <= 32) {
                    return Formatter.toHexString((int)l3, true, 2) + "h";
                }
                return Formatter.toHexString(l3, true, 2) + "h";
            }
            case 2: {
                return Formatter.toHexString(l3, true) + "h";
            }
            case 3: {
                if (l2 == 0L && l3 < 0L) {
                    return "-" + Formatter.toHexString(-l3, true) + "h";
                }
                return Formatter.toHexString(l3, true) + "h";
            }
            case 4: {
                return "[" + Strings.safe(this.getRegisterName(l3)) + "]";
            }
            case 5: {
                return "[" + Formatter.toHexString(l3, true) + "h]";
            }
            case 6: {
                return Strings.safe(this.getAlias(l3));
            }
        }
        return Strings.ff("<???>(type=%d,value=%d,size=%d)", this.getOperandType(), l3, this.getOperandBitsize());
    }

    @Override
    public String getPrefix(IInstruction iInstruction) {
        return null;
    }

    @Override
    public String getSuffix(IInstruction iInstruction) {
        return null;
    }

    @Override
    public String getAlias(long l2) {
        return null;
    }

    public String toString() {
        return this.format(null, 0L);
    }

    protected final String innerFormat() {
        long l2 = this.getOperandValue();
        switch (this.type) {
            case 2: 
            case 3: {
                if (l2 > 0L) {
                    return "+" + Formatter.toHexString(l2, true) + "h";
                }
                return "-" + Formatter.toHexString(-l2, true) + "h";
            }
        }
        return this.format(null, 0L);
    }
}

