/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.util.collect.CFBytesTrie;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;

@SerDisabled
public abstract class AbstractInstructionManager<T extends IInstruction>
implements CFBytesTrie.IKeyExtractor<T> {
    private CFBytesTrie<T> insnCacheFast = new CFBytesTrie();

    public AbstractInstructionManager() {
        this.insnCacheFast.setKeyExtractor(this);
    }

    public T getInstruction(BytesBlock bytesBlock) throws ProcessorException {
        Object object;
        boolean bl = this.useCache(bytesBlock);
        byte[] byArray = this.buildKey(bytesBlock);
        if (bl && (object = (IInstruction)this.insnCacheFast.get(byArray, false)) != null) {
            return this.retrieveInstructionFromCache(object);
        }
        object = this.findInstruction(bytesBlock);
        if (object != null && bl) {
            this.insnCacheFast.put(byArray, object);
        }
        return object;
    }

    protected T retrieveInstructionFromCache(T t) {
        return t;
    }

    protected abstract T findInstruction(BytesBlock var1) throws ProcessorException;

    protected boolean useCache(BytesBlock bytesBlock) {
        return true;
    }

    protected byte[] buildKey(BytesBlock bytesBlock) {
        return bytesBlock.getCode();
    }

    protected static void raiseUndefined(byte[] byArray) throws ProcessorException {
        throw new ProcessorException(AbstractInstructionManager.getUndefinedMessage(byArray));
    }

    protected static String getUndefinedMessage(byte[] byArray) {
        return Strings.f("Instruction %s is undefined", Formatter.byteArrayToHex(byArray));
    }

    protected static String getUnpredictableMessage(byte[] byArray, String string) {
        return Strings.f("Instruction %s %s is unpredictable", Formatter.byteArrayToHex(byArray), string);
    }

    @Override
    public byte[] extract(T t) {
        return t.getCode();
    }

    public void clearCache() {
        this.insnCacheFast.clear();
    }
}

