/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.InstructionFlags;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.core.units.code.asm.simulator.IInsnEmulator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Set;

@Ser
public abstract class AbstractInstruction<T extends IInstructionOperand>
implements IInstruction {
    private static final boolean BREAK_FLOW = true;
    private static final boolean ROUTINE_CALL = true;
    @SerId(value=1)
    private BytesBlock code;
    @SerId(value=2)
    private String mnemonic;
    @SerId(value=3)
    protected T[] operands;
    @SerId(value=4)
    protected int processorMode;

    public AbstractInstruction(BytesBlock bytesBlock, String string, T[] TArray, int n2) {
        this.code = bytesBlock;
        this.mnemonic = string;
        this.operands = TArray;
        this.processorMode = n2;
    }

    @Override
    public int getSize() {
        return this.code.getCode().length;
    }

    public BytesBlock getCodeBlock() {
        return this.code;
    }

    @Override
    public byte[] getCode() {
        return this.code.getCode();
    }

    public byte[] getCode(ByteOrder byteOrder) {
        return this.code.getCode(byteOrder);
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    public T[] getOperands() {
        return this.operands;
    }

    public T getOperand(int n2) {
        return this.operands[n2];
    }

    @Override
    public int getCountOfOperands() {
        return this.operands.length;
    }

    @Override
    public int getProcessorMode() {
        return this.processorMode;
    }

    protected CodePointer buildNextEntryPoint(long l2) {
        return new CodePointer(l2 + (long)this.getSize(), this.processorMode);
    }

    protected boolean isBreakingFlow(IInsnEmulator<T> iInsnEmulator) {
        if (!this.isJump(iInsnEmulator)) {
            return false;
        }
        return iInsnEmulator.getBranchType() == IInsnEmulator.BranchType.JMP;
    }

    protected boolean isRoutineCall(IInsnEmulator<T> iInsnEmulator) {
        if (!this.isJump(iInsnEmulator)) {
            return false;
        }
        return iInsnEmulator.getBranchType() == IInsnEmulator.BranchType.CALL;
    }

    protected boolean isJump(IInsnEmulator<T> iInsnEmulator) {
        if (iInsnEmulator == null) {
            return false;
        }
        return iInsnEmulator.isPCUpdated();
    }

    public Set<InstructionFlags> getInstructionFlags() {
        return Collections.emptySet();
    }

    @Override
    public String format(Object object) {
        Long l2 = (Long)object;
        long l3 = l2 == null ? 0L : l2;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.getMnemonic());
            stringBuilder.append(" ");
            int n2 = 0;
            for (IInstructionOperand iInstructionOperand : this.getOperands()) {
                if (n2 >= 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iInstructionOperand.format(this, l3));
                ++n2;
            }
            return stringBuilder.toString();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(Strings.ff("Unable to format %s: %s", Formatter.byteArrayToHex(this.getCode()), stringBuilder.toString()), runtimeException);
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.code == null ? 0 : this.code.hashCode());
        n2 = 31 * n2 + this.processorMode;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractInstruction abstractInstruction = (AbstractInstruction)object;
        if (this.code == null ? abstractInstruction.code != null : !this.code.equals(abstractInstruction.code)) {
            return false;
        }
        return this.processorMode == abstractInstruction.processorMode;
    }

    public String toString() {
        return Strings.ff("(%s) %s", Formatter.byteArrayToHex(this.getCode()), this.format(0L));
    }
}

