/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractOperandBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.IEncodedMemoryArea;

public abstract class AbstractImmediateOperandBuilder<T extends IInstructionOperand>
extends AbstractOperandBuilder<T> {
    public static final int POST_ADD1 = 0x100000;
    public static final int REL_ADDRESS = 0x200000;
    public static final int ABS_ADDRESS = 0x400000;
    public static final int PC_SHIFT_4 = 0x800000;
    private ImmediateType type;
    private int postAdd = 0;

    protected AbstractImmediateOperandBuilder(ImmediateType immediateType, int n2, int n3, IEncodedMemoryArea iEncodedMemoryArea) {
        super(iEncodedMemoryArea, n2, n3, 0);
        this.type = immediateType;
    }

    protected AbstractImmediateOperandBuilder(ImmediateType immediateType, int n2, int n3, int n4, IEncodedMemoryArea iEncodedMemoryArea) {
        super(iEncodedMemoryArea, n2, n3, n4);
        this.type = immediateType;
    }

    public void postAdd(int n2) {
        this.postAdd = n2;
    }

    protected long getValue(byte[] byArray, int n2) throws ProcessorException {
        switch (this.type) {
            case SignExtend32: {
                return EncodedMemoryAreaUtil.signExtendInt(byArray, this.getMemoryArea());
            }
            case SignExtend64: {
                return EncodedMemoryAreaUtil.signExtendLong(byArray, this.getMemoryArea());
            }
        }
        return EncodedMemoryAreaUtil.zeroExtend(byArray, this.getMemoryArea());
    }

    @Override
    public T buildOperand(byte[] byArray, int n2) throws ProcessorException {
        long l2 = this.getValue(byArray, n2);
        if ((this.flags & 0x100000) != 0) {
            ++l2;
        }
        if (this.isOptional(l2 += (long)this.postAdd)) {
            return null;
        }
        return this.buildImmediate(n2, l2);
    }

    protected int getSize() {
        switch (this.type) {
            case SignExtend32: 
            case ZeroExtendLength: 
            case ZeroExtend32: {
                return this.getMemoryArea().getLength();
            }
            case SignExtend64: 
            case ZeroExtend64: {
                return 64;
            }
        }
        return 32;
    }

    public int getPostAdd() {
        return this.postAdd;
    }

    public boolean isSigned() {
        return this.type == ImmediateType.SignExtend32 || this.type == ImmediateType.SignExtend64;
    }

    protected abstract T buildImmediate(int var1, long var2);

    public static enum ImmediateType {
        SignExtend32,
        SignExtend64,
        ZeroExtendLength,
        ZeroExtend32,
        ZeroExtend64;

    }
}

