/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemoryShim;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Bytes;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jebglobal.ayq;
import com.pnfsoftware.jebglobal.ayr;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;

public class VirtualMemoryUtil {
    private static final ILogger logger = GlobalLog.getLogger(VirtualMemoryUtil.class);

    public static IVirtualMemory createMemory(int n2, int n3, Endianness endianness) {
        return new ayr(n2, n3, endianness);
    }

    public static boolean isPageAllocated(IVirtualMemory iVirtualMemory, long l2) {
        return iVirtualMemory.check(l2, 1, 0) != 0;
    }

    public static long findAvailableRange(IVirtualMemory iVirtualMemory, long l2, int n2) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = iVirtualMemory.getPageSize();
            long l4 = (long)n2 & 0xFFFFFFFFL;
            long l5 = iVirtualMemory.roundToPage(l2);
            long l6 = -1L;
            long l7 = l5;
            while (Long.compareUnsigned(l7, l5) >= 0) {
                long l8 = l7 + l3;
                if (!VirtualMemoryUtil.isPageAllocated(iVirtualMemory, l7)) {
                    if (l6 == -1L) {
                        l6 = l7;
                    } else if (l8 - l6 >= l4) {
                        return l6;
                    }
                } else {
                    l6 = -1L;
                }
                l7 = l8;
            }
            return -1L;
        }
    }

    public static long allocate(IVirtualMemory iVirtualMemory, long l2, int n2, int n3) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = VirtualMemoryUtil.findAvailableRange(iVirtualMemory, l2, n2);
            if (l3 != -1L) {
                try {
                    iVirtualMemory.allocate(l3, n2, n3);
                }
                catch (MemoryException memoryException) {
                    Object[] objectArray = new Object[]{n2, l3};
                }
            }
            return l3;
        }
    }

    public static int allocateFillGaps(IVirtualMemory iVirtualMemory, long l2, int n2, int n3) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = iVirtualMemory.roundToSize(l2 + ((long)n2 & 0xFFFFFFFFL));
            long l4 = iVirtualMemory.getPageSize();
            int n4 = 0;
            for (long i = iVirtualMemory.roundToPage(l2); i != l3; i += l4) {
                if (iVirtualMemory.check(i, 1, 0) != 0) continue;
                try {
                    iVirtualMemory.allocate(i, 1, n3);
                }
                catch (MemoryException memoryException) {
                    throw new RuntimeException(memoryException);
                }
                ++n4;
            }
            return n4;
        }
    }

    public static boolean deallocate(IVirtualMemory iVirtualMemory, long l2, int n2) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            try {
                iVirtualMemory.free(l2, n2);
                return true;
            }
            catch (MemoryException memoryException) {
                return false;
            }
            finally {
            }
        }
    }

    public static int readBytesSafe(IVirtualMemory iVirtualMemory, long l2, int n2, byte[] byArray, int n3, int n4) {
        if ((n4 & 1) == 0) {
            throw new IllegalArgumentException("Expected at least READ access");
        }
        try {
            IVirtualMemory iVirtualMemory2 = iVirtualMemory;
            synchronized (iVirtualMemory2) {
                int n5 = iVirtualMemory.check(l2, n2, n4);
                iVirtualMemory.read(l2, n5, byArray, n3);
                return n5;
            }
        }
        catch (MemoryException memoryException) {
            return -1;
        }
    }

    public static int readBytesSafe(IVirtualMemory iVirtualMemory, long l2, int n2, byte[] byArray, int n3, boolean bl) {
        try {
            int n4 = bl ? 0 : 1;
            IVirtualMemory iVirtualMemory2 = iVirtualMemory;
            synchronized (iVirtualMemory2) {
                int n5 = iVirtualMemory.check(l2, n2, n4);
                iVirtualMemory.read(l2, n5, byArray, n3, bl);
                return n5;
            }
        }
        catch (MemoryException memoryException) {
            return -1;
        }
    }

    public static int convertSegmentFlagsToVMFlags(int n2) {
        int n3 = 0;
        if ((n2 & 2) != 0) {
            n3 |= 1;
        }
        if ((n2 & 1) != 0) {
            n3 |= 2;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        return n3;
    }

    public static int read(IVirtualMemory iVirtualMemory, long l2) {
        try {
            return iVirtualMemory.readByte(l2) & 0xFF;
        }
        catch (MemoryException memoryException) {
            return -1;
        }
    }

    public static boolean readSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            iVirtualMemory.read(l2, byArray.length, byArray, 0);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readByteSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            byArray[0] = iVirtualMemory.readByte(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLEShortSafe(IVirtualMemory iVirtualMemory, long l2, short[] sArray) {
        try {
            sArray[0] = iVirtualMemory.readLEShort(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLEIntSafe(IVirtualMemory iVirtualMemory, long l2, int[] nArray) {
        try {
            nArray[0] = iVirtualMemory.readLEInt(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLELongSafe(IVirtualMemory iVirtualMemory, long l2, long[] lArray) {
        try {
            lArray[0] = iVirtualMemory.readLELong(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readBEShortSafe(IVirtualMemory iVirtualMemory, long l2, short[] sArray) {
        try {
            sArray[0] = iVirtualMemory.readBEShort(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readBEIntSafe(IVirtualMemory iVirtualMemory, long l2, int[] nArray) {
        try {
            nArray[0] = iVirtualMemory.readBEInt(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readBELongSafe(IVirtualMemory iVirtualMemory, long l2, long[] lArray) {
        try {
            lArray[0] = iVirtualMemory.readBELong(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            iVirtualMemory.write(l2, byArray.length, byArray, 0);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeByteSafe(IVirtualMemory iVirtualMemory, long l2, byte by) {
        try {
            iVirtualMemory.writeByte(l2, by);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLEShortSafe(IVirtualMemory iVirtualMemory, long l2, short s2) {
        try {
            iVirtualMemory.writeLEShort(l2, s2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLEIntSafe(IVirtualMemory iVirtualMemory, long l2, int n2) {
        try {
            iVirtualMemory.writeLEInt(l2, n2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLELongSafe(IVirtualMemory iVirtualMemory, long l2, long l3) {
        try {
            iVirtualMemory.writeLELong(l2, l3);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readShortSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, short[] sArray) {
        try {
            sArray[0] = endianness.isLittle() ? iVirtualMemory.readLEShort(l2) : iVirtualMemory.readBEShort(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readIntSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, int[] nArray) {
        try {
            nArray[0] = endianness.isLittle() ? iVirtualMemory.readLEInt(l2) : iVirtualMemory.readBEInt(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLongSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, long[] lArray) {
        try {
            lArray[0] = endianness.isLittle() ? iVirtualMemory.readLELong(l2) : iVirtualMemory.readBELong(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeShortSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, short s2) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLEShort(l2, s2);
            } else {
                iVirtualMemory.writeBEShort(l2, s2);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeIntSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, int n2) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLEInt(l2, n2);
            } else {
                iVirtualMemory.writeBEInt(l2, n2);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLongSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, long l3) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLELong(l2, l3);
            } else {
                iVirtualMemory.writeBELong(l2, l3);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeBooleans(IVirtualMemory iVirtualMemory, long l2, boolean[] blArray, int n2, int n3) {
        byte[] byArray = new byte[n3];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            boolean bl = blArray[i];
            byArray[n4++] = bl ? (byte)1 : 0;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readBooleans(IVirtualMemory iVirtualMemory, long l2, boolean[] blArray, int n2, int n3) {
        byte[] byArray = new byte[n3];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            byte by;
            blArray[i] = ((by = byArray[n4++]) & 1) == 1;
        }
        return true;
    }

    public static boolean writeBytes(IVirtualMemory iVirtualMemory, long l2, byte[] byArray, int n2, int n3) {
        try {
            iVirtualMemory.write(l2, n3, byArray, n2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readBytes(IVirtualMemory iVirtualMemory, long l2, byte[] byArray, int n2, int n3) {
        try {
            iVirtualMemory.read(l2, n3, byArray, n2, true);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeChars(IVirtualMemory iVirtualMemory, long l2, char[] cArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 2];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            char c2 = cArray[i];
            if (bl) {
                byArray[n4++] = (byte)c2;
                byArray[n4++] = (byte)(c2 >> 8);
                continue;
            }
            byArray[n4++] = (byte)(c2 >> 8);
            byArray[n4++] = (byte)c2;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readChars(IVirtualMemory iVirtualMemory, long l2, char[] cArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 2];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            cArray[i] = (char)EndianUtil.bytesToShort(byArray, n4, byteOrder);
            n4 += 2;
        }
        return true;
    }

    public static boolean writeShorts(IVirtualMemory iVirtualMemory, long l2, short[] sArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 2];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            short s2 = sArray[i];
            if (bl) {
                byArray[n4++] = (byte)s2;
                byArray[n4++] = (byte)(s2 >> 8);
                continue;
            }
            byArray[n4++] = (byte)(s2 >> 8);
            byArray[n4++] = (byte)s2;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readShorts(IVirtualMemory iVirtualMemory, long l2, short[] sArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 2];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            sArray[i] = EndianUtil.bytesToShort(byArray, n4, byteOrder);
            n4 += 2;
        }
        return true;
    }

    public static boolean writeInts(IVirtualMemory iVirtualMemory, long l2, int[] nArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 4];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            int n5 = nArray[i];
            if (bl) {
                byArray[n4++] = (byte)n5;
                byArray[n4++] = (byte)(n5 >> 8);
                byArray[n4++] = (byte)(n5 >> 16);
                byArray[n4++] = (byte)(n5 >> 24);
                continue;
            }
            byArray[n4++] = (byte)(n5 >> 24);
            byArray[n4++] = (byte)(n5 >> 16);
            byArray[n4++] = (byte)(n5 >> 8);
            byArray[n4++] = (byte)n5;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readInts(IVirtualMemory iVirtualMemory, long l2, int[] nArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 4];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            nArray[i] = EndianUtil.bytesToInt(byArray, n4, byteOrder);
            n4 += 4;
        }
        return true;
    }

    public static boolean writeLongs(IVirtualMemory iVirtualMemory, long l2, long[] lArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 8];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            long l3 = lArray[i];
            if (bl) {
                byArray[n4++] = (byte)l3;
                byArray[n4++] = (byte)(l3 >> 8);
                byArray[n4++] = (byte)(l3 >> 16);
                byArray[n4++] = (byte)(l3 >> 24);
                byArray[n4++] = (byte)(l3 >> 32);
                byArray[n4++] = (byte)(l3 >> 40);
                byArray[n4++] = (byte)(l3 >> 48);
                byArray[n4++] = (byte)(l3 >> 56);
                continue;
            }
            byArray[n4++] = (byte)(l3 >> 56);
            byArray[n4++] = (byte)(l3 >> 48);
            byArray[n4++] = (byte)(l3 >> 40);
            byArray[n4++] = (byte)(l3 >> 32);
            byArray[n4++] = (byte)(l3 >> 24);
            byArray[n4++] = (byte)(l3 >> 16);
            byArray[n4++] = (byte)(l3 >> 8);
            byArray[n4++] = (byte)l3;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readLongs(IVirtualMemory iVirtualMemory, long l2, long[] lArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 8];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            lArray[i] = EndianUtil.bytesToLong(byArray, n4, byteOrder);
            n4 += 8;
        }
        return true;
    }

    public static boolean writeFloats(IVirtualMemory iVirtualMemory, long l2, float[] fArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 4];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            int n5 = Float.floatToIntBits(fArray[i]);
            if (bl) {
                byArray[n4++] = (byte)n5;
                byArray[n4++] = (byte)(n5 >> 8);
                byArray[n4++] = (byte)(n5 >> 16);
                byArray[n4++] = (byte)(n5 >> 24);
                continue;
            }
            byArray[n4++] = (byte)(n5 >> 24);
            byArray[n4++] = (byte)(n5 >> 16);
            byArray[n4++] = (byte)(n5 >> 8);
            byArray[n4++] = (byte)n5;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readFloats(IVirtualMemory iVirtualMemory, long l2, float[] fArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 4];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            fArray[i] = Float.intBitsToFloat(EndianUtil.bytesToInt(byArray, n4, byteOrder));
            n4 += 4;
        }
        return true;
    }

    public static boolean writeDoubles(IVirtualMemory iVirtualMemory, long l2, double[] dArray, int n2, int n3) {
        boolean bl;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            bl = true;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            bl = false;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 8];
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            long l3 = Double.doubleToLongBits(dArray[i]);
            if (bl) {
                byArray[n4++] = (byte)l3;
                byArray[n4++] = (byte)(l3 >> 8);
                byArray[n4++] = (byte)(l3 >> 16);
                byArray[n4++] = (byte)(l3 >> 24);
                byArray[n4++] = (byte)(l3 >> 32);
                byArray[n4++] = (byte)(l3 >> 40);
                byArray[n4++] = (byte)(l3 >> 48);
                byArray[n4++] = (byte)(l3 >> 56);
                continue;
            }
            byArray[n4++] = (byte)(l3 >> 56);
            byArray[n4++] = (byte)(l3 >> 48);
            byArray[n4++] = (byte)(l3 >> 40);
            byArray[n4++] = (byte)(l3 >> 32);
            byArray[n4++] = (byte)(l3 >> 24);
            byArray[n4++] = (byte)(l3 >> 16);
            byArray[n4++] = (byte)(l3 >> 8);
            byArray[n4++] = (byte)l3;
        }
        return VirtualMemoryUtil.writeSafe(iVirtualMemory, l2, byArray);
    }

    public static boolean readDoubles(IVirtualMemory iVirtualMemory, long l2, double[] dArray, int n2, int n3) {
        ByteOrder byteOrder;
        if (iVirtualMemory.getStandardEndianess().isLittle()) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (iVirtualMemory.getStandardEndianess().isBig()) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            return false;
        }
        byte[] byArray = new byte[n3 * 8];
        if (!VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray)) {
            return false;
        }
        int n4 = 0;
        for (int i = n2; i < n2 + n3; ++i) {
            dArray[i] = Double.longBitsToDouble(EndianUtil.bytesToLong(byArray, n4, byteOrder));
            n4 += 8;
        }
        return true;
    }

    public static String readNullTerminatedStringSafe(IVirtualMemory iVirtualMemory, long l2, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        long l3 = l2;
        try {
            byte by;
            while (n3 < n2 && (by = iVirtualMemory.readByte(l3)) != 0) {
                stringBuilder.append((char)by);
                ++n3;
                ++l3;
            }
        }
        catch (MemoryException memoryException) {
            return null;
        }
        if (n3 == n2) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static IVirtualMemoryShim getCopyOnWriteShim(IVirtualMemory iVirtualMemory) {
        if (iVirtualMemory instanceof ayq) {
            return ((ayq)iVirtualMemory).fz();
        }
        throw new IllegalArgumentException("The input memory object does not support copy-on-write shims");
    }

    public static long findByte(IVirtualMemory iVirtualMemory, long l2, long l3, int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        return VirtualMemoryUtil.findBytes(iVirtualMemory, false, l2, l3, byArray, null);
    }

    public static long findBytes(IVirtualMemory iVirtualMemory, boolean bl, long l2, long l3, byte[] byArray, byte[] byArray2) {
        if (byArray.length == 0) {
            return l2;
        }
        long l4 = iVirtualMemory.getPageSize();
        long l5 = l4 - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if ((long)byArray.length > l4) {
            return -1L;
        }
        boolean bl2 = Longs.compareUnsigned(l2, l3) > 0;
        long l6 = l2 & l5;
        long l7 = l2 - l6;
        int n2 = bl2 ? -1 : 1;
        TreeSet<Long> treeSet = new TreeSet<Long>(iVirtualMemory.getAllocatedPageBases());
        Long l8 = bl2 ? treeSet.floor(l6) : treeSet.ceiling(l6);
        if (l8 == null) {
            return -1L;
        }
        l6 = l8;
        ArrayList<Long> arrayList = new ArrayList<Long>(treeSet);
        byte[] byArray3 = new byte[(int)l4 + byArray.length - 1];
        for (int i = Collections.binarySearch(arrayList, l6); i >= 0 && i < arrayList.size(); i += n2) {
            int n3;
            l6 = (Long)arrayList.get(i);
            if (!bl2 ? Longs.compareUnsigned(l6, l3) > 0 : Longs.compareUnsigned(l6 + l4, l3) < 0) {
                return -1L;
            }
            int n4 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l6, byArray3.length, byArray3, 0, bl);
            if (n4 <= 0) continue;
            if (!bl2) {
                n3 = Bytes.indexOf(byArray3, (int)l7, n4, byArray, 0, byArray.length, byArray2);
                if (n3 >= 0) {
                    return l6 + (long)n3;
                }
                l7 = 0L;
                continue;
            }
            n3 = Bytes.lastIndexOf(byArray3, (int)l7, byArray, byArray2);
            if (n3 >= 0) {
                return l6 + (long)n3;
            }
            l7 = (int)l4;
        }
        return -1L;
    }

    public static Long readAsLongSafe(IVirtualMemory iVirtualMemory, long l2, int n2) {
        return VirtualMemoryUtil.readAsLongSafe(iVirtualMemory, iVirtualMemory.getStandardEndianess(), l2, n2);
    }

    public static Long readAsLongSafe(IVirtualMemory iVirtualMemory, Endianness endianness, long l2, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = iVirtualMemory.read(l2, n2, byArray, 0);
        }
        catch (MemoryException memoryException) {}
        if (n3 != n2) {
            return null;
        }
        switch (n2) {
            case 1: {
                return byArray[0];
            }
            case 2: {
                return EndianUtil.bytesToShort(byArray, 0, endianness.toByteOrder());
            }
            case 4: {
                return EndianUtil.bytesToInt(byArray, 0, endianness.toByteOrder());
            }
            case 8: {
                return EndianUtil.bytesToLong(byArray, 0, endianness.toByteOrder());
            }
        }
        return null;
    }

    public Long readAsUnsignedLongSafe(IVirtualMemory iVirtualMemory, long l2, int n2) {
        return VirtualMemoryUtil.readAsUnsignedLongSafe(iVirtualMemory, iVirtualMemory.getStandardEndianess(), l2, n2);
    }

    public static Long readAsUnsignedLongSafe(IVirtualMemory iVirtualMemory, Endianness endianness, long l2, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = iVirtualMemory.read(l2, n2, byArray, 0);
        }
        catch (MemoryException memoryException) {}
        if (n3 != n2) {
            return null;
        }
        switch (n2) {
            case 1: {
                return (long)byArray[0] & 0xFFL;
            }
            case 2: {
                return (long)EndianUtil.bytesToShort(byArray, 0, endianness.toByteOrder()) & 0xFFFFL;
            }
            case 4: {
                return (long)EndianUtil.bytesToInt(byArray, 0, endianness.toByteOrder()) & 0xFFFFFFFFL;
            }
            case 8: {
                return EndianUtil.bytesToLong(byArray, 0, endianness.toByteOrder());
            }
        }
        return null;
    }

    public static byte[] dump(IVirtualMemory iVirtualMemory, long l2, long l3) {
        int n2 = (int)(l3 - l2);
        byte[] byArray = new byte[n2];
        VirtualMemoryUtil.dump(iVirtualMemory, l2, l3, byArray, 0);
        return byArray;
    }

    public static void dump(IVirtualMemory iVirtualMemory, long l2, long l3, byte[] byArray, int n2) {
        int n3 = iVirtualMemory.getPageSize();
        long l4 = l2;
        int n4 = n2;
        long l5 = iVirtualMemory.roundToSize(l2);
        if (Long.compareUnsigned(l5, l2) > 0) {
            int n5 = (int)(l5 - l2);
            long l6 = iVirtualMemory.roundToPage(l2);
            if (iVirtualMemory.isAllocatedPage(l6)) {
                try {
                    iVirtualMemory.read(l4, n5, byArray, n4, true);
                }
                catch (MemoryException memoryException) {
                    throw new RuntimeException(memoryException);
                }
            }
            n4 += n5;
            l4 += (long)n5;
        }
        long l7 = iVirtualMemory.roundToPage(l3);
        while (Long.compareUnsigned(l4, l7) < 0) {
            if (iVirtualMemory.isAllocatedPage(l4)) {
                try {
                    iVirtualMemory.read(l4, n3, byArray, n4, true);
                }
                catch (MemoryException memoryException) {
                    throw new RuntimeException(memoryException);
                }
            }
            n4 += n3;
            l4 += (long)n3;
        }
        if (Long.compareUnsigned(l7, l3) < 0) {
            int n6 = (int)(l3 - l7);
            if (iVirtualMemory.isAllocatedPage(l7)) {
                try {
                    iVirtualMemory.read(l4, n6, byArray, n4, true);
                }
                catch (MemoryException memoryException) {
                    throw new RuntimeException(memoryException);
                }
            }
        }
    }

    public static void dumpToImageFiles(IVirtualMemory iVirtualMemory, File file) throws IOException {
        VirtualMemoryUtil.dumpToImageFiles(iVirtualMemory, file, null, null);
    }

    public static void dumpToImageFiles(IVirtualMemory iVirtualMemory, File file, String string, String string2) throws IOException {
        IO.createDirectory(file);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n2 = iVirtualMemory.getPageSize();
        ArrayList<Long> arrayList = new ArrayList<Long>(iVirtualMemory.getAllocatedPageBases());
        int n3 = 0;
        while (n3 < arrayList.size()) {
            long l2 = (Long)arrayList.get(n3);
            ++n3;
            long l3 = l2 + (long)n2;
            while (arrayList.contains(l3)) {
                l3 += (long)n2;
                ++n3;
            }
            int n4 = (int)(l3 - l2);
            byte[] byArray = new byte[n4];
            VirtualMemoryUtil.readSafe(iVirtualMemory, l2, byArray);
            IO.writeFile(new File(file, Strings.ff("%s%X%s", string, l2, string2)), byArray);
        }
    }
}

