/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrimitiveCategory;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;

public class VMWriter {
    IVirtualMemory vm;
    long addr;
    INativeType t;
    IStructureType ut;
    byte[] data;
    boolean bigend;

    public VMWriter(IVirtualMemory iVirtualMemory, long l2, INativeType iNativeType) {
        this.vm = iVirtualMemory;
        this.addr = l2;
        this.t = iNativeType;
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType2 instanceof IStructureType) {
            this.ut = (IStructureType)iNativeType2;
        }
        this.data = new byte[iNativeType.getSize()];
        this.bigend = iVirtualMemory.getStandardEndianess().isBig();
    }

    public boolean commit() {
        try {
            this.vm.write(this.addr, this.data.length, this.data, 0);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set(String string, Object object) {
        if (this.ut == null) {
            throw new IllegalStateException("The provided type was not a structured");
        }
        IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
        if (iStructureTypeField == null) {
            return false;
        }
        INativeType iNativeType = TypeUtil.getNonAlias(iStructureTypeField.getType());
        if (!TypeUtil.isPrimitive(iNativeType)) {
            return false;
        }
        IPrimitiveType iPrimitiveType = (IPrimitiveType)iNativeType;
        int n2 = iStructureTypeField.getOffset();
        if (iPrimitiveType.getCategory() == PrimitiveCategory.FLOAT) {
            double d;
            if (object instanceof Double) {
                d = (Double)object;
            } else {
                if (!(object instanceof Float)) return false;
                d = ((Float)object).floatValue();
            }
            switch (iNativeType.getSize()) {
                case 4: {
                    this.setFloatAt(n2, (float)d);
                    return true;
                }
                case 8: {
                    this.setDoubleAt(n2, d);
                    return true;
                }
                default: {
                    return false;
                }
            }
        } else {
            long l2;
            if (iPrimitiveType.getCategory() != PrimitiveCategory.INTEGER && iPrimitiveType.getCategory() != PrimitiveCategory.UNSIGNED) return false;
            if (iPrimitiveType.getCategory() == PrimitiveCategory.INTEGER) {
                if (object instanceof Byte) {
                    l2 = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    l2 = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    l2 = ((Integer)object).intValue();
                } else {
                    if (!(object instanceof Long)) return false;
                    l2 = (Long)object;
                }
            } else if (object instanceof Byte) {
                l2 = (long)((Byte)object).byteValue() & 0xFFL;
            } else if (object instanceof Short) {
                l2 = (long)((Short)object).shortValue() & 0xFFFFL;
            } else if (object instanceof Integer) {
                l2 = (long)((Integer)object).intValue() & 0xFFFFFFFFL;
            } else {
                if (!(object instanceof Long)) return false;
                l2 = (Long)object;
            }
            switch (iNativeType.getSize()) {
                case 1: {
                    this.setByteAt(n2, (byte)l2);
                    return true;
                }
                case 2: {
                    this.setShortAt(n2, (short)l2);
                    return true;
                }
                case 4: {
                    this.setIntAt(n2, (int)l2);
                    return true;
                }
                case 8: {
                    this.setLongAt(n2, l2);
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
    }

    public void setByteAt(int n2, byte by) {
        this.data[n2] = by;
    }

    public void setShortAt(int n2, short s2) {
        if (this.bigend) {
            EndianUtil.shortToBEBytes(s2, this.data, n2);
        } else {
            EndianUtil.shortToLEBytes(s2, this.data, n2);
        }
    }

    public void setIntAt(int n2, int n3) {
        if (this.bigend) {
            EndianUtil.intToBEBytes(n3, this.data, n2);
        } else {
            EndianUtil.intToLEBytes(n3, this.data, n2);
        }
    }

    public void setLongAt(int n2, long l2) {
        if (this.bigend) {
            EndianUtil.longToBEBytes(l2, this.data, n2);
        } else {
            EndianUtil.longToLEBytes(l2, this.data, n2);
        }
    }

    public void setFloatAt(int n2, float f) {
        int n3 = Float.floatToIntBits(f);
        this.setIntAt(n2, n3);
    }

    public void setDoubleAt(int n2, double d) {
        long l2 = Double.doubleToLongBits(d);
        this.setLongAt(n2, l2);
    }
}

