/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import java.nio.ByteOrder;

public class VMReader {
    IVirtualMemory vm;

    public VMReader(IVirtualMemory iVirtualMemory) {
        this.vm = iVirtualMemory;
    }

    public Buf read(long l2, INativeType iNativeType) {
        int n2 = iNativeType.getSize();
        byte[] byArray = new byte[n2];
        try {
            if (this.vm.read(l2, n2, byArray, 0, true) != n2) {
                return null;
            }
            return new Buf(byArray, iNativeType, this.vm);
        }
        catch (MemoryException memoryException) {
            return null;
        }
    }

    public static class Buf {
        byte[] bytes;
        INativeType t;
        IStructureType ut;
        IVirtualMemory vm;
        ByteOrder bo;

        Buf(byte[] byArray, INativeType iNativeType, IVirtualMemory iVirtualMemory) {
            this.bytes = byArray;
            this.t = iNativeType;
            INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
            if (iNativeType2 instanceof IStructureType) {
                this.ut = (IStructureType)iNativeType2;
            }
            this.vm = iVirtualMemory;
            this.bo = iVirtualMemory.getStandardEndianess().toByteOrder();
        }

        public int getByte(String string) {
            IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
            return this.getIntAt(iStructureTypeField.getOffset());
        }

        public int getByteAt(int n2) {
            return this.bytes[n2];
        }

        public int getShort(String string) {
            IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
            return this.getShortAt(iStructureTypeField.getOffset());
        }

        public int getShortAt(int n2) {
            return EndianUtil.bytesToShort(this.bytes, n2, this.bo);
        }

        public int getInt(String string) {
            IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
            return this.getIntAt(iStructureTypeField.getOffset());
        }

        public int getIntAt(int n2) {
            return EndianUtil.bytesToInt(this.bytes, n2, this.bo);
        }

        public long getLong(String string) {
            IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
            return this.getLongAt(iStructureTypeField.getOffset());
        }

        public long getLongAt(int n2) {
            return EndianUtil.bytesToLong(this.bytes, n2, this.bo);
        }

        public long getPtr(String string) {
            IStructureTypeField iStructureTypeField = this.ut.getFieldByName(string);
            return this.getPtrAt(iStructureTypeField.getOffset());
        }

        public long getPtrAt(int n2) {
            int n3 = this.t.getTypeManager().getPointerSize();
            if (n3 == 4) {
                return this.getIntAt(n2);
            }
            if (n3 == 8) {
                return this.getLongAt(n2);
            }
            throw new RuntimeException();
        }

        public String readPointedAsciiString(String string) {
            long l2 = this.getPtr(string);
            return VirtualMemoryUtil.readNullTerminatedStringSafe(this.vm, l2, 4096);
        }
    }
}

