/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryAllocListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryWriteListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryAllocEvent;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryWriteEvent;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MemoryChangesRecorder {
    private IVirtualMemory vm;
    private Results mc;
    private IMemoryAllocListener memAllocListener = new IMemoryAllocListener(){

        @Override
        public void onAllocEvent(MemoryAllocEvent memoryAllocEvent) {
            long l2 = MemoryChangesRecorder.this.vm.roundToPage(memoryAllocEvent.getAddress());
            MemoryChangesRecorder.this.mc.allocPages.add(l2);
        }
    };
    private IMemoryWriteListener memPreWriteListener = new IMemoryWriteListener(){

        @Override
        public void onMemoryWriteEvent(MemoryWriteEvent memoryWriteEvent) {
            long l2 = MemoryChangesRecorder.this.vm.roundToPage(memoryWriteEvent.getAddress());
            if (MemoryChangesRecorder.this.mc.allocPages.contains(l2)) {
                return;
            }
            if (MemoryChangesRecorder.this.mc.writtenPages.add(l2)) {
                int n2 = MemoryChangesRecorder.this.vm.getPageSize();
                byte[] byArray = new byte[n2];
                try {
                    MemoryChangesRecorder.this.vm.read(l2, n2, byArray, 0, true);
                }
                catch (MemoryException memoryException) {}
                MemoryChangesRecorder.this.mc.writtenPagesData.put(l2, byArray);
            }
        }
    };

    public MemoryChangesRecorder(IVirtualMemory iVirtualMemory) {
        this.vm = iVirtualMemory;
    }

    public Results getMemoryChanges() {
        if (this.mc == null) {
            throw new IllegalStateException();
        }
        return this.mc;
    }

    public void setup() {
        if (this.mc != null) {
            throw new IllegalStateException();
        }
        this.mc = new Results();
        this.vm.addAllocListener(this.memAllocListener);
        this.vm.addPreWriteListener(this.memPreWriteListener);
    }

    public void teardown() {
        this.vm.removeAllocListener(this.memAllocListener);
        this.vm.removePreWriteListener(this.memPreWriteListener);
    }

    public static class Results {
        Set<Long> allocPages = new HashSet<Long>();
        Set<Long> writtenPages = new HashSet<Long>();
        Map<Long, byte[]> writtenPagesData = new HashMap<Long, byte[]>();

        public Set<Long> getAllocatedPages() {
            return this.allocPages;
        }

        public Set<Long> getWrittenPages() {
            return this.writtenPages;
        }

        public byte[] getPreWritePageData(long l2) {
            return this.writtenPagesData.get(l2);
        }

        public String toString() {
            return Strings.ff("%d allocated pages, %d written pages", this.allocPages.size(), this.writtenPages.size());
        }
    }
}

