/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.mangling;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IManglingEngine;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IUnmangledData;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IUnmangledRoutine;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.axk;
import com.pnfsoftware.jebglobal.ayh;
import com.pnfsoftware.jebglobal.ayj;
import com.pnfsoftware.jebglobal.ayl;
import com.pnfsoftware.jebglobal.ayn;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UnmanglerService {
    private static final ILogger logger = GlobalLog.getLogger(UnmanglerService.class);
    public static final int MANGLING_ENGINE_MSVC = 1;
    public static final int MANGLING_ENGINE_MSVCPP = 2;
    public static final int MANGLING_ENGINE_MSVCPP_V2 = 3;
    public static final int MANGLING_ENGINE_CXXA = 4;
    private List<IManglingEngine> engines = new CopyOnWriteArrayList<IManglingEngine>();
    private INativeCodeUnit<?> codeUnit;

    public UnmanglerService(INativeCodeUnit<?> iNativeCodeUnit) {
        this.codeUnit = iNativeCodeUnit;
    }

    public void registerEngine(int n2) {
        if (n2 == 1) {
            this.engines.add(new ayj());
        } else {
            if (n2 == 2) {
                throw new IllegalArgumentException("Deprecated mangling engine id");
            }
            if (n2 == 3) {
                this.engines.add(new ayl());
            } else if (n2 == 4) {
                this.engines.add(new ayh());
            } else {
                throw new IllegalArgumentException("Unknown mangling engine id");
            }
        }
    }

    public boolean importUnmangledRoutineName(INativeMethodItem iNativeMethodItem, String string, IUnmangledRoutine iUnmangledRoutine, boolean bl) {
        if (!(iNativeMethodItem instanceof axk) || iUnmangledRoutine == null || iNativeMethodItem.getName(true) == null) {
            return false;
        }
        String string2 = iUnmangledRoutine.getName();
        if (string2 != null) {
            ((axk)iNativeMethodItem).ce(string);
            ((axk)iNativeMethodItem).fz(string2);
            iNativeMethodItem.setName(string2);
            String string3 = iUnmangledRoutine.getFull();
            if (string3 != null) {
                ((axk)iNativeMethodItem).mm(string3);
            }
        }
        return true;
    }

    public boolean importUnmangledRoutinePrototype(INativeMethodItem iNativeMethodItem, IUnmangledRoutine iUnmangledRoutine) {
        if (!(iNativeMethodItem instanceof axk) || iUnmangledRoutine == null) {
            return false;
        }
        String string = iUnmangledRoutine.getSignature(true, true);
        if (string != null) {
            return this.codeUnit.setRoutineSignature(iNativeMethodItem, string, true);
        }
        return false;
    }

    public IUnmangledRoutine unmangleRoutine(String string, boolean bl) {
        if (this.engines.isEmpty()) {
            return null;
        }
        IUnmangledRoutine iUnmangledRoutine = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData = iManglingEngine.unmangle(string);
            if (!(iUnmangledData instanceof IUnmangledRoutine)) continue;
            IUnmangledRoutine iUnmangledRoutine2 = (IUnmangledRoutine)iUnmangledData;
            if (bl) {
                return iUnmangledRoutine2;
            }
            if (iUnmangledRoutine != null && !iUnmangledRoutine2.getFull().equals(iUnmangledRoutine.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", iUnmangledRoutine.getFull(), iUnmangledRoutine2.getFull());
                return null;
            }
            iUnmangledRoutine = iUnmangledRoutine2;
        }
        return iUnmangledRoutine;
    }

    public IUnmangledData unmangleData(String string, boolean bl) {
        if (this.engines.isEmpty()) {
            return null;
        }
        ayn ayn2 = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData = iManglingEngine.unmangle(string);
            if (!(iUnmangledData instanceof ayn)) continue;
            ayn ayn3 = (ayn)iUnmangledData;
            if (bl) {
                return ayn3;
            }
            if (ayn2 != null && !ayn3.getFull().equals(ayn2.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", ayn2.getFull(), ayn3.getFull());
                return null;
            }
            ayn2 = ayn3;
        }
        return ayn2;
    }

    public IUnmangledData unmangle(String string, boolean bl) {
        if (this.engines.isEmpty()) {
            return null;
        }
        IUnmangledData iUnmangledData = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData2 = iManglingEngine.unmangle(string);
            if (iUnmangledData2 == null) continue;
            if (bl) {
                return iUnmangledData2;
            }
            if (iUnmangledData != null && !iUnmangledData2.getFull().equals(iUnmangledData.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", iUnmangledData.getFull(), iUnmangledData2.getFull());
                return null;
            }
            iUnmangledData = iUnmangledData2;
        }
        return iUnmangledData;
    }
}

