/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.items;

import com.google.common.base.Strings;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ILabelManager;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeDataAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeStringItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.StringEntry;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.StringEncoding;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Characters;
import com.pnfsoftware.jebglobal.axr;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DataStringUtil {
    private static final ILogger logger = GlobalLog.getLogger(DataStringUtil.class);
    public static final int maxStringItemNameLength = 64;
    public static final String NAME_PREFIX = "a";
    public static final int NAME_DEFAULT_LENGTH = 16;
    private static UnicodeRule bopomofo = UnicodeRule.starts("BOPOMOFO");
    private static UnicodeRule han = UnicodeRule.starts("CJK_");
    private static List<UnicodeLanguage> languages = Arrays.asList(new UnicodeLanguage(han, bopomofo), new UnicodeLanguage(han, UnicodeRule.eq("HIRAGANA"), UnicodeRule.eq("KATAKANA")), new UnicodeLanguage(han, UnicodeRule.starts("HANGUL_")));

    public static boolean isValidStringAt(IVirtualMemory iVirtualMemory, long l2, int n2, int n3) {
        return DataStringUtil.getStringAt(iVirtualMemory, l2, n2, n3) != null;
    }

    public static String getStringAt(IVirtualMemory iVirtualMemory, long l2, int n2, int n3) {
        return DataStringUtil.getStringAt(iVirtualMemory, l2, n2, n3, null);
    }

    public static String getStringAt(IVirtualMemory iVirtualMemory, long l2, int n2, int n3, StringEncoding[] stringEncodingArray) {
        StringEntry stringEntry = DataStringUtil.getStringItemFromMemory(null, iVirtualMemory, l2, -1L, null, n2, n3);
        if (stringEntry == null) {
            return null;
        }
        if (stringEncodingArray != null && stringEncodingArray.length > 0) {
            stringEncodingArray[0] = stringEntry.encoding;
        }
        return stringEntry.str;
    }

    public static StringEntry getStringAt(IVirtualMemory iVirtualMemory, long l2, long l3, int n2, int n3) {
        return DataStringUtil.getStringItemFromMemory(null, iVirtualMemory, l2, l3, null, n2, n3);
    }

    public static INativeStringItem createFromMemory(INativeDataAnalyzer iNativeDataAnalyzer, ILabelManager iLabelManager, IVirtualMemory iVirtualMemory, long l2, long l3, StringEncoding stringEncoding, int n2, int n3) {
        StringEntry stringEntry = DataStringUtil.getStringItemFromMemory(iNativeDataAnalyzer, iVirtualMemory, l2, l3, stringEncoding, n2, n3);
        if (stringEntry == null) {
            return null;
        }
        return stringEntry.item;
    }

    private static StringEntry getStringItemFromMemory(INativeDataAnalyzer iNativeDataAnalyzer, IVirtualMemory iVirtualMemory, long l2, long l3, StringEncoding stringEncoding, int n2, int n3) {
        Object object;
        boolean bl;
        if (n2 < 0) {
            n2 = 3;
        }
        if (n3 <= 0 || n3 > 100000) {
            n3 = 100000;
        }
        if (n2 > n3) {
            return null;
        }
        List<Object> list = null;
        if (stringEncoding != null) {
            list = new ArrayList<StringEncoding>();
            list.add((Object)stringEncoding);
        }
        boolean bl2 = bl = stringEncoding == null;
        if (bl && (list = DataStringUtil.heurDetermineStringType(iVirtualMemory, l2)).isEmpty()) {
            return null;
        }
        ArrayList<StringEntry> arrayList = new ArrayList<StringEntry>();
        for (StringEncoding n7 : list) {
            int n4 = DataStringUtil.getSimpleCharSize(n7);
            int n5 = n3 * n4;
            long l4 = l2 + (long)n5;
            if (l3 >= 0L) {
                l4 = Math.min(l3, l4);
                n5 = (int)(l4 - l2);
                n3 = n5 / n4;
            }
            if ((object = DataStringUtil.determineSize(iVirtualMemory, l2, l4, n5, n4, n7)) == null) continue;
            int n6 = ((Couple)object).getFirst();
            StringEncoding stringEncoding2 = ((Couple)object).getSecond();
            String string = DataStringUtil.determineValue(stringEncoding2, iVirtualMemory, l2, n6, bl);
            if (string == null || string.length() < n2 || string.length() > n3 || bl && !DataStringUtil.heurIsValidString(string, n2)) continue;
            StringEntry stringEntry = new StringEntry(string, l2, n6, stringEncoding2, null);
            arrayList.add(stringEntry);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        StringEntry stringEntry = DataStringUtil.chooseBestStringType(arrayList);
        if (iNativeDataAnalyzer == null) {
            return stringEntry;
        }
        int n7 = DataStringUtil.getSimpleCharSize(stringEntry.encoding);
        ITypeManager iTypeManager = iNativeDataAnalyzer.getTypeManager();
        IPrimitiveType iPrimitiveType = iTypeManager.getPrimitives().getIntegerBySize(n7, true);
        IArrayType iArrayType = iTypeManager.createArray(iPrimitiveType, stringEntry.size / n7);
        axr axr2 = (axr)iNativeDataAnalyzer.createString(l2, stringEntry.size, iArrayType, stringEntry.encoding, null);
        axr2.fz(stringEntry.str);
        object = DataStringUtil.createItemNameFromString(stringEntry.str, 16);
        if (object != null) {
            axr2.setName((String)object);
        }
        stringEntry.item = axr2;
        return stringEntry;
    }

    private static StringEntry chooseBestStringType(List<StringEntry> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.get((int)0).encoding == StringEncoding.UTF16_LE_ZERO && list.get((int)1).encoding == StringEncoding.ASCII_ZERO) {
            HashSet hashSet = new HashSet();
            boolean bl = false;
            for (int i = 0; i < list.get((int)0).str.length(); ++i) {
                char c2 = list.get((int)0).str.charAt(i);
                if (c2 >= '\u0100') {
                    bl = true;
                    break;
                }
                if (!hashSet.contains(Character.valueOf(c2))) continue;
                return list.get(0);
            }
            Object[] objectArray = new Object[]{list.get((int)0).str, list.get((int)1).str};
            if (bl && hashSet.size() <= 2) {
                return list.get(1);
            }
        }
        return list.get(0);
    }

    private static List<StringEncoding> heurDetermineStringType(IVirtualMemory iVirtualMemory, long l2) {
        ArrayList<StringEncoding> arrayList = new ArrayList<StringEncoding>();
        byte[] byArray = new byte[4];
        int n2 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, 4, byArray, 0, 1);
        if (n2 == 4) {
            if (byArray[0] != 0) {
                if (byArray[1] == 0 && byArray[2] != 0 && byArray[3] == 0) {
                    arrayList.add(StringEncoding.UTF16_LE_ZERO);
                } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] != 0 && byArray[3] == 0) {
                    arrayList.add(StringEncoding.UTF16_ZERO);
                } else if (byArray[0] == -2 && byArray[1] == -1 && byArray[2] == 0 && byArray[3] != 0) {
                    arrayList.add(StringEncoding.UTF16_ZERO);
                }
                if (Characters.isAsciiChar(byArray[0]) && DataStringUtil.areAsciiCharOrEnd(byArray[1], byArray[2], byArray[3])) {
                    arrayList.add(StringEncoding.ASCII_ZERO);
                } else if (DataStringUtil.isValidUtf8Start(byArray[0], byArray[1], byArray[2], byArray[3])) {
                    arrayList.add(StringEncoding.UTF8_ZERO);
                }
            } else if (byArray[1] != 0 && byArray[2] == 0 && byArray[3] != 0) {
                arrayList.add(StringEncoding.UTF16_BE_ZERO);
            }
        }
        return arrayList;
    }

    private static boolean isValidUtf8Start(byte ... byArray) {
        int n2 = 0;
        int n3 = 0;
        for (byte by : byArray) {
            int n4 = by & 0xFF;
            if (n3 == 0) {
                if (by == 0) {
                    return true;
                }
                n2 = n4;
                if (n4 >= 0 && n4 <= 127) {
                    n3 = 0;
                    continue;
                }
                if (n4 >= 194 && n4 <= 244) {
                    n3 = 1;
                    continue;
                }
                return false;
            }
            if (n3 <= 0) continue;
            if (n4 < 80 || n4 > 191) {
                return false;
            }
            if (n2 >= 194 && n2 <= 223) {
                n3 = 0;
            }
            if (n2 >= 224 && n2 <= 239) {
                n3 = n3 < 2 ? ++n3 : 0;
            }
            if (n2 < 240 || n2 > 244) continue;
            if (n3 < 3) {
                ++n3;
                continue;
            }
            n3 = 0;
        }
        return true;
    }

    private static boolean areAsciiCharOrEnd(byte ... byArray) {
        for (byte by : byArray) {
            if (by == 0) {
                return true;
            }
            if (Characters.isAsciiChar(by)) continue;
            return false;
        }
        return false;
    }

    private static int getSimpleCharSize(StringEncoding stringEncoding) {
        switch (stringEncoding) {
            case ASCII_ZERO: 
            case UTF8_ZERO: 
            case UTF8_NONZERO: {
                return 1;
            }
            case UTF16_LE_ZERO: 
            case UTF16_BE_ZERO: 
            case UTF16_ZERO: {
                return 2;
            }
        }
        throw new RuntimeException("Unsupported string type: " + stringEncoding);
    }

    private static Couple<Integer, StringEncoding> determineSize(IVirtualMemory iVirtualMemory, long l2, long l3, int n2, int n3, StringEncoding stringEncoding) {
        int n4;
        int n5 = Math.min(n2, 256);
        byte[] byArray = new byte[n5];
        int n6 = 0;
        boolean bl = false;
        for (long i = l2; i < l3; i += (long)n4) {
            int n7;
            int n8 = Math.min(n5, (int)(l3 - i));
            n4 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, i, n8, byArray, 0, 1);
            if (n4 <= 0) {
                return null;
            }
            if (n3 == 1) {
                for (n7 = 0; n7 < n4; ++n7) {
                    if (byArray[n7] == 0) {
                        bl = true;
                        ++n7;
                        break;
                    }
                    if (stringEncoding != StringEncoding.ASCII_ZERO || Characters.isAsciiCharOrCommonFormat(byArray[n7])) continue;
                    stringEncoding = StringEncoding.UTF8_ZERO;
                }
            } else if (n3 == 2) {
                for (n7 = 0; n7 < n4 - 1; n7 += 2) {
                    if (byArray[n7] != 0 || byArray[n7 + 1] != 0) continue;
                    bl = true;
                    n7 += 2;
                    break;
                }
            } else {
                throw new RuntimeException();
            }
            n6 += n7;
            if (n7 < n4 || bl) break;
        }
        if (!bl && stringEncoding != null && stringEncoding.isZeroTerminated()) {
            return null;
        }
        if (n6 % n3 != 0) {
            return null;
        }
        return new Couple<Integer, StringEncoding>(n6, stringEncoding);
    }

    private static String createItemNameFromString(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(NAME_PREFIX);
        for (int i = 0; i < string.length() && i < 64; ++i) {
            char c2 = string.charAt(i);
            if (Character.isLetterOrDigit(c2)) {
                if (i == 0) {
                    c2 = Character.toUpperCase(c2);
                }
                stringBuilder.append(c2);
            } else if (!Character.isIdentifierIgnorable(c2)) {
                stringBuilder.append('_');
            }
            if (n2 >= 0 && stringBuilder.length() >= n2) break;
        }
        return stringBuilder.toString();
    }

    public static String determineValue(INativeStringItem iNativeStringItem, IVirtualMemory iVirtualMemory, boolean bl) {
        byte[] byArray;
        int n2;
        long l2 = iNativeStringItem.getMemoryAddress();
        int n3 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, n2 = (int)iNativeStringItem.getMemorySize(), byArray = new byte[n2], 0, 1);
        if (n3 < n2) {
            return null;
        }
        return DataStringUtil.determineValue(iNativeStringItem.getStringType(), byArray, 0, n2, bl);
    }

    public static String determineValue(StringEncoding stringEncoding, IVirtualMemory iVirtualMemory, long l2, int n2, boolean bl) {
        byte[] byArray = new byte[n2];
        int n3 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, n2, byArray, 0, 1);
        if (n3 < n2) {
            return null;
        }
        return DataStringUtil.determineValue(stringEncoding, byArray, 0, n2, bl);
    }

    public static String determineValue(StringEncoding stringEncoding, byte[] byArray, int n2, int n3, boolean bl) {
        byte[] byArray2;
        int n4 = n3 - (stringEncoding.isZeroTerminated() ? stringEncoding.getBasicCharSize() : 0);
        Charset charset = stringEncoding.getCharset();
        String string = new String(byArray, n2, n4, charset);
        if (bl && ((byArray2 = string.getBytes(charset)).length != n4 || ArrayUtil.compareBytes(byArray2, 0, byArray, n2, n4) != 0)) {
            return null;
        }
        return string;
    }

    public static boolean heurIsValidString(String string, int n2) {
        HashMap<Character.UnicodeBlock, Integer> hashMap = new HashMap<Character.UnicodeBlock, Integer>();
        HashSet<Character> hashSet = new HashSet<Character>();
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            char c2 = string.charAt(i);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                Character.UnicodeBlock unicodeBlock;
                object = (Integer)hashMap.get(unicodeBlock = Character.UnicodeBlock.BASIC_LATIN);
                hashMap.put(unicodeBlock, object == null ? 1 : (Integer)object + 1);
                ++n3;
                continue;
            }
            if (c2 >= ' ' && c2 <= '~' || c2 == '\r' || c2 == '\n' || c2 == '\t') {
                ++n3;
                continue;
            }
            int n4 = Character.getType(c2);
            switch (n4) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    object = Character.UnicodeBlock.of(c2);
                    Integer n5 = (Integer)hashMap.get(object);
                    hashMap.put((Character.UnicodeBlock)object, n5 == null ? 1 : n5 + 1);
                    break;
                }
                case 28: {
                    if (c2 == '\u00a9' || c2 == '\u00ae' || (c2 == '\u00a6' || c2 == '\u00b0') && i > 2) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            hashSet.add(Character.valueOf(c2));
        }
        if (hashSet.size() + n3 < n2) {
            return false;
        }
        if (hashMap.isEmpty()) {
            return true;
        }
        return DataStringUtil.testCompatibleUnicodeBlocks(hashMap, n2);
    }

    private static boolean testCompatibleUnicodeBlocks(Map<Character.UnicodeBlock, Integer> map, int n2) {
        boolean bl = map.remove(Character.UnicodeBlock.BASIC_LATIN) != null;
        map.remove(Character.UnicodeBlock.CURRENCY_SYMBOLS);
        map.remove(Character.UnicodeBlock.SPACING_MODIFIER_LETTERS);
        map.remove(Character.UnicodeBlock.GENERAL_PUNCTUATION);
        map.remove(Character.UnicodeBlock.GENERAL_PUNCTUATION);
        map.remove(Character.UnicodeBlock.SUPPLEMENTAL_PUNCTUATION);
        if (map.isEmpty()) {
            return true;
        }
        if (!bl && map.containsKey(Character.UnicodeBlock.LATIN_1_SUPPLEMENT)) {
            return false;
        }
        Optional<Integer> optional = map.values().stream().reduce(Integer::sum);
        if (!optional.isPresent() || optional.get() < n2) {
            return false;
        }
        if (map.size() <= 1) {
            return true;
        }
        String string = null;
        for (Character.UnicodeBlock object : map.keySet()) {
            if (string == null) {
                string = object.toString();
                continue;
            }
            if (!(string = Strings.commonPrefix(string, object.toString())).isEmpty()) continue;
            break;
        }
        if (string.length() >= 5 || string.startsWith("YI") || string.startsWith("CJK_")) {
            return true;
        }
        for (UnicodeLanguage unicodeLanguage : languages) {
            if (!unicodeLanguage.isValid(map.keySet())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSafeAsciiStringAt(IVirtualMemory iVirtualMemory, long l2, int n2, int n3) {
        return DataStringUtil.isSafeAsciiStringAt(iVirtualMemory, l2, StringEncoding.ASCII_ZERO, n2, n3);
    }

    public static boolean isSafeAsciiStringAt(IVirtualMemory iVirtualMemory, long l2, StringEncoding stringEncoding, int n2, int n3) {
        int n4;
        Couple<Integer, StringEncoding> couple;
        if (n3 <= 0 || stringEncoding == null) {
            return false;
        }
        int n5 = DataStringUtil.getSimpleCharSize(stringEncoding);
        int n6 = n3 * n5;
        byte[] byArray = new byte[n6];
        if ((couple = DataStringUtil.determineSize(iVirtualMemory, l2, l2 + (long)(n6 += stringEncoding.isZeroTerminated() ? n5 : 0), n6, n5, stringEncoding)) == null || couple.getSecond() != stringEncoding || couple.getFirst() - (stringEncoding.isZeroTerminated() ? n5 : 0) < n2 * n5) {
            return false;
        }
        int n7 = couple.getFirst() - n5;
        int n8 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, n7, byArray, 0, 1);
        if (n8 < 1) {
            return false;
        }
        boolean bl = true;
        if (stringEncoding == StringEncoding.UTF16_ZERO) {
            if (n7 < 2) {
                return false;
            }
            if (byArray[0] == -2 && byArray[1] == -1) {
                bl = false;
            } else if (byArray[0] == -1 && byArray[1] == -2) {
                bl = true;
            } else {
                return false;
            }
        }
        int n9 = n4 = stringEncoding == StringEncoding.UTF16_ZERO ? 2 : 0;
        while (n4 < n7) {
            byte by = byArray[n4];
            if (n5 == 2 && n4 + 1 < n7) {
                byte by2 = byArray[n4 + 1];
                if (stringEncoding == StringEncoding.UTF16_BE_ZERO || !bl) {
                    by = byArray[n4 + 1];
                    by2 = byArray[n4];
                }
                if (by2 != 0) {
                    return false;
                }
                ++n4;
            }
            if (!Characters.isAsciiCharOrCommonFormat(by)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static class UnicodeLanguage {
        List<UnicodeRule> unicodeRules;

        UnicodeLanguage(UnicodeRule ... unicodeRuleArray) {
            this.unicodeRules = Arrays.asList(unicodeRuleArray);
        }

        public boolean isValid(Set<Character.UnicodeBlock> set) {
            for (Character.UnicodeBlock unicodeBlock : set) {
                if (this.isValid(unicodeBlock.toString())) continue;
                return false;
            }
            return true;
        }

        private boolean isValid(String string) {
            for (UnicodeRule unicodeRule : this.unicodeRules) {
                if (!(unicodeRule.match ? string.equals(unicodeRule.name) : unicodeRule.matchStart && string.startsWith(unicodeRule.name))) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnicodeRule {
        String name;
        boolean match = false;
        boolean matchStart = false;

        private UnicodeRule() {
        }

        static UnicodeRule starts(String string) {
            UnicodeRule unicodeRule = new UnicodeRule();
            unicodeRule.name = string;
            unicodeRule.matchStart = true;
            return unicodeRule;
        }

        static UnicodeRule eq(String string) {
            UnicodeRule unicodeRule = new UnicodeRule();
            unicodeRule.name = string;
            unicodeRule.match = true;
            return unicodeRule;
        }
    }
}

