/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class OptimizersPerformanceCounters {
    public SortedMap<String, E> map = new TreeMap<String, E>();

    public SortedMap<String, E> getCounters() {
        return Collections.unmodifiableSortedMap(this.map);
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 0L;
        for (E object : this.map.values()) {
            l2 += object.exectime;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String string = (String)entry.getKey();
            E e = (E)entry.getValue();
            int n2 = l2 == 0L ? 0 : (int)(e.exectime * 100L / l2);
            Strings.ff(stringBuilder, "- \"%s\": rc=%d oc=%d t=%d(%s) (%d%%)\n", string, e.runcnt, e.optcnt, e.exectime, TimeFormatter.formatTimestampDelta(e.exectime), n2);
        }
        Strings.ff(stringBuilder, "Total: %s", TimeFormatter.formatTimestampDelta(l2));
        return stringBuilder.toString();
    }

    public static class E {
        public long exectime;
        public int runcnt;
        public int optcnt;
    }
}

