/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizerTarget;
import com.pnfsoftware.jeb.util.format.Strings;

public class OptimizerEntry<T extends IOptimizerTarget> {
    private IOptimizer<T> opt;
    private int group;
    private boolean enabled;
    Stat stat;

    public OptimizerEntry(IOptimizer<T> iOptimizer, int n2) {
        if (iOptimizer == null) {
            throw new IllegalArgumentException();
        }
        this.opt = iOptimizer;
        this.group = n2;
        this.enabled = true;
        this.stat = new Stat();
    }

    public IOptimizer<T> getOptimizer() {
        return this.opt;
    }

    public int getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        return bl2;
    }

    public Stat getStatistics() {
        return this.stat;
    }

    public String toString() {
        return Strings.ff("Optimizer:\"%s\",stats=%s", this.opt.getPluginInformation().getName(), this.getStatistics());
    }

    public static class Stat {
        long runtimeMs;
        int runcnt;
        int optcnt;

        public long getExecutionTimeMillis() {
            return this.runtimeMs;
        }

        public int getRunCount() {
            return this.runcnt;
        }

        public int getOptimizationCount() {
            return this.optcnt;
        }

        public String toString() {
            return Strings.ff("ms=%d,run=%d,opt=%d", this.getExecutionTimeMillis(), this.getRunCount(), this.getOptimizationCount());
        }
    }
}

