/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.EditablePluginInformation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizerTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerMode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractOptimizer<T extends IOptimizerTarget>
extends AbstractPlugin
implements IOptimizer<T> {
    public static final ILogger logger = GlobalLog.getLogger(AbstractOptimizer.class);
    private EditablePluginInformation info = new EditablePluginInformation();
    private IMasterOptimizer<T> mo;
    private OptimizerMode requiredModeThreshold = OptimizerMode.NORMAL;
    private OptimizerType type;
    private Set<String> tags;
    private double priority = 0.0;
    private int preferredExecStage;

    public AbstractOptimizer() {
        this(null);
    }

    public AbstractOptimizer(T t) {
        this.setType(null);
        this.setName(null);
    }

    protected void setName(String string) {
        int n2;
        if (string == null && (n2 = (string = this.getClass().getSimpleName()).indexOf(36)) >= 0) {
            string = string.substring(0, n2);
        }
        this.info.setName(string);
    }

    public String getName() {
        return this.info.getName();
    }

    @Override
    public EditablePluginInformation getPluginInformation() {
        return this.info;
    }

    @Override
    public void setMasterOptimizer(IMasterOptimizer<T> iMasterOptimizer) {
        this.mo = iMasterOptimizer;
    }

    @Override
    public IMasterOptimizer<T> getMasterOptimizer() {
        return this.mo;
    }

    protected void setType(OptimizerType optimizerType) {
        if (optimizerType == null) {
            optimizerType = OptimizerType.NORMAL;
        }
        this.type = optimizerType;
    }

    @Override
    public OptimizerMode getRequiredModeThreshold() {
        return this.requiredModeThreshold;
    }

    protected void setRequiredModeThreshold(OptimizerMode optimizerMode) {
        this.requiredModeThreshold = optimizerMode;
    }

    @Override
    public OptimizerType getType() {
        return this.type;
    }

    protected void addTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(string);
    }

    protected void removeTag(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.tags == null) {
            return;
        }
        if (this.tags.remove(string) && this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    @Override
    public Set<String> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tags);
    }

    protected void setPreferredExecutionStage(int n2) {
        this.preferredExecStage = n2;
    }

    @Override
    public int getPreferredExecutionStage() {
        return this.preferredExecStage;
    }

    protected void setPriority(double d) {
        this.priority = d;
    }

    @Override
    public final double getPriority() {
        return this.priority;
    }
}

