/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizerInstrumenter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizerTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerMode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizersPerformanceCounters;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.adw;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractMasterOptimizer<T extends IOptimizerTarget>
implements IMasterOptimizer<T> {
    private static final StructuredLogger logger = aeb.ce(AbstractMasterOptimizer.class);
    private static int runmode = 2;
    protected T t;
    private OptimizerMode currentMode = OptimizerMode.NORMAL;
    protected SortedMap<Integer, List<OptimizerEntry<T>>> optGrpMap = new TreeMap<Integer, List<OptimizerEntry<T>>>();
    protected List<OptimizerEntry<T>> optList = new ArrayList<OptimizerEntry<T>>();
    protected int grp1NMaxRunCount;
    protected List<IMasterOptimizerInstrumenter<T>> instrumenters = new ArrayList<IMasterOptimizerInstrumenter<T>>();
    protected boolean enableUnsafeOptimizers;
    protected boolean enableDeobfuscators;
    protected int decryptorSupport;
    private Set<String> tagsAllowed = null;
    private Set<String> tagsBlocked = new HashSet<String>();
    private int totalOptCount;
    private int totalDeobOptCount;

    public AbstractMasterOptimizer(T t, int n2) {
        this.setTarget(t);
        this.grp1NMaxRunCount = n2;
    }

    @Override
    public T getTarget() {
        return this.t;
    }

    @Override
    public void setTarget(T t) {
        this.t = t;
    }

    @Override
    public OptimizerMode setMode(OptimizerMode optimizerMode) {
        OptimizerMode optimizerMode2 = this.currentMode;
        this.currentMode = optimizerMode == null ? OptimizerMode.NORMAL : optimizerMode;
        return optimizerMode2;
    }

    @Override
    public OptimizerMode getMode() {
        return this.currentMode;
    }

    public void setEnableUnsafeOptimizers(boolean bl) {
        this.enableUnsafeOptimizers = bl;
    }

    public boolean isEnableUnsafeOptimizers() {
        return this.enableUnsafeOptimizers;
    }

    public void setEnableDeobfuscators(boolean bl) {
        this.enableDeobfuscators = bl;
    }

    public boolean isEnableDeobfuscators() {
        return this.enableDeobfuscators;
    }

    public void setDecryptorSupport(int n2) {
        this.decryptorSupport = n2;
    }

    public int getDecryptorSupport() {
        return this.decryptorSupport;
    }

    @Override
    public void setPolicyForOptimizerTag(String string, boolean bl) {
        if (bl) {
            if (string == null || string.isEmpty()) {
                this.tagsAllowed = new HashSet<String>();
            } else if (string.equals("*")) {
                this.tagsAllowed = null;
            } else {
                if (this.tagsAllowed == null) {
                    return;
                }
                this.tagsAllowed.add(string);
            }
        } else if (string == null || string.isEmpty()) {
            this.tagsBlocked = new HashSet<String>();
        } else if (string.equals("*")) {
            this.tagsBlocked = null;
        } else {
            if (this.tagsBlocked == null) {
                return;
            }
            this.tagsBlocked.add(string);
        }
    }

    @Override
    public OptimizerEntry<T> registerOptimizer(IOptimizer<T> iOptimizer) {
        return this.registerOptimizer(1, iOptimizer);
    }

    @Override
    public OptimizerEntry<T> registerOptimizer(int n2, IOptimizer<T> iOptimizer) {
        if (n2 < -2) {
            throw new IllegalArgumentException("Illegal group id: " + n2);
        }
        if (iOptimizer.getMasterOptimizer() != null && iOptimizer.getMasterOptimizer() != this) {
            throw new IllegalStateException(Strings.ff("The optimizer %s is already used by a master optimizer! Please create a new optimizer object.", iOptimizer));
        }
        iOptimizer.setMasterOptimizer(this);
        if (iOptimizer.getType() == OptimizerType.ON_DEMAND) {
            n2 = -2;
        }
        ArrayList<OptimizerEntry<T>> arrayList = null;
        for (int i = -2; i <= n2; ++i) {
            arrayList = (ArrayList<OptimizerEntry<T>>)this.optGrpMap.get(i);
            if (arrayList != null) continue;
            arrayList = new ArrayList<OptimizerEntry<T>>();
            this.optGrpMap.put(i, arrayList);
        }
        OptimizerEntry<T> optimizerEntry = new OptimizerEntry<T>(iOptimizer, n2);
        arrayList.add(optimizerEntry);
        Collections.sort(arrayList, new Comparator<OptimizerEntry<T>>(){

            @Override
            public int compare(OptimizerEntry<T> optimizerEntry, OptimizerEntry<T> optimizerEntry2) {
                return Double.compare(optimizerEntry2.getOptimizer().getPriority(), optimizerEntry.getOptimizer().getPriority());
            }
        });
        this.optList.add(optimizerEntry);
        return optimizerEntry;
    }

    @Override
    public boolean unregisterOptimizer(OptimizerEntry<T> optimizerEntry) {
        if (!this.optList.remove(optimizerEntry)) {
            return false;
        }
        int n2 = optimizerEntry.getGroup();
        List list = (List)this.optGrpMap.get(n2);
        if (list == null) {
            return false;
        }
        return list.remove(optimizerEntry);
    }

    public void unregisterAllOptimizers() {
        this.optList.clear();
        for (Integer n2 : this.optGrpMap.keySet()) {
            ((List)this.optGrpMap.get(n2)).clear();
        }
    }

    @Override
    public List<OptimizerEntry<T>> getRegisteredOptimizers() {
        return new ArrayList<OptimizerEntry<T>>(this.optList);
    }

    @Override
    public List<OptimizerEntry<T>> getRegisteredOptimizers(int n2) {
        ArrayList<OptimizerEntry<T>> arrayList = new ArrayList<OptimizerEntry<T>>();
        List list = (List)this.optGrpMap.get(n2);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public OptimizerEntry<T> getOptimizer(Class<? extends IOptimizer<T>> clazz) {
        for (OptimizerEntry<T> optimizerEntry : this.getRegisteredOptimizers()) {
            if (!clazz.isInstance(optimizerEntry.getOptimizer())) continue;
            return optimizerEntry;
        }
        return null;
    }

    @Override
    public int getTotalOptimizationCount() {
        return this.totalOptCount;
    }

    @Override
    public int getOptimizationCount(boolean bl) {
        if (bl) {
            return this.totalDeobOptCount;
        }
        return this.totalOptCount;
    }

    @Override
    public IOptimizer<T> getOptimizerObject(Class<? extends IOptimizer<T>> clazz) {
        OptimizerEntry<T> optimizerEntry = this.getOptimizer(clazz);
        return optimizerEntry == null ? null : optimizerEntry.getOptimizer();
    }

    @Override
    public int perform() {
        if (runmode == 0) {
            return this.performV1();
        }
        if (runmode == 1) {
            return this.performV2(false);
        }
        if (runmode == 2) {
            return this.performV2(true);
        }
        throw new RuntimeException("Unknown runmode: " + runmode);
    }

    protected int performV1() {
        int n2;
        int n3;
        int n4 = 0;
        Object[] cfr_ignored_0 = new Object[0];
        T t = this.getTarget();
        this.preAllOptimizationsCallback(t);
        List list = (List)this.optGrpMap.get(0);
        if (list != null) {
            n4 += this.performMultiple(list, 0);
        }
        if (this.grp1NMaxRunCount < 0) {
            n3 = Integer.MAX_VALUE;
        } else {
            n2 = this.optGrpMap.subMap(1, Integer.MAX_VALUE).size();
            n3 = this.grp1NMaxRunCount * Math.max(1, n2);
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
        }
        n2 = n3;
        int n5 = 1;
        int n6 = 0;
        while (n2-- > 0 && (list = (List)this.optGrpMap.get(n5)) != null) {
            int n7 = this.performMultiple(list, n5);
            n4 += n7;
            if (n5 > n6) {
                n6 = n5;
            }
            if (n7 > 0) {
                n5 = 1;
                continue;
            }
            ++n5;
        }
        if (n2 < 0) {
            logger.debug("opti runcount: exhausted", new Object[0]);
            if (n6 < this.optGrpMap.lastKey()) {
                logger.debug("some optimizer groups were not executed!", new Object[0]);
            }
            this.reportMaxOptiRunCountReached(t);
        }
        if ((list = (List)this.optGrpMap.get(-1)) != null) {
            this.performMultiple(list, -1);
        }
        this.postAllOptimizationsCallback(t);
        return n4;
    }

    protected int performV2(boolean bl) {
        int n2;
        Object[] cfr_ignored_0 = new Object[0];
        T t = this.getTarget();
        this.preAllOptimizationsCallback(t);
        this.optList.sort((optimizerEntry, optimizerEntry2) -> -Double.compare(optimizerEntry.getOptimizer().getPriority(), optimizerEntry2.getOptimizer().getPriority()));
        ArrayList<OptimizerEntry<T>> arrayList = new ArrayList<OptimizerEntry<T>>(this.optList);
        int n3 = bl ? 400 : 100;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n4 = 0;
        int n5 = 0;
        do {
            if (n4 > n3) {
                String string = "Optimization round exceeding threshold";
                adw.ce(new RuntimeException(string));
                break;
            }
            linkedHashSet.clear();
            n2 = 0;
            for (OptimizerEntry optimizerEntry3 : arrayList) {
                int n6 = this.performSingle(optimizerEntry3);
                if (n6 > 0) {
                    n2 += n6;
                    linkedHashSet.add(optimizerEntry3.getOptimizer());
                }
                if (!bl || n6 <= 0) continue;
                break;
            }
            n5 += n2;
            ++n4;
        } while (n2 > 0);
        this.postAllOptimizationsCallback(t);
        return n5;
    }

    private void reportMaxOptiRunCountReached(T t) {
    }

    @Override
    public int performMultiple(List<OptimizerEntry<T>> list) {
        return this.performMultiple(list, null);
    }

    private int performMultiple(List<OptimizerEntry<T>> list, Integer n2) {
        (new Object[1])[0] = n2;
        int n3 = 0;
        for (OptimizerEntry<T> optimizerEntry : list) {
            n3 += this.performSingle(optimizerEntry);
        }
        return n3;
    }

    @Override
    public int performSingle(OptimizerEntry<T> optimizerEntry) {
        if (!optimizerEntry.isEnabled()) {
            return 0;
        }
        IOptimizer<T> iOptimizer = optimizerEntry.getOptimizer();
        if (!this.getMode().meetsRequirement(iOptimizer.getRequiredModeThreshold())) {
            return 0;
        }
        if (iOptimizer.getType() == OptimizerType.ON_DEMAND) {
            return 0;
        }
        if (!this.enableUnsafeOptimizers && iOptimizer.getType() == OptimizerType.UNSAFE) {
            return 0;
        }
        boolean bl = iOptimizer.getTags().contains("deobfuscator");
        if (!this.enableDeobfuscators && bl) {
            return 0;
        }
        T t = this.getTarget();
        this.preOptimizationCallback(t, optimizerEntry);
        long l2 = System.nanoTime();
        int n2 = 0;
        try {
            n2 = iOptimizer.performOnTarget(t);
            if (n2 > 0) {
                this.totalOptCount += n2;
                if (bl) {
                    this.totalDeobOptCount += n2;
                }
            }
        }
        catch (Exception exception) {
            if (!this.onOptimizerException(t, iOptimizer, exception)) {
                throw exception;
            }
        }
        long l3 = (System.nanoTime() - l2) / 1000000L;
        this.postOptimizationCallback(t, optimizerEntry, n2, l3);
        ++optimizerEntry.stat.runcnt;
        optimizerEntry.stat.optcnt += n2;
        optimizerEntry.stat.runtimeMs += l3;
        adw.ce();
        return n2;
    }

    protected void preAllOptimizationsCallback(T t) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.preAllOptimizationsCallback(t);
        }
    }

    protected void preOptimizationCallback(T t, OptimizerEntry<T> optimizerEntry) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.preOptimizationCallback(t, optimizerEntry);
        }
    }

    protected void postAllOptimizationsCallback(T t) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.postAllOptimizationsCallback(t);
        }
    }

    protected void postOptimizationCallback(T t, OptimizerEntry<T> optimizerEntry, int n2, long l2) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.postOptimizationCallback(t, optimizerEntry, n2, l2);
        }
    }

    @Override
    public void registerInstrumenter(IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter) {
        this.instrumenters.add(iMasterOptimizerInstrumenter);
    }

    @Override
    public boolean unregisterInstrumenter(IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter) {
        return this.instrumenters.remove(iMasterOptimizerInstrumenter);
    }

    protected boolean onOptimizerException(T t, IOptimizer<T> iOptimizer, Exception exception) {
        logger.error("An optimizer failed on %s: %s: %s", t.getTargetName(), iOptimizer.getPluginInformation(), exception);
        return true;
    }

    public OptimizersPerformanceCounters retrievePerformanceCounters() {
        OptimizersPerformanceCounters optimizersPerformanceCounters = new OptimizersPerformanceCounters();
        for (OptimizerEntry<T> optimizerEntry : this.getRegisteredOptimizers()) {
            String string = optimizerEntry.getOptimizer().getPluginInformation().getName();
            OptimizerEntry.Stat stat = optimizerEntry.getStatistics();
            OptimizersPerformanceCounters.E e = new OptimizersPerformanceCounters.E();
            e.exectime = stat.getExecutionTimeMillis();
            e.runcnt = stat.getRunCount();
            e.optcnt = stat.getOptimizationCount();
            optimizersPerformanceCounters.map.put(string, e);
        }
        return optimizersPerformanceCounters;
    }

    protected abstract String getTargetAddress(T var1);
}

