/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt;

import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EPatternCompiler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EPatternMatcher;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.AbstractEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractEPatternOptimizer
extends AbstractEOptimizer {
    private static final StructuredLogger logger = aeb.ce(AbstractEPatternOptimizer.class);

    public AbstractEPatternOptimizer() {
        this(true);
    }

    public AbstractEPatternOptimizer(boolean bl) {
        super(bl ? DataChainsUpdatePolicy.UPDATE_IF_OPTIMIZED : DataChainsUpdatePolicy.UPDATE_IF_REQUIRED);
    }

    protected abstract Collection<EPatternCompiler.EPattern> getPatterns();

    private static Map<IEGeneric, Integer> generateDescDepthsMap(CFG<IEStatement> cFG) {
        IdentityHashMap<IEGeneric, Integer> identityHashMap = new IdentityHashMap<IEGeneric, Integer>();
        for (IEStatement iEStatement : cFG.instructions()) {
            AbstractEPatternOptimizer.calcDescDepthsRecurse(iEStatement, identityHashMap);
        }
        return identityHashMap;
    }

    private static Map<IEGeneric, Integer> generateDescDepthsMap(IEGeneric iEGeneric) {
        IdentityHashMap<IEGeneric, Integer> identityHashMap = new IdentityHashMap<IEGeneric, Integer>();
        AbstractEPatternOptimizer.calcDescDepthsRecurse(iEGeneric, identityHashMap);
        return identityHashMap;
    }

    private static int calcDescDepthsRecurse(IEGeneric iEGeneric, Map<IEGeneric, Integer> map) {
        int n2;
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        if (arrayList.isEmpty()) {
            n2 = 0;
        } else {
            int n3 = 0;
            for (IEGeneric iEGeneric2 : arrayList) {
                int n4 = AbstractEPatternOptimizer.calcDescDepthsRecurse(iEGeneric2, map);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            n2 = 1 + n3;
        }
        map.put(iEGeneric, n2);
        return n2;
    }

    @Override
    protected int perform() {
        int n2 = 0;
        Map<IEGeneric, Integer> map = null;
        boolean bl = false;
        for (EPatternCompiler.EPattern ePattern : this.getPatterns()) {
            EPatternMatcher ePatternMatcher = new EPatternMatcher(ePattern, this.cfg, this.ectx);
            if (map == null) {
                map = AbstractEPatternOptimizer.generateDescDepthsMap(this.cfg);
            }
            ePatternMatcher.setIRDepthsMap(map);
            EPatternMatcher.Result result = null;
            while ((result = ePatternMatcher.search(result)) != null) {
                if (!ePatternMatcher.replace(result, false)) continue;
                if (!bl && ePatternMatcher.getPattern().getOutput() != null && (ePatternMatcher.getPattern().getOutput().getFlags() & 0x100) != 0) {
                    bl = true;
                }
                map = null;
                ++n2;
            }
        }
        return this.postPerform(n2, bl);
    }

    @Override
    public IEGeneric performOnExpression(IEGeneric iEGeneric, IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
        int n2 = 0;
        Map<IEGeneric, Integer> map = null;
        block0: for (EPatternCompiler.EPattern ePattern : this.getPatterns()) {
            EPatternMatcher ePatternMatcher = new EPatternMatcher(ePattern, iEGeneric, iERoutineContext);
            EPatternMatcher.Result result = null;
            while (true) {
                if (map == null) {
                    map = AbstractEPatternOptimizer.generateDescDepthsMap(iEGeneric);
                }
                ePatternMatcher.setIRDepthsMap(map);
                if ((result = ePatternMatcher.search(result)) == null) continue block0;
                if (!ePatternMatcher.replace(result, false)) continue;
                map = null;
                ++n2;
                if (result.getOptimizedExpression() != iEGeneric) break;
            }
            iEGeneric = result.getOptimizedExpression();
            break;
        }
        if (n2 <= 0) {
            return null;
        }
        return iEGeneric;
    }
}

