/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt;

import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.EMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.AbstractOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerType;
import com.pnfsoftware.jebglobal.amr;

public abstract class AbstractEOptimizer
extends AbstractOptimizer<IERoutineContext>
implements IEOptimizer {
    private DataChainsUpdatePolicy dataChainsUpdatePolicy;
    protected IERoutineContext ectx;
    protected CFG<IEStatement> cfg;

    public AbstractEOptimizer() {
        this(null);
    }

    public AbstractEOptimizer(DataChainsUpdatePolicy dataChainsUpdatePolicy) {
        this(dataChainsUpdatePolicy, null);
    }

    public AbstractEOptimizer(DataChainsUpdatePolicy dataChainsUpdatePolicy, OptimizerType optimizerType) {
        this.setType(optimizerType);
        this.setDataChainsUpdatePolicy(dataChainsUpdatePolicy);
    }

    public IEMasterOptimizer getMasterOptimizer() {
        return (IEMasterOptimizer)super.getMasterOptimizer();
    }

    protected IEMasterOptimizer getMasterOptimizerSafe() {
        IEMasterOptimizer iEMasterOptimizer = this.getMasterOptimizer();
        if (iEMasterOptimizer == null) {
            iEMasterOptimizer = EMasterOptimizer.EMPTY;
        }
        return iEMasterOptimizer;
    }

    @Override
    public DataChainsUpdatePolicy getDataChainsUpdatePolicy() {
        return this.dataChainsUpdatePolicy;
    }

    protected void setDataChainsUpdatePolicy(DataChainsUpdatePolicy dataChainsUpdatePolicy) {
        if (dataChainsUpdatePolicy == null) {
            dataChainsUpdatePolicy = DataChainsUpdatePolicy.UPDATE_PERFORMED_INTERNALLY;
        }
        this.dataChainsUpdatePolicy = dataChainsUpdatePolicy;
    }

    @Override
    public IEGeneric performOnExpression(IEGeneric iEGeneric, IERoutineContext iERoutineContext) {
        return null;
    }

    @Override
    public final int performOnTarget(IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
        this.cfg = iERoutineContext.getCfg();
        try {
            int n2 = this.perform();
            return n2;
        }
        finally {
            this.ectx = null;
            this.cfg = null;
        }
    }

    protected abstract int perform();

    protected final int postPerform(int n2) {
        return this.postPerform(n2, false);
    }

    protected final int postPerform(int n2, boolean bl) {
        if (n2 > 0 && (this.dataChainsUpdatePolicy == DataChainsUpdatePolicy.UPDATE_IF_OPTIMIZED || this.dataChainsUpdatePolicy == DataChainsUpdatePolicy.UPDATE_IF_REQUIRED && bl)) {
            this.ectx.invalidateDataFlowAnalysis();
        }
        return n2;
    }

    @Deprecated
    protected final int postPerform(boolean bl, int n2) {
        return this.postPerform(n2);
    }

    @Deprecated
    protected final int postPerform(boolean bl, int n2, boolean bl2) {
        return this.postPerform(n2, bl2);
    }

    protected boolean deleteUnreachableTrampoline(BasicBlock<IEStatement> basicBlock) {
        return amr.ce(this.cfg, basicBlock);
    }

    protected int cleanCfg() {
        return amr.ce(this.cfg);
    }

    protected void verifyCfg() {
        EUtil.verify(this.ectx);
    }

    protected void dumpCfg(String string) {
        EUtil.dump(this.ectx.getCfg(), string);
    }
}

