/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt;

import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.DecompilerException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EExpressionGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EExpressionMatcher;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.SubstitutionDefinition;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.AbstractEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;

public abstract class AbstractEExpressionOptimizer
extends AbstractEOptimizer {
    protected boolean skipStatementProcessing = true;
    protected boolean skipLeftSideOfAssignment = false;
    protected IEStatement currentStatement = null;

    public AbstractEExpressionOptimizer(DataChainsUpdatePolicy dataChainsUpdatePolicy) {
        super(dataChainsUpdatePolicy);
    }

    @Override
    protected int perform() {
        boolean[] blArray = new boolean[]{false};
        int n2 = 0;
        for (BasicBlock<IEStatement> basicBlock : this.cfg.getBlocks()) {
            for (int i = 0; i < basicBlock.size(); ++i) {
                int n3;
                IEStatement iEStatement;
                this.currentStatement = iEStatement = (IEStatement)basicBlock.get(i);
                do {
                    Object object;
                    Object object2;
                    n3 = 0;
                    if (!this.skipStatementProcessing && (object2 = this.optimizeExpression(iEStatement)) != null) {
                        ((EOR)object2).safeCopyType(iEStatement);
                        object = ((EOR)object2).getExpression();
                        if (!(object instanceof IEStatement)) {
                            throw new DecompilerException("Expected a statement IRE");
                        }
                        iEStatement = (IEStatement)((EOR)object2).getExpression();
                        basicBlock.set(i, iEStatement);
                        if (((EOR)object2).getUpdateDFA()) {
                            blArray[0] = true;
                        }
                        ++n3;
                    }
                    if (n3 == 0) {
                        if (this.skipLeftSideOfAssignment && iEStatement instanceof IEAssign) {
                            object2 = (IEAssign)iEStatement;
                            n3 += this.optimize((IEGeneric)object2, object2.getSrcOperand(), blArray, null);
                            if (object2.getDstOperand() instanceof IEMem) {
                                object = (IEMem)object2.getDstOperand();
                                n3 += this.optimize(object2.getDstOperand(), object.getReference(), blArray, null);
                            }
                        } else {
                            object2 = EUtil.getSubExpressions(iEStatement);
                            object = object2.iterator();
                            while (object.hasNext()) {
                                IEGeneric iEGeneric = (IEGeneric)object.next();
                                n3 += this.optimize(iEStatement, iEGeneric, blArray, null);
                            }
                        }
                    }
                    n2 += n3;
                } while (n3 > 0);
            }
        }
        this.currentStatement = null;
        return this.postPerform(n2, blArray[0]);
    }

    @Override
    public IEGeneric performOnExpression(IEGeneric iEGeneric, IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
        IEGeneric[] iEGenericArray = new IEGeneric[1];
        int n2 = this.optimize(null, iEGeneric, null, iEGenericArray);
        if (n2 <= 0) {
            return null;
        }
        if (iEGenericArray[0] != null) {
            return iEGenericArray[0];
        }
        return iEGeneric;
    }

    private int optimize(IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean[] blArray, IEGeneric[] iEGenericArray) {
        EOR eOR = this.optimizeExpression(iEGeneric2);
        if (eOR != null) {
            eOR.safeCopyType(iEGeneric2);
            if (iEGeneric == null) {
                if (iEGenericArray != null) {
                    iEGenericArray[0] = eOR.getExpression();
                }
            } else if (!iEGeneric.replaceSubExpression(iEGeneric2, eOR.getExpression())) {
                return 0;
            }
            if (eOR.getUpdateDFA() && blArray != null) {
                blArray[0] = true;
            }
            return 1;
        }
        int n2 = 0;
        for (IEGeneric iEGeneric3 : EUtil.getSubExpressions(iEGeneric2)) {
            n2 += this.optimize(iEGeneric2, iEGeneric3, blArray, iEGenericArray);
        }
        return n2;
    }

    protected abstract EOR optimizeExpression(IEGeneric var1);

    protected IEGeneric doSubstitution(IEGeneric iEGeneric, SubstitutionDefinition ... substitutionDefinitionArray) {
        for (SubstitutionDefinition substitutionDefinition : substitutionDefinitionArray) {
            EExpressionMatcher eExpressionMatcher = new EExpressionMatcher(substitutionDefinition.getPattern());
            if (!eExpressionMatcher.isMatch(iEGeneric)) continue;
            IEGeneric iEGeneric2 = new EExpressionGenerator(this.ectx, substitutionDefinition.getReplacement()).generate(eExpressionMatcher.getMatchMap());
            return iEGeneric2;
        }
        return null;
    }

    public static class EOR {
        private IEGeneric e;
        private boolean updateDFA;

        public static EOR create(IEGeneric iEGeneric, boolean bl) {
            if (iEGeneric == null) {
                return null;
            }
            return new EOR(iEGeneric, bl);
        }

        public static EOR create(IEGeneric iEGeneric) {
            return EOR.create(iEGeneric, false);
        }

        private EOR(IEGeneric iEGeneric, boolean bl) {
            if (iEGeneric == null) {
                throw new NullPointerException("An expression was expected");
            }
            this.e = iEGeneric;
            this.updateDFA = bl;
        }

        public IEGeneric getExpression() {
            return this.e;
        }

        public boolean getUpdateDFA() {
            return this.updateDFA;
        }

        public void safeCopyType(IEGeneric iEGeneric) {
            if (iEGeneric.getType() != null && this.e.getType() == null) {
                if (this.e instanceof IEImm && !((IEImm)this.e).isMutable()) {
                    this.e = ((IEImm)this.e).duplicateToMutable();
                }
                this.e.setType(iEGeneric.getType(), null);
            }
        }
    }
}

