/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.EEmulator;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLayoutInfo;

public class RoutineIOHandler {
    private EEmulator emu;
    private IEGlobalContext g;
    private boolean is64bit;
    private ICallingConvention cc;
    private IStorageEntryGenerator ingen;

    public RoutineIOHandler(EEmulator eEmulator) {
        if (eEmulator == null) {
            throw new IllegalArgumentException();
        }
        this.emu = eEmulator;
        this.g = eEmulator.getGlobalContext();
        this.is64bit = eEmulator.getGlobalContext().getConverter().getRegisterBitsize() == 64;
    }

    public EEmulator getEmulator() {
        return this.emu;
    }

    public void reset(ICallingConvention iCallingConvention) {
        if (iCallingConvention == null) {
            throw new IllegalArgumentException();
        }
        this.cc = iCallingConvention;
        this.ingen = iCallingConvention.getInputsGenerator();
    }

    public long nextAsPtr() {
        StorageEntry storageEntry = this.ingen.next(TypeLayoutInfo.ptr);
        return this.emu.readStorage(storageEntry).getValueAsAddress();
    }

    public int nextAsObj() {
        long l2 = this.nextAsPtr();
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new RuntimeException();
        }
        return (int)l2;
    }

    public void skipJniEnvPtr() {
        if (!this.ingen.getCurrentEntries().isEmpty()) {
            throw new IllegalStateException();
        }
        this.nextAsPtr();
    }

    public int nextAsInt() {
        StorageEntry storageEntry = this.ingen.next(TypeLayoutInfo.i1);
        IEImm iEImm = this.emu.readStorage(storageEntry).truncate(32);
        return (int)iEImm.getValueAsLong();
    }

    public long nextAsLong() {
        StorageEntry storageEntry = this.ingen.next(this.is64bit ? TypeLayoutInfo.i1 : TypeLayoutInfo.i2);
        IEImm iEImm = this.emu.readStorage(storageEntry).truncate(64);
        return iEImm.getValueAsLong();
    }

    public long nextAsSizet() {
        return this.nextAsLong();
    }

    public long nextAsOfft() {
        return this.nextAsLong();
    }

    public float nextAsFloat() {
        StorageEntry storageEntry = this.ingen.next(TypeLayoutInfo.f1);
        IEImm iEImm = this.emu.readStorage(storageEntry);
        if (iEImm.getBitsize() == 32) {
            return iEImm.getValueAsSingleFloat();
        }
        if (iEImm.getBitsize() == 64) {
            return iEImm.truncate(32).getValueAsSingleFloat();
        }
        if (iEImm.getBitsize() > 64) {
            return iEImm.truncate(32).getValueAsSingleFloat();
        }
        throw new RuntimeException();
    }

    public double nextAsDouble() {
        StorageEntry storageEntry = this.ingen.next(this.is64bit ? TypeLayoutInfo.f1 : TypeLayoutInfo.f2);
        IEImm iEImm = this.emu.readStorage(storageEntry);
        if (iEImm.getBitsize() == 64) {
            return iEImm.getValueAsDoubleFloat();
        }
        if (iEImm.getBitsize() > 64) {
            return iEImm.truncate(64).getValueAsDoubleFloat();
        }
        throw new RuntimeException();
    }

    public void retInt(int n2) {
        IEImm iEImm = this.g.createImm(n2, this.g.getRegisterBitsize());
        StorageEntry storageEntry = this.cc.getOutput(TypeLayoutInfo.i1, 0);
        this.emu.writeStorage(storageEntry, iEImm);
    }

    public void retLong(long l2) {
        IEImm iEImm = this.g.createImm(l2, this.g.getRegisterBitsize());
        StorageEntry storageEntry = this.cc.getOutput(this.is64bit ? TypeLayoutInfo.i1 : TypeLayoutInfo.i2, 0);
        this.emu.writeStorage(storageEntry, iEImm);
    }

    public void retSizet(long l2) {
        this.retLong(l2);
    }

    public void retPtr(long l2) {
        IEImm iEImm = this.g.createImm(l2, this.g.getAddressBitsize());
        StorageEntry storageEntry = this.cc.getOutput(TypeLayoutInfo.ptr, 0);
        this.emu.writeStorage(storageEntry, iEImm);
    }

    public void retObj(int n2) {
        this.retInt(n2);
    }

    public void retFloat(float f) {
        IEImm iEImm = this.g.createImm(f);
        StorageEntry storageEntry = this.cc.getOutput(TypeLayoutInfo.f1, 0);
        this.emu.writeStorage(storageEntry, iEImm);
    }

    public void retDouble(double d) {
        IEImm iEImm = this.g.createImm(d);
        StorageEntry storageEntry = this.cc.getOutput(this.is64bit ? TypeLayoutInfo.f1 : TypeLayoutInfo.f2, 0);
        this.emu.writeStorage(storageEntry, iEImm);
    }
}

