/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator;

import com.pnfsoftware.jeb.util.collect.BytePipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemoryWrites {
    private List<E> records = new ArrayList<E>();
    private BytePipe storage = new BytePipe();
    private byte[] data;

    public void record(long l2, byte[] byArray) {
        if (byArray.length == 0) {
            return;
        }
        int n2 = this.storage.available();
        this.storage.append(byArray);
        this.records.add(new E(l2, n2, byArray.length));
    }

    public void complete() {
        this.data = this.storage.getAll();
        this.storage = null;
    }

    public boolean isComplete() {
        return this.data != null;
    }

    private void verifyClosed() {
        if (this.data == null) {
            throw new IllegalStateException("Recording is not complete");
        }
    }

    public int getCountOfRecords() {
        return this.records.size();
    }

    public Record getRecord(int n2) {
        this.verifyClosed();
        E e = this.records.get(n2);
        return new Record(e.addr, Arrays.copyOfRange(this.data, e.offset, e.offset + e.size));
    }

    public byte[] getAggregatedWrittenBytes() {
        this.verifyClosed();
        return this.data;
    }

    public static class Record {
        long address;
        byte[] data;

        Record(long l2, byte[] byArray) {
            this.address = l2;
            this.data = Arrays.copyOf(byArray, byArray.length);
        }

        public long getAddress() {
            return this.address;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private static class E {
        long addr;
        int offset;
        int size;

        E(long l2, int n2, int n3) {
            this.addr = l2;
            this.offset = n2;
            this.size = n3;
        }
    }
}

