/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator;

import com.pnfsoftware.jeb.core.units.code.DecompilationContext;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.INativeContext;
import com.pnfsoftware.jeb.core.units.code.asm.LinuxSyscallResolver;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.AbstractConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ConverterInstructionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.EvaluationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStateHooks;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.IEEmulatorHooks;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.MemoryWrites;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemoryShim;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryChanges;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLayoutInfo;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.collect.CacheMap;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import com.pnfsoftware.jebglobal.alm;
import com.pnfsoftware.jebglobal.alp;
import com.pnfsoftware.jebglobal.amg;
import com.pnfsoftware.jebglobal.axk;
import com.pnfsoftware.jebglobal.axp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class EEmulator {
    private static final ILogger logger = GlobalLog.getLogger(EEmulator.class);
    static boolean debugLogEnabled = false;
    static boolean extraVerboseLogInsn = false;
    static boolean extraVerboseLogIR = false;
    private static final int MODE_ROUTINE = 1;
    private static final int MODE_STUB = 2;
    private static final int MODE_FULL_ROUTINE = 3;
    private static final int MODE_FULL_STUB = 4;
    public static final int defaultMaxIterCount = 10000;
    public static final boolean defaultAllowOpt = false;
    public static final long defaultHeapBase = 0x7C000000L;
    public static final long defaultStackBase = 0x7E000000L;
    public static final boolean defaultResetUnknownRegisters = true;
    public static final long defaultReturnAddr = 287454020L;
    public static final boolean defaultRecordMemoryWrites = false;
    private static final long baseAddressForExterns = 0x7F000000L;
    private static final boolean defaultPerformFreshDecompilations = false;
    private int internalState = 0;
    private INativeDecompilerContext decomp;
    private INativeContext code;
    private IEGlobalContext gctx;
    private IEConverter<?> cv;
    private ProcessorType proctype;
    private ITypeManager typeman;
    private int regsize;
    private int addrsize;
    private int slotsize;
    private IEVar SP;
    private int idSP;
    private IEVar PC;
    private int idPC;
    private EState state;
    private long stackPreferredBase = 0x7E000000L;
    private long stackStart = -1L;
    private int stackSize = 0;
    private boolean resetUnknownRegisters = true;
    private long currentAddrForPseudoRoutines = 0x7F000000L;
    private long retAddr = 287454020L;
    private boolean recordMemoryWrites = false;
    private boolean performFreshDecompilations = false;
    private long heapPreferredBase = 0x7C000000L;
    private long heapCurrent = -1L;
    private long heapEnd = -1L;
    private int execmode;
    private INativeMethodItem routine0;
    private IPrototypeItem proto0;
    private List<IEImm> args = new ArrayList<IEImm>();
    private Long pcStart;
    private Long pcStop;
    private Integer irOffsetStart;
    private Integer irOffsetStop;
    private Map<INativeMethodItem, IERoutineContext> ctxmap = new HashMap<INativeMethodItem, IERoutineContext>();
    private Deque<CSE> callstack = new ArrayDeque<CSE>();
    private IEImm lastEvalResult;
    private Metadata metadata = new Metadata();
    amg pseudoIRContext;
    private CacheMap<Long, ConvertedInsnCachedIREntry> mapConverterCachedEntries;
    private Map<Long, RegisteredRoutine> mapRegisteredRoutines = new HashMap<Long, RegisteredRoutine>();
    private Map<String, RegisteredRoutine> mapRegisteredRoutinesByName = new HashMap<String, RegisteredRoutine>();
    private MemoryWrites memwrites;
    private final AtomicLong currentRequestId = new AtomicLong(1L);
    private volatile long lastRequestId = 0L;
    private List<IEEmulatorHooks> emuhooks = new ArrayList<IEEmulatorHooks>();

    private static void log(String string, Object ... objectArray) {
    }

    public static EEmulator createStandard(IEGlobalContext iEGlobalContext) {
        return EEmulator.createStandard(iEGlobalContext, 10000);
    }

    public static EEmulator createStandard(IEGlobalContext iEGlobalContext, int n2) {
        IVirtualMemoryShim iVirtualMemoryShim = VirtualMemoryUtil.getCopyOnWriteShim(iEGlobalContext.getNativeMemory());
        EState eState = iEGlobalContext.buildEmptyState();
        eState.setMaxEvaluationCount(n2);
        eState.setExecuteSubRoutines(true);
        eState.setMemory(iVirtualMemoryShim);
        return new EEmulator(eState);
    }

    public EEmulator(EState eState) {
        if (eState == null || eState.getGlobalContext() == null) {
            throw new IllegalArgumentException();
        }
        this.state = eState;
        this.gctx = eState.getGlobalContext();
        this.proctype = this.gctx.getNativeContext().getProcessor().getType();
        this.typeman = this.gctx.getNativeContext().getTypeManager();
        this.cv = this.gctx.getConverter();
        this.decomp = this.cv.getDecompiler();
        this.code = this.decomp.getNativeContext();
        this.regsize = this.cv.getRegisterBitsize() / 8;
        this.addrsize = this.cv.getAddressBitsize() / 8;
        this.slotsize = this.cv.getStackSlotSize();
        this.SP = this.cv.getStackPointer();
        this.idSP = this.SP.getId();
        this.PC = this.cv.getProgramCounter();
        this.idPC = this.PC.getId();
        if (this.proctype == ProcessorType.ARM64) {
            eState.setPointerSanitizer(new EState.PointerSanitizer(){

                @Override
                public long process(long l2) {
                    return l2 & 0xFFFFFFFFFFFFL;
                }
            });
        }
    }

    private void verifyState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    private boolean isExecRoutine() {
        return (this.execmode & 1) == 1;
    }

    private boolean isExecFull() {
        return this.execmode >= 3;
    }

    public IEGlobalContext getGlobalContext() {
        return this.gctx;
    }

    public int getRegisterSize() {
        return this.regsize;
    }

    public int getAddressSize() {
        return this.addrsize;
    }

    public int getStackSlotSize() {
        return this.slotsize;
    }

    public void setRecordMemoryWrites(boolean bl) {
        this.verifyState(this.internalState == 0);
        this.recordMemoryWrites = bl;
    }

    public void setResetUnknownRegisters(boolean bl) {
        this.verifyState(this.internalState == 0);
        this.resetUnknownRegisters = bl;
    }

    public void setPreferredStackBase(long l2) {
        this.verifyState(this.internalState == 0);
        this.stackPreferredBase = l2;
    }

    public void setPerformFreshDecompilations(boolean bl) {
        this.performFreshDecompilations = bl;
    }

    public void setStubExecution(IERoutineContext iERoutineContext, int n2, int n3) {
        this.execmode = 2;
        this.routine0 = iERoutineContext.getRoutine();
        this.ctxmap.put(this.routine0, iERoutineContext);
        this.irOffsetStart = n2;
        this.irOffsetStop = n3;
    }

    public void setStubExecution(INativeMethodItem iNativeMethodItem, long l2, long l3) {
        this.execmode = 2;
        this.routine0 = iNativeMethodItem;
        this.pcStart = l2;
        this.pcStop = l3;
    }

    public void setTargetRoutine(INativeMethodItem iNativeMethodItem) {
        this.execmode = 1;
        this.routine0 = iNativeMethodItem;
    }

    public void setPreferredTargetPrototype(IPrototypeItem iPrototypeItem) {
        this.proto0 = iPrototypeItem;
    }

    public void setGlobalRoutineEmulation(INativeMethodItem iNativeMethodItem) {
        this.setGlobalRoutineEmulation(iNativeMethodItem.getMemoryAddress(), iNativeMethodItem.getPrototype());
    }

    public void setGlobalRoutineEmulation(long l2, IPrototypeItem iPrototypeItem) {
        this.execmode = 3;
        this.pcStart = l2;
        this.pcStop = null;
        this.proto0 = iPrototypeItem;
        this.routine0 = null;
        this.ctxmap = null;
        this.callstack = null;
    }

    public void setGlobalStubEmulation(long l2, Long l3) {
        this.execmode = 4;
        this.pcStart = l2;
        this.pcStop = l3;
        this.proto0 = null;
        this.routine0 = null;
        this.ctxmap = null;
        this.callstack = null;
    }

    public void setReturnAddress(long l2) {
        this.retAddr = l2;
    }

    public void clearArgument() {
        this.args.clear();
    }

    public void addArgument(long l2, INativeType iNativeType) {
        this.args.add(alp.ce(l2, iNativeType.getSize() * 8));
    }

    public void addArgument(byte[] byArray, INativeType iNativeType) {
        this.args.add(alp.ce(byArray, iNativeType.getSize() * 8));
    }

    public void addArgument(IEImm iEImm) {
        this.args.add(iEImm);
    }

    public void setArguments(Collection<IEImm> collection) {
        this.args.clear();
        this.args.addAll(collection);
    }

    public static IPrototypeItem retrievePrototype(INativeDecompilerContext iNativeDecompilerContext, INativeMethodItem iNativeMethodItem) {
        if (iNativeMethodItem.getPrototype() != null) {
            return iNativeMethodItem.getPrototype();
        }
        IWildcardPrototype iWildcardPrototype = iNativeDecompilerContext.getGlobalContext().getCandidatePrototype(iNativeMethodItem);
        if (iWildcardPrototype != null) {
            return iWildcardPrototype.resolve();
        }
        return null;
    }

    private IPrototypeItem retrieveTargetPrototype() {
        this.verifyState(this.isExecRoutine());
        if (this.proto0 == null) {
            if (this.routine0 == null) {
                throw new IllegalStateException("No target routine was specified, the prototype cannot be retrieved. You may set it manually.");
            }
            this.proto0 = EEmulator.retrievePrototype(this.decomp, this.routine0);
        }
        return this.proto0;
    }

    public void setup() {
        if (this.internalState != 0) {
            return;
        }
        this.internalState = 1;
        if (this.state.getPrimaryEmulator() == null) {
            this.state.setPrimaryEmulator(this);
            this.state.registerHooks(new MemHooks(), true);
            if (this.recordMemoryWrites) {
                this.memwrites = new MemoryWrites();
            }
        } else {
            this.state.pushFrame();
        }
        boolean bl = this.state.setDisabledHooks(true);
        Long l2 = null;
        if (this.routine0 != null) {
            l2 = this.routine0.getMemoryAddress();
        } else if (this.pcStart != null) {
            l2 = this.pcStart;
        }
        if (l2 != null) {
            this.state.setValue(this.idPC, (long)l2);
        }
        this.cv.customInitStateRegisters(this.state, l2);
        if (this.stackPreferredBase != -1L) {
            this.stackStart = (this.stackPreferredBase & 0xFFFFFFFFFFFFF000L) - 65536L;
            this.stackSize = 131072;
            this.stackStart = VirtualMemoryUtil.findAvailableRange(this.state.getMemory(), this.stackStart, this.stackSize);
            long l3 = this.stackStart + (long)(this.stackSize / 2);
            VirtualMemoryUtil.allocateFillGaps(this.state.getMemory(), this.stackStart, this.stackSize, 3);
            this.state.setValue(this.SP, l3);
            this.state.setNativeStackStart(this.stackStart);
            this.state.setNativeStackEnd(this.stackStart + (long)this.stackSize);
            this.state.writeMemoryBad(this.stackStart, this.stackSize * 8, 2);
        }
        if (this.resetUnknownRegisters) {
            for (IEVar iEVar : this.gctx.getAllRegisters()) {
                if (this.state.hasValue(iEVar.getId())) continue;
                this.state.setValue(iEVar, 0L);
            }
        }
        this.state.setDisabledHooks(bl);
    }

    public boolean setStack(long l2, int n2, Long l3) {
        boolean bl = this.state.setDisabledHooks(true);
        try {
            try {
                this.state.getMemory().allocate(l2, n2, 3);
            }
            catch (MemoryException memoryException) {
                boolean bl2 = false;
                this.state.setDisabledHooks(bl);
                return bl2;
            }
            if (l3 != null) {
                this.state.setValue(this.SP, (long)l3);
            }
            this.state.setNativeStackStart(l2);
            this.state.setNativeStackEnd(l2 + (long)n2);
            this.state.writeMemoryBad(l2, n2 * 8, 2);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.state.setDisabledHooks(bl);
        }
    }

    private void writeRoutineInputs() {
        if (!this.isExecRoutine()) {
            return;
        }
        IPrototypeItem iPrototypeItem = this.retrieveTargetPrototype();
        if (iPrototypeItem == null) {
            throw new IllegalStateException("The target routine does not have a prototype");
        }
        boolean bl = this.state.setDisabledHooks(true);
        try {
            ICallingConvention iCallingConvention = iPrototypeItem.getCallingConvention();
            IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
            int n2 = 0;
            List<? extends INativeType> list = iPrototypeItem.getParameterTypes();
            for (IEImm iEImm : this.args) {
                Object object;
                TypeLayoutInfo typeLayoutInfo = TypeLayoutInfo.i1;
                if (n2 < list.size()) {
                    object = list.get(n2);
                    typeLayoutInfo = TypeUtil.getLayoutInfo((INativeType)object);
                }
                object = iStorageEntryGenerator.next(typeLayoutInfo);
                this.writeStorage((StorageEntry)object, iEImm);
                ++n2;
            }
            StorageEntry storageEntry = iCallingConvention.getReturnAddressSlot();
            this.writeStorage(storageEntry, alp.ce(this.retAddr, this.addrsize * 8));
            this.args.clear();
        }
        finally {
            this.state.setDisabledHooks(bl);
        }
    }

    public void teardown() {
        this.verifyState(this.internalState == 1 || this.internalState == 2);
        if (!this.isPrimaryEmulator()) {
            this.state.popFrame();
        }
        this.internalState = 3;
    }

    public boolean isPrimaryEmulator() {
        return this == this.state.getPrimaryEmulator();
    }

    public EState getState() {
        return this.state;
    }

    public IVirtualMemory getVirtualMemory() {
        return this.getState().getMemory();
    }

    public MemoryChanges getMemoryChanges() throws UnsupportedOperationException {
        IVirtualMemory iVirtualMemory = this.state.getMemory();
        if (!(iVirtualMemory instanceof IVirtualMemoryShim)) {
            throw new UnsupportedOperationException();
        }
        return ((IVirtualMemoryShim)iVirtualMemory).getChanges();
    }

    public long getSPAddress() {
        return this.state.getValueAsUnsignedLong(this.idSP);
    }

    public long updateSPAddress(int n2) {
        long l2 = this.state.getValueAsUnsignedLong(this.idSP);
        this.state.setValue(this.idSP, l2 += (long)n2);
        return l2;
    }

    public long getPCAddress() {
        return this.state.getValueAsUnsignedLong(this.idPC);
    }

    public void setPCAddress(long l2) {
        this.state.setValue(this.idPC, l2);
    }

    public void run() throws EvaluationException {
        long l2;
        this.verifyState(this.internalState <= 2);
        if (this.internalState == 0) {
            this.setup();
        }
        this.internalState = 2;
        if (this.routine0 != null) {
            l2 = this.routine0.getMemoryAddress();
        } else if (this.pcStart != null) {
            l2 = this.pcStart;
        } else {
            throw new IllegalStateException("No initial PC");
        }
        this.state.setValue(this.idPC, l2);
        this.writeRoutineInputs();
        if (this.isExecFull()) {
            this.runFull();
        } else {
            this.runLocal();
        }
    }

    private void runLocal() {
        this.verifyState(!this.isExecFull());
        boolean bl = this.execmode == 2;
        INativeMethodItem iNativeMethodItem = this.routine0;
        long l2 = iNativeMethodItem.getMemoryAddress();
        Integer n2 = null;
        if (bl) {
            if (this.irOffsetStart != null) {
                n2 = this.irOffsetStart;
            } else if (this.pcStart != null) {
                IERoutineContext iERoutineContext = this.getIRContext(l2);
                if (iERoutineContext == null) {
                    throw new EvaluationException();
                }
                this.irOffsetStart = iERoutineContext.convertNativeAddress(this.pcStart).intValue();
                this.irOffsetStop = iERoutineContext.convertNativeAddress(this.pcStop).intValue();
                n2 = this.irOffsetStart;
            } else {
                throw new EvaluationException();
            }
        }
        int n3 = 0;
        block0: while (true) {
            long l3;
            int n4;
            Object object;
            IERoutineContext iERoutineContext;
            if ((iERoutineContext = this.getIRContext(l2)) == null) {
                object = this.mapRegisteredRoutines.get(l2);
                if (object == null) {
                    EEmulator.log("Cannot retrieve routine at address 0x%X", l2);
                    break;
                }
                if (!Booleans.toBoolean(this.hooksEvaluateExternal(((RegisteredRoutine)object).name, ((RegisteredRoutine)object).routine))) {
                    EEmulator.log("Cannot simulate extern %s", ((RegisteredRoutine)object).name);
                    break;
                }
                long l4 = l2;
                if (l4 != (l2 = this.state.getProgramCounter().getValueAsAddress())) {
                    n3 = 0;
                    continue;
                }
                if (n3 > 1000000) {
                    EEmulator.log("Cannot simulate extern %s: infinite loop detected", ((RegisteredRoutine)object).name);
                    break;
                }
                ++n3;
                continue;
            }
            iNativeMethodItem = iERoutineContext.getRoutine();
            object = iERoutineContext.getCfg();
            this.state.setRoutineContext(iERoutineContext);
            if (n2 != null) {
                n4 = n2;
                l3 = iERoutineContext.convertIntermediateOffset(n2);
                n2 = null;
            } else {
                l3 = l2;
                n4 = iERoutineContext.convertNativeAddress(l2).intValue();
            }
            this.state.setVirtualPC(n4);
            this.state.setValue(this.PC, l3);
            while (true) {
                if (bl && iNativeMethodItem == this.routine0 && n4 == this.irOffsetStop) {
                    return;
                }
                l2 = iERoutineContext.convertIntermediateOffset(n4);
                if (!bl && l2 == this.retAddr) {
                    return;
                }
                IEStatement iEStatement = (IEStatement)((CFG)object).getInstruction(n4);
                if (iEStatement == null) {
                    return;
                }
                Strings.spaces(2 * this.state.countFrames());
                this.lastEvalResult = iEStatement.evaluate(this.state);
                if (!this.state.incrementEvaluationCount()) {
                    EEmulator.log("Exceeding itercount", new Object[0]);
                    break block0;
                }
                if (this.state.getRoutineContext() == null) {
                    long l5 = this.getPCAddress();
                    if (l5 == this.retAddr) {
                        return;
                    }
                    this.decomp.getNativeContext().getRoutine(l5);
                    l2 = l5;
                    continue block0;
                }
                n4 = this.state.getVirtualPC();
            }
            break;
        }
        EEmulator.log("Emulation failed!", new Object[0]);
        throw new EvaluationException();
    }

    private void runFull() {
        boolean bl;
        this.verifyState(this.isExecFull());
        boolean bl2 = bl = this.execmode == 4;
        if (this.pseudoIRContext == null) {
            this.pseudoIRContext = new amg((alm)this.gctx);
            ((AbstractConverter)this.cv).setCurrentContext(this.pseudoIRContext);
        }
        IVirtualMemory iVirtualMemory = this.getVirtualMemory();
        IProcessor<?> iProcessor = this.decomp.getNativeContext().getProcessor();
        long l2 = this.pcStart;
        ConverterInstructionEntry converterInstructionEntry = new ConverterInstructionEntry();
        ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
        converterInstructionEntry.r = arrayList;
        this.setPCAddress(l2);
        if (this.mapConverterCachedEntries == null) {
            this.mapConverterCachedEntries = new CacheMap(10000, 2000, true);
        }
        int n2 = this.state.getEvaluationCount();
        while (true) {
            IEStatement iEStatement;
            List<IEStatement> list;
            IInstruction iInstruction;
            ConvertedInsnCachedIREntry convertedInsnCachedIREntry;
            l2 = this.getPCAddress();
            if (bl) {
                if (this.pcStop != null && this.pcStop == l2) {
                    int n3 = this.state.getEvaluationCount();
                    EEmulator.log("Emulation COMPLETED - stop address reached (%d iter. - total in State: %d)", n3 - n2, n3);
                    return;
                }
            } else if (l2 == this.retAddr) {
                int n4 = this.state.getEvaluationCount();
                EEmulator.log("Emulation COMPLETED - routine returned (%d iter. - total in State: %d)", n4 - n2, n4);
                return;
            }
            if ((convertedInsnCachedIREntry = this.mapConverterCachedEntries.get(l2)) == null) {
                try {
                    iInstruction = iProcessor.parseAt(iVirtualMemory, l2);
                }
                catch (ProcessorException processorException) {
                    iInstruction = null;
                }
                convertedInsnCachedIREntry = new ConvertedInsnCachedIREntry(l2, iInstruction, null);
                this.mapConverterCachedEntries.put(l2, convertedInsnCachedIREntry);
            } else {
                iInstruction = convertedInsnCachedIREntry.nativeInsn;
            }
            Boolean bl3 = this.hooksEvaluateAt(l2, convertedInsnCachedIREntry.nativeInsn);
            if (bl3 != null) {
                if (bl3.booleanValue()) continue;
                throw new EvaluationException(Strings.ff("evaluateAt() failed at: 0x%X: %s", l2, convertedInsnCachedIREntry.nativeInsn));
            }
            if (convertedInsnCachedIREntry.nativeInsn != null && this.hooksEvaluateSyscall(l2, convertedInsnCachedIREntry.nativeInsn)) continue;
            RegisteredRoutine registeredRoutine = this.mapRegisteredRoutines.get(l2);
            if (registeredRoutine != null && (bl3 = this.hooksEvaluateExternal(registeredRoutine.name, registeredRoutine.routine)) != null) {
                if (bl3.booleanValue()) continue;
                throw new EvaluationException(Strings.ff("evaluateExternal() failed at: 0x%X: %s", l2, registeredRoutine.name));
            }
            if (iInstruction == null) {
                if (registeredRoutine != null) {
                    throw new EvaluationException(Strings.ff("Cannot eval routine: %s", registeredRoutine));
                }
                throw new EvaluationException(Strings.ff("Cannot parse at address: 0x%X", l2));
            }
            if (convertedInsnCachedIREntry.stmlist == null) {
                list = converterInstructionEntry.r;
                converterInstructionEntry.address = l2;
                converterInstructionEntry.insn = iInstruction;
                converterInstructionEntry.irAddress = 0;
                converterInstructionEntry.r.clear();
                ((AbstractConverter)this.cv).convertInstruction(converterInstructionEntry);
                EUtil.setLowerLevelAddress(l2, list);
                convertedInsnCachedIREntry.stmlist = new ArrayList<IEStatement>(list);
            }
            list = convertedInsnCachedIREntry.stmlist;
            int n5 = 0;
            this.state.setVirtualPC(n5);
            boolean bl4 = false;
            if (list.size() == 1 && list.get(0).isUntranslatedInstruction()) {
                iEStatement = list.get(0).asUntranslated();
                bl3 = this.hooksEvaluateUntranslated((IEUntranslatedInstruction)iEStatement, iInstruction);
                if (bl3 != null && bl3.booleanValue()) {
                    bl4 = true;
                } else {
                    throw new EvaluationException(Strings.ff("evaluateUntranslated() could not do the job at: 0x%X: %s = %s", l2, iInstruction, iEStatement));
                }
            }
            if (!bl4) {
                while (n5 >= 0 && n5 < list.size()) {
                    iEStatement = list.get(n5);
                    try {
                        this.setPCAddress(l2);
                        this.lastEvalResult = iEStatement.evaluate(this.state);
                    }
                    catch (Exception exception) {
                        EEmulator.log("FAILED TO EVALUATE: %s  { from native insn: 0x%X: %s }", iEStatement, l2, iInstruction);
                        throw exception;
                    }
                    n5 = this.state.getVirtualPC();
                }
            }
            if (!this.state.incrementEvaluationCount()) break;
            if (this.state.getValueSafe(this.idPC) != null) continue;
            this.setPCAddress(l2 + (long)iInstruction.getSize());
        }
        EEmulator.log("Exceeding itercount (%d)", this.state.getEvaluationCount());
        EEmulator.log("Emulation failed!", new Object[0]);
        throw new EvaluationException();
    }

    public void setLastEvaluationResult(IEImm iEImm) {
        this.lastEvalResult = iEImm;
    }

    public IEImm getLastEvaluationResult() {
        return this.lastEvalResult;
    }

    private void callstackPush(INativeMethodItem iNativeMethodItem, INativeMethodItem iNativeMethodItem2, long l2, int n2) {
        this.callstack.push(new CSE(iNativeMethodItem, iNativeMethodItem2, l2, n2));
    }

    private CSE callstackPop() {
        return this.callstack.pop();
    }

    private IERoutineContext getIRContext(long l2) {
        this.verifyState(!this.isExecFull());
        if (!this.isPrimaryEmulator()) {
            return this.state.getPrimaryEmulator().getIRContext(l2);
        }
        INativeMethodItem iNativeMethodItem = this.decomp.getNativeContext().getRoutineOver(l2);
        if (iNativeMethodItem == null) {
            return null;
        }
        IERoutineContext iERoutineContext = this.ctxmap.get(iNativeMethodItem);
        if (iERoutineContext == null) {
            IDecompiledMethod iDecompiledMethod = this.decompile(iNativeMethodItem);
            if (iDecompiledMethod == null) {
                return null;
            }
            iERoutineContext = iDecompiledMethod.getIRContext();
            if (iERoutineContext == null) {
                return null;
            }
            this.ctxmap.put(iNativeMethodItem, iERoutineContext);
        }
        return iERoutineContext;
    }

    private IDecompiledMethod decompile(INativeMethodItem iNativeMethodItem) {
        if (!(this.decomp instanceof INativeDecompilerUnit)) {
            return null;
        }
        EEmulator.log("Requesting IR conversion: %s", iNativeMethodItem);
        GlobalLog.setGlobalFilter(true);
        try {
            int n2 = 64;
            if (this.performFreshDecompilations) {
                n2 |= 0x80;
            }
            DecompilationContext decompilationContext = new DecompilationContext(n2);
            NativeDecompilationStage nativeDecompilationStage = NativeDecompilationStage.IR_CONVERSION;
            IDecompiledMethod iDecompiledMethod = ((INativeDecompilerUnit)this.decomp).decompileMethodEx(iNativeMethodItem, decompilationContext, nativeDecompilationStage);
            return iDecompiledMethod;
        }
        catch (Exception exception) {
            logger.error("Failed to generate IR for method: %s", iNativeMethodItem);
            IDecompiledMethod iDecompiledMethod = null;
            return iDecompiledMethod;
        }
        finally {
            GlobalLog.setGlobalFilter(false);
        }
    }

    private long generateAddressForPseudoRoutine() {
        long l2 = this.currentAddrForPseudoRoutines;
        this.currentAddrForPseudoRoutines += 16L;
        return l2;
    }

    public long findRegisteredRoutine(String string) {
        RegisteredRoutine registeredRoutine = this.mapRegisteredRoutinesByName.get(string);
        if (registeredRoutine != null) {
            return registeredRoutine.addr;
        }
        return 0L;
    }

    public long createPseudoRoutine(String string) {
        RegisteredRoutine registeredRoutine = this.mapRegisteredRoutinesByName.get(string);
        if (registeredRoutine != null) {
            return registeredRoutine.addr;
        }
        long l2 = this.generateAddressForPseudoRoutine();
        return this.registerRoutine(l2, string);
    }

    public long createPseudoRoutine(INativeMethodItem iNativeMethodItem) {
        RegisteredRoutine registeredRoutine = this.mapRegisteredRoutinesByName.get(iNativeMethodItem.getName(false));
        if (registeredRoutine != null) {
            return registeredRoutine.addr;
        }
        long l2 = this.generateAddressForPseudoRoutine();
        return this.registerRoutine(l2, iNativeMethodItem);
    }

    public long registerRoutine(long l2, String string) {
        RegisteredRoutine registeredRoutine = new RegisteredRoutine(l2, string, null);
        this.mapRegisteredRoutines.put(l2, registeredRoutine);
        this.mapRegisteredRoutinesByName.put(string, registeredRoutine);
        return l2;
    }

    public long registerRoutine(long l2, INativeMethodItem iNativeMethodItem) {
        String string = iNativeMethodItem.getName(false);
        RegisteredRoutine registeredRoutine = new RegisteredRoutine(l2, string, iNativeMethodItem);
        this.mapRegisteredRoutines.put(l2, registeredRoutine);
        this.mapRegisteredRoutinesByName.put(string, registeredRoutine);
        return l2;
    }

    public final long currentRequestId() {
        return this.lastRequestId;
    }

    private final long getRequestId() {
        this.lastRequestId = this.currentRequestId.getAndIncrement();
        return this.lastRequestId;
    }

    public Boolean hooksEvaluateAt(long l2, IInstruction iInstruction) {
        if (!this.emuhooks.isEmpty()) {
            Object object;
            long l3 = this.getRequestId();
            Boolean bl = null;
            Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
            while (iterator.hasNext() && (bl = (object = iterator.next()).evaluateAt(this, l2, iInstruction)) == null) {
            }
            if (bl != null) {
                boolean bl2 = bl;
                for (IEEmulatorHooks iEEmulatorHooks : this.emuhooks) {
                    iEEmulatorHooks.postEvaluateAt(this, l2, iInstruction, l3, bl2);
                }
                if (!bl2) {
                    Object[] objectArray = new Object[]{l2, iInstruction};
                }
                return bl2;
            }
        }
        return null;
    }

    public Boolean hooksEvaluateExternal(String string, INativeMethodItem iNativeMethodItem) {
        if (!this.emuhooks.isEmpty()) {
            Object object;
            long l2 = this.getRequestId();
            Boolean bl = null;
            Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
            while (iterator.hasNext() && (bl = (object = iterator.next()).evaluateExternal(this, string, iNativeMethodItem)) == null) {
            }
            if (bl != null) {
                boolean bl2 = bl;
                for (IEEmulatorHooks iEEmulatorHooks : this.emuhooks) {
                    iEEmulatorHooks.postEvaluateExternal(this, string, iNativeMethodItem, l2, bl2);
                }
                if (!bl2) {
                    (new Object[1])[0] = string;
                }
                return bl2;
            }
        }
        return null;
    }

    public Boolean hooksEvaluateUntranslated(IEUntranslatedInstruction iEUntranslatedInstruction, IInstruction iInstruction) {
        if (!this.emuhooks.isEmpty()) {
            Object object;
            long l2 = this.getRequestId();
            Boolean bl = null;
            Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
            while (iterator.hasNext() && (bl = (object = iterator.next()).evaluateUntranslated(this, iEUntranslatedInstruction, iInstruction)) == null) {
            }
            if (bl != null) {
                boolean bl2 = bl;
                for (IEEmulatorHooks iEEmulatorHooks : this.emuhooks) {
                    iEEmulatorHooks.postEvaluateUntranslated(this, iEUntranslatedInstruction, iInstruction, l2, bl2);
                }
                if (!bl2) {
                    (new Object[1])[0] = iEUntranslatedInstruction;
                }
                return bl2;
            }
        }
        return null;
    }

    public boolean hooksEvaluateSyscall(long l2, IInstruction iInstruction) {
        if (this.emuhooks.isEmpty()) {
            return false;
        }
        String string = iInstruction.getMnemonic().toLowerCase();
        if (this.proctype == ProcessorType.X86_64) {
            if (string.equals("syscall")) {
                IEEmulatorHooks iEEmulatorHooks2;
                LinuxSyscallResolver linuxSyscallResolver = LinuxSyscallResolver.getInstance(this.proctype);
                IEImm iEImm = this.state.getValue(this.gctx.getVariableByName("rax"));
                int n2 = (int)iEImm.getValueAsLong();
                String string2 = linuxSyscallResolver.getName(n2);
                INativeMethodItem iNativeMethodItem = linuxSyscallResolver.getRoutine(n2, this.typeman);
                if (iNativeMethodItem == null) {
                    Object[] objectArray = new Object[]{n2, Strings.safe(string2, "???")};
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("rdi").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("rsi").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("rdx").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("r10").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("r8").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("r9").getId()));
                long l3 = this.getRequestId();
                Long l4 = null;
                Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
                while (iterator.hasNext() && (l4 = (iEEmulatorHooks2 = iterator.next()).evaluateSyscall(this, l2, iInstruction, n2, string2, iNativeMethodItem, arrayList)) == null) {
                }
                if (l4 != null) {
                    this.state.setValue(this.gctx.getVariableByName("rax"), (long)l4);
                    this.setPCAddress(this.getPCAddress() + (long)iInstruction.getSize());
                    for (IEEmulatorHooks iEEmulatorHooks2 : this.emuhooks) {
                        iEEmulatorHooks2.postEvaluateSyscall(this, l2, iInstruction, n2, string2, iNativeMethodItem, arrayList, l3, l4);
                    }
                    return true;
                }
                (new Object[1])[0] = string2;
            }
        } else if (this.proctype == ProcessorType.X86) {
            if (string.equals("int")) {
                IEEmulatorHooks iEEmulatorHooks3;
                LinuxSyscallResolver linuxSyscallResolver = LinuxSyscallResolver.getInstance(this.proctype);
                IEImm iEImm = this.state.getValue(this.gctx.getVariableByName("eax"));
                int n3 = (int)iEImm.getValueAsLong();
                String string3 = linuxSyscallResolver.getName(n3);
                INativeMethodItem iNativeMethodItem = linuxSyscallResolver.getRoutine(n3, this.typeman);
                if (iNativeMethodItem == null) {
                    Object[] objectArray = new Object[]{n3, Strings.safe(string3, "???")};
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("ebx").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("ecx").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("edx").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("esi").getId()));
                arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("edi").getId()));
                long l5 = this.getRequestId();
                Long l6 = null;
                Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
                while (iterator.hasNext() && (l6 = (iEEmulatorHooks3 = iterator.next()).evaluateSyscall(this, l2, iInstruction, n3, string3, iNativeMethodItem, arrayList)) == null) {
                }
                if (l6 != null) {
                    this.state.setValue(this.gctx.getVariableByName("eax"), (long)l6);
                    this.setPCAddress(this.getPCAddress() + (long)iInstruction.getSize());
                    for (IEEmulatorHooks iEEmulatorHooks3 : this.emuhooks) {
                        iEEmulatorHooks3.postEvaluateSyscall(this, l2, iInstruction, n3, string3, iNativeMethodItem, arrayList, l5, l6);
                    }
                    return true;
                }
                (new Object[1])[0] = string3;
            }
        } else if (this.proctype == ProcessorType.ARM64 && string.equals("svc")) {
            IEEmulatorHooks iEEmulatorHooks4;
            LinuxSyscallResolver linuxSyscallResolver = LinuxSyscallResolver.getInstance(this.proctype);
            IEImm iEImm = this.state.getValue(this.gctx.getVariableByName("X8"));
            int n4 = (int)iEImm.getValueAsLong();
            String string4 = linuxSyscallResolver.getName(n4);
            INativeMethodItem iNativeMethodItem = linuxSyscallResolver.getRoutine(n4, this.typeman);
            if (iNativeMethodItem == null) {
                Object[] objectArray = new Object[]{n4, Strings.safe(string4, "???")};
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X0").getId()));
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X1").getId()));
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X2").getId()));
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X3").getId()));
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X4").getId()));
            arrayList.add(this.state.getValueAsLongSafe(this.gctx.getVariableByName("X5").getId()));
            long l7 = this.getRequestId();
            Long l8 = null;
            Iterator<IEEmulatorHooks> iterator = this.emuhooks.iterator();
            while (iterator.hasNext() && (l8 = (iEEmulatorHooks4 = iterator.next()).evaluateSyscall(this, l2, iInstruction, n4, string4, iNativeMethodItem, arrayList)) == null) {
            }
            if (l8 != null) {
                this.state.setValue(this.gctx.getVariableByName("X0"), (long)l8);
                this.setPCAddress(this.getPCAddress() + (long)iInstruction.getSize());
                for (IEEmulatorHooks iEEmulatorHooks4 : this.emuhooks) {
                    iEEmulatorHooks4.postEvaluateSyscall(this, l2, iInstruction, n4, string4, iNativeMethodItem, arrayList, l7, l8);
                }
                return true;
            }
            (new Object[1])[0] = string4;
        }
        return false;
    }

    public void monitorHLSpecial(int n2, Object ... objectArray) {
        if (!this.emuhooks.isEmpty()) {
            List<Object> list = Collections.unmodifiableList(Arrays.asList(objectArray));
            for (IEEmulatorHooks iEEmulatorHooks : this.emuhooks) {
                try {
                    iEEmulatorHooks.monitorHLSpecial(this, n2, list);
                }
                catch (Exception exception) {}
            }
        }
    }

    public IEImm readStorage(StorageEntry storageEntry) {
        switch (storageEntry.getType()) {
            case STACK: {
                long l2 = this.state.getStackPointer().getValueAsAddress();
                long l3 = l2 + (long)(storageEntry.getValueAsStackIndex() * this.slotsize);
                try {
                    if (this.slotsize == 4) {
                        return alp.ce(this.state.getMemory().readInt(l3), this.slotsize * 8);
                    }
                    if (this.slotsize == 8) {
                        return alp.ce(this.state.getMemory().readLong(l3), this.slotsize * 8);
                    }
                }
                catch (Exception exception) {}
                return null;
            }
            case REGISTER: {
                long l4 = storageEntry.getValue(this.state.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
                IEVar iEVar = (IEVar)this.state.getGlobalContext().getConverter().getRegisterVariableFromNativeRegisterId(l4);
                return this.state.getValue(iEVar);
            }
        }
        return null;
    }

    private byte[] shortToBytes(short s2) {
        return this.gctx.isBigEndian() ? EndianUtil.shortToBEBytes(s2) : EndianUtil.shortToLEBytes(s2);
    }

    private byte[] intToBytes(int n2) {
        return this.gctx.isBigEndian() ? EndianUtil.intToBEBytes(n2) : EndianUtil.intToLEBytes(n2);
    }

    private byte[] longToBytes(long l2) {
        return this.gctx.isBigEndian() ? EndianUtil.longToBEBytes(l2) : EndianUtil.longToLEBytes(l2);
    }

    public boolean writeStorage(StorageEntry storageEntry, IEImm iEImm) {
        switch (storageEntry.getType()) {
            case STACK: {
                long l2 = this.state.getStackPointer().getValueAsAddress();
                long l3 = l2 + (long)(storageEntry.getValueAsStackIndex() * this.slotsize);
                if (this.slotsize == 2) {
                    short s2 = (short)iEImm.getValueAsLong();
                    return this.state.writeMemory(l3, this.shortToBytes(s2));
                }
                if (this.slotsize == 4) {
                    int n2 = (int)iEImm.getValueAsLong();
                    return this.state.writeMemory(l3, this.intToBytes(n2));
                }
                if (this.slotsize == 8) {
                    long l4 = iEImm.getValueAsLong();
                    return this.state.writeMemory(l3, this.longToBytes(l4));
                }
                return false;
            }
            case REGISTER: {
                long l5 = storageEntry.getValue(this.state.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
                IEVar iEVar = (IEVar)this.state.getGlobalContext().getConverter().getRegisterVariableFromNativeRegisterId(l5);
                this.state.setValue(iEVar, iEImm.truncate(iEVar.getBitsize()));
                return true;
            }
        }
        return false;
    }

    public boolean processStoredReturnAddress(StorageEntry storageEntry) {
        return this.processStoredReturnAddress(storageEntry, 0);
    }

    public boolean processStoredReturnAddress(StorageEntry storageEntry, int n2) {
        switch (storageEntry.getType()) {
            case STACK: {
                long l2;
                if (storageEntry.getValueAsStackIndex() != 0) {
                    return false;
                }
                IEImm iEImm = this.state.getValue(this.SP);
                try {
                    l2 = this.state.getMemory().readPointer(iEImm.getValueAsAddress());
                }
                catch (MemoryException memoryException) {
                    return false;
                }
                this.state.setValue(this.SP, iEImm._add(alp.ce((1 + n2) * this.slotsize, iEImm.getBitsize())));
                this.state.setValue(this.PC, l2);
                return true;
            }
            case REGISTER: {
                long l3 = storageEntry.getValue(this.state.isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
                IEVar iEVar = (IEVar)this.state.getGlobalContext().getConverter().getRegisterVariableFromNativeRegisterId(l3);
                IEImm iEImm = this.state.getValue(iEVar);
                if (n2 != 0) {
                    IEImm iEImm2 = this.state.getValue(this.SP);
                    this.state.setValue(this.SP, iEImm2._add(alp.ce(n2 * this.slotsize, iEImm2.getBitsize())));
                }
                this.state.setValue(this.PC, iEImm.truncate(this.PC.getBitsize()));
                return true;
            }
        }
        return false;
    }

    public Long readPointer(long l2) {
        this.verifyState(this.internalState >= 1);
        try {
            return this.state.getMemory().readPointer(l2);
        }
        catch (MemoryException memoryException) {
            return null;
        }
    }

    public boolean writePointer(long l2, long l3) {
        this.verifyState(this.internalState >= 1);
        try {
            this.state.getMemory().writePointer(l2, l3);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public MemoryWrites getMemoryWrites() {
        this.verifyState(this.internalState >= 2);
        if (this.memwrites == null) {
            return null;
        }
        if (!this.memwrites.isComplete()) {
            this.memwrites.complete();
        }
        return this.memwrites;
    }

    public IEImm getReturnValue() {
        this.verifyState(this.internalState >= 2);
        if (this.proto0.getCountOfReturns() != 1) {
            return null;
        }
        INativeType iNativeType = this.proto0.getReturnType();
        TypeLayoutInfo typeLayoutInfo = TypeUtil.getLayoutInfo(iNativeType);
        ICallingConvention iCallingConvention = this.proto0.getCallingConvention();
        StorageEntry storageEntry = iCallingConvention.getOutput(typeLayoutInfo, 0);
        return this.readStorage(storageEntry);
    }

    public IEImm getReturnAddress() {
        this.verifyState(this.internalState >= 2);
        ICallingConvention iCallingConvention = this.proto0.getCallingConvention();
        StorageEntry storageEntry = iCallingConvention.getReturnAddressSlot();
        return this.readStorage(storageEntry);
    }

    public long getTruncatedRegisterValue(String string) {
        int n2 = this.gctx.getVariableByName(string).getId();
        IEImm iEImm = this.state.getValueSafe(n2);
        if (iEImm == null) {
            return 0L;
        }
        return iEImm.getValue().longValue();
    }

    public boolean commitMemoryChanges(boolean bl) {
        this.verifyState(this.internalState >= 2);
        IVirtualMemory iVirtualMemory = this.state.getMemory();
        if (!(iVirtualMemory instanceof IVirtualMemoryShim)) {
            return false;
        }
        IVirtualMemoryShim iVirtualMemoryShim = (IVirtualMemoryShim)iVirtualMemory;
        if (bl) {
            iVirtualMemoryShim.commitChanges(true, false, false);
        } else {
            iVirtualMemoryShim.commitChanges(true, true, true);
        }
        return true;
    }

    public void registerHooks(IEEmulatorHooks iEEmulatorHooks, boolean bl) {
        int n2;
        int n3;
        if (iEEmulatorHooks == null) {
            return;
        }
        int n4 = -1;
        int n5 = iEEmulatorHooks.getPriority();
        for (n3 = 0; n3 < this.emuhooks.size() && (n2 = this.emuhooks.get(n3).getPriority()) >= n5; ++n3) {
            if (n2 != n5 || n4 != -1) continue;
            n4 = n3;
        }
        if (!bl || n4 < 0) {
            this.emuhooks.add(n3, iEEmulatorHooks);
        } else {
            this.emuhooks.add(n4, iEEmulatorHooks);
        }
    }

    public void unregisterHooks(IEEmulatorHooks iEEmulatorHooks) {
        if (iEEmulatorHooks == null) {
            return;
        }
        this.emuhooks.remove(iEEmulatorHooks);
    }

    @Deprecated
    public void addHooks(IEEmulatorHooks iEEmulatorHooks) {
        this.registerHooks(iEEmulatorHooks, false);
    }

    @Deprecated
    public void removeHooks(IEEmulatorHooks iEEmulatorHooks) {
        this.unregisterHooks(iEEmulatorHooks);
    }

    public long heapAlloc(int n2) {
        int n3;
        if (n2 <= 0) {
            return 0L;
        }
        n2 += 4;
        IVirtualMemory iVirtualMemory = this.state.getMemory();
        if (this.heapCurrent == -1L) {
            n3 = (int)iVirtualMemory.roundToSize(n2);
            this.heapCurrent = VirtualMemoryUtil.allocate(iVirtualMemory, this.heapPreferredBase, n3, 3);
            this.heapEnd = this.heapCurrent + (long)n3;
        } else {
            n3 = (int)(this.heapEnd - this.heapCurrent);
            if (n3 < n2) {
                int n4 = (int)iVirtualMemory.roundToSize(n2 - n3);
                try {
                    iVirtualMemory.allocate(this.heapEnd, n4, 3);
                }
                catch (MemoryException memoryException) {
                    return 0L;
                }
                this.heapEnd += (long)n4;
            }
        }
        long l2 = this.heapCurrent;
        this.heapCurrent += (long)n2;
        try {
            iVirtualMemory.writeInt(l2, n2 - 4);
        }
        catch (MemoryException memoryException) {
            return 0L;
        }
        return l2 + 4L;
    }

    public long heapRealloc(long l2, int n2) {
        int n3;
        IVirtualMemory iVirtualMemory = this.state.getMemory();
        try {
            n3 = iVirtualMemory.readInt(l2 - 4L);
        }
        catch (MemoryException memoryException) {
            return 0L;
        }
        long l3 = this.heapAlloc(n2);
        if (l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[n3];
        if (!VirtualMemoryUtil.readBytes(iVirtualMemory, l2, byArray, 0, n3) || !VirtualMemoryUtil.writeBytes(iVirtualMemory, l3, byArray, 0, n3)) {
            this.heapFree(l3);
            return 0L;
        }
        this.heapFree(l2);
        return l3;
    }

    public void heapFree(long l2) {
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private class MemHooks
    implements IEStateHooks {
        private MemHooks() {
        }

        @Override
        public Integer onReadMemory(EState eState, long l2, byte[] byArray) {
            INativeMethodItem iNativeMethodItem;
            INativeContinuousItem iNativeContinuousItem = EEmulator.this.code.getNativeItemAt(l2);
            if (iNativeContinuousItem != null && (iNativeContinuousItem.getMemorySize() == (long)byArray.length || byArray.length == EEmulator.this.addrsize) && iNativeContinuousItem instanceof axp && (iNativeMethodItem = ((axp)iNativeContinuousItem).To()) != null && ((axk)iNativeMethodItem).GC() == null && iNativeMethodItem.getMemoryAddress() == null) {
                long l3 = EEmulator.this.createPseudoRoutine(iNativeMethodItem);
                try {
                    eState.getMemory().writePointer(l2, l3);
                }
                catch (MemoryException memoryException) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Boolean onWriteMemory(EState eState, long l2, byte[] byArray) {
            if (EEmulator.this.memwrites != null && l2 != 0L && byArray != null && byArray.length != 0) {
                EEmulator.log("MEM.WRITE: 0x%X: %s", l2, Formatter.byteArrayToHex(byArray));
                EEmulator.this.memwrites.record(l2, byArray);
            }
            if (EEmulator.this.mapConverterCachedEntries != null) {
                EEmulator.this.mapConverterCachedEntries.removeRange(l2, l2 + (long)byArray.length);
            }
            return null;
        }
    }

    static class RegisteredRoutine {
        long addr;
        String name;
        INativeMethodItem routine;

        public RegisteredRoutine(long l2, String string, INativeMethodItem iNativeMethodItem) {
            this.addr = l2;
            this.name = string;
            this.routine = iNativeMethodItem;
        }

        public String toString() {
            return Strings.ff("%s (0x%X)", this.name, this.addr);
        }
    }

    static class ConvertedInsnCachedIREntry {
        long nativeAddress;
        IInstruction nativeInsn;
        List<IEStatement> stmlist;

        ConvertedInsnCachedIREntry(long l2, IInstruction iInstruction, List<IEStatement> list) {
            this.nativeAddress = l2;
            this.nativeInsn = iInstruction;
            this.stmlist = list;
        }
    }

    public static class Metadata {
        public String processName;
    }

    static class CSE {
        INativeMethodItem target;
        INativeMethodItem caller;
        long callerPC;
        int callerVirtualPC;

        CSE(INativeMethodItem iNativeMethodItem, INativeMethodItem iNativeMethodItem2, long l2, int n2) {
            this.target = iNativeMethodItem;
            this.caller = iNativeMethodItem2;
            this.callerPC = l2;
            this.callerVirtualPC = n2;
        }
    }
}

