/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INodeHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import java.math.BigInteger;

public class Leaf
implements INode {
    public static final int FLAG_POSSIBLE_IMM = 1;
    public static final int FLAG_POSSIBLE_VAR = 2;
    public static final int FLAG_POSSIBLE_RANGE = 4;
    public static final int FLAG_POSSIBLE_NON_TERMINAL = 8;
    public static final int FLAG_POSSIBLE_TERMINAL = 7;
    public static final int FLAG_POSSIBLE_ALL = 15;
    static final int FLAG_CONSTANT_IMM = 16;
    static final int FLAG_LASTBIT_IMM = 32;
    public int id;
    public int optionalBitsize;
    public int flags;
    public INodeHandler handler;
    public BigInteger value;

    public Leaf(int n2, int n3, int n4, INodeHandler iNodeHandler) {
        if ((n4 & 0x10) != 0) {
            throw new IllegalArgumentException("Invalid flag, wildcard leaf cannot be a determined immediate value");
        }
        if (n2 < 0 || n2 >= 1000) {
            throw new IllegalArgumentException("Invalid id for leaf: " + n2);
        }
        this.id = n2;
        this.optionalBitsize = n3;
        this.flags = n4;
        this.handler = iNodeHandler;
        this.value = null;
    }

    public Leaf(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public Leaf(long l2, int n2, int n3) {
        if (n3 < -1 || n3 >= 1000) {
            throw new IllegalArgumentException("Invalid id for leaf: " + n3);
        }
        this.id = n3;
        this.optionalBitsize = n2;
        this.flags = 16;
        this.handler = null;
        this.value = BigInteger.valueOf(l2);
    }

    public Leaf setHandler(INodeHandler iNodeHandler) {
        this.handler = iNodeHandler;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.value != null) {
            stringBuilder.append("I");
        } else {
            stringBuilder.append("L");
        }
        if (this.id >= 0) {
            Strings.ff(stringBuilder, "(%d)", this.id);
        }
        if (this.value != null) {
            if (this.value.signum() >= 0) {
                Strings.ff(stringBuilder, ":0x%s", this.value.toString(16).toUpperCase());
            } else {
                Strings.ff(stringBuilder, ":-0x%s", this.value.negate().toString(16).toUpperCase());
            }
        }
        return stringBuilder.toString();
    }
}

