/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.core.units.code.AbstractVisitResults;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVisitor;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EExpressionGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EExpressionMatcher;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.EPatternCompiler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INode;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class EPatternMatcher {
    private static final StructuredLogger logger = aeb.ce(EPatternMatcher.class);
    private final EPatternCompiler.EPattern pattern;
    private final IERoutineContext ctx;
    private final CFG<IEStatement> cfg;
    private final IEGeneric exp0;
    private boolean allowDeepAssociativity = true;
    private Map<IEGeneric, Integer> IRDepthsMap;

    public EPatternMatcher(EPatternCompiler.EPattern ePattern, CFG<IEStatement> cFG, IERoutineContext iERoutineContext) {
        this.pattern = ePattern;
        this.cfg = cFG;
        this.ctx = iERoutineContext;
        this.exp0 = null;
    }

    public EPatternMatcher(EPatternCompiler.EPattern ePattern, IEGeneric iEGeneric, IERoutineContext iERoutineContext) {
        this.pattern = ePattern;
        this.ctx = iERoutineContext;
        this.exp0 = iEGeneric;
        this.cfg = null;
    }

    public EPatternCompiler.EPattern getPattern() {
        return this.pattern;
    }

    public IERoutineContext getContext() {
        return this.ctx;
    }

    public CFG<IEStatement> getInputCfg() {
        return this.cfg;
    }

    public IEGeneric getInputExpression() {
        return this.exp0;
    }

    public boolean isAllowDeepAssociativity() {
        return this.allowDeepAssociativity;
    }

    public void setAllowDeepAssociativity(boolean bl) {
        this.allowDeepAssociativity = bl;
    }

    public void setIRDepthsMap(Map<IEGeneric, Integer> map) {
        this.IRDepthsMap = map;
    }

    public Map<IEGeneric, Integer> getIRDepthsMap() {
        return this.IRDepthsMap;
    }

    public String toString() {
        return Strings.ff("Matcher for: pattern=%s, CFG=%s", this.pattern, this.cfg);
    }

    public Result search() {
        return this.search(null);
    }

    private int restore(AtomicInteger atomicInteger) {
        int n2;
        if (atomicInteger != null && (n2 = atomicInteger.intValue()) >= 0) {
            atomicInteger.set(-1);
            return n2;
        }
        return 0;
    }

    private Result searchFull(Result result) {
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicInteger atomicInteger2 = new AtomicInteger();
        AtomicInteger atomicInteger3 = new AtomicInteger();
        if (result != null) {
            atomicInteger = new AtomicInteger(result.ipattern0);
            atomicInteger2 = new AtomicInteger(result.iblk0);
            atomicInteger3 = new AtomicInteger(result.iinsn0 + 1);
        }
        for (int i = this.restore(atomicInteger); i < this.pattern.getInputs().size(); ++i) {
            int n2;
            int n3;
            IBasicBlock iBasicBlock;
            EPatternCompiler.EPattern.P p = this.pattern.getInputs().get(i);
            EPatternCompiler.EPattern.P.E e = p.getTriggerLine();
            INode iNode = e.expr;
            INode iNode2 = e.rhs;
            for (int j = this.restore(atomicInteger2); j < this.cfg.size() && ((BasicBlock)(iBasicBlock = this.cfg.get(j))).size() >= p.getCountOfLines() && (n3 = p.getTriggerIndex()) >= 0 && (n2 = ((BasicBlock)iBasicBlock).size() - p.getCountOfLines() + n3) >= 0; ++j) {
                for (int k = n3 + this.restore(atomicInteger3); k <= n2; ++k) {
                    boolean bl;
                    Object object;
                    Object object2;
                    IEStatement iEStatement = (IEStatement)((BasicBlock)iBasicBlock).get(k);
                    int n4 = k - n3;
                    HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                    IEGeneric[] iEGenericArray = new IEGeneric[2];
                    if (this.pattern.isPureInputExpression() || this.pattern.isPureOuputExpression()) {
                        object2 = new EVisitResults(1);
                        ((AbstractVisitResults)object2).setVisitResult(false);
                        object = new EExpressionMatcher(iNode, hashMap);
                        ((EExpressionMatcher)object).setAllowDeepAssociativity(this.allowDeepAssociativity);
                        ((EExpressionMatcher)object).setIRDepthsMap(this.IRDepthsMap);
                        bl = iEStatement.visitDepthPost(new IEVisitor((EExpressionMatcher)object, iEGenericArray){
                            final /* synthetic */ EExpressionMatcher val$m;
                            final /* synthetic */ IEGeneric[] val$matched;
                            {
                                this.val$m = eExpressionMatcher;
                                this.val$matched = iEGenericArray;
                            }

                            @Override
                            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric2, IVisitResults<IEGeneric> iVisitResults) {
                                this.val$m.reset();
                                if (this.val$m.isMatch(iEGeneric)) {
                                    this.val$matched[0] = iEGeneric;
                                    this.val$matched[1] = iEGeneric2;
                                    iVisitResults.interrupt(true);
                                }
                            }
                        }, null, (EVisitResults)object2);
                    } else {
                        if (!(iEStatement instanceof IEAssign)) continue;
                        object2 = ((IEAssign)iEStatement).getDstOperand();
                        object = ((IEAssign)iEStatement).getSrcOperand();
                        EExpressionMatcher eExpressionMatcher = new EExpressionMatcher(iNode, hashMap);
                        eExpressionMatcher.setAllowDeepAssociativity(this.allowDeepAssociativity);
                        eExpressionMatcher.setIRDepthsMap(this.IRDepthsMap);
                        if (!eExpressionMatcher.isMatch((IEGeneric)object2)) continue;
                        eExpressionMatcher = new EExpressionMatcher(iNode2, hashMap);
                        eExpressionMatcher.setAllowDeepAssociativity(this.allowDeepAssociativity);
                        eExpressionMatcher.setIRDepthsMap(this.IRDepthsMap);
                        if (!eExpressionMatcher.isMatch((IEGeneric)object)) continue;
                        bl = true;
                    }
                    if (bl && !this.pattern.isPureInputExpression()) {
                        int n5 = n4 + p.getCountOfLines();
                        int n6 = n4;
                        int n7 = 0;
                        while (n6 < n5) {
                            if (n7 != n3) {
                                IEStatement iEStatement2 = (IEStatement)((BasicBlock)iBasicBlock).get(n6);
                                if (!(iEStatement2 instanceof IEAssign)) {
                                    bl = false;
                                    break;
                                }
                                IEGeneric iEGeneric = ((IEAssign)iEStatement2).getDstOperand();
                                IEGeneric iEGeneric2 = ((IEAssign)iEStatement2).getSrcOperand();
                                EPatternCompiler.EPattern.P.E e2 = p.getLine(n7);
                                INode iNode3 = e2.expr;
                                INode iNode4 = e2.rhs;
                                EExpressionMatcher eExpressionMatcher = new EExpressionMatcher(iNode3, hashMap);
                                eExpressionMatcher.setAllowDeepAssociativity(this.allowDeepAssociativity);
                                eExpressionMatcher.setIRDepthsMap(this.IRDepthsMap);
                                if (!eExpressionMatcher.isMatch(iEGeneric)) {
                                    bl = false;
                                    break;
                                }
                                eExpressionMatcher = new EExpressionMatcher(iNode4, hashMap);
                                eExpressionMatcher.setAllowDeepAssociativity(this.allowDeepAssociativity);
                                eExpressionMatcher.setIRDepthsMap(this.IRDepthsMap);
                                if (!eExpressionMatcher.isMatch(iEGeneric2)) {
                                    bl = false;
                                    break;
                                }
                            }
                            ++n6;
                            ++n7;
                        }
                    }
                    if (!bl || (p.getFlags() & 1) != 0 && this.hasOverlappingVars(hashMap) || (p.getFlags() & 2) != 0 && !this.hasSameLeafSize(hashMap)) continue;
                    Result result2 = new Result(this.ctx, this.cfg, this.exp0, this.pattern, i, hashMap);
                    result2.matchAddress = ((BasicBlock)iBasicBlock).getAddressOfInstruction(n4);
                    result2.iblk0 = j;
                    result2.ipattern0 = i;
                    result2.iinsn0 = k - n3;
                    result2.matchIRE = iEGenericArray[0];
                    result2.matchParentIRE = iEGenericArray[1];
                    if (this.pattern.getVerifier() != null && !this.pattern.getVerifier().verify(this, result2)) continue;
                    return result2;
                }
            }
        }
        return null;
    }

    private Result searchExpression(Result result) {
        if (!this.pattern.isPureInputExpression()) {
            return null;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        if (result != null) {
            atomicInteger = new AtomicInteger(result.ipattern0);
        }
        IEGeneric iEGeneric = this.exp0;
        if (result != null) {
            iEGeneric = result.optimizedExpression;
        }
        for (int i = this.restore(atomicInteger); i < this.pattern.getInputs().size(); ++i) {
            EPatternCompiler.EPattern.P p = this.pattern.getInputs().get(i);
            EPatternCompiler.EPattern.P.E e = p.getTriggerLine();
            INode iNode = e.expr;
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            final IEGeneric[] iEGenericArray = new IEGeneric[2];
            EVisitResults eVisitResults = new EVisitResults(1);
            eVisitResults.setVisitResult(false);
            final EExpressionMatcher eExpressionMatcher = new EExpressionMatcher(iNode, hashMap);
            eExpressionMatcher.setAllowDeepAssociativity(this.allowDeepAssociativity);
            eExpressionMatcher.setIRDepthsMap(this.IRDepthsMap);
            if (!iEGeneric.visitDepthPost(new IEVisitor(){

                @Override
                public void process(IEGeneric iEGeneric, IEGeneric iEGeneric2, IVisitResults<IEGeneric> iVisitResults) {
                    eExpressionMatcher.reset();
                    if (eExpressionMatcher.isMatch(iEGeneric)) {
                        iEGenericArray[0] = iEGeneric;
                        iEGenericArray[1] = iEGeneric2;
                        iVisitResults.interrupt(true);
                    }
                }
            }, null, eVisitResults) || (p.getFlags() & 1) != 0 && this.hasOverlappingVars(hashMap) || (p.getFlags() & 2) != 0 && !this.hasSameLeafSize(hashMap)) continue;
            Result result2 = new Result(this.ctx, this.cfg, this.exp0, this.pattern, i, hashMap);
            result2.ipattern0 = i;
            result2.matchIRE = iEGenericArray[0];
            result2.matchParentIRE = iEGenericArray[1];
            if (this.pattern.getVerifier() != null && !this.pattern.getVerifier().verify(this, result2)) continue;
            return result2;
        }
        return null;
    }

    private boolean hasOverlappingVars(Map<Integer, Object> map) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            IEVar iEVar;
            Object object = entry.getValue();
            if (!(object instanceof IEVar) || hashSet.add((iEVar = (IEVar)object).getId())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameLeafSize(Map<Integer, Object> map) {
        int n2 = -1;
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof IEGeneric)) continue;
            int n3 = ((IEGeneric)object).getBitsize();
            if (n2 < 0) {
                n2 = n3;
                continue;
            }
            if (n3 == n2) continue;
            return false;
        }
        return true;
    }

    public Result search(Result result) {
        if (!this.pattern.isCompiled()) {
            throw new IllegalArgumentException("Pattern is not compiled");
        }
        if (this.cfg != null) {
            return this.searchFull(result);
        }
        if (this.exp0 != null) {
            return this.searchExpression(result);
        }
        throw new RuntimeException();
    }

    public Result searchAndReplace() {
        return this.searchAndReplace(null);
    }

    public Result searchAndReplace(Result result) {
        Result result2 = this.search(result);
        if (result2 == null) {
            return null;
        }
        result2.replaced = this.replace(result2, true);
        return result2;
    }

    public boolean replace(Result result, boolean bl) {
        int n2;
        int n3;
        Object object;
        if (!bl && this.pattern.replacer != null && (object = this.pattern.replacer.replace(this, result)) != null) {
            return ((Boolean)object).booleanValue();
        }
        object = this.pattern.getOutput();
        if (object == null) {
            throw new IllegalArgumentException("No replacement pattern provided");
        }
        if (this.pattern.isPureInputExpression() || this.pattern.isPureOuputExpression()) {
            INode iNode = ((EPatternCompiler.EPattern.P)object).clist.get((int)0).expr;
            IEGeneric iEGeneric = new EExpressionGenerator(this.ctx, iNode).generate(result.matchMap, (Integer)result.matchIRE.getBitsize());
            if (result.matchIRE.getType() != null) {
                iEGeneric.setType(result.matchIRE.getType());
            }
            if (result.matchParentIRE == null) {
                result.optimizedExpression = iEGeneric;
                return true;
            }
            if (!result.matchParentIRE.replaceSubExpression(result.matchIRE, iEGeneric)) {
                return false;
            }
            result.optimizedExpression = result.exp0;
            return true;
        }
        EPatternCompiler.EPattern.P p = this.pattern.getInput(result.getInputIndex());
        int n4 = p.getCountOfReplacedLines();
        int n5 = 0;
        long l2 = this.getMatchAddress(result, p.getFirstReplacedLineIndex());
        Couple<BasicBlock<IEStatement>, Integer> couple = this.cfg.getInstructionLocation(l2);
        BasicBlock<IEStatement> basicBlock = couple.getFirst();
        int n6 = couple.getSecond();
        int n7 = n6 + n4;
        for (n3 = n6; n3 < n7; ++n3) {
            n5 += basicBlock.get(n3).getSize();
        }
        n3 = ((EPatternCompiler.EPattern.P)object).getCountOfLines();
        if (n5 < n3) {
            return false;
        }
        ArrayList<IEAssign> arrayList = new ArrayList<IEAssign>();
        for (n2 = 0; n2 < n3; ++n2) {
            EPatternCompiler.EPattern.P.E e = ((EPatternCompiler.EPattern.P)object).getLine(n2);
            IEGeneric iEGeneric = new EExpressionGenerator(this.ctx, e.rhs).generate(result.matchMap);
            IEGeneric iEGeneric2 = new EExpressionGenerator(this.ctx, e.expr).generate(result.matchMap);
            IEAssign iEAssign = this.ctx.createAssign(iEGeneric2, iEGeneric);
            arrayList.add(iEAssign);
        }
        n2 = arrayList.size() - 1;
        ((IEStatement)arrayList.get(n2)).setSize(n5 - n2);
        for (IEStatement iEStatement : arrayList) {
            for (int i = n6; i < n7; ++i) {
                iEStatement.copyLowerLevelAddresses(basicBlock.get(i));
            }
        }
        if (!this.cfg.replaceInstructionsInBlock(l2, n4, arrayList)) {
            return false;
        }
        this.cfg.invalidateDataFlowAnalysis();
        return true;
    }

    public int searchAndReplaceAll() {
        return this.searchAndReplaceAll(null);
    }

    public int searchAndReplaceAll(Result[] resultArray) {
        int n2 = 0;
        Result result = null;
        while ((result = this.searchAndReplace(result)) != null) {
            if (resultArray != null) {
                resultArray[0] = result;
            }
            ++n2;
        }
        return n2;
    }

    public long getMatchAddress(Result result, int n2) {
        EPatternCompiler.EPattern.P p = this.pattern.getInput(result.getInputIndex());
        if (n2 < 0) {
            n2 += p.getCountOfLines();
        }
        Couple<BasicBlock<IEStatement>, Integer> couple = this.cfg.getInstructionLocation(result.getMatchAddress());
        int n3 = couple.getSecond() + n2;
        return couple.getFirst().getAddressOfInstruction(n3);
    }

    public static class Result {
        private IERoutineContext ctx;
        private CFG<IEStatement> cfg;
        private IEGeneric exp0;
        private EPatternCompiler.EPattern pattern;
        private int ipattern0;
        private int iblk0;
        private int iinsn0;
        private int inputIndex;
        private long matchAddress;
        private IEGeneric matchIRE;
        private IEGeneric matchParentIRE;
        private Map<Integer, Object> matchMap;
        private boolean replaced;
        private IEGeneric optimizedExpression;

        Result(IERoutineContext iERoutineContext, CFG<IEStatement> cFG, IEGeneric iEGeneric, EPatternCompiler.EPattern ePattern, int n2, Map<Integer, Object> map) {
            this.ctx = iERoutineContext;
            this.cfg = cFG;
            this.exp0 = iEGeneric;
            this.pattern = ePattern;
            this.inputIndex = n2;
            this.matchMap = map;
        }

        public IERoutineContext getContext() {
            return this.ctx;
        }

        public CFG<IEStatement> getCfg() {
            return this.cfg;
        }

        public IEGeneric getInputExpression() {
            return this.exp0;
        }

        public EPatternCompiler.EPattern getPattern() {
            return this.pattern;
        }

        public int getInputIndex() {
            return this.inputIndex;
        }

        public IEGeneric getMatchedExpression() {
            return this.matchIRE;
        }

        public IEGeneric getMatchedParent() {
            return this.matchParentIRE;
        }

        public long getMatchAddress() {
            return this.matchAddress;
        }

        public Map<Integer, Object> getMatchMap() {
            return this.matchMap;
        }

        public <T> T getMatchedLeaf(int n2, Class<T> clazz) {
            return (T)this.matchMap.get(n2);
        }

        public IEGeneric getMatchedLeaf(int n2) {
            return (IEGeneric)this.matchMap.get(n2);
        }

        public boolean isReplaced() {
            return this.replaced;
        }

        public IEGeneric getOptimizedExpression() {
            return this.optimizedExpression;
        }

        public String toString() {
            return Strings.ff("Input #%d found at address 0x%X, matchMap: %s", this.inputIndex, this.matchAddress, this.matchMap);
        }
    }
}

