/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.IEMatchVerifier;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.IEPatternReplacer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Leaf;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Node;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.O;
import com.pnfsoftware.jeb.util.collect.Sets;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EPatternCompiler {
    private static final StructuredLogger logger = aeb.ce(EPatternCompiler.class);
    public static final int FLAG_NO_VARIABLE_LEAF_OVERLAP = 1;
    public static final int FLAG_SAME_BITSIZE_FOR_LEAVES = 2;
    public static final int FLAG_INVALIDATE_DFA = 256;
    private static final int FMASK_INPUT = 3;
    private static final int FMASK_OUTPUT = 256;
    public static final EPatternCompiler DEFAULT_COMPILER = new EPatternCompiler();
    private int cflags;
    private static Set<Character> trgLeaves = Sets.createNonNulls(Character.valueOf('@'), Character.valueOf('T'), Character.valueOf('$'), Character.valueOf('V'), Character.valueOf('#'), Character.valueOf('N'));
    private static Set<Character> trgOperators = Sets.createNonNulls(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('['), Character.valueOf('?'), Character.valueOf(':'));

    public EPatternCompiler(int n2) {
        this.cflags = n2;
    }

    public EPatternCompiler() {
        this(0);
    }

    public int getFlags() {
        return this.cflags;
    }

    public EPattern compile(EPattern ePattern) {
        if (ePattern.compiled) {
            throw new IllegalStateException("Pattern is already compiled");
        }
        if (ePattern.inputs.isEmpty()) {
            throw new IllegalArgumentException("A pattern needs at least one input");
        }
        for (EPattern.P p : ePattern.inputs) {
            p.pflags |= this.cflags & 3;
            try {
                this.compile1(p);
            }
            catch (Exception exception) {
                logger.catching(exception, "Error compiling input pattern");
                throw exception;
            }
        }
        EPattern.P p = ePattern.output;
        if (p != null) {
            p.pflags |= this.cflags & 0x100;
            try {
                this.compile1(p);
            }
            catch (Exception exception) {
                logger.catching(exception, "Error compiling ouput pattern");
                throw exception;
            }
        }
        ePattern.compiled = true;
        return ePattern;
    }

    private void compile1(EPattern.P p) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (String string : p.pstrings) {
            int n8;
            char c2;
            int n9 = 0;
            boolean bl = false;
            int n10 = 0;
            while (n10 < string.length() && EPattern.specialChars.contains(Character.valueOf(c2 = Character.toUpperCase(string.charAt(n10))))) {
                if (c2 == '>') {
                    n3 = n2;
                    ++n10;
                    continue;
                }
                if (c2 == 'X') {
                    bl = true;
                    ++n10;
                    continue;
                }
                EPatternCompiler.throwParsingException("Unsupported special char", string, n10);
            }
            if (bl) {
                if (n5 == 0) {
                    ++n4;
                }
            } else {
                ++n5;
            }
            InternalCompiler internalCompiler = new InternalCompiler(string);
            Parsed parsed = internalCompiler.parse(n10);
            Parsed parsed2 = new Parsed();
            if (parsed.continuationRequested) {
                parsed2 = internalCompiler.parse(parsed.pos);
            }
            if ((n8 = parsed.score + parsed2.score) > n7) {
                n6 = n2;
                n7 = n8;
            }
            EPattern.P.E e = new EPattern.P.E(n9 | p.pflags, parsed.result, parsed2.result);
            p.clist.add(e);
            ++n2;
        }
        if (n3 < 0) {
            n3 = n6;
        }
        p.itrigger = n3;
        p.ireplbegin = n4;
        p.ireplend = n4 + n5;
    }

    private static void throwParsingException(String object, String string, int n2) {
        object = Strings.ff("Illegal input pattern: %s", object);
        if (n2 >= 0) {
            object = (String)object + Strings.ff(":\n  %s\n  %s^", string, Strings.generate(' ', n2));
        }
        throw new IllegalStateException((String)object);
    }

    private static class InternalCompiler {
        private final String s;
        private int score;

        InternalCompiler(String string) {
            this.s = string;
        }

        Parsed parse() {
            return this.parse(0);
        }

        Parsed parse(int n2) {
            Parsed parsed = this.parse(n2, 0, '\u0000');
            parsed.score = this.score;
            return parsed;
        }

        private Parsed parse(int n2, int n3, char c2) {
            char c3 = '\u0000';
            O o2 = null;
            ArrayList<INode> arrayList = new ArrayList<INode>();
            boolean bl = false;
            while (n2 < this.s.length()) {
                char c4;
                if (Character.isSpaceChar(c4 = this.s.charAt(n2++))) continue;
                if (c4 == '(') {
                    Parsed parsed = this.parse(n2, n3 + 1, ')');
                    this.sliceResult(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == ')' || c4 == ']' || c4 == '}') {
                    c3 = c4;
                    break;
                }
                int n4 = 0;
                if (o2 == null && arrayList.isEmpty() && n2 < this.s.length() && (c4 == '-' || c4 == '+') && Character.isDigit(this.s.charAt(n2))) {
                    n4 = c4 == '-' ? -1 : 1;
                    c4 = this.s.charAt(n2++);
                }
                if (n4 == 0 && trgOperators.contains(Character.valueOf(c4))) {
                    int n5;
                    String string;
                    if (o2 == O.COND) {
                        if (c4 != ':') {
                            this.err("Illegal ternary operator", n2);
                        }
                    } else if (o2 != null) {
                        switch (o2) {
                            case ADD: 
                            case MUL: 
                            case AND: 
                            case OR: 
                            case XOR: {
                                break;
                            }
                            default: {
                                this.err("Operator already present: " + o2, n2);
                            }
                        }
                    }
                    if ((string = this.s.substring(n2 - 1, n5 = this.scanUntil(this.s, n2))).equals("=")) {
                        if (n3 != 0) {
                            this.err("Illegal assignment", n2 - 1);
                        }
                        bl = true;
                        break;
                    }
                    O o3 = this.parseOperator(string, n2);
                    if (o2 != null) {
                        if (o2 == O.ADD && o3 != O.ADD) {
                            this.err("Illegal additive sequence", n2);
                        }
                        if (o2 == O.MUL && o3 != O.MUL) {
                            this.err("Illegal multiplicative sequence", n2);
                        }
                        if (o2 == O.AND && o3 != O.AND) {
                            this.err("Illegal bitwise-and sequence", n2);
                        }
                        if (o2 == O.OR && o3 != O.OR) {
                            this.err("Illegal bitwise-or sequence", n2);
                        }
                        if (o2 == O.XOR && o3 != O.XOR) {
                            this.err("Illegal bitwise-xor sequence", n2);
                        }
                    }
                    o2 = o3;
                    n2 = n5;
                    continue;
                }
                if (Character.isDigit(c4)) {
                    Parsed parsed = this.parseImm(n2 - 1, n4 < 0 ? -1 : 1);
                    this.sliceResult(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    ++this.score;
                    continue;
                }
                if (trgLeaves.contains(Character.valueOf(c4 = Character.toUpperCase(c4)))) {
                    Parsed parsed = this.parseLeaf(n2 - 1);
                    this.sliceResult(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    this.score += 2;
                    continue;
                }
                this.err("Character not parsed: " + c4, n2 - 1);
            }
            if (c3 != c2) {
                this.err("Illegal closing parenthesis", n2 - 1);
            }
            Parsed parsed = new Parsed();
            parsed.pos = n2;
            parsed.continuationRequested = bl;
            if (bl || o2 == null) {
                if (arrayList.size() != 1) {
                    this.err("Missing operand");
                }
                parsed.result = (INode)arrayList.get(0);
            } else {
                if (arrayList.isEmpty()) {
                    this.err("Missing operand(s)");
                }
                if (o2 == O.SUB && arrayList.size() == 1) {
                    o2 = O.NEG;
                }
                parsed.result = new Node(o2, arrayList.toArray(new INode[arrayList.size()]));
            }
            return parsed;
        }

        private void sliceResult(Parsed parsed) {
            int n2 = parsed.pos;
            if (n2 < this.s.length() && this.s.charAt(n2) == '[') {
                if (this.s.startsWith("[H1]", n2)) {
                    parsed.result = new Node(O.SLICE_HALF1, parsed.result);
                    parsed.pos += 4;
                } else if (this.s.startsWith("[H2]", n2)) {
                    parsed.result = new Node(O.SLICE_HALF2, parsed.result);
                    parsed.pos += 4;
                }
            }
        }

        int scanUntil(String string, int n2) {
            char c2;
            while (n2 < string.length() && (c2 = string.charAt(n2)) != '(' && c2 != ')' && !Character.isSpaceChar((int)c2) && c2 != '[' && c2 != ']' && c2 != '{' && c2 != '}') {
                ++n2;
            }
            return n2;
        }

        int scanInt(String string, int n2) {
            char c2;
            while (n2 < string.length() && Character.isDigit((int)(c2 = string.charAt(n2)))) {
                ++n2;
            }
            return n2;
        }

        Parsed parseImm(int n2, int n3) {
            int n4 = this.scanUntil(this.s, n2);
            String string = this.s.substring(n2, n4);
            long l2 = Conversion.stringToLong(string, -1L);
            if (l2 < 0L) {
                this.err("Illegal immediate: " + string, n2 - 1);
            }
            n2 = n4;
            int n5 = -1;
            if (n2 < this.s.length() && this.s.charAt(n2) == '{') {
                if ((n4 = this.scanUntil(this.s, ++n2)) >= this.s.length() || this.s.charAt(n4) != '}') {
                    this.err("", n4);
                }
                n5 = Conversion.stringToInt(this.s.substring(n2, n4), -1);
                n2 = n4 + 1;
            }
            return new Parsed(new Leaf((long)n3 * l2, 0, n5), n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Parsed parseLeaf(int n2) {
            int n3;
            char c2 = this.s.charAt(n2++);
            int n4 = this.scanUntil(this.s, n2);
            if (n4 == n2) {
                this.err("Missing leaf identifier", n2);
            }
            if (c2 == '$') {
                n3 = 15;
            } else if (c2 == '@') {
                if (!this.s.substring(n2, n4).startsWith("LASTBIT")) throw new RuntimeException("Unknown @ marker for leaf");
                n3 = 32;
                n2 += 7;
            } else if (c2 == 'T') {
                n3 = 7;
            } else if (c2 == 'N') {
                n3 = 8;
            } else if (c2 == 'V') {
                n3 = 2;
            } else {
                if (c2 != '#') throw new RuntimeException("Unknown leaf identifier: " + c2);
                n3 = 1;
            }
            int n5 = 0;
            char c3 = this.s.charAt(n2);
            if (Character.isDigit(c3)) {
                n4 = this.scanInt(this.s, n2);
                n5 = Integer.parseInt(this.s.substring(n2, n4));
                n2 = n4;
                return new Parsed(new Leaf(n5, 0, n3), n2);
            } else {
                this.err("Missing leaf id", n2);
            }
            return new Parsed(new Leaf(n5, 0, n3), n2);
        }

        O parseOperator(String string, int n2) {
            switch (string.toLowerCase()) {
                case "+": {
                    return O.ADD;
                }
                case "-": {
                    return O.SUB;
                }
                case "*": {
                    return O.MUL;
                }
                case "/": {
                    return O.DIV_S;
                }
                case "%": {
                    return O.REM_S;
                }
                case "/u": {
                    return O.DIV_U;
                }
                case "%u": {
                    return O.REM_U;
                }
                case "~": {
                    return O.NOT;
                }
                case "&": {
                    return O.AND;
                }
                case "|": {
                    return O.OR;
                }
                case "^": {
                    return O.XOR;
                }
                case "!": {
                    return O.LNOT;
                }
                case "&&": {
                    return O.LAND;
                }
                case "||": {
                    return O.LOR;
                }
                case "==": {
                    return O.EQ;
                }
                case "!=": {
                    return O.NE;
                }
                case "<": {
                    return O.LT_S;
                }
                case "<=": {
                    return O.LE_S;
                }
                case ">": {
                    return O.GT_S;
                }
                case ">=": {
                    return O.GE_S;
                }
                case "<u": {
                    return O.LT_U;
                }
                case "<=u": {
                    return O.LE_U;
                }
                case ">u": {
                    return O.GT_U;
                }
                case ">=u": {
                    return O.GE_U;
                }
                case "<<": {
                    return O.SHL;
                }
                case ">>": {
                    return O.SAR;
                }
                case ">>>": 
                case ">>u": {
                    return O.SHR;
                }
                case "...": {
                    return O.COMPOSE_2;
                }
                case ".=.": {
                    return O.COMPOSE_2EQ;
                }
                case "_carry": {
                    return O.CARRY;
                }
                case "_ncadd": {
                    return O.NCADD;
                }
                case "_ncsub": {
                    return O.NCSUB;
                }
                case "_lsb": {
                    return O.SLICE_FIRSTBIT;
                }
                case "_msb": {
                    return O.SLICE_LASTBIT;
                }
                case "_hsb": {
                    return O.SLICE_HALFBIT;
                }
                case "_parity": {
                    return O.PARITY;
                }
                case "_trn": {
                    return O.TRN;
                }
                case "_trn8": {
                    return O.TRN8;
                }
                case "_trn16": {
                    return O.TRN16;
                }
                case "_trn32": {
                    return O.TRN32;
                }
                case "_trn64": {
                    return O.TRN64;
                }
                case "_trn128": {
                    return O.TRN128;
                }
                case "_ext": {
                    return O.EXT;
                }
                case "_ext8": {
                    return O.EXT8;
                }
                case "_ext16": {
                    return O.EXT16;
                }
                case "_ext32": {
                    return O.EXT32;
                }
                case "_ext64": {
                    return O.EXT64;
                }
                case "_ext128": {
                    return O.EXT128;
                }
                case "?": 
                case ":": {
                    return O.COND;
                }
            }
            throw new RuntimeException("TBI: Operator: " + string);
        }

        void err(String string) {
            this.err(string, -1);
        }

        void err(String string, int n2) {
            EPatternCompiler.throwParsingException(string, this.s, n2);
        }
    }

    private static class Parsed {
        INode result;
        int pos;
        int score;
        boolean continuationRequested;

        public Parsed() {
        }

        public Parsed(INode iNode) {
            this.result = iNode;
            this.pos = -1;
        }

        public Parsed(INode iNode, int n2) {
            this.result = iNode;
            this.pos = n2;
        }

        public String toString() {
            if (this.result == null) {
                return "?";
            }
            return this.result.toString();
        }
    }

    public static class EPattern {
        static final char CH_TRIGGER = '>';
        static final char CH_KEEP = 'X';
        private static final Set<Character> specialChars = Sets.createNonNulls(Character.valueOf('>'), Character.valueOf('X'));
        String name;
        boolean compiled;
        List<P> inputs = new ArrayList<P>();
        P output;
        IEMatchVerifier verifier;
        IEPatternReplacer replacer;
        Boolean pureexp;
        Boolean pureexpout;

        public static EPattern cc(String ... stringArray) {
            return EPattern.cc(0, stringArray);
        }

        public static EPattern cc(int n2, String ... stringArray) {
            return EPattern.create().addInput(n2, stringArray).compile();
        }

        public static EPattern create() {
            return EPattern.create(null);
        }

        public static EPattern create(String string) {
            return new EPattern(string);
        }

        private EPattern(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public EPattern setInput(String string) {
            return this.setInput(0, string);
        }

        public EPattern setInput(int n2, String string) {
            if (!this.inputs.isEmpty()) {
                logger.warn("An IR input pattern is being overwritten! Was this intended?", new Object[0]);
                if (Licensing.isDebugBuild()) {
                    throw new RuntimeException("IR pattern already set!");
                }
            }
            this.inputs.clear();
            return this.addInput(0, string);
        }

        public EPattern addInput(String ... stringArray) {
            return this.addInput(0, stringArray);
        }

        public EPattern addInput(int n2, String ... stringArray) {
            this.inputs.add(new P(n2, stringArray));
            return this;
        }

        public boolean isPureInputExpression() {
            return this.pureexp;
        }

        public boolean isPureOuputExpression() {
            return this.pureexpout;
        }

        public P getInput(int n2) {
            return this.inputs.get(n2);
        }

        public List<P> getInputs() {
            return this.inputs;
        }

        public EPattern setOutput(String ... stringArray) {
            return this.setOutput(0, stringArray);
        }

        public EPattern setOutput(int n2, String ... stringArray) {
            this.output = new P(n2, stringArray);
            return this;
        }

        public boolean hasOutput() {
            return this.output != null;
        }

        public P getOutput() {
            return this.output;
        }

        public EPattern setVerifier(IEMatchVerifier iEMatchVerifier) {
            this.verifier = iEMatchVerifier;
            return this;
        }

        public IEMatchVerifier getVerifier() {
            return this.verifier;
        }

        public EPattern setCustomReplacer(IEPatternReplacer iEPatternReplacer) {
            this.replacer = iEPatternReplacer;
            return this;
        }

        public IEPatternReplacer getCustomReplacer() {
            return this.replacer;
        }

        private Boolean determinePureInputExpression() {
            if (this.pureexp != null) {
                throw new IllegalStateException();
            }
            for (P p : this.inputs) {
                boolean bl;
                boolean bl2 = bl = p.clist.size() == 1 && p.clist.get((int)0).rhs == null;
                if (this.pureexp == null) {
                    this.pureexp = bl;
                    continue;
                }
                if (this.pureexp == bl) continue;
                return null;
            }
            this.pureexpout = this.output != null && this.output.clist.size() == 1 && this.output.clist.get((int)0).rhs == null;
            return this.pureexp;
        }

        public EPattern compile(EPatternCompiler ePatternCompiler) {
            if (ePatternCompiler == null) {
                ePatternCompiler = DEFAULT_COMPILER;
            }
            EPattern ePattern = ePatternCompiler.compile(this);
            if (this.determinePureInputExpression() == null) {
                throw new RuntimeException("Inconsistent inputs!");
            }
            return ePattern;
        }

        public EPattern compile() {
            return this.compile(null);
        }

        public EPattern compile(int n2) {
            return this.compile(new EPatternCompiler(n2));
        }

        public boolean isCompiled() {
            return this.compiled;
        }

        public String toString() {
            int n2;
            if (!this.isCompiled()) {
                return "(Not compiled)";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name != null) {
                stringBuilder.append("Pattern: ").append(this.name).append("\n");
            }
            int n3 = 0;
            for (P p : this.inputs) {
                if (this.inputs.size() == 1 && this.output != null) {
                    stringBuilder.append("Input:\n");
                } else if (this.inputs.size() > 1) {
                    Strings.ff(stringBuilder, "Input #%d:\n", n3 + 1);
                }
                stringBuilder.append(p).append("\n");
                ++n3;
            }
            if (this.output != null) {
                Strings.ff(stringBuilder, "Output:\n%s\n", this.output);
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(n2 = stringBuilder.length() - 1) == '\n') {
                stringBuilder.deleteCharAt(n2);
            }
            return stringBuilder.toString();
        }

        public static class P {
            private int pflags;
            private String[] pstrings;
            int itrigger;
            int ireplbegin;
            int ireplend;
            List<E> clist = new ArrayList<E>();

            P(int n2, String ... stringArray) {
                this.pflags = n2;
                this.pstrings = stringArray;
            }

            public int getFlags() {
                return this.pflags;
            }

            public List<E> getLines() {
                return this.clist;
            }

            public E getLine(int n2) {
                return this.clist.get(n2);
            }

            public int getCountOfLines() {
                return this.clist.size();
            }

            public E getTriggerLine() {
                return this.clist.get(this.itrigger);
            }

            public int getTriggerIndex() {
                return this.itrigger;
            }

            public int getFirstReplacedLineIndex() {
                return this.ireplbegin;
            }

            public int getLastReplacedLineIndex() {
                return this.ireplend - 1;
            }

            public int getCountOfReplacedLines() {
                return this.ireplend - this.ireplbegin;
            }

            public String toString() {
                if (this.clist.isEmpty()) {
                    return "(Pattern is not compiled)";
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                for (E e : this.clist) {
                    if (n2 >= 1) {
                        stringBuilder.append("\n");
                    }
                    if (this.clist.size() >= 2) {
                        StringBuilder stringBuilder2 = new StringBuilder();
                        if (this.itrigger == n2) {
                            stringBuilder2.append('>');
                        }
                        if (n2 < this.ireplbegin || n2 >= this.ireplend) {
                            stringBuilder2.append('X');
                        }
                        stringBuilder2.append(Strings.generate(' ', 3 - stringBuilder2.length()));
                        stringBuilder.append((CharSequence)stringBuilder2);
                    }
                    stringBuilder.append(e);
                    ++n2;
                }
                return stringBuilder.toString();
            }

            static class E {
                int eflags;
                INode expr;
                INode rhs;

                E(int n2, INode iNode) {
                    this.eflags = n2;
                    this.expr = iNode;
                    this.rhs = null;
                }

                E(int n2, INode iNode, INode iNode2) {
                    this.eflags = n2;
                    this.expr = iNode;
                    this.rhs = iNode2;
                }

                public int getFlag() {
                    return this.eflags;
                }

                public INode getExpressionOrLhs() {
                    return this.expr;
                }

                public INode getOptionalRhs() {
                    return this.rhs;
                }

                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.expr);
                    if (this.rhs != null) {
                        stringBuilder.append(" = ").append(this.rhs);
                    }
                    return stringBuilder.toString();
                }
            }
        }
    }
}

