/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IERange;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Leaf;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Node;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.O;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Util;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EExpressionMatcher {
    private static final ILogger logger = GlobalLog.getLogger(EExpressionMatcher.class);
    public static boolean verbose = false;
    private static int commuteForkMode = 2;
    private static int MAX_FORK_COUNT = 50;
    private INode template;
    private Map<Integer, Object> map;
    private int state;
    private int forkcount;
    private boolean allowDeepAssociativity = false;
    private Map<IEGeneric, Integer> IRDepthsMap;
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);

    public EExpressionMatcher(INode iNode, Map<Integer, Object> map) {
        if (iNode == null) {
            throw new IllegalArgumentException();
        }
        this.template = iNode;
        if (iNode instanceof Node && ((Node)iNode).descMaxDepth < 0) {
            Util.setMaxDepths(iNode);
        }
        if (map == null) {
            map = new HashMap<Integer, Object>();
        }
        this.map = map;
    }

    public EExpressionMatcher(INode iNode) {
        this(iNode, null);
    }

    private EExpressionMatcher() {
    }

    private boolean canFork() {
        return this.forkcount < MAX_FORK_COUNT;
    }

    private EExpressionMatcher fork(EExpressionMatcher eExpressionMatcher) {
        EExpressionMatcher eExpressionMatcher2 = new EExpressionMatcher();
        eExpressionMatcher2.template = this.template;
        eExpressionMatcher2.map = new HashMap<Integer, Object>(this.map);
        eExpressionMatcher2.state = this.state;
        eExpressionMatcher2.forkcount = this.forkcount + 1;
        eExpressionMatcher2.allowDeepAssociativity = this.allowDeepAssociativity;
        return eExpressionMatcher2;
    }

    public void setAllowDeepAssociativity(boolean bl) {
        this.allowDeepAssociativity = bl;
    }

    public boolean isAllowDeepAssociativity() {
        return this.allowDeepAssociativity;
    }

    public void setIRDepthsMap(Map<IEGeneric, Integer> map) {
        this.IRDepthsMap = map;
    }

    public Map<IEGeneric, Integer> getIRDepthsMap() {
        return this.IRDepthsMap;
    }

    public Map<Integer, Object> getMatchMap() {
        return this.map;
    }

    public void reset(boolean bl) {
        if (!bl) {
            this.map.clear();
        }
        this.state = 0;
        this.forkcount = 0;
    }

    public void reset() {
        this.reset(false);
    }

    public boolean isMatch(IEGeneric iEGeneric) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = 1;
        return this.isEqual(iEGeneric, this.template, 0);
    }

    private static boolean failed() {
        return false;
    }

    private static boolean failed(O o2, IEGeneric iEGeneric) {
        return false;
    }

    private static boolean failed(String string) {
        return false;
    }

    private boolean isEqual(IEGeneric iEGeneric, INode iNode, int n2) {
        if (iNode instanceof Node) {
            int n3;
            Object object2;
            Object object3;
            Node node = (Node)iNode;
            if (this.IRDepthsMap != null && (object3 = this.IRDepthsMap.get(iEGeneric)) != null && node.descMaxDepth > (Integer)object3) {
                return false;
            }
            object3 = node.operator;
            if (object3 == null) {
                if (!(iEGeneric instanceof IEOperation)) {
                    return EExpressionMatcher.failed("Expected an EOperation");
                }
                object2 = ((IEOperation)iEGeneric).getOperationType();
                for (Object object : node.opgrp.operators) {
                    if (object.getOperationType() != object2) continue;
                    object3 = object;
                    n3 = node.opgrp.id;
                    Iterator<IEGeneric> iterator = this.map.get(n3);
                    if (iterator != null) {
                        if (iterator == object2) break;
                        return EExpressionMatcher.failed("Leaf mismatched");
                    }
                    this.map.put(n3, object2);
                    break;
                }
                if (object3 == null) {
                    return EExpressionMatcher.failed("Null operator");
                }
            }
            if (node.opnds.length >= 3) {
                switch (object3) {
                    case ADD: {
                        if (!iEGeneric.isOperation(OperationType.ADD, OperationType.SUB)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        object2 = this.collectAdds((IEOperation)iEGeneric);
                        if (object2.size() != node.opnds.length) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        if (!this.checkSequence((List<SeqEntry>)object2, node.opnds, 0, n2)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        return true;
                    }
                    case MUL: {
                        if (!iEGeneric.isOperation(OperationType.MUL)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        object2 = this.collectMuls((IEOperation)iEGeneric);
                        if (object2.size() != node.opnds.length) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        if (!this.checkSequence((List<SeqEntry>)object2, node.opnds, 0, n2)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        return true;
                    }
                    case AND: 
                    case OR: 
                    case XOR: {
                        if (!iEGeneric.isOperation(OperationType.AND, OperationType.OR, OperationType.XOR)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        object2 = this.collectBitwise((IEOperation)iEGeneric);
                        if (object2.size() != node.opnds.length) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        if (!this.checkSequence((List<SeqEntry>)object2, node.opnds, 0, n2)) {
                            return EExpressionMatcher.failed(object3, iEGeneric);
                        }
                        return true;
                    }
                }
            }
            switch (object3) {
                case SLICE: {
                    if (iEGeneric instanceof IESlice) {
                        int n4 = ((Leaf)node.opnds[1]).value.intValue();
                        int n5 = ((Leaf)node.opnds[2]).value.intValue();
                        if (n4 == ((IESlice)iEGeneric).getBitStart() && n5 == ((IESlice)iEGeneric).getBitEnd()) {
                            IEGeneric iEGeneric2 = ((IESlice)iEGeneric).getWholeExpression();
                            return this.isEqual(iEGeneric2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_FIRSTBIT: {
                    if (iEGeneric instanceof IESlice && (object2 = ((IESlice)iEGeneric).getRange()).getRangeLength() == 1 && object2.getBegin() == 0) {
                        IEGeneric bigInteger = ((IESlice)iEGeneric).getWholeExpression();
                        return this.isEqual(bigInteger, node.opnds[0], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_LASTBIT: {
                    if (iEGeneric instanceof IESlice) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        IERange bigInteger = ((IESlice)iEGeneric).getRange();
                        if (bigInteger.getRangeLength() == 1 && bigInteger.getEnd() == object2.getBitsize()) {
                            return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_HALFBIT: {
                    if (iEGeneric instanceof IESlice) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        IERange iERange = ((IESlice)iEGeneric).getRange();
                        if (iERange.getRangeLength() == 1 && iERange.getEnd() == object2.getBitsize() / 2) {
                            return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_FIRST32: {
                    if (iEGeneric instanceof IESlice) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        IERange iERange = ((IESlice)iEGeneric).getRange();
                        if (iERange.getRangeLength() == 32 && iERange.getBegin() == 0) {
                            return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_HALF1: {
                    if (iEGeneric instanceof IESlice) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        IERange iERange = ((IESlice)iEGeneric).getRange();
                        if (iERange.getRangeLength() == object2.getBitsize() / 2 && iERange.getBegin() == 0) {
                            return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case SLICE_HALF2: {
                    if (iEGeneric instanceof IESlice) {
                        object2 = ((IESlice)iEGeneric).getWholeExpression();
                        IERange iERange = ((IESlice)iEGeneric).getRange();
                        if (iERange.getRangeLength() == object2.getBitsize() / 2 && iERange.getEnd() == object2.getBitsize()) {
                            return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
                        }
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case COMPOSE_2: {
                    if (iEGeneric instanceof IECompose && (object2 = (IECompose)iEGeneric).getPartsCount() == 2) {
                        return this.isEqual(object2.getLowPart(), node.opnds[0], n2 + 1) && this.isEqual(object2.getHighPart(), node.opnds[1], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case COMPOSE_2EQ: {
                    if (iEGeneric instanceof IECompose && (object2 = (IECompose)iEGeneric).getPartsCount() == 2 && object2.getLowPart().getBitsize() == object2.getHighPart().getBitsize()) {
                        return this.isEqual(object2.getLowPart(), node.opnds[0], n2 + 1) && this.isEqual(object2.getHighPart(), node.opnds[1], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case COND: {
                    if (iEGeneric instanceof IECond) {
                        object2 = (IECond)iEGeneric;
                        return this.isEqual(object2.getCondition(), node.opnds[0], n2 + 1) && this.isEqual(object2.getExpressionTrue(), node.opnds[1], n2 + 1) && this.isEqual(object2.getExpressionFalse(), node.opnds[2], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case TRN: 
                case TRN8: 
                case TRN16: 
                case TRN32: 
                case TRN64: 
                case TRN128: {
                    if (iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getOperationType() == OperationType.CAST) {
                        int n6 = object3.getResultingBitsize();
                        if (n6 != 0 && n6 != iEGeneric.getBitsize()) {
                            return EExpressionMatcher.failed("Unexpected bitsize");
                        }
                        IEGeneric iEGeneric3 = ((IEOperation)iEGeneric).getOperand1();
                        return this.isEqual(iEGeneric3, node.opnds[0], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
                case EXT: 
                case EXT8: 
                case EXT16: 
                case EXT32: 
                case EXT64: 
                case EXT128: {
                    if (iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getOperationType() == OperationType.CAST_S) {
                        int n7 = object3.getResultingBitsize();
                        if (n7 != 0 && n7 != iEGeneric.getBitsize()) {
                            return EExpressionMatcher.failed("Unexpected bitsize");
                        }
                        IEGeneric iEGeneric4 = ((IEOperation)iEGeneric).getOperand1();
                        return this.isEqual(iEGeneric4, node.opnds[0], n2 + 1);
                    }
                    return EExpressionMatcher.failed(object3, iEGeneric);
                }
            }
            if (iEGeneric instanceof IEImm && object3 == O.NOT) {
                object2 = iEGeneric.asImm()._not();
                return this.isEqual((IEGeneric)object2, node.opnds[0], n2 + 1);
            }
            if (iEGeneric instanceof IEOperation) {
                Object object;
                object2 = (IEOperation)iEGeneric;
                OperationType operationType = object2.getOperationType();
                int n4 = EExpressionMatcher.compareOperator(operationType, object3) ? 1 : 0;
                if (n4 == 0) {
                    int n5;
                    if (object2.getOperand2() instanceof IEImm) {
                        IEImm iEImm;
                        if (operationType == OperationType.ADD && object3 == O.SUB || operationType == OperationType.SUB && object3 == O.ADD) {
                            List<IEGeneric> list = EUtil.getSubExpressions((IEGeneric)object2);
                            list.set(1, list.get(1).asImm()._neg());
                            return this.isEqual(list.get(0), node.opnds[0], n2 + 1) && this.isEqual(list.get(1), node.opnds[1], n2 + 1);
                        }
                        if (operationType == OperationType.SHL && object3 == O.MUL) {
                            IEImm iEImm2 = object2.getOperand2().asImm();
                            if (iEImm2.canReadAsLong()) {
                                int n6 = (int)iEImm2.getValueAsLong();
                                IEImm iEImm3 = EUtil.imm(2L, object2.getBitsize())._pow(n6);
                                return this.isEqual(object2.getOperand1(), node.opnds[0], n2 + 1) && this.isEqual(iEImm3, node.opnds[1], n2 + 1);
                            }
                        } else if (object3 == O.SHL && operationType == OperationType.MUL && (object = (iEImm = object2.getOperand2().asImm())._log2()) != null) {
                            IEImm iEImm4 = EUtil.imm(((Integer)object).intValue(), object2.getBitsize());
                            return this.isEqual(object2.getOperand1(), node.opnds[0], n2 + 1) && this.isEqual(iEImm4, node.opnds[1], n2 + 1);
                        }
                    }
                    switch (object3) {
                        case GE_S: {
                            n5 = operationType == OperationType.LE_S ? 1 : 0;
                            break;
                        }
                        case GT_S: {
                            n5 = operationType == OperationType.LT_S ? 1 : 0;
                            break;
                        }
                        case LE_S: {
                            n5 = operationType == OperationType.GE_S ? 1 : 0;
                            break;
                        }
                        case LT_S: {
                            n5 = operationType == OperationType.GT_S ? 1 : 0;
                            break;
                        }
                        case GE_U: {
                            n5 = operationType == OperationType.LE_U ? 1 : 0;
                            break;
                        }
                        case GT_U: {
                            n5 = operationType == OperationType.LT_U ? 1 : 0;
                            break;
                        }
                        case LE_U: {
                            n5 = operationType == OperationType.GE_U ? 1 : 0;
                            break;
                        }
                        case LT_U: {
                            n5 = operationType == OperationType.GT_U ? 1 : 0;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    if (n5 != 0) {
                        return this.isEqual(object2.getOperand2(), node.opnds[0], n2 + 1) && this.isEqual(object2.getOperand1(), node.opnds[1], n2 + 1);
                    }
                }
                if (n4 != 0) {
                    List<IEGeneric> list = EUtil.getSubExpressions((IEGeneric)object2);
                    object = this.checkCommutative(list, node, (O)((Object)object3), n2);
                    if (object != null) {
                        Boolean bl;
                        if (!((Boolean)object).booleanValue() && (bl = this.checkAssociative((IEOperation)object2, node, (O)((Object)object3), n2)) != null) {
                            return bl;
                        }
                        return (Boolean)object;
                    }
                    object = this.checkAssociative((IEOperation)object2, node, (O)((Object)object3), n2);
                    if (object != null) {
                        return (Boolean)object;
                    }
                    n3 = 0;
                    for (IEGeneric iEGeneric5 : list) {
                        if (!this.isEqual(iEGeneric5, node.opnds[n3], n2 + 1)) {
                            return EExpressionMatcher.failed("Operand mismatch: " + iEGeneric5);
                        }
                        ++n3;
                    }
                    return true;
                }
            }
        } else {
            boolean bl;
            Leaf leaf = (Leaf)iNode;
            if (leaf.optionalBitsize != 0 && leaf.optionalBitsize != iEGeneric.getBitsize()) {
                return EExpressionMatcher.failed("leaf: unexpected bitsize");
            }
            boolean bl2 = bl = iEGeneric instanceof IEVar || iEGeneric instanceof IEImm || iEGeneric instanceof IERange;
            if ((leaf.flags & 0xF) == 15 || iEGeneric instanceof IEVar && (leaf.flags & 2) == 2 || iEGeneric instanceof IEImm && (leaf.flags & 1) == 1 || iEGeneric instanceof IERange && (leaf.flags & 4) == 4 || bl && (leaf.flags & 7) == 7 || !bl && (leaf.flags & 8) == 8) {
                if (leaf.handler != null && (iEGeneric = leaf.handler.process(leaf, iEGeneric)) == null) {
                    return EExpressionMatcher.failed("leaf: process() returned null");
                }
                IEGeneric iEGeneric4 = (IEGeneric)this.map.get(leaf.id);
                if (iEGeneric4 != null) {
                    return this.compareAndUpdate(iEGeneric4, iEGeneric, leaf, true);
                }
                this.map.put(leaf.id, iEGeneric);
                return true;
            }
            if (iEGeneric instanceof IEImm && (leaf.flags & 0x10) != 0) {
                Object object;
                if (leaf.id >= 0) {
                    object = (IEGeneric)this.map.get(leaf.id);
                    if (object != null) {
                        return this.compareAndUpdate((IEGeneric)object, iEGeneric, leaf, true);
                    }
                    this.map.put(leaf.id, iEGeneric);
                }
                object = leaf.value;
                BigInteger bigInteger = ((IEImm)iEGeneric).getValue();
                if (bigInteger.compareTo((BigInteger)object) == 0) {
                    return true;
                }
                if (iEGeneric.getBitsize() == 1 && bigInteger.equals(MINUS_ONE)) {
                    return BigInteger.ONE.compareTo(leaf.value) == 0;
                }
            } else if (iEGeneric instanceof IEImm && (leaf.flags & 0x20) != 0) {
                IEGeneric iEGeneric5 = (IEGeneric)this.map.get(leaf.id);
                if (iEGeneric5 == null) {
                    return false;
                }
                BigInteger bigInteger = BigInteger.valueOf(iEGeneric5.getBitsize() - 1);
                BigInteger bigInteger2 = ((IEImm)iEGeneric).getValue();
                return bigInteger2.compareTo(bigInteger) == 0;
            }
        }
        return EExpressionMatcher.failed();
    }

    private boolean compareAndUpdate(IEGeneric iEGeneric, IEGeneric iEGeneric2, Leaf leaf, boolean bl) {
        if (iEGeneric.equals(iEGeneric2)) {
            return true;
        }
        if (iEGeneric.equalsEx(iEGeneric2, false)) {
            if (iEGeneric2.getType() == null) {
                return true;
            }
            if (iEGeneric.getType() == null) {
                if (leaf.id >= 0 && bl) {
                    this.map.put(leaf.id, iEGeneric2);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    static boolean compareOperator(OperationType operationType, O o2) {
        switch (o2) {
            case MUL: {
                return operationType == OperationType.MUL;
            }
            case DIV: {
                return operationType == OperationType.DIV_U || operationType == OperationType.DIV_S;
            }
            case REM: {
                return operationType == OperationType.REM_U || operationType == OperationType.REM_S;
            }
            case NCADD: {
                return operationType == OperationType.ADD || operationType == OperationType.XOR || operationType == OperationType.OR;
            }
            case NCSUB: {
                return operationType == OperationType.SUB || operationType == OperationType.XOR;
            }
        }
        return o2.getOperationType() == operationType;
    }

    List<SeqEntry> collectAdds(IEOperation iEOperation) {
        ArrayList<SeqEntry> arrayList = new ArrayList<SeqEntry>();
        this.collectAddsRecurse(iEOperation, false, arrayList);
        return arrayList;
    }

    private void collectAddsRecurse(IEGeneric iEGeneric, boolean bl, List<SeqEntry> list) {
        if (iEGeneric instanceof IEOperation) {
            IEOperation iEOperation = iEGeneric.asOperation();
            OperationType operationType = iEOperation.getOperationType();
            if (operationType == OperationType.ADD) {
                this.collectAddsRecurse(iEOperation.getOperand1(), bl, list);
                this.collectAddsRecurse(iEOperation.getOperand2(), bl, list);
            } else if (operationType == OperationType.SUB) {
                this.collectAddsRecurse(iEOperation.getOperand1(), bl, list);
                this.collectAddsRecurse(iEOperation.getOperand2(), !bl, list);
            } else {
                list.add(new SeqEntry(iEGeneric, bl));
            }
        } else if (!(iEGeneric instanceof IEImm) || !((IEImm)iEGeneric).isZero()) {
            list.add(new SeqEntry(iEGeneric, bl));
        }
    }

    List<SeqEntry> collectMuls(IEOperation iEOperation) {
        ArrayList<SeqEntry> arrayList = new ArrayList<SeqEntry>();
        this.collectMulsRecurse(iEOperation, false, arrayList);
        return arrayList;
    }

    private void collectMulsRecurse(IEGeneric iEGeneric, boolean bl, List<SeqEntry> list) {
        if (iEGeneric instanceof IEOperation) {
            IEOperation iEOperation = iEGeneric.asOperation();
            OperationType operationType = iEOperation.getOperationType();
            if (operationType == OperationType.MUL) {
                this.collectMulsRecurse(iEOperation.getOperand1(), bl, list);
                this.collectMulsRecurse(iEOperation.getOperand2(), bl, list);
            } else if (operationType == OperationType.SUB && iEOperation.getOperand1().isImm() && iEOperation.getOperand1().asImm().isZero()) {
                this.collectMulsRecurse(iEOperation.getOperand2(), !bl, list);
            } else {
                list.add(new SeqEntry(iEGeneric, bl));
            }
        } else {
            list.add(new SeqEntry(iEGeneric, bl));
        }
    }

    List<SeqEntry> collectBitwise(IEOperation iEOperation) {
        ArrayList<SeqEntry> arrayList = new ArrayList<SeqEntry>();
        this.collectBitwiseRecurse(iEOperation, iEOperation.getOperationType(), arrayList);
        return arrayList;
    }

    private void collectBitwiseRecurse(IEGeneric iEGeneric, OperationType operationType, List<SeqEntry> list) {
        if (iEGeneric instanceof IEOperation) {
            IEOperation iEOperation = iEGeneric.asOperation();
            OperationType operationType2 = iEOperation.getOperationType();
            if (operationType2 == operationType) {
                this.collectBitwiseRecurse(iEOperation.getOperand1(), operationType, list);
                this.collectBitwiseRecurse(iEOperation.getOperand2(), operationType, list);
            } else {
                list.add(new SeqEntry(iEGeneric));
            }
        } else {
            list.add(new SeqEntry(iEGeneric));
        }
    }

    boolean checkSequence(List<SeqEntry> list, INode[] iNodeArray, int n2, int n3) {
        if (list.isEmpty()) {
            return true;
        }
        INode iNode = iNodeArray[n2];
        for (int i = 0; i < list.size(); ++i) {
            SeqEntry seqEntry = list.get(i);
            IEGeneric iEGeneric = seqEntry.exp;
            if (seqEntry.neg) {
                if (!(iNode instanceof Node) || ((Node)iNode).operator != O.NEG) continue;
                iNode = ((Node)iNode).opnds[0];
            }
            if (!this.canFork()) {
                return false;
            }
            EExpressionMatcher eExpressionMatcher = this.fork(this);
            boolean bl = eExpressionMatcher.isEqual(iEGeneric, iNode, n3 + 1);
            this.forkcount = eExpressionMatcher.forkcount;
            if (!bl) continue;
            ArrayList<SeqEntry> arrayList = new ArrayList<SeqEntry>(list);
            arrayList.remove(i);
            bl = eExpressionMatcher.checkSequence(arrayList, iNodeArray, n2 + 1, n3 + 1);
            this.forkcount = eExpressionMatcher.forkcount;
            if (!bl) continue;
            this.map.putAll(eExpressionMatcher.map);
            return true;
        }
        return false;
    }

    private Boolean checkCommutative(List<IEGeneric> list, Node node, O o2, int n2) {
        if (commuteForkMode > 0 && o2.isCommutative()) {
            if (node.opnds[0] instanceof Leaf && node.opnds[1] instanceof Leaf) {
                boolean bl = false;
                Leaf leaf = (Leaf)node.opnds[0];
                Leaf leaf2 = (Leaf)node.opnds[1];
                int n3 = leaf.id;
                int n4 = leaf2.id;
                IEGeneric iEGeneric = (IEGeneric)this.map.get(n3);
                IEGeneric iEGeneric2 = (IEGeneric)this.map.get(n4);
                if (iEGeneric != null && iEGeneric2 == null) {
                    if (iEGeneric.equalsEx(list.get(1), false)) {
                        bl = true;
                    }
                } else if (iEGeneric == null && iEGeneric2 != null) {
                    if (iEGeneric2.equalsEx(list.get(0), false)) {
                        bl = true;
                    }
                } else if (!(iEGeneric == null || iEGeneric2 == null || iEGeneric.equalsEx(list.get(0), false) && iEGeneric2.equalsEx(list.get(1), false))) {
                    bl = true;
                }
                if (bl) {
                    return this.isEqual(list.get(0), node.opnds[1], n2 + 1) && this.isEqual(list.get(1), node.opnds[0], n2 + 1);
                }
                return this.isEqual(list.get(0), node.opnds[0], n2 + 1) && this.isEqual(list.get(1), node.opnds[1], n2 + 1);
            }
            if (commuteForkMode >= 2 && this.canFork()) {
                EExpressionMatcher eExpressionMatcher = this.fork(this);
                boolean bl = false;
                boolean bl2 = eExpressionMatcher.isEqual(list.get(0), node.opnds[0], n2 + 1);
                this.forkcount = eExpressionMatcher.forkcount;
                if (bl2) {
                    bl = eExpressionMatcher.isEqual(list.get(1), node.opnds[1], n2 + 1);
                    this.forkcount = eExpressionMatcher.forkcount;
                }
                if (!bl) {
                    eExpressionMatcher = this.fork(this);
                    bl2 = eExpressionMatcher.isEqual(list.get(0), node.opnds[1], n2 + 1);
                    this.forkcount = eExpressionMatcher.forkcount;
                    if (bl2) {
                        bl = eExpressionMatcher.isEqual(list.get(1), node.opnds[0], n2 + 1);
                        this.forkcount = eExpressionMatcher.forkcount;
                    }
                }
                if (!bl2 || !bl) {
                    return EExpressionMatcher.failed("Operand mismatch: " + list.get(1));
                }
                this.map.putAll(eExpressionMatcher.map);
                return true;
            }
        }
        return null;
    }

    private Boolean checkAssociative(IEOperation iEOperation, Node node, O o2, int n2) {
        if (this.allowDeepAssociativity && o2.isAssociative() && this.canFork()) {
            List<SeqEntry> list;
            switch (o2.getOperationType()) {
                case ADD: {
                    list = this.collectAdds(iEOperation);
                    break;
                }
                case MUL: {
                    list = this.collectMuls(iEOperation);
                    break;
                }
                default: {
                    list = this.collectBitwise(iEOperation);
                }
            }
            if (list == null || list.size() <= 2 || list.size() < node.opnds.length) {
                return null;
            }
            EExpressionMatcher eExpressionMatcher = this.fork(this);
            List<IEOperation> list2 = this.buildAssociatives(list, o2);
            for (IEOperation iEOperation2 : list2) {
                ArrayList<SeqEntry> arrayList = new ArrayList<SeqEntry>();
                arrayList.add(new SeqEntry(iEOperation2.getOperand1(), false));
                arrayList.add(new SeqEntry(iEOperation2.getOperand2(), false));
                if (!eExpressionMatcher.checkSequence(arrayList, node.opnds, 0, n2)) continue;
                this.map.putAll(eExpressionMatcher.map);
                return true;
            }
            return null;
        }
        return null;
    }

    private List<IEOperation> buildAssociatives(List<SeqEntry> list, O o2) {
        ArrayList<IEOperation> arrayList = new ArrayList<IEOperation>();
        ArrayList<SeqEntry> arrayList2 = new ArrayList<SeqEntry>(list);
        ArrayList<SeqEntry> arrayList3 = new ArrayList<SeqEntry>();
        arrayList3.add(0, (SeqEntry)arrayList2.remove(0));
        IEGeneric iEGeneric = this.buildAssociativeOp(arrayList3, o2);
        IEGeneric iEGeneric2 = this.buildAssociativeOp(arrayList2, o2);
        arrayList.add(EUtil.op(o2.getOperationType(), iEGeneric, iEGeneric2));
        for (int i = 1; i < list.size(); ++i) {
            for (int j = i; i == 1 && j < list.size() - 1 || i != 1 && j < list.size(); ++j) {
                arrayList2 = new ArrayList<SeqEntry>(list);
                arrayList3 = new ArrayList();
                for (int k = j; k >= i; --k) {
                    arrayList3.add(0, (SeqEntry)arrayList2.remove(k));
                }
                arrayList3.add(0, (SeqEntry)arrayList2.remove(0));
                iEGeneric = this.buildAssociativeOp(arrayList3, o2);
                iEGeneric2 = this.buildAssociativeOp(arrayList2, o2);
                arrayList.add(EUtil.op(o2.getOperationType(), iEGeneric, iEGeneric2));
            }
        }
        return arrayList;
    }

    private IEGeneric buildAssociativeOp(List<SeqEntry> list, O o2) {
        if (list.isEmpty()) {
            return null;
        }
        SeqEntry seqEntry = list.get(0);
        IEGeneric iEGeneric = seqEntry.neg ? EUtil.op(o2.getOperationType(), EUtil.imm(0L, seqEntry.exp.getBitsize()), seqEntry.exp) : seqEntry.exp;
        for (int i = 1; i < list.size(); ++i) {
            SeqEntry seqEntry2 = list.get(i);
            if (seqEntry2.neg) {
                if (o2.getOperationType() == OperationType.ADD) {
                    iEGeneric = EUtil.sub(iEGeneric, seqEntry2.exp);
                    continue;
                }
                iEGeneric = EUtil.op(o2.getOperationType(), iEGeneric, EUtil.op(o2.getOperationType(), EUtil.imm(0L, seqEntry2.exp.getBitsize()), seqEntry2.exp));
                continue;
            }
            iEGeneric = EUtil.op(o2.getOperationType(), iEGeneric, seqEntry2.exp);
        }
        return iEGeneric;
    }

    public String toString() {
        return Strings.ff("IR Matcher: '%s' [leafmap: %s] [fork: %d]", this.template, this.map, this.forkcount);
    }

    static class SeqEntry {
        IEGeneric exp;
        boolean neg;

        SeqEntry(IEGeneric iEGeneric) {
            this.exp = iEGeneric;
        }

        SeqEntry(IEGeneric iEGeneric, boolean bl) {
            this.exp = iEGeneric;
            this.neg = bl;
        }

        public String toString() {
            if (this.neg) {
                return "-" + this.exp;
            }
            return this.exp.toString();
        }
    }
}

