/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Leaf;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.Node;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler.O;
import com.pnfsoftware.jeb.util.collect.IdentityHashSet;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Map;

public class EExpressionGenerator {
    private IERoutineContext ctx;
    private INode template;
    private Map<Integer, Object> map;
    private IdentityHashSet<IEGeneric> usedForGen;

    public EExpressionGenerator(IERoutineContext iERoutineContext, INode iNode) {
        if (iERoutineContext == null || iNode == null) {
            throw new IllegalArgumentException();
        }
        this.ctx = iERoutineContext;
        this.template = iNode;
    }

    public IEGeneric generate(Map<Integer, Object> map) {
        return this.generate(map, null);
    }

    IEGeneric generate(Map<Integer, Object> map, Integer n2) {
        if (this.usedForGen != null) {
            throw new IllegalStateException();
        }
        this.usedForGen = new IdentityHashSet();
        this.map = map;
        try {
            IEGeneric iEGeneric = this.generate(this.template, n2);
            return iEGeneric;
        }
        finally {
            this.map = null;
            this.usedForGen.clear();
        }
    }

    private IEGeneric generate(INode iNode) {
        return this.generate(iNode, null);
    }

    private IEGeneric generate(INode iNode, Integer n2) {
        IEGeneric iEGeneric;
        if (iNode instanceof Node) {
            int n3;
            Node node = (Node)iNode;
            O o2 = node.operator;
            if (o2 == null && (o2 = (O)((Object)this.map.get(n3 = node.opgrp.id))) == null) {
                return null;
            }
            switch (o2) {
                case SLICE: {
                    IEGeneric iEGeneric2 = this.generate(node.opnds[0]);
                    int n4 = ((Leaf)node.opnds[1]).value.intValue();
                    int n5 = ((Leaf)node.opnds[2]).value.intValue();
                    return iEGeneric2.slice(n4, n5);
                }
                case SLICE_FIRSTBIT: {
                    IEGeneric iEGeneric3 = this.generate(node.opnds[0]);
                    return iEGeneric3.lsb();
                }
                case SLICE_LASTBIT: {
                    IEGeneric iEGeneric4 = this.generate(node.opnds[0]);
                    return iEGeneric4.msb();
                }
                case SLICE_FIRST32: {
                    IEGeneric iEGeneric5 = this.generate(node.opnds[0]);
                    return iEGeneric5.part(32);
                }
                case SLICE_HALF1: {
                    IEGeneric iEGeneric6 = this.generate(node.opnds[0]);
                    return iEGeneric6.part(iEGeneric6.getBitsize() / 2);
                }
                case SLICE_HALF2: {
                    IEGeneric iEGeneric7 = this.generate(node.opnds[0]);
                    return iEGeneric7.slice(iEGeneric7.getBitsize() / 2, iEGeneric7.getBitsize());
                }
                case COMPOSE_2: {
                    IEGeneric iEGeneric8 = this.generate(node.opnds[0]);
                    IEGeneric iEGeneric9 = this.generate(node.opnds[1], n2 == null ? null : Integer.valueOf(n2 - iEGeneric8.getBitsize()));
                    return this.ctx.createCompose(iEGeneric8, iEGeneric9);
                }
                case COMPOSE_2EQ: {
                    IEGeneric iEGeneric10 = this.generate(node.opnds[0], n2 == null ? null : Integer.valueOf(n2 / 2));
                    IEGeneric iEGeneric11 = this.generate(node.opnds[1], (Integer)(n2 == null ? iEGeneric10.getBitsize() : n2 / 2));
                    if (iEGeneric10.getBitsize() != iEGeneric11.getBitsize()) {
                        throw new RuntimeException();
                    }
                    return this.ctx.createCompose(iEGeneric10, iEGeneric11);
                }
                case COND: {
                    IEGeneric iEGeneric12 = this.generate(node.opnds[0]);
                    IEGeneric iEGeneric13 = this.generate(node.opnds[1], n2 == null ? null : n2);
                    IEGeneric iEGeneric14 = this.generate(node.opnds[2], (Integer)iEGeneric13.getBitsize());
                    return this.ctx.createCond(iEGeneric12, iEGeneric13, iEGeneric14);
                }
                case TRN: 
                case TRN8: 
                case TRN16: 
                case TRN32: 
                case TRN64: 
                case TRN128: {
                    int n6 = o2.getResultingBitsize();
                    if (n6 == 0) {
                        if (n2 == null) {
                            throw new RuntimeException();
                        }
                        n3 = n2;
                    } else {
                        if (n2 != null && n2 != n6) {
                            throw new RuntimeException();
                        }
                        n3 = n6;
                    }
                    IEGeneric iEGeneric15 = this.generate(node.opnds[0]);
                    return this.ctx.createResizeOperation(iEGeneric15, n3, false);
                }
                case EXT: 
                case EXT8: 
                case EXT16: 
                case EXT32: 
                case EXT64: 
                case EXT128: {
                    int n7 = o2.getResultingBitsize();
                    if (n7 == 0) {
                        if (n2 == null) {
                            throw new RuntimeException();
                        }
                        n3 = n2;
                    } else {
                        if (n2 != null && n2 != n7) {
                            throw new RuntimeException();
                        }
                        n3 = n7;
                    }
                    IEGeneric iEGeneric16 = this.generate(node.opnds[0]);
                    return this.ctx.createResizeOperation(iEGeneric16, n3, true);
                }
            }
            OperationType operationType = o2.getOperationType();
            if (operationType == null) {
                return null;
            }
            Integer n8 = null;
            if (n2 != null) {
                switch (operationType) {
                    case ADD: 
                    case SUB: 
                    case MUL: 
                    case DIV_S: 
                    case DIV_U: 
                    case REM_S: 
                    case REM_U: 
                    case AND: 
                    case OR: 
                    case XOR: 
                    case ROL: 
                    case ROR: 
                    case SAR: 
                    case SHL: 
                    case SHR: 
                    case NOT: 
                    case POW: {
                        n8 = n2;
                    }
                }
            }
            IEGeneric[] iEGenericArray = new IEGeneric[3];
            int n9 = 0;
            for (INode iNode2 : node.opnds) {
                if (n9 >= iEGenericArray.length) {
                    return null;
                }
                IEGeneric iEGeneric17 = this.generate(iNode2, n8);
                if (iEGeneric17 == null) {
                    return null;
                }
                if (n8 == null) {
                    n8 = iEGeneric17.getBitsize();
                }
                iEGenericArray[n9] = iEGeneric17;
                ++n9;
            }
            return this.ctx.createOperation(operationType, iEGenericArray[0], iEGenericArray[1]);
        }
        Leaf leaf = (Leaf)iNode;
        if (leaf.flags == 16 && leaf.id == -1) {
            if (leaf.optionalBitsize != 0) {
                return this.ctx.createImm(leaf.value.longValue(), leaf.optionalBitsize);
            }
            if (n2 != null) {
                return this.ctx.createImm(leaf.value.longValue(), (int)n2);
            }
        }
        if ((iEGeneric = (IEGeneric)this.map.get(leaf.id)) == null) {
            throw new RuntimeException(Strings.ff("Expression not found (leaf_id=%d). Are you using LC() in a substituter? \"Very sad!\" (c) DJT", leaf.id));
        }
        if (leaf.flags == 16) {
            int n10 = iEGeneric.getBitsize();
            if (leaf.optionalBitsize != 0 || n10 == 0) {
                throw new RuntimeException("Illegal bitsize values");
            }
            IEImm iEImm = this.ctx.createImm(leaf.value.longValue(), n10);
            if (!(iEGeneric instanceof IEImm) || !iEGeneric.equalsEx(iEImm, false)) {
                return iEImm;
            }
        }
        if (!this.usedForGen.add(iEGeneric)) {
            iEGeneric = iEGeneric.duplicate();
        }
        return iEGeneric;
    }
}

