/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.compiler;

import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IERange;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESwitch;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardTypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.Sets;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ECompiler {
    private static final ILogger logger = GlobalLog.getLogger(ECompiler.class);
    private IEGlobalContext gctx;
    private Map<String, Integer> labelmap = new HashMap<String, Integer>();
    private static final int CANARY_BASE = 0x70000000;
    private int currentCanaryOffset = 0x70000000;
    private Map<String, Integer> labelToCanary = new HashMap<String, Integer>();
    private Map<Integer, String> canaryToLabel = new HashMap<Integer, String>();
    private static Set<Character> trgOperators = Sets.createNonNulls(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('#'));
    private static Set<Character> stdStoppers = Sets.createNonNulls(Character.valueOf(' '), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(':'), Character.valueOf(','), Character.valueOf(';'));
    private static Set<Character> stdStoppersWithOpTriggers = new HashSet<Character>(stdStoppers);
    private static Set<Character> digits;
    private static Set<Character> hexchars;
    private static Set<Character> tokenchars;

    public static IEGeneric cc(String string, IEGlobalContext iEGlobalContext) {
        return ECompiler.cc(string, iEGlobalContext, IEGeneric.class);
    }

    public static <T extends IEGeneric> T cc(String string, IEGlobalContext iEGlobalContext, Class<T> clazz) {
        ECompiler eCompiler = new ECompiler(iEGlobalContext);
        try {
            return (T)eCompiler.compileStatement(string).getStatement();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (T)eCompiler.compileExpression(string).getExpression();
        }
    }

    public ECompiler(IEGlobalContext iEGlobalContext) {
        this.gctx = iEGlobalContext;
    }

    public void reset() {
        this.labelmap.clear();
        this.currentCanaryOffset = 0x70000000;
        this.labelToCanary.clear();
        this.canaryToLabel.clear();
    }

    public CompiledExpression compileExpression(String string) {
        return this.compileExpression(null, string);
    }

    public CompiledExpression compileExpression(IERoutineContext iERoutineContext, String string) {
        if (iERoutineContext == null) {
            iERoutineContext = this.gctx.createRoutineContext();
        }
        InternalCompiler internalCompiler = new InternalCompiler(iERoutineContext, string);
        Parsed parsed = internalCompiler.parse();
        if (parsed.result instanceof IEStatement) {
            throw new IllegalArgumentException("Expected a non-statement");
        }
        return new CompiledExpression(iERoutineContext, parsed.result);
    }

    public CompiledStatement compileStatement(String string) {
        return this.compileStatement(null, string);
    }

    public CompiledStatement compileStatement(IERoutineContext iERoutineContext, String string) {
        CFG<IEStatement> cFG = this.compileCfg(iERoutineContext, string);
        if (cFG.getInstructionCount() != 1) {
            throw new IllegalArgumentException("The provided input string do not fit in a single instruction");
        }
        return new CompiledStatement(cFG.getInstruction(0L));
    }

    public CFG<IEStatement> compileCfg(String ... stringArray) {
        return this.compileCfg((IERoutineContext)null, stringArray);
    }

    public CFG<IEStatement> compileCfg(IERoutineContext iERoutineContext, String ... stringArray) {
        return this.compile(iERoutineContext, false, 0L, Arrays.asList(stringArray), 0, stringArray.length).getSecond();
    }

    public CompiledRoutine compileRoutine(String ... stringArray) {
        return this.compileProc(Arrays.asList(stringArray), 0, stringArray.length);
    }

    public CompiledProgram compileProgram(File file) throws IOException {
        List<String> list = IO.readLines(file);
        return this.compileProgram(list);
    }

    public CompiledProgram compileProgram(String ... stringArray) {
        return this.compileProgram(Arrays.asList(stringArray));
    }

    public CompiledProgram compileProgram(List<String> list) {
        CompiledProgram compiledProgram = new CompiledProgram();
        boolean bl = false;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string = list.get(i);
            if (Strings.isBlank(string = ECompiler.trimComment(string))) continue;
            if (string.startsWith("PROC")) {
                if (bl) {
                    ECompiler.throwParsingException("Unexpected PROC inside PROC", string);
                }
                bl = true;
                n2 = i;
                continue;
            }
            if (string.startsWith("ENDP")) {
                if (!bl) {
                    ECompiler.throwParsingException("Unexpected ENDP outside PROC", string);
                }
                object = this.compileProc(list, n2, i + 1);
                compiledProgram.addRoutine((CompiledRoutine)object);
                bl = false;
                n2 = -1;
                continue;
            }
            if (string.startsWith("D")) {
                if (bl) {
                    ECompiler.throwParsingException("Cannot declare data inside a PROC", string);
                }
                object = this.compileField(string);
                compiledProgram.addField((CompiledField)object);
                continue;
            }
            if (bl) continue;
            ECompiler.throwParsingException("Unknown / Directive not supported", string);
        }
        return compiledProgram;
    }

    private static String trimComment(String string) {
        if (string.trim().startsWith("//")) {
            return "";
        }
        int n2 = string.indexOf(";");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private CompiledField compileField(String string) {
        int n2;
        CompiledField compiledField = new CompiledField();
        String string2 = ECompiler.trimComment(string);
        if (Strings.isBlank(string2)) {
            ECompiler.throwParsingException("Empty line or comment line", string2);
        }
        if (string2.startsWith("DB", n2 = ECompiler.skipSpaces(string2, 0)) || string2.startsWith("DW", n2) || string2.startsWith("DD", n2) || string2.startsWith("DQ", n2)) {
            long l2;
            int n3;
            char c2 = Character.toUpperCase(string2.charAt(n2 + 1));
            String string3 = string2.substring(n2 = ECompiler.mustSkipSpacesOrEol(string2, n2 + 2), n3 = ECompiler.scanUntilStopper(string2, n2));
            if (!string3.startsWith("@")) {
                ECompiler.throwParsingException("Expected an @ character to prefix the native address", string2, n2);
            }
            compiledField.address = l2 = Long.parseLong(string2.substring(n2 + 1, n3), 16);
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n3);
            if (n2 == string2.length()) {
                ECompiler.throwParsingException("Missing data value", string2, n2);
            }
            char c3 = string2.charAt(n2);
            if (c2 == 'B' && (c3 == '\'' || c3 == '\"')) {
                if (c3 == '\'') {
                    n3 = ECompiler.scanUntil(string2, ++n2, false, '\'');
                    compiledField.value = Formatter.hexStringToByteArray(string2, n2, n3);
                    n2 = n3 + 1;
                } else if (c3 == '\"') {
                    n3 = ECompiler.scanString(string2, n2);
                    try {
                        String string4 = Formatter.unescapeString(string2.substring(n2 + 1, n3));
                        compiledField.value = string4.getBytes("US-ASCII");
                    }
                    catch (Exception exception) {
                        ECompiler.throwParsingException("Illegal DS string", string2, n2);
                    }
                }
                if (compiledField.value == null) {
                    ECompiler.throwParsingException("Illegal value for DS", string2, n2);
                }
            } else {
                n3 = ECompiler.scanUntilStopper(string2, n2);
                Long l3 = Conversion.stringToLongUnsafe(string2.substring(n2, n3));
                if (l3 == null) {
                    ECompiler.throwParsingException("Illegal number value", string2, n2);
                }
                switch (c2) {
                    case 'B': {
                        compiledField.value = new byte[]{l3.byteValue()};
                        break;
                    }
                    case 'W': {
                        if (this.gctx.isBigEndian()) {
                            compiledField.value = EndianUtil.shortToBEBytes(l3.shortValue());
                            break;
                        }
                        compiledField.value = EndianUtil.shortToLEBytes(l3.shortValue());
                        break;
                    }
                    case 'D': {
                        if (this.gctx.isBigEndian()) {
                            compiledField.value = EndianUtil.intToBEBytes(l3.intValue());
                            break;
                        }
                        compiledField.value = EndianUtil.intToLEBytes(l3.intValue());
                        break;
                    }
                    case 'Q': {
                        if (this.gctx.isBigEndian()) {
                            compiledField.value = EndianUtil.longToBEBytes(l3);
                            break;
                        }
                        compiledField.value = EndianUtil.longToLEBytes(l3);
                        break;
                    }
                    default: {
                        ECompiler.throwParsingException("Unknown data declarator", string2, n2);
                    }
                }
            }
        } else if (string2.startsWith("DV", n2)) {
            int n4;
            String string5 = string2.substring(n2 = ECompiler.mustSkipSpacesOrEol(string2, n2 + 2), n4 = ECompiler.scanUntilStopper(string2, n2));
            if (string5.startsWith("@")) {
                ECompiler.throwParsingException("@ character not allowed in variable name", string2, n2);
            }
            compiledField.name = string5;
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n4);
            String string6 = string2.substring(n2, n4 = ECompiler.scanUntilStopper(string2, n2));
            if (!string6.startsWith("@")) {
                ECompiler.throwParsingException("Expected an @ character to prefix the native address", string2, n2);
            }
            compiledField.address = Long.parseLong(string2.substring(n2 + 1, n4), 16);
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n4);
            if (string2.charAt(n2) != ':') {
                ECompiler.throwParsingException("Expected a type prefixed by :", string2, n2);
            }
            n4 = ECompiler.scanUntilStopper(string2, ++n2);
            String string7 = string2.substring(n2, n4);
            INativeType iNativeType = TypeUtil.buildQuickType(this.gctx.getWildcardTypeManager().getNativeTypeManager(), string7);
            if (iNativeType == null) {
                ECompiler.throwParsingException(Strings.ff("Cannot parse type string: '%s'", string7), string2, n2);
            }
            compiledField.type = iNativeType;
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n4);
            if (n2 < string2.length()) {
                byte[] byArray;
                String string8;
                if (string2.charAt(n2) != '\'') {
                    ECompiler.throwParsingException("Expected a hex-encoded string enclosed in single-quotes", string2, n2);
                }
                if ((string8 = string2.substring(++n2, n4 = ECompiler.scanUntil(string2, n2, false, '\'')).replace(" ", "")).length() % 2 != 0) {
                    ECompiler.throwParsingException("Illegal hex-encoded string (odd length)", string2, n2);
                }
                if ((byArray = Formatter.hexStringToByteArray(string8)).length > iNativeType.getSize()) {
                    ECompiler.throwParsingException(Strings.ff("%d bytes provided when the type specifies %d bytes!", byArray.length, iNativeType.getSize()), string2, n2);
                }
                compiledField.value = byArray;
            }
        } else if (string2.startsWith("DS", n2)) {
            int n5;
            String string9 = string2.substring(n2 = ECompiler.mustSkipSpacesOrEol(string2, n2 + 2), n5 = ECompiler.scanUntilStopper(string2, n2));
            if (string9.startsWith("@")) {
                ECompiler.throwParsingException("@ character not allowed in variable name", string2, n2);
            }
            compiledField.name = string9;
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n5);
            String string10 = string2.substring(n2, n5 = ECompiler.scanUntilStopper(string2, n2));
            if (!string10.startsWith("@")) {
                ECompiler.throwParsingException("Expected an @ character to prefix the native address", string2, n2);
            }
            compiledField.address = Long.parseLong(string2.substring(n2 + 1, n5), 16);
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n5);
            if (string2.charAt(n2) != '\"') {
                ECompiler.throwParsingException("String variable data must be enclosed in double-quotes", string2, n2);
            }
            n5 = ECompiler.scanString(string2, n2);
            try {
                compiledField.stringValue = Formatter.unescapeString(string2.substring(n2 + 1, n5));
                byte[] byArray = compiledField.stringValue.getBytes("US-ASCII");
                compiledField.value = Arrays.copyOf(byArray, byArray.length + 1);
            }
            catch (Exception exception) {
                ECompiler.throwParsingException("Illegal DS string", string2, n2);
            }
            compiledField.type = TypeUtil.buildArrayType(this.gctx.getWildcardTypeManager().getNativeTypeManager(), "char", compiledField.value.length);
        } else if (string2.startsWith("DR", n2)) {
            int n6;
            String string11 = string2.substring(n2 = ECompiler.mustSkipSpacesOrEol(string2, n2 + 2), n6 = ECompiler.scanUntilStopper(string2, n2));
            if (string11.startsWith("@")) {
                ECompiler.throwParsingException("@ character not allowed in reference name", string2, n2);
            }
            compiledField.name = string11;
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n6);
            String string12 = string2.substring(n2, n6 = ECompiler.scanUntilStopper(string2, n2));
            if (!string12.startsWith("@")) {
                ECompiler.throwParsingException("Expected an @ character to prefix the native address", string2, n2);
            }
            compiledField.address = Long.parseLong(string2.substring(n2 + 1, n6), 16);
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n6);
            if (string2.charAt(n2) != '&') {
                ECompiler.throwParsingException("Referenced name must start with ampersand", string2, n2);
            }
            n6 = ECompiler.scanUntilStopper(string2, ++n2);
            compiledField.impname = string2.substring(n2, n6);
            n2 = ECompiler.mustSkipSpacesOrEol(string2, n6);
            if (n2 != string2.length()) {
                if (string2.charAt(n2) != ':') {
                    ECompiler.throwParsingException("Expected a type prefixed by :", string2, n2);
                }
                n6 = ECompiler.scanUntilSpace(string2, ++n2);
                String string13 = string2.substring(n2, n6);
                INativeType iNativeType = TypeUtil.buildQuick(this.gctx.getWildcardTypeManager().getNativeTypeManager(), string13);
                if (iNativeType == null) {
                    ECompiler.throwParsingException(Strings.ff("Cannot parse type string: '%s'", string13), string2, n2);
                }
                compiledField.imptype = iNativeType;
            }
        } else {
            ECompiler.throwParsingException("Unsupported data declarator", string2, n2);
        }
        return compiledField;
    }

    private CompiledRoutine compileProc(List<String> list, int n2, int n3) {
        Object object;
        int n4;
        long l2 = 0L;
        String string = null;
        IPrototypeItem iPrototypeItem = null;
        String string2 = list.get(n2);
        if ((string2 = ECompiler.trimComment(string2)).startsWith("PROC", n4 = ECompiler.skipSpaces(string2, 0))) {
            if ((n4 = ECompiler.mustSkipSpacesOrEol(string2, n4 + 4)) < string2.length()) {
                int n5;
                char c2 = string2.charAt(n4);
                if (c2 != '@' && c2 != ':') {
                    n5 = ECompiler.scanUntilStopper(string2, n4);
                    string = string2.substring(n4, n5);
                    n4 = ECompiler.mustSkipSpacesOrEol(string2, n5);
                }
                if (n4 < string2.length()) {
                    if (string2.charAt(n4) == '@') {
                        n5 = ECompiler.scanHexInt(string2, ++n4);
                        l2 = Long.parseLong(string2.substring(n4, n5), 16);
                        n4 = ECompiler.mustSkipSpacesOrEol(string2, n5);
                    }
                    if (n4 < string2.length()) {
                        if (string2.charAt(n4) == ':') {
                            object = string2.substring(++n4);
                            iPrototypeItem = TypeUtil.buildQuickPrototype(this.gctx.getWildcardTypeManager().getNativeTypeManager(), (String)object);
                            if (iPrototypeItem == null) {
                                ECompiler.throwParsingException(Strings.ff("Could not parse prototype: '%s'", object), string2, n4);
                            }
                        } else {
                            ECompiler.throwParsingException("Unknown token in procedure declaration", string2, n4);
                        }
                    }
                }
            }
            string2 = list.get(n3 - 1);
            if (!(string2 = ECompiler.trimComment(string2)).startsWith("ENDP", n4 = ECompiler.skipSpaces(string2, 0))) {
                throw new RuntimeException("Expected ENDP");
            }
            ECompiler.mustSkipSpacesOrEol(string2, n4 + 4);
            ++n2;
            --n3;
        }
        IERoutineContext iERoutineContext = this.compile(null, true, l2, list, n2, n3).getFirst();
        object = new CompiledRoutine(iERoutineContext);
        ((CompiledRoutine)object).address = l2;
        ((CompiledRoutine)object).name = string;
        ((CompiledRoutine)object).proto = iPrototypeItem;
        return object;
    }

    private Couple<IERoutineContext, CFG<IEStatement>> compile(IERoutineContext iERoutineContext, boolean bl, long l2, List<String> list, int n2, int n3) {
        CFG<IEStatement> cFG;
        Object object;
        Object object2;
        this.reset();
        if (iERoutineContext == null) {
            iERoutineContext = this.gctx.createRoutineContext();
        }
        int n4 = 0;
        long l3 = l2;
        ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
        for (String object4 : list.subList(n2, n3)) {
            object2 = ECompiler.trimComment(object4);
            InternalCompiler internalCompiler = new InternalCompiler(iERoutineContext, (String)object2);
            object = internalCompiler.parseStatement(n4, l3);
            if (object == null) continue;
            IEStatement iEStatement = (IEStatement)((Parsed)object).result;
            iEStatement.setSize(((Parsed)object).requestedStatementSize);
            arrayList.add(iEStatement);
            if (((Parsed)object).requestedNativeAddress != null) {
                if (arrayList.size() == 1 && l3 != ((Parsed)object).requestedNativeAddress) {
                    ECompiler.throwParsingException(Strings.ff("Entry instruction specifies native address 0x%X -- it should be 0x%X", ((Parsed)object).requestedNativeAddress, l3), (String)object2);
                }
                if (((Parsed)object).requestedNativeAddress < l3) {
                    ECompiler.throwParsingException(Strings.ff("Instruction specifies native address 0x%X -- it should be at least 0x%X", ((Parsed)object).requestedNativeAddress, l3), (String)object2);
                }
                l3 = ((Parsed)object).requestedNativeAddress;
            }
            iEStatement.setLowerLevelAddress(l3);
            n4 += iEStatement.getSize();
            ++l3;
        }
        for (IEStatement iEStatement : arrayList) {
            int n5;
            if (iEStatement instanceof IEJump) {
                object2 = (IEJump)iEStatement;
                n5 = object2.getBranchAddress();
                if (n5 < 0x70000000) continue;
                object = this.canaryToLabel.get(n5);
                Integer n6 = this.labelmap.get(object);
                Assert.a(n6 != null, "Cannot resolve if-statement target for label: " + (String)object);
                object2.setBranchAddress(n6);
                continue;
            }
            if (!(iEStatement instanceof IESwitch)) continue;
            object2 = (IESwitch)iEStatement;
            n5 = object2.getDefaultAddress();
            if (n5 >= 0x70000000) {
                object = this.canaryToLabel.get(n5);
                Integer n7 = this.labelmap.get(object);
                Assert.a(n7 != null, "Cannot resolve switch default target for label: " + (String)object);
                object2.setDefaultAddress(n7);
            }
            for (Couple couple : object2.getCases()) {
                n5 = (Integer)couple.getSecond();
                if (n5 < 0x70000000) continue;
                String string = this.canaryToLabel.get(n5);
                Integer n8 = this.labelmap.get(string);
                Assert.a(n8 != null, "Cannot resolve switch case target for label: " + string);
                couple.setSecond(Integer.valueOf(n8));
            }
        }
        if (!bl) {
            cFG = new CFG<IEStatement>(arrayList, null, null, 0L, 0L, 2);
        } else {
            iERoutineContext.setStatements(arrayList, true, false, true);
            this.gctx.addRoutineContext(iERoutineContext);
            cFG = iERoutineContext.getCfg();
        }
        return new Couple<IERoutineContext, CFG<IEStatement>>(iERoutineContext, cFG);
    }

    private static void throwParsingException(String string, String string2) {
        ECompiler.throwParsingException(string, string2, -1);
    }

    private static void throwParsingException(String object, String string, int n2) {
        object = Strings.ff("Parsing error: %s", object);
        object = n2 >= 0 ? (String)object + Strings.ff(":\n  %s\n  %s^", string, Strings.generate(' ', n2)) : (String)object + Strings.ff(":\n  %s", string);
        throw new IllegalStateException((String)object);
    }

    private static boolean isContained(char c2, char ... cArray) {
        for (char c3 : cArray) {
            if (c2 != c3) continue;
            return true;
        }
        return false;
    }

    private static int scanUntil(String string, int n2, boolean bl, Set<Character> set) {
        char c2;
        while (n2 < string.length() && !(bl ^ set.contains(Character.valueOf(c2 = string.charAt(n2))))) {
            ++n2;
        }
        return n2;
    }

    private static int scanUntil(String string, int n2, boolean bl, char ... cArray) {
        char c2;
        while (n2 < string.length() && !(bl ^ ECompiler.isContained(c2 = string.charAt(n2), cArray))) {
            ++n2;
        }
        return n2;
    }

    private static int scanUntilStopper(String string, int n2) {
        return ECompiler.scanUntil(string, n2, false, stdStoppers);
    }

    private static int scanUntilStopperOrOperatorTrigger(String string, int n2) {
        return ECompiler.scanUntil(string, n2, false, stdStoppersWithOpTriggers);
    }

    private static int scanUntilSpace(String string, int n2) {
        return ECompiler.scanUntil(string, n2, false, ' ');
    }

    private static int scanInt(String string, int n2) {
        return ECompiler.scanUntil(string, n2, true, digits);
    }

    private static int scanHexInt(String string, int n2) {
        return ECompiler.scanUntil(string, n2, true, hexchars);
    }

    private static int scanToken(String string, int n2) {
        return ECompiler.scanUntil(string, n2, true, tokenchars);
    }

    private static int skipSpaces(String string, int n2) {
        char c2;
        while (n2 < string.length() && (c2 = string.charAt(n2)) == ' ') {
            ++n2;
        }
        return n2;
    }

    private static int mustSkipSpacesOrEol(String string, int n2) {
        int n3 = ECompiler.skipSpaces(string, n2);
        if (n3 == n2 && n3 != string.length()) {
            ECompiler.throwParsingException("Expected a space separator before next token or EOL", string, n2);
        }
        return n3;
    }

    private static int scanString(String string, int n2) {
        char c2;
        Assert.a((c2 = string.charAt(n2++)) == '\"');
        while (n2 < string.length()) {
            if ((c2 = string.charAt(n2++)) == '\\') {
                ++n2;
            }
            if (c2 != '\"') continue;
            --n2;
            break;
        }
        return n2;
    }

    static {
        stdStoppersWithOpTriggers.addAll(trgOperators);
        digits = Sets.createNonNulls(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
        hexchars = Sets.createNonNulls(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'));
        tokenchars = Sets.createNonNulls(Character.valueOf('_'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    private class InternalCompiler {
        IERoutineContext ectx;
        InternalCompiler parent;
        int parentBegin;
        private final String s;
        private Integer irOffset;
        private long currentNativeAddress;

        InternalCompiler(IERoutineContext iERoutineContext, String string) {
            this.ectx = iERoutineContext;
            this.s = Strings.rtrim(string);
        }

        private InternalCompiler(InternalCompiler internalCompiler, int n2, int n3) {
            this.parent = internalCompiler;
            this.parentBegin = n2;
            this.ectx = internalCompiler.ectx;
            this.s = internalCompiler.s.substring(n2, n3);
        }

        private InternalCompiler(InternalCompiler internalCompiler, int n2) {
            this.parent = internalCompiler;
            this.parentBegin = n2;
            this.ectx = internalCompiler.ectx;
            this.s = internalCompiler.s.substring(n2);
        }

        int getIROffset() {
            InternalCompiler internalCompiler = this;
            while (internalCompiler.irOffset == null) {
                internalCompiler = internalCompiler.parent;
            }
            return internalCompiler.irOffset;
        }

        long getNativeAddress() {
            InternalCompiler internalCompiler = this;
            while (internalCompiler.irOffset == null) {
                internalCompiler = internalCompiler.parent;
            }
            return internalCompiler.currentNativeAddress;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Parsed parseStatement(int n2, long l2) {
            Parsed parsed;
            int n3;
            if (this.irOffset != null) {
                throw new IllegalStateException("Already parsing a statement");
            }
            this.irOffset = n2;
            this.currentNativeAddress = l2;
            int n4 = ECompiler.skipSpaces(this.s, 0);
            String string = this.s.substring(n4);
            if (string.isEmpty()) {
                return null;
            }
            if (string.startsWith("//") || string.startsWith(";")) {
                throw new IllegalStateException("Unexpected line comment, it should have been trimmed");
            }
            char c2 = string.charAt(0);
            if (c2 == '@') {
                String string2 = this.s.substring(n4 + 1);
                if (ECompiler.this.labelmap.put(string2, n2) == null) return null;
                this.err("Label redefinition", n4);
                return null;
            }
            Long l3 = null;
            int n5 = 1;
            if (c2 == '/' || Character.isDigit(c2)) {
                if (c2 != '/') {
                    n3 = ECompiler.scanHexInt(this.s, n4);
                    l3 = Long.parseLong(this.s.substring(n4, n3), 16);
                    n4 = n3;
                    c2 = this.s.charAt(n4);
                }
                if (c2 == '/') {
                    n3 = ECompiler.scanHexInt(this.s, ++n4);
                    n5 = Integer.parseInt(this.s.substring(n4, n3), 16);
                    n4 = n3;
                    c2 = this.s.charAt(n4);
                }
                if (c2 != ':') {
                    this.err("Expected a semi-colon after explicit statement size", n4);
                }
                n4 = ECompiler.skipSpaces(this.s, n4 + 1);
                string = this.s.substring(n4);
            }
            if (string.equals("nop")) {
                parsed = new Parsed(this.ectx.createNop());
            } else if (string.contains(" = ")) {
                int n6;
                Boolean bl = null;
                int n7 = this.s.lastIndexOf("[BRANCH]");
                if (n7 >= 0) {
                    bl = false;
                } else {
                    n7 = this.s.lastIndexOf("[SUB]");
                    if (n7 >= 0) {
                        bl = true;
                    } else {
                        n7 = this.s.length();
                    }
                }
                ArrayList<BranchTarget> arrayList = null;
                int n8 = this.s.lastIndexOf("[BRANCH_HINTS:");
                if (n8 >= 0) {
                    bl = false;
                    arrayList = new ArrayList<BranchTarget>();
                    n6 = this.s.indexOf("]", n8);
                    for (String string3 : this.s.substring(n8 + 14, n6).split(",")) {
                        int n9 = Conversion.stringToInt(string3.trim(), -1);
                        if (n9 == -1) {
                            this.err("Illegal branch hint: " + string3, n4);
                        }
                        arrayList.add(new BranchTarget(new CodePointer(n9)));
                    }
                    if (n8 < n7) {
                        n7 = n8;
                    }
                }
                n6 = this.s.indexOf(" = ");
                Parsed parsed2 = new InternalCompiler(this, n4, n6).parse();
                IEGeneric iEGeneric = parsed2.result;
                Parsed parsed3 = new InternalCompiler(this, n6 + 3, n7).parse();
                IEGeneric iEGeneric2 = parsed3.result;
                parsed = bl == null ? new Parsed(this.ectx.createAssign(iEGeneric, iEGeneric2)) : new Parsed(this.ectx.createBranchAssign(iEGeneric, iEGeneric2, bl));
                if (arrayList != null) {
                    if (!(parsed.result instanceof IEAssign)) {
                        this.err("Expected a PC-assign since branch hints are provided!", n4);
                    }
                    ((IEAssign)parsed.result).getBranchDetails(true).addCandidates(arrayList);
                }
            } else if (string.startsWith("goto ")) {
                Parsed parsed4;
                String[] stringArray = new String[1];
                int[] nArray = new int[1];
                int n10 = this.parseIROffset(this.s, n4 += 5, stringArray, nArray);
                parsed = parsed4 = new Parsed(this.ectx.createJump(n10));
            } else if (string.startsWith("jump ")) {
                Parsed parsed5 = new InternalCompiler(this, n4 += 5).parse();
                parsed = new Parsed(this.ectx.createJumpFar(parsed5.result));
            } else if (string.startsWith("if ")) {
                n4 += 3;
                n3 = this.s.indexOf(" goto ");
                if (n3 >= 0) {
                    Parsed parsed6 = new InternalCompiler(this, n4, n3).parse();
                    IEGeneric iEGeneric = parsed6.result;
                    String[] stringArray = new String[1];
                    int[] nArray = new int[1];
                    int n11 = this.parseIROffset(this.s, n3 + 6, stringArray, nArray);
                    parsed = parsed6 = new Parsed(this.ectx.createJump(n11, iEGeneric));
                } else {
                    n3 = this.s.indexOf(" jump ");
                    if (n3 < 0) throw new RuntimeException("Illegal type of if-statemet");
                    Parsed parsed7 = new InternalCompiler(this, n4, n3).parse();
                    IEGeneric iEGeneric = parsed7.result;
                    parsed7 = new InternalCompiler(this, n3 + 6).parse();
                    IEGeneric iEGeneric3 = parsed7.result;
                    parsed = new Parsed(this.ectx.createJumpFar(iEGeneric3, iEGeneric));
                }
            } else if (string.startsWith("switch ")) {
                n3 = ECompiler.scanUntil(this.s, n4 += 7, false, '(');
                Parsed parsed8 = new InternalCompiler(this, n4, n3).parse();
                IEGeneric iEGeneric = parsed8.result;
                String[] stringArray = new String[1];
                int[] nArray = new int[1];
                int n12 = this.parseIROffset(this.s, n3 + 1, stringArray, nArray);
                n4 = nArray[0];
                if (this.s.charAt(n4 = ECompiler.skipSpaces(this.s, n4)) != ')') {
                    throw new RuntimeException();
                }
                ++n4;
                if (this.s.charAt(n4 = ECompiler.skipSpaces(this.s, n4)) != ':') {
                    throw new RuntimeException();
                }
                ++n4;
                IESwitch iESwitch = this.ectx.createSwitch(iEGeneric, n12);
                while ((n4 = ECompiler.scanUntil(this.s, n4, false, '{')) != this.s.length()) {
                    if ((n3 = ECompiler.scanUntil(this.s, ++n4, false, '}')) == this.s.length()) {
                        throw new RuntimeException("Missing }");
                    }
                    int n13 = this.s.indexOf("->", n4);
                    if (n13 == -1 || n13 >= n3) {
                        throw new RuntimeException();
                    }
                    parsed8 = new InternalCompiler(this, n4, n13).parse();
                    IEGeneric iEGeneric4 = parsed8.result;
                    int n14 = this.parseIROffset(this.s, n13 + 2, stringArray, nArray);
                    iESwitch.addCase(iEGeneric4, n14);
                    n4 = n3 + 1;
                }
                parsed = new Parsed(iESwitch);
            } else if (string.startsWith("call ")) {
                IEGeneric iEGeneric;
                n3 = ECompiler.scanUntil(this.s, n4 += 5, false, '(');
                Parsed parsed9 = new InternalCompiler(this, n4, n3).parse();
                IEGeneric iEGeneric5 = parsed9.result;
                n4 = n3;
                if (!this.s.startsWith("(", n4)) {
                    ECompiler.throwParsingException("Expected start of parameters for ECall", this.s, n4);
                }
                ++n4;
                ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
                boolean bl = false;
                while (!bl) {
                    n3 = ECompiler.scanUntil(this.s, n4, false, ',', ')');
                    if (this.s.charAt(n3) == ')') {
                        bl = true;
                    }
                    if (n3 > n4 && !Strings.isBlank(this.s.substring(n4, n3))) {
                        IEGeneric iEGeneric6 = (ECompiler)ECompiler.this.new InternalCompiler((InternalCompiler)this, (int)n4, (int)n3).parse().result;
                        arrayList.add(iEGeneric6);
                    }
                    n4 = n3 + 1;
                }
                if (!this.s.startsWith("->(", n4)) {
                    ECompiler.throwParsingException("Expected end of params and start of returns for ECall", this.s, n4);
                }
                n4 += 3;
                ArrayList<IEGeneric> arrayList2 = new ArrayList<IEGeneric>();
                boolean bl2 = false;
                while (!bl2) {
                    n3 = ECompiler.scanUntil(this.s, n4, false, ',', ')');
                    if (this.s.charAt(n3) == ')') {
                        bl2 = true;
                    }
                    if (n3 > n4 && !Strings.isBlank(this.s.substring(n4, n3))) {
                        iEGeneric = (ECompiler)ECompiler.this.new InternalCompiler((InternalCompiler)this, (int)n4, (int)n3).parse().result;
                        arrayList2.add(iEGeneric);
                    }
                    n4 = n3 + 1;
                }
                if (!this.s.startsWith("{", n4)) {
                    ECompiler.throwParsingException("Expected end of returns and start of return-location expression", this.s, n4);
                }
                n3 = ECompiler.scanUntil(this.s, ++n4, false, '}');
                iEGeneric = null;
                if (n3 > n4 && !Strings.isBlank(this.s.substring(n4, n3))) {
                    iEGeneric = (ECompiler)ECompiler.this.new InternalCompiler((InternalCompiler)this, (int)n4, (int)n3).parse().result;
                }
                IWildcardTypeManager iWildcardTypeManager = ECompiler.this.gctx.getWildcardTypeManager();
                IWildcardPrototype iWildcardPrototype = iWildcardTypeManager.createPrototype(null, EUtil.getWildcardTypes(iWildcardTypeManager, arrayList2), EUtil.getWildcardTypes(iWildcardTypeManager, arrayList), null);
                IECall iECall = this.ectx.createCall(iEGeneric5, iEGeneric, arrayList2, arrayList, 0, null, iWildcardPrototype);
                parsed = new Parsed(iECall);
            } else if (string.startsWith("return")) {
                n4 += 6;
                if ((n4 = ECompiler.skipSpaces(this.s, n4)) == this.s.length()) {
                    parsed = new Parsed(this.ectx.createReturn());
                } else {
                    Parsed parsed10 = new InternalCompiler(this, n4).parse();
                    parsed = new Parsed(this.ectx.createReturn(parsed10.result));
                }
            } else {
                if (!string.startsWith("untranslated")) throw new IllegalArgumentException("Unsupported statement type: " + string);
                throw new RuntimeException("TBI: untranslated");
            }
            parsed.requestedStatementSize = n5;
            parsed.requestedNativeAddress = l3;
            return parsed;
        }

        private int parseIROffset(String string, int n2, String[] stringArray, int[] nArray) {
            Integer n3;
            int n4;
            char c2 = string.charAt(n2 = ECompiler.skipSpaces(string, n2));
            if (c2 == '@') {
                n4 = ECompiler.scanToken(string, n2 + 1);
                String string2 = string.substring(n2 + 1, n4);
                n3 = ECompiler.this.labelmap.get(string2);
                if (n3 == null && (n3 = ECompiler.this.labelToCanary.get(string2)) == null) {
                    n3 = ECompiler.this.currentCanaryOffset++;
                    ECompiler.this.labelToCanary.put(string2, n3);
                    ECompiler.this.canaryToLabel.put(n3, string2);
                }
                if (stringArray != null) {
                    stringArray[0] = string2;
                }
            } else {
                n4 = ECompiler.scanHexInt(string, n2);
                n3 = Integer.parseInt(string.substring(n2, n4), 16);
            }
            if (nArray != null) {
                nArray[0] = n4;
            }
            return n3;
        }

        Parsed parse() {
            return this.parse(0);
        }

        private Parsed parse(int n2) {
            return this.parse(n2, 0, '\u0000', ExpressionType.ANY);
        }

        private Parsed parse(int n2, int n3, char c2, ExpressionType expressionType) {
            char c3 = '\u0000';
            OperationType operationType = null;
            int[] nArray = new int[1];
            ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
            while (n2 < this.s.length()) {
                char c4;
                if (Character.isSpaceChar(c4 = this.s.charAt(n2++))) continue;
                if (c4 == 'C') {
                    if ((c4 = this.s.charAt(n2++)) != '(') {
                        this.err("Expected opening paren right after C, got: " + c4, n2 - 1);
                    }
                    Parsed parsed = this.parse(n2, n3 + 1, ')', ExpressionType.COMPOSITION);
                    this.extractSliceAndType(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == '(') {
                    Parsed parsed = this.parse(n2, n3 + 1, ')', ExpressionType.ANY);
                    this.extractSliceAndType(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == ')' || c4 == ']' || c4 == '}' || c4 == '>' && expressionType == ExpressionType.SEGVAR) {
                    c3 = c4;
                    break;
                }
                if (c4 == '?' || c4 == ':') {
                    if (operationType != null) {
                        this.err("Conflicting operator use with ternary-operator expression", n2);
                    }
                    if (c4 == '?') {
                        expressionType = ExpressionType.CONDITIONAL;
                        continue;
                    }
                    if (expressionType == ExpressionType.CONDITIONAL) continue;
                    this.err("Partial termary-operator expression, colon was missing", n2);
                    continue;
                }
                if (trgOperators.contains(Character.valueOf(c4))) {
                    int n4;
                    String string;
                    if (operationType != null) {
                        this.err("Operator already present", n2);
                    }
                    if ((string = this.s.substring(n2 - 1, n4 = ECompiler.scanUntilStopper(this.s, n2))).equals("=")) {
                        this.err("Nested assignments are not supported", n2);
                    }
                    operationType = this.parseOperator(string, nArray);
                    n2 = n4;
                    continue;
                }
                if (c4 == 'i' || c4 == 'f') {
                    Parsed parsed = this.parseImm(this.s, n2 - 1);
                    this.extractSliceAndType(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == 's' || c4 == 'v') {
                    Parsed parsed = this.parseVar(this.s, n2 - 1);
                    this.extractSliceAndType(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == 'm') {
                    Parsed parsed = this.parseMem(n2 - 1, n3);
                    this.extractSliceAndType(parsed);
                    arrayList.add(parsed.result);
                    n2 = parsed.pos;
                    continue;
                }
                if (c4 == ',') {
                    if (expressionType == ExpressionType.COMPOSITION) continue;
                    this.err("Unexpected comma outside composition", n2 - 1);
                    continue;
                }
                if (c4 == ';') {
                    throw new IllegalStateException("Unexpected comment, it should have been trimmed");
                }
                this.err("Character not parsed: " + c4, n2 - 1);
            }
            if (c3 != c2) {
                this.err("Illegal closing parenthesis", n2 - 1);
            }
            Parsed parsed = new Parsed();
            parsed.pos = n2;
            if (operationType == null) {
                if (expressionType == ExpressionType.COMPOSITION) {
                    if (arrayList.size() < 2) {
                        this.err("Composition needs at least two operands");
                    }
                    parsed.result = this.ectx.createCompose(arrayList);
                } else if (expressionType == ExpressionType.CONDITIONAL) {
                    if (arrayList.size() != 3) {
                        this.err("Conditional needs exactly three operands");
                    }
                    parsed.result = this.ectx.createCond((IEGeneric)arrayList.get(0), (IEGeneric)arrayList.get(1), (IEGeneric)arrayList.get(2));
                } else {
                    if (arrayList.size() != 1) {
                        this.err("Expected a single item");
                    }
                    parsed.result = (IEGeneric)arrayList.get(0);
                }
            } else {
                if (arrayList.isEmpty()) {
                    this.err("Operation does not have any operand");
                }
                if (arrayList.size() == 1) {
                    parsed.result = operationType.isConversion() ? this.ectx.createConversionOperation(operationType, (IEGeneric)arrayList.get(0), nArray[0]) : this.ectx.createOperation(operationType, (IEGeneric)arrayList.get(0));
                } else if (arrayList.size() == 2) {
                    parsed.result = this.ectx.createOperation(operationType, (IEGeneric)arrayList.get(0), (IEGeneric)arrayList.get(1));
                } else {
                    this.err("Operation takes at most two operands");
                }
            }
            return parsed;
        }

        private void extractSliceAndType(Parsed parsed) {
            int n2 = parsed.pos;
            while (n2 < this.s.length()) {
                if (this.s.charAt(n2) == '[') {
                    Parsed parsed2 = this.parseRange(this.s, n2, parsed.result);
                    n2 = parsed2.pos;
                    parsed.result = ECompiler.this.gctx.createSlice(parsed.result, (IERange)parsed2.result);
                    parsed.pos = n2;
                    continue;
                }
                if (!this.s.startsWith("<<", n2)) break;
                int n3 = this.s.indexOf(">>", n2 += 2);
                if (n3 < 0) {
                    this.err("Missing end of etype character sequence >>", n2);
                }
                String string = this.s.substring(n2, n3);
                n2 = n3 + 2;
                IWildcardType iWildcardType = null;
                if (!string.isEmpty()) {
                    iWildcardType = ECompiler.this.gctx.getWildcardTypeManager().parse(string, parsed.result.getBitsize());
                }
                if (parsed.result instanceof IEImm && !((IEImm)parsed.result).isMutable()) {
                    parsed.result = ((IEImm)parsed.result).duplicateWithType(iWildcardType);
                } else if (!parsed.result.setType(iWildcardType)) {
                    this.err(Strings.ff("Failed to set requested type '%s' on IR expression '%s'", iWildcardType, parsed.result), n2);
                }
                parsed.pos = n2;
            }
        }

        private Parsed parseImm(String string, int n2) {
            Object object;
            char c2;
            Assert.a((c2 = string.charAt(n2++)) == 'i' || c2 == 'f');
            int n3 = ECompiler.scanInt(string, n2);
            int n4 = Integer.parseInt(string.substring(n2, n3));
            Assert.a(n4 > 0);
            n2 = n3;
            char c3 = string.charAt(n2++);
            if (c3 != ':') {
                this.err("Expected semi-colon", n2);
            }
            if (c2 == 'f') {
                IEImm iEImm = null;
                n3 = ECompiler.scanUntilStopper(string, n2);
                String string2 = string.substring(n2, n3);
                n2 = n3;
                if (n4 == 32) {
                    iEImm = ECompiler.this.gctx.createImm(Float.parseFloat(string2));
                } else if (n4 == 64) {
                    iEImm = ECompiler.this.gctx.createImm(Double.parseDouble(string2));
                } else {
                    this.err("Unsupported size for floating immediate: " + n4, n2);
                }
                return new Parsed(iEImm, n2);
            }
            BigInteger bigInteger = null;
            Long l2 = null;
            if (string.charAt(n2) == '^') {
                int n5 = ++n2;
                ++n2;
                if (string.charAt(n5) != '+') {
                    this.err("Expected a '+' after '^'", n2);
                }
                l2 = this.getNativeAddress();
            } else if (string.charAt(n2) == '$') {
                int n6 = ++n2;
                ++n2;
                if (string.charAt(n6) != '+') {
                    this.err("Expected a '+' after '$'", n2);
                }
                this.err("Unsupported: '$+x', use '^+x' for now", n2);
            } else if (string.charAt(n2) == '\'') {
                int n7 = ++n2;
                ++n2;
                c3 = string.charAt(n7);
                if (c3 > '\u007f') {
                    this.err("Char for EImm definition must be in [0, 0x7F) range", n2);
                }
                if (string.charAt(n2++) != '\'') {
                    this.err("Expected a closing single-quote", n2);
                }
                bigInteger = BigInteger.valueOf((long)c3 & 0xFFL);
            }
            if (bigInteger == null) {
                int n8;
                n3 = ECompiler.scanUntilStopperOrOperatorTrigger(string, n2);
                if (string.charAt(n3 - 1) == 'h') {
                    object = string.substring(n2, n3 - 1);
                    n8 = 16;
                } else {
                    object = string.substring(n2, n3);
                    n8 = 10;
                }
                bigInteger = new BigInteger((String)object, n8);
                n2 = n3;
            }
            if (l2 != null) {
                bigInteger = bigInteger.add(BigInteger.valueOf(l2));
            }
            object = this.ectx.createImm(bigInteger, n4);
            return new Parsed((IEGeneric)object, n2);
        }

        private Parsed parseVar(String string, int n2) {
            IEVar iEVar;
            String string2;
            char c2;
            Assert.a((c2 = string.charAt(n2++)) == 's' || c2 == 'v');
            int n3 = ECompiler.scanInt(string, n2);
            int n4 = Integer.parseInt(string.substring(n2, n3));
            Assert.a(n4 > 0);
            n2 = n3;
            c2 = string.charAt(n2++);
            if (c2 != ':') {
                this.err("Expected semi-colon", n2);
            }
            Assert.a((string2 = string.substring(n2, n3 = ECompiler.scanUntilStopperOrOperatorTrigger(string, n2))).length() > 0);
            n2 = n3;
            if (string2.startsWith("_")) {
                string2 = string2.substring(1);
            }
            if ((iEVar = ECompiler.this.gctx.getVariableByName(string2)) == null && (iEVar = this.ectx.getVariableByName(string2)) == null) {
                if (string2.startsWith("par") || string2.startsWith("var")) {
                    int n5 = Integer.parseInt(string2.substring(3), 16);
                    if (string2.startsWith("var")) {
                        n5 = -n5;
                    }
                    iEVar = this.ectx.getStackManager().createPureStackItem(n5, n4);
                } else if (string2.startsWith("ptr_par") || string2.startsWith("ptr_var")) {
                    int n6 = Integer.parseInt(string2.substring(7), 16);
                    if (string2.startsWith("ptr_var")) {
                        n6 = -n6;
                    }
                    iEVar = this.ectx.createStackReference(n6, null);
                } else if (string2.startsWith("g")) {
                    long l2 = Long.parseLong(string2.substring(1), 16);
                    iEVar = ECompiler.this.gctx.createGlobalVariable(l2, n4);
                } else if (string2.startsWith("ptr_g")) {
                    try {
                        long l3 = Long.parseLong(string2.substring(5), 16);
                        iEVar = ECompiler.this.gctx.createGlobalReference(null, l3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        iEVar = ECompiler.this.gctx.createGlobalReference(string2.substring(5), -1L);
                    }
                } else if (string2.startsWith("r")) {
                    iEVar = ECompiler.this.gctx.createRegister(string2, n4);
                } else if (string2.startsWith("R")) {
                    iEVar = ECompiler.this.gctx.createVirtualRegister(string2, n4);
                } else if (string2.startsWith("v")) {
                    iEVar = this.ectx.createVar(string2, n4);
                } else if (string2.startsWith("$")) {
                    String string3 = string2.substring(1);
                    int n7 = string3.indexOf(36);
                    if (n7 >= 0) {
                        Integer.parseInt(string3.substring(n7 + 1));
                        string3 = string3.substring(0, n7);
                    }
                    if ((n7 = string3.lastIndexOf(95)) >= 0) {
                        String string4 = string3.substring(n7 + 1);
                        if (string4.startsWith("lo")) {
                            int n8 = Integer.parseInt(string3.substring(n7 + 3));
                            if (n8 != n4) {
                                this.err("Bitsize inconsistency", n2);
                            }
                            string3 = string3.substring(0, n7);
                            IEVar iEVar2 = this.ectx.getVariableByName(string3);
                            Couple<IEVar, IEVar> couple = this.ectx.copyTruncatedVariable(iEVar2, n4);
                            iEVar = couple.getFirst();
                        } else if (string4.startsWith("hi")) {
                            this.err("TBI: vx_hiN", n2);
                        } else {
                            String string5 = string3.substring(0, n7);
                            String string6 = string3.substring(n7 + 1);
                            IEVar iEVar3 = this.ectx.getVariableByName(string5);
                            IEVar iEVar4 = this.ectx.getVariableByName(string6);
                            iEVar = this.ectx.copyPairOfVariables(iEVar3, iEVar4);
                        }
                    } else {
                        IEVar iEVar5 = this.ectx.getVariableByName(string3);
                        if (iEVar5 == null) {
                            this.err("Variable " + string3 + " does not exist");
                        }
                        int n9 = 100;
                        while (n9-- > 0 && !(iEVar = this.ectx.copyVariable(iEVar5)).getName().equals(string2)) {
                        }
                        if (n9 < 0) {
                            this.err("Too many copies were created, failed to create " + string2);
                        }
                    }
                    if (!iEVar.getName().equals(string2)) {
                        this.err("Illegal copy index at this point in compilation");
                    }
                } else {
                    this.err("Unsupported name prefix for EVar creation: " + string2, n2);
                }
            }
            Assert.a(iEVar.getBitsize() == n4, "Illegal bitsize for variable " + iEVar + ": " + n4);
            return new Parsed(iEVar, n2);
        }

        private Parsed parseMem(int n2, int n3) {
            Parsed parsed;
            char c2;
            Assert.a((c2 = this.s.charAt(n2++)) == 'm');
            int n4 = ECompiler.scanInt(this.s, n2);
            int n5 = 0;
            try {
                n5 = Integer.parseInt(this.s.substring(n2, n4));
            }
            catch (NumberFormatException numberFormatException) {
                this.err("Illegal bitsize for memory", n2);
            }
            Assert.a(n5 > 0);
            n2 = n4;
            c2 = this.s.charAt(n2++);
            IEGeneric iEGeneric = null;
            if (c2 != '[') {
                if (c2 != '<') {
                    this.err("Expected opening bracket for reference or segment", n2);
                }
                parsed = this.parse(n2, n3 + 1, '>', ExpressionType.SEGVAR);
                iEGeneric = parsed.result;
                if (!(iEGeneric instanceof IEVar)) {
                    this.err("The segment of an EMem must be an EVar", n2);
                }
                n2 = parsed.pos;
                if ((c2 = this.s.charAt(n2++)) != '[') {
                    this.err("Expected opening bracket for reference", n2);
                }
            }
            parsed = this.parse(n2, n3 + 1, ']', ExpressionType.ANY);
            IEMem iEMem = this.ectx.createMem(iEGeneric, parsed.result, n5);
            return new Parsed(iEMem, parsed.pos);
        }

        private Parsed parseRange(String string, int n2, IEGeneric iEGeneric) {
            Object object;
            char c2;
            Assert.a((c2 = string.charAt(n2++)) == '[');
            int n3 = Strings.indexOf2(string, n2, '[', ']');
            if (n3 < 0) {
                this.err("Closing range braket not found", n2);
            }
            boolean bl = string.charAt(n3) == ']';
            String string2 = string.substring(n2, n3);
            n2 = n3 + 1;
            int n4 = 0;
            int n5 = 0;
            String[] stringArray = string2.split(":", -1);
            if (stringArray.length == 1) {
                if (!bl) {
                    this.err("Single bit syntax for range requires a ] closing bracket", n2);
                }
                if ((n4 = Integer.parseInt(stringArray[0].trim())) < 0) {
                    if (iEGeneric == null) {
                        this.err("Range syntax with implicit end requires the sliced-expression", n2);
                    }
                    n4 += iEGeneric.getBitsize();
                }
                n5 = n4 + 1;
            } else if (stringArray.length == 2) {
                object = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                n4 = ((String)object).isEmpty() ? 0 : Integer.parseInt((String)object);
                if (string3.isEmpty()) {
                    if (iEGeneric == null) {
                        this.err("Range syntax with implicit end requires the sliced-expression", n2);
                    }
                    n5 = iEGeneric.getBitsize();
                } else {
                    n5 = Integer.parseInt(string3);
                    if (bl) {
                        ++n5;
                    }
                }
            } else {
                this.err("Unexpected range", n2);
            }
            if (n4 < 0 || n5 < n4) {
                this.err("Illegal range", n2);
            }
            object = ECompiler.this.gctx.createRange(n4, n5);
            return new Parsed((IEGeneric)object, n2);
        }

        private OperationType parseOperator(String string, int[] nArray) {
            switch (string = string.toLowerCase()) {
                case "+": {
                    return OperationType.ADD;
                }
                case "-": {
                    return OperationType.SUB;
                }
                case "*": {
                    return OperationType.MUL;
                }
                case "/": {
                    return OperationType.DIV_S;
                }
                case "/u": {
                    return OperationType.DIV_U;
                }
                case "%": {
                    return OperationType.REM_S;
                }
                case "%u": {
                    return OperationType.REM_U;
                }
                case "~": {
                    return OperationType.NOT;
                }
                case "&": {
                    return OperationType.AND;
                }
                case "|": {
                    return OperationType.OR;
                }
                case "^": {
                    return OperationType.XOR;
                }
                case "!": {
                    return OperationType.LOG_NOT;
                }
                case "&&": {
                    return OperationType.LOG_AND;
                }
                case "||": {
                    return OperationType.LOG_OR;
                }
                case "==": {
                    return OperationType.LOG_EQ;
                }
                case "!=": {
                    return OperationType.LOG_NEQ;
                }
                case "<": {
                    return OperationType.LT_S;
                }
                case "<=": {
                    return OperationType.LE_S;
                }
                case ">": {
                    return OperationType.GT_S;
                }
                case ">=": {
                    return OperationType.GE_S;
                }
                case "<u": {
                    return OperationType.LT_U;
                }
                case "<=u": {
                    return OperationType.LE_U;
                }
                case ">u": {
                    return OperationType.GT_U;
                }
                case ">=u": {
                    return OperationType.GE_U;
                }
                case "<<": {
                    return OperationType.SHL;
                }
                case ">>": {
                    return OperationType.SAR;
                }
                case ">>>": 
                case ">>u": {
                    return OperationType.SHR;
                }
                case "<<>": {
                    return OperationType.ROL;
                }
                case ">><": {
                    return OperationType.ROR;
                }
                case "**": {
                    return OperationType.POW;
                }
                case "#parity": {
                    return OperationType.PAR;
                }
                case "#carry": {
                    return OperationType.CARRY;
                }
                case "+f": {
                    return OperationType.FADD;
                }
                case "-f": {
                    return OperationType.FSUB;
                }
                case "*f": {
                    return OperationType.FMUL;
                }
                case "/f": {
                    return OperationType.FDIV;
                }
                case "==f": {
                    return OperationType.FEQ;
                }
                case "!=f": {
                    return OperationType.FNE;
                }
                case "<f": {
                    return OperationType.FLT;
                }
                case ">f": {
                    return OperationType.FGT;
                }
                case "<=f": {
                    return OperationType.FLE;
                }
                case ">=f": {
                    return OperationType.FGE;
                }
            }
            if (string.startsWith("#") && string.contains("_")) {
                int n2 = string.indexOf(95);
                String string2 = string.substring(1, n2);
                nArray[0] = Integer.parseInt(string.substring(n2 + 1));
                return OperationType.fromName(string2);
            }
            throw new RuntimeException("TBI: Operator: " + string);
        }

        private void err(String string) {
            this.err(string, -1);
        }

        private void err(String string, int n2) {
            InternalCompiler internalCompiler = this;
            while (internalCompiler.parent != null) {
                n2 += internalCompiler.parentBegin;
                internalCompiler = internalCompiler.parent;
            }
            ECompiler.throwParsingException(string, internalCompiler.s, n2);
        }
    }

    static enum ExpressionType {
        ANY,
        CONDITIONAL,
        COMPOSITION,
        SEGVAR;

    }

    private static class Parsed {
        IEGeneric result;
        int pos;
        int requestedStatementSize;
        Long requestedNativeAddress;

        public Parsed() {
        }

        public Parsed(IEGeneric iEGeneric) {
            this.result = iEGeneric;
            this.pos = -1;
        }

        public Parsed(IEGeneric iEGeneric, int n2) {
            this.result = iEGeneric;
            this.pos = n2;
        }

        public String toString() {
            if (this.result == null) {
                return "?";
            }
            return this.result.toString();
        }
    }

    public static class CompiledProgram {
        private Set<String> namesInUse = new HashSet<String>();
        private Set<Long> addressesInUse = new HashSet<Long>();
        private List<CompiledRoutine> routines = new ArrayList<CompiledRoutine>();
        private List<CompiledField> fields = new ArrayList<CompiledField>();

        private void verify(String string, Long l2) {
            if (string != null && !this.namesInUse.add(string)) {
                throw new RuntimeException("Routine: name conflict: " + string);
            }
            if (l2 != null && !this.addressesInUse.add(l2)) {
                throw new RuntimeException(Strings.ff("Routine: address conflict: 0x%X", l2));
            }
        }

        void addRoutine(CompiledRoutine compiledRoutine) {
            this.verify(compiledRoutine.getName(), compiledRoutine.getAddress());
            this.routines.add(compiledRoutine);
        }

        public List<CompiledRoutine> getRoutines() {
            return this.routines;
        }

        public CompiledRoutine getRoutine(int n2) {
            return this.routines.get(n2);
        }

        void addField(CompiledField compiledField) {
            this.verify(compiledField.getName(), compiledField.getAddress());
            this.fields.add(compiledField);
        }

        public List<CompiledField> getFields() {
            return this.fields;
        }

        public CompiledField getField(int n2) {
            return this.fields.get(n2);
        }
    }

    public static class CompiledField {
        long address;
        String name;
        INativeType type;
        byte[] value;
        String stringValue;
        String impname;
        INativeType imptype;

        public boolean isRawBytes() {
            return this.type == null && this.value != null;
        }

        public boolean isRegularVariable() {
            return this.name != null && this.type != null && this.impname == null && this.stringValue == null;
        }

        public boolean isStringVariable() {
            return this.name != null && this.type != null && this.impname == null && this.stringValue != null;
        }

        public boolean isImportedVariable() {
            return this.name != null && this.type == null && this.impname != null && this.value == null;
        }

        public long getAddress() {
            return this.address;
        }

        public String getName() {
            return this.name;
        }

        public INativeType getType() {
            return this.type;
        }

        public int getSize() {
            return this.value.length;
        }

        public byte[] getBytes() {
            return this.value;
        }

        public String getNameOfImport() {
            return this.impname;
        }

        public INativeType getTypeOfImport() {
            return this.imptype;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public String toString() {
            if (this.isRegularVariable()) {
                return this.name + "{" + this.type.getName() + "}@" + Formatter.toHexString(this.address, true) + (String)(this.value != null ? "=" + Formatter.byteArrayToHex(this.value) : "");
            }
            if (this.isStringVariable()) {
                return "@" + Formatter.toHexString(this.address, true) + "=\"" + this.stringValue + "\"";
            }
            if (this.isImportedVariable()) {
                return this.name + "@" + Formatter.toHexString(this.address, true) + "->" + this.impname + (String)(this.imptype != null ? "{" + this.imptype.getName() + "}" : "");
            }
            if (this.isRawBytes()) {
                return "@" + Formatter.toHexString(this.address, true) + "=" + Formatter.byteArrayToHex(this.value);
            }
            return super.toString();
        }
    }

    public static class CompiledRoutine {
        String name;
        long address;
        IPrototypeItem proto;
        IERoutineContext ctx;

        public CompiledRoutine(IERoutineContext iERoutineContext) {
            this.ctx = iERoutineContext;
        }

        public String getName() {
            return this.name;
        }

        public long getAddress() {
            return this.address;
        }

        public IPrototypeItem getPrototype() {
            return this.proto;
        }

        public IERoutineContext getContext() {
            return this.ctx;
        }
    }

    public static class CompiledStatement {
        IEStatement stm;

        public CompiledStatement(IEStatement iEStatement) {
            this.stm = iEStatement;
        }

        public IERoutineContext getContext() {
            return this.stm.getContext();
        }

        public IEStatement getStatement() {
            return this.stm;
        }
    }

    public static class CompiledExpression {
        IERoutineContext ctx;
        IEGeneric expr;

        public CompiledExpression(IERoutineContext iERoutineContext, IEGeneric iEGeneric) {
            this.ctx = iERoutineContext;
            this.expr = iEGeneric;
        }

        public IERoutineContext getContext() {
            return this.ctx;
        }

        public IEGeneric getExpression() {
            return this.expr;
        }
    }
}

