/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Ser
public class VarSrc {
    @SerId(value=1)
    private E v;
    @SerId(value=2)
    private E v1;
    @SerId(value=3)
    private List<E> vX;

    private VarSrc() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.v);
        if (this.v1 != null) {
            stringBuilder.append(":").append(this.v1);
            if (this.vX != null) {
                for (E e : this.vX) {
                    stringBuilder.append(":").append(e);
                }
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.v == null ? 0 : this.v.hashCode());
        n2 = 31 * n2 + (this.v1 == null ? 0 : this.v1.hashCode());
        n2 = 31 * n2 + (this.vX == null ? 0 : this.vX.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VarSrc varSrc = (VarSrc)object;
        if (this.v == null ? varSrc.v != null : !this.v.equals(varSrc.v)) {
            return false;
        }
        if (this.v1 == null ? varSrc.v1 != null : !this.v1.equals(varSrc.v1)) {
            return false;
        }
        return !(this.vX == null ? varSrc.vX != null : !this.vX.equals(varSrc.vX));
    }

    public static VarSrc dup(int n2) {
        VarSrc varSrc = new VarSrc();
        varSrc.v = new E(n2);
        return varSrc;
    }

    public static VarSrc pair(int n2, int n3) {
        VarSrc varSrc = new VarSrc();
        varSrc.v = new E(n2);
        varSrc.v1 = new E(n3);
        return varSrc;
    }

    public static VarSrc slice(int n2, int n3, Integer n4) {
        VarSrc varSrc = new VarSrc();
        varSrc.v = new E(n2, n3, n4);
        return varSrc;
    }

    public static VarSrc truncated(int n2, int n3) {
        VarSrc varSrc = new VarSrc();
        varSrc.v = new E(n2, 0, n3);
        return varSrc;
    }

    public List<E> getSource() {
        if (this.v1 == null) {
            return Collections.unmodifiableList(Arrays.asList(this.v));
        }
        if (this.vX == null) {
            return Collections.unmodifiableList(Arrays.asList(this.v, this.v1));
        }
        throw new RuntimeException("TBI");
    }

    public boolean isDuplicate() {
        return this.v1 == null && this.v.range == null;
    }

    public int getAsDuplicate() {
        return this.v.srcid;
    }

    public boolean isPair() {
        return this.vX == null && this.v1 != null && this.v.range == null && this.v1.range == null;
    }

    public Couple<Integer, Integer> getAsPair() {
        return new Couple<Integer, Integer>(this.v.srcid, this.v1.srcid);
    }

    public boolean isSlice() {
        return this.v1 == null && this.v.range != null;
    }

    public Couple<Integer, Couple<Integer, Integer>> getAsSlice() {
        return new Couple<Integer, Couple<Integer, Integer>>(this.v.srcid, this.v.range);
    }

    public boolean isTruncated() {
        return this.v1 == null && this.v.range != null && this.v.range.getFirst() == 0;
    }

    public Couple<Integer, Integer> getAsTruncated() {
        return new Couple<Integer, Integer>(this.v.srcid, this.v.range.getSecond());
    }

    public boolean containsSourceId(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectSourceIds(arrayList, null);
        return arrayList.contains(n2);
    }

    public void collectSourceIds(Collection<Integer> collection) {
        this.collectSourceIds(collection, null);
    }

    public List<Integer> getSourceIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectSourceIds(arrayList, null);
        return arrayList;
    }

    public void collectSourceIds(Collection<Integer> collection, Collection<Integer> collection2) {
        if (collection2 == null) {
            collection2 = Collections.emptyList();
        }
        if (!collection2.contains(this.v.srcid)) {
            collection.add(this.v.srcid);
        }
        if (this.v1 != null) {
            if (!collection2.contains(this.v1.srcid)) {
                collection.add(this.v1.srcid);
            }
            if (this.vX != null) {
                for (E e : this.vX) {
                    if (collection2.contains(e.srcid)) continue;
                    collection.add(e.srcid);
                }
            }
        }
    }

    @Ser
    public static class E {
        @SerId(value=1)
        private int srcid;
        @SerId(value=2)
        private Couple<Integer, Integer> range;

        private E(int n2) {
            this.srcid = n2;
        }

        private E(int n2, int n3, Integer n4) {
            this.srcid = n2;
            if (n3 > 0 || n4 != null) {
                this.range = new Couple<Integer, Integer>(n3, n4);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("id_").append(Integer.toHexString(this.srcid));
            if (this.range != null) {
                stringBuilder.append("[").append(this.range.getFirst()).append(",").append(this.range.getSecond()).append("[");
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (this.range == null ? 0 : this.range.hashCode());
            n2 = 31 * n2 + this.srcid;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            E e = (E)object;
            if (this.range == null ? e.range != null : !this.range.equals(e.range)) {
                return false;
            }
            return this.srcid == e.srcid;
        }

        public int getSourceId() {
            return this.srcid;
        }

        public Couple<Integer, Integer> getSourceRange() {
            return this.range;
        }
    }
}

