/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class SPDC
implements Comparable<SPDC> {
    public static final SPDC Unknown = new SPDC(0, 0, 0);
    public static final int GUARANTEE_UNKNOWN = 0;
    public static final int GUARANTEE_LOW = 10;
    public static final int GUARANTEE_MEDIUM = 20;
    public static final int GUARANTEE_HIGH = 30;
    public static final int ORIGIN_UNKNOWN = 0;
    public static final int ORIGIN_SIMULATION = 10;
    public static final int ORIGIN_ANALYSIS = 20;
    public static final int ORIGIN_NATIVE = 30;
    public static final int ORIGIN_USER = 40;
    @SerId(value=1)
    private int value;
    @SerId(value=2)
    private int guarantee;
    @SerId(value=3)
    private int origin;

    public static SPDC getBest(SPDC sPDC, SPDC sPDC2) {
        if (sPDC == null) {
            return sPDC2;
        }
        if (sPDC2 == null) {
            return sPDC;
        }
        return sPDC.compareTo(sPDC2) > 0 ? sPDC : sPDC2;
    }

    public SPDC(int n2, int n3, int n4) {
        this.value = n2;
        this.guarantee = n3;
        this.origin = n4;
    }

    public int getValue() {
        return this.value;
    }

    public int getGuarantee() {
        return this.guarantee;
    }

    public int getOrigin() {
        return this.origin;
    }

    public SPDC clone() {
        return new SPDC(this.value, this.guarantee, this.origin);
    }

    @Override
    public int compareTo(SPDC sPDC) {
        if (this.guarantee < sPDC.guarantee) {
            return -1;
        }
        if (this.guarantee > sPDC.guarantee) {
            return 1;
        }
        if (this.origin < sPDC.origin) {
            return -1;
        }
        if (this.origin > sPDC.origin) {
            return 1;
        }
        if (this.value < sPDC.value) {
            return -1;
        }
        if (this.value > sPDC.value) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.guarantee;
        n2 = 31 * n2 + this.origin;
        n2 = 31 * n2 + this.value;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SPDC sPDC = (SPDC)object;
        if (this.guarantee != sPDC.guarantee) {
            return false;
        }
        if (this.origin != sPDC.origin) {
            return false;
        }
        return this.value == sPDC.value;
    }

    String guaranteeToString() {
        switch (this.guarantee) {
            case 0: {
                return "unknown";
            }
            case 10: {
                return "low";
            }
            case 20: {
                return "medium";
            }
            case 30: {
                return "high";
            }
        }
        return "g=" + this.guarantee;
    }

    String originToString() {
        switch (this.origin) {
            case 0: {
                return "unknown";
            }
            case 10: {
                return "simulation";
            }
            case 20: {
                return "analysis";
            }
            case 30: {
                return "native";
            }
            case 40: {
                return "user";
            }
        }
        return "o=" + this.origin;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "%d{g=%s,o=%s}", this.value, this.guaranteeToString(), this.originToString());
        return stringBuilder.toString();
    }
}

