/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Ser
public class PreRoutineInvocationDetails {
    private static final StructuredLogger logger = aeb.ce(PreRoutineInvocationDetails.class);
    @SerId(value=1)
    IVirtualMemory mem;
    @SerId(value=2)
    Map<Integer, IEImm> varmap;
    @SerId(value=3)
    List<IEImm> stackSlotValues;
    @SerId(value=4)
    List<Integer> stackSlotAges;

    public PreRoutineInvocationDetails(IERoutineContext iERoutineContext, EState eState) {
        if (eState == null) {
            throw new IllegalArgumentException();
        }
        this.mem = eState.getMemory().duplicate();
        this.varmap = new HashMap<Integer, IEImm>(eState.getVariables());
        if (iERoutineContext != null && eState.getMemoryWriteHitmap() != null) {
            byte[] byArray;
            IEImm iEImm;
            long l2;
            int n2;
            int n3;
            int n4 = iERoutineContext.getStackManager().getNormalSlotSize();
            int n5 = iERoutineContext.getStackPointerId();
            if (eState.hasValue(n5) && (n3 = (n2 = VirtualMemoryUtil.readBytesSafe(this.mem, l2 = (iEImm = eState.getValue(n5)).getValueAsAddress(), (byArray = new byte[8 * n4]).length, byArray, 0, 1)) / n4) > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n3);
                ArrayList<IEImm> arrayList2 = new ArrayList<IEImm>(n3);
                block2: for (long i = 0L; i < (long)n3; ++i) {
                    long l3 = l2 + i * (long)n4;
                    IEImm iEImm2 = null;
                    try {
                        iEImm2 = iERoutineContext.createMem(EUtil.imm(l3, this.mem.getSpaceBits()), n4 * 8).evaluate(eState);
                    }
                    catch (Exception exception) {}
                    arrayList2.add(iEImm2);
                    int n6 = -1;
                    for (int j = 0; j < n4; ++j) {
                        Integer n7 = eState.getMemoryWriteHitmap().get(l3 + (long)j);
                        if (n7 == null) break block2;
                        int n8 = eState.getEvaluationCount() - n7;
                        if (j == 0) {
                            n6 = n8;
                            continue;
                        }
                        if (n8 != n6) break block2;
                    }
                    arrayList.add(n6);
                }
                this.stackSlotValues = arrayList2;
                this.stackSlotAges = arrayList;
            }
        }
    }

    public IVirtualMemory getVirtualMemory() {
        return this.mem;
    }

    public Map<Integer, IEImm> getVariableMap() {
        return this.varmap;
    }

    public List<Integer> getStackSlotAges() {
        return this.stackSlotAges;
    }

    public List<IEImm> getStackSlotValues() {
        return this.stackSlotValues;
    }

    public IEImm readArg(IEConverter<?> iEConverter, StorageEntry storageEntry) {
        if (storageEntry.getType() == StorageEntry.Type.REGISTER) {
            IEGeneric iEGeneric = iEConverter.getRegisterVariableFromNativeRegisterId(storageEntry.getValue());
            if (iEGeneric instanceof IEVar) {
                int n2 = ((IEVar)iEGeneric).getId();
                return this.getVariableMap().get(n2);
            }
        } else if (storageEntry.getType() == StorageEntry.Type.STACK) {
            int n3 = storageEntry.getValueAsStackIndex();
            List<IEImm> list = this.getStackSlotValues();
            if (list != null && n3 < list.size()) {
                return list.get(n3);
            }
        }
        return null;
    }
}

