/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public enum OperationType {
    ADD("+", 2),
    SUB("-", 2),
    MUL("*", 2),
    MUL_U("*u", 2),
    DIV_S("/", 2),
    DIV_U("/u", 2),
    REM_S("%", 2),
    REM_U("%u", 2),
    MUL2_S("*&", 2),
    MUL2_U("*&u", 2),
    DIV2_S("/&", 2),
    DIV2_U("/&u", 2),
    AND("&", 2),
    OR("|", 2),
    XOR("^", 2),
    NOT("~", 1),
    LOG_AND("&&", 2),
    LOG_OR("||", 2),
    LOG_NOT("!", 1),
    LOG_EQ("==", 2),
    LOG_NEQ("!=", 2),
    LT_S("<", 2),
    LE_S("<=", 2),
    GT_S(">", 2),
    GE_S(">=", 2),
    LT_U("<u", 2),
    LE_U("<=u", 2),
    GT_U(">u", 2),
    GE_U(">=u", 2),
    SHL("<<", 2),
    SHR(">>u", 2),
    SAR(">>", 2),
    ROR(">><", 2),
    ROL("<<>", 2),
    PAR("PARITY", 1),
    CAST("TRN", 1),
    CAST_S("EXT", 1),
    CARRY("CARRY", 2),
    POW("**", 2),
    FEQ("==", 2),
    FNE("!=", 2),
    FLT("<", 2),
    FGT(">", 2),
    FLE("<=", 2),
    FGE(">=", 2),
    FADD("+", 2),
    FSUB("-", 2),
    FMUL("*", 2),
    FDIV("/", 2),
    FP2FP("FP2FP", 1),
    FP2INT("FP2INT", 1),
    INT2FP("INT2FP", 1),
    FP2UINT("FP2UINT", 1),
    UINT2FP("UINT2FP", 1),
    FUN("is_unordered", 2),
    ADD_SSAT("+SSAT", 2),
    ADD_USAT("+USAT", 2),
    SUB_SSAT("-SSAT", 2),
    SUB_USAT("-USAT", 2),
    FUNCTION("FUNCTION", -1);

    private final String repr;
    private final int opndcnt;

    private OperationType(String string2, int n3) {
        this.repr = string2;
        this.opndcnt = n3;
    }

    public int getOperandCount() {
        return this.opndcnt;
    }

    public String toString() {
        return this.repr;
    }

    public boolean isValid(int n2) {
        return n2 == this.opndcnt;
    }

    public boolean shouldNotUse() {
        switch (this) {
            case MUL_U: 
            case MUL2_S: 
            case MUL2_U: 
            case DIV2_S: 
            case DIV2_U: 
            case CARRY: {
                return true;
            }
        }
        return false;
    }

    public boolean isLogical() {
        switch (this) {
            case LOG_AND: 
            case LOG_OR: 
            case LOG_NOT: 
            case LOG_EQ: 
            case LOG_NEQ: 
            case LT_S: 
            case LE_S: 
            case GT_S: 
            case GE_S: 
            case LT_U: 
            case LE_U: 
            case GT_U: 
            case GE_U: 
            case FEQ: 
            case FNE: 
            case FLT: 
            case FGT: 
            case FLE: 
            case FGE: {
                return true;
            }
        }
        return false;
    }

    public boolean isShift() {
        switch (this) {
            case SHL: 
            case SHR: 
            case SAR: 
            case ROL: 
            case ROR: {
                return true;
            }
        }
        return false;
    }

    public boolean isConversion() {
        switch (this) {
            case CAST: 
            case CAST_S: 
            case FP2FP: 
            case FP2INT: 
            case INT2FP: 
            case FP2UINT: 
            case UINT2FP: {
                return true;
            }
        }
        return false;
    }

    public boolean isIntegerConversion() {
        switch (this) {
            case CAST: 
            case CAST_S: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatConversion() {
        switch (this) {
            case FP2FP: 
            case FP2INT: 
            case INT2FP: 
            case FP2UINT: 
            case UINT2FP: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatOperation() {
        switch (this) {
            case FADD: 
            case FSUB: 
            case FMUL: 
            case FDIV: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatComparison() {
        switch (this) {
            case FEQ: 
            case FNE: 
            case FLT: 
            case FGT: 
            case FLE: 
            case FGE: {
                return true;
            }
        }
        return false;
    }

    public static OperationType fromName(String string) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.toString().equalsIgnoreCase(string)) continue;
            return operationType;
        }
        throw new IllegalArgumentException("Could not find constant: " + string);
    }

    public boolean isAnyOf(OperationType ... operationTypeArray) {
        for (OperationType operationType : operationTypeArray) {
            if (operationType != this) continue;
            return true;
        }
        return false;
    }
}

