/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.IdRanges;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@Ser
public class MemoryAccessInfo {
    public static final MemoryAccessInfo ACCESSES_NONE = new MemoryAccessInfo(false, false, false, false);
    public static final MemoryAccessInfo ACCESSES_STACK = new MemoryAccessInfo(true, true, false, false);
    public static final MemoryAccessInfo ACCESSES_GLOBALS = new MemoryAccessInfo(false, false, true, true);
    public static final MemoryAccessInfo ACCESSES_ALL = new MemoryAccessInfo(true, true, true, true);
    @SerId(value=1)
    private boolean mutable;
    @SerId(value=2)
    private IdRanges globalsReads;
    @SerId(value=3)
    private IdRanges globalsWrites;
    @SerId(value=4)
    private IdRanges stackReads;
    @SerId(value=5)
    private IdRanges stackWrites;
    @SerId(value=6)
    private IdRanges stackSpoiled;

    public MemoryAccessInfo() {
        this(true);
    }

    public MemoryAccessInfo(boolean bl) {
        this.mutable = true;
        if (bl) {
            return;
        }
        this.setGlobalsAccessRanges(new IdRanges(), new IdRanges());
        this.setStackAccessRanges(new IdRanges(), new IdRanges());
    }

    public MemoryAccessInfo(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl3) {
            this.globalsReads = new IdRanges();
        }
        if (!bl4) {
            this.globalsWrites = new IdRanges();
        }
        if (!bl) {
            this.stackReads = new IdRanges();
        }
        if (!bl2) {
            this.stackWrites = new IdRanges();
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private void verifyCustom() {
        if (!this.isMutable()) {
            throw new IllegalStateException("This MAI cannot be customized!");
        }
    }

    public boolean isNoAccess() {
        return !this.isAccessMemory();
    }

    public boolean isAccessMemory() {
        return this.stackReads == null || !this.stackReads.isEmpty() || this.stackWrites == null || !this.stackWrites.isEmpty() || this.globalsReads == null || !this.globalsReads.isEmpty() || this.globalsWrites == null || !this.globalsWrites.isEmpty();
    }

    public boolean isReadMemory() {
        return this.stackReads == null || !this.stackReads.isEmpty() || this.globalsReads == null || !this.globalsReads.isEmpty();
    }

    public boolean isWriteMemory() {
        return this.stackWrites == null || !this.stackWrites.isEmpty() || this.globalsWrites == null || !this.globalsWrites.isEmpty();
    }

    public boolean isAccessStack() {
        return this.stackReads == null || !this.stackReads.isEmpty() || this.stackWrites == null || !this.stackWrites.isEmpty();
    }

    public boolean isReadStack() {
        return this.stackReads == null || !this.stackReads.isEmpty();
    }

    public boolean isWriteStack() {
        return this.stackWrites == null || !this.stackWrites.isEmpty();
    }

    public boolean isAccessGlobals() {
        return this.globalsReads == null || !this.globalsReads.isEmpty() || this.globalsWrites == null || !this.globalsWrites.isEmpty();
    }

    public boolean isReadGlobals() {
        return this.globalsReads == null || !this.globalsReads.isEmpty();
    }

    public boolean isWriteGlobals() {
        return this.globalsWrites == null || !this.globalsWrites.isEmpty();
    }

    public boolean hasSpoiledStack() {
        return this.stackSpoiled != null && !this.stackSpoiled.isEmpty();
    }

    public void setAccessRanges(IdRanges idRanges, IdRanges idRanges2, IdRanges idRanges3, IdRanges idRanges4) {
        this.verifyCustom();
        this.stackReads = idRanges;
        this.stackWrites = idRanges2;
        this.globalsReads = idRanges3;
        this.globalsWrites = idRanges4;
    }

    public void setStackAccessRanges(IdRanges idRanges, IdRanges idRanges2) {
        this.verifyCustom();
        this.stackReads = idRanges;
        this.stackWrites = idRanges2;
    }

    public IdRanges getStackReads() {
        this.verifyCustom();
        return this.stackReads;
    }

    public IdRanges getStackWrites() {
        this.verifyCustom();
        return this.stackWrites;
    }

    public void setGlobalsAccessRanges(IdRanges idRanges, IdRanges idRanges2) {
        this.verifyCustom();
        this.globalsReads = idRanges;
        this.globalsWrites = idRanges2;
    }

    public IdRanges getGlobalsReads() {
        this.verifyCustom();
        return this.globalsReads;
    }

    public IdRanges getGlobalsWrites() {
        this.verifyCustom();
        return this.globalsWrites;
    }

    public void setStackSpoiledRanges(IdRanges idRanges) {
        this.verifyCustom();
        this.stackSpoiled = idRanges;
    }

    public IdRanges getStackSpoiledRanges() {
        this.verifyCustom();
        return this.stackSpoiled;
    }

    public MemoryAccessInfo clone() {
        if (!this.mutable) {
            return this;
        }
        MemoryAccessInfo memoryAccessInfo = new MemoryAccessInfo();
        memoryAccessInfo.mutable = this.mutable;
        memoryAccessInfo.globalsReads = this.globalsReads == null ? null : new IdRanges(this.globalsReads);
        memoryAccessInfo.globalsWrites = this.globalsWrites == null ? null : new IdRanges(this.globalsWrites);
        memoryAccessInfo.stackReads = this.stackReads == null ? null : new IdRanges(this.stackReads);
        memoryAccessInfo.stackWrites = this.stackWrites == null ? null : new IdRanges(this.stackWrites);
        memoryAccessInfo.stackSpoiled = this.stackSpoiled == null ? null : new IdRanges(this.stackSpoiled);
        return memoryAccessInfo;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.globalsReads == null ? 0 : this.globalsReads.hashCode());
        n2 = 31 * n2 + (this.globalsWrites == null ? 0 : this.globalsWrites.hashCode());
        n2 = 31 * n2 + (this.stackReads == null ? 0 : this.stackReads.hashCode());
        n2 = 31 * n2 + (this.stackWrites == null ? 0 : this.stackWrites.hashCode());
        n2 = 31 * n2 + (this.stackSpoiled == null ? 0 : this.stackSpoiled.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MemoryAccessInfo memoryAccessInfo = (MemoryAccessInfo)object;
        if (this.globalsReads == null ? memoryAccessInfo.globalsReads != null : !this.globalsReads.equals(memoryAccessInfo.globalsReads)) {
            return false;
        }
        if (this.globalsWrites == null ? memoryAccessInfo.globalsWrites != null : !this.globalsWrites.equals(memoryAccessInfo.globalsWrites)) {
            return false;
        }
        if (this.stackReads == null ? memoryAccessInfo.stackReads != null : !this.stackReads.equals(memoryAccessInfo.stackReads)) {
            return false;
        }
        if (this.stackWrites == null ? memoryAccessInfo.stackWrites != null : !this.stackWrites.equals(memoryAccessInfo.stackWrites)) {
            return false;
        }
        return !(this.stackSpoiled == null ? memoryAccessInfo.stackSpoiled != null : !this.stackSpoiled.equals(memoryAccessInfo.stackSpoiled));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNoAccess()) {
            stringBuilder.append("NO_ACCESS");
        } else {
            if (this.isReadGlobals()) {
                stringBuilder.append("GLOBALS_R,");
            }
            if (this.isWriteGlobals()) {
                stringBuilder.append("GLOBALS_W,");
            }
            if (this.isReadStack()) {
                stringBuilder.append("STK_R,");
            }
            if (this.isWriteStack()) {
                stringBuilder.append("STK_W,");
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        return stringBuilder.toString();
    }

    public Collection<IEVar> filterGlobalsReads(Collection<IEVar> collection) {
        return this.filter(this.globalsReads, collection);
    }

    public Collection<IEVar> filterGlobalsWrites(Collection<IEVar> collection) {
        return this.filter(this.globalsWrites, collection);
    }

    public Collection<IEVar> filterStackReads(Collection<IEVar> collection) {
        return this.filter(this.stackReads, collection);
    }

    public Collection<IEVar> filterStackWrites(Collection<IEVar> collection) {
        return this.filter(this.stackWrites, collection);
    }

    public Collection<IEVar> filterStackSpoiled(Collection<IEVar> collection) {
        return this.filter(this.stackSpoiled, collection);
    }

    private Collection<IEVar> filter(IdRanges idRanges, Collection<IEVar> collection) {
        if (idRanges == null) {
            return collection;
        }
        if (idRanges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IEVar> arrayList = new ArrayList<IEVar>();
        for (IEVar iEVar : collection) {
            if (!idRanges.containsVarPart(iEVar)) continue;
            arrayList.add(iEVar);
        }
        return arrayList;
    }
}

