/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.IVariable;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public interface IEVar
extends IVariable,
IEGeneric {
    public static final int FLAG_NO_COPY = 16;
    public static final int FLAG_LIKELY_SAVED_VAR = 32;
    public static final int FLAG_LIKELY_COPIED_PARAM = 64;
    public static final int ID_BEGIN = 0;
    public static final int ID_END = Integer.MAX_VALUE;
    public static final int ID_PHYSICAL_REGISTER = 0;
    public static final int ID_PHYSICAL_REGISTER_END = 65536;
    public static final int ID_VIRTUAL_REGISTER = 65536;
    public static final int ID_VIRTUAL_REGISTER_END = 131072;
    public static final int ID_REGISTER = 0;
    public static final int ID_REGISTER_END = 131072;
    public static final int REGISTER_RANGE_SIZE = 131072;
    public static final int ID_SYMBOL = 131072;
    public static final int ID_SYMBOL_END = 196608;
    public static final int ID_MEMVAR = 0x1000000;
    public static final int ID_MEMVAR_END = Integer.MAX_VALUE;
    public static final int ID_PSEUDO_VAR = -1;
    public static final int IDL_PSEUDO_VAR = 1;
    public static final int IDL_PSEUDO_VAR_END = 2;
    public static final int IDL_SPECIAL = 2;
    public static final int IDL_SPECIAL_END = 65536;
    public static final int IDL_MIRROR = 65536;
    public static final int IDL_MIRROR_END = 196608;
    public static final int IDL_COPY_DUP2 = 196608;
    public static final int IDL_COPY_DUP2_END = 0x130000;
    public static final int IDL_COPY_MERGER = 0x130000;
    public static final int IDL_COPY_MERGER_END = 0x170000;
    public static final int IDL_COPY_SLICE = 0x170000;
    public static final int IDL_COPY_SLICE_END = 0x1B0000;
    public static final int IDL_COPY_DUPFULL = 65536;
    public static final int IDL_COPY_DUPFULL_END = 0x130000;
    public static final int IDL_COPY = 65536;
    public static final int IDL_COPY_END = 0x1B0000;
    public static final int IDL_SYMBOL = 0x800000;
    public static final int IDL_SYMBOL_END = 0x810000;
    public static final int IDL_VIRTUAL = 0x1000000;
    public static final int IDL_VIRTUAL_END = 0x2000000;
    public static final int IDL_STACKVAR = 0x2000000;
    public static final int IDL_STACKVAR_BASE = 0x40000000;
    public static final int IDL_STACKVAR_END = Integer.MAX_VALUE;
    public static final int IDL_BEGIN = 1;
    public static final int IDL_END = Integer.MAX_VALUE;

    public boolean isTypeable();

    public void copyProperties(IEVar var1);

    public ICElement generateC(IERoutineContext var1, ICMethod var2, int var3);

    public ICElement generateC(IERoutineContext var1, ICMethod var2, int var3, boolean var4);

    @Override
    public int getId();

    @Override
    public String getName();

    public Long getAddress();

    default public boolean isPhysicalRegister() {
        return this.getId() >= 0 && this.getId() < 65536;
    }

    default public boolean isVirtualRegister() {
        return this.getId() >= 65536 && this.getId() < 131072;
    }

    default public boolean isRegister() {
        return this.isPhysicalRegister() || this.isVirtualRegister();
    }

    default public boolean isGlobalVariable() {
        return this.getId() >= 0x1000000 && this.getId() < Integer.MAX_VALUE;
    }

    default public boolean isGlobalReference() {
        return this.getId() >= 131072 && this.getId() < 196608;
    }

    default public boolean isRoutineScope() {
        return this.getId() < 0;
    }

    default public boolean isPseudoVar() {
        return this.getId() == -1;
    }

    default public boolean isCopy() {
        int n2 = -this.getId();
        return n2 >= 65536 && n2 < 0x1B0000;
    }

    default public boolean isStackVariable() {
        int n2 = -this.getId();
        return n2 >= 0x2000000 && n2 < Integer.MAX_VALUE;
    }

    default public boolean isStackReference() {
        int n2 = -this.getId();
        return n2 >= 0x800000 && n2 < 0x810000;
    }

    default public boolean isReference() {
        return this.isStackReference() || this.isGlobalReference();
    }
}

