/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class FunctionOptype {
    public static final int FLAG_OPND_HAVE_SAME_BITSIZE = 1;
    public static final int FLAG_PASSTHRU_FOR_ECALL_DFA_CALCULATION = 16;
    @SerId(value=1)
    String name;
    @SerId(value=2)
    int flags;
    @SerId(value=3)
    int minOpndCount;
    @SerId(value=4)
    int maxOpndCount;
    @SerId(value=5)
    int resultBitsize;

    FunctionOptype(String string, int n2, int n3, int n4, int n5) {
        if (Strings.isBlank(string)) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n4 < n3) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 1) != 0 && n4 <= 1) {
            throw new IllegalArgumentException();
        }
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        if (n5 == 0 && n3 == 0) {
            throw new IllegalArgumentException();
        }
        this.name = string;
        this.flags = n2;
        this.minOpndCount = n3;
        this.maxOpndCount = n4;
        this.resultBitsize = n5;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasFlags(int n2) {
        return (this.flags & n2) == n2;
    }

    public int getMinOperandCount() {
        return this.minOpndCount;
    }

    public int getMaxOperandCount() {
        return this.maxOpndCount;
    }

    public int getResultBitsize(IEGeneric ... iEGenericArray) {
        if (this.resultBitsize > 0) {
            return this.resultBitsize;
        }
        if (iEGenericArray.length >= 1) {
            return iEGenericArray[0].getBitsize();
        }
        throw new IllegalArgumentException();
    }

    public void validateOperands(IEGeneric ... iEGenericArray) {
        int n2 = iEGenericArray.length;
        if (n2 < this.minOpndCount || n2 > this.maxOpndCount) {
            throw new IllegalArgumentException();
        }
        IEGeneric[] iEGenericArray2 = iEGenericArray;
        int n3 = iEGenericArray2.length;
        for (int i = 0; i < n3; ++i) {
            IEGeneric iEGeneric = iEGenericArray2[i];
            if (iEGeneric != null) continue;
            throw new IllegalArgumentException();
        }
        if (n2 >= 2 && (this.flags & 1) != 0) {
            int n4 = iEGenericArray[0].getBitsize();
            for (n3 = 1; n3 < iEGenericArray.length; ++n3) {
                if (iEGenericArray[n3].getBitsize() == n4) continue;
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

