/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.ELocation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGroupElt;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IERange;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.VarSrc;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.io.Endianness;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class EVarCopyFinder {
    private IERoutineContext ctx;
    private StorageEntry entry;
    private Collection<Integer> filters;
    private ELocation loc;
    private boolean done;
    private boolean created;
    private IEVar[] svars;

    public static IEGeneric retrieveVariableForRegister(IERoutineContext iERoutineContext, IEGeneric iEGeneric, Collection<Integer> collection, boolean bl, Long l2) {
        EVarCopyFinder eVarCopyFinder = new EVarCopyFinder(iERoutineContext, null, collection, l2);
        IEGeneric iEGeneric2 = eVarCopyFinder.retrieveVariableForRegister(iEGeneric, bl);
        return iEGeneric2;
    }

    public EVarCopyFinder(IERoutineContext iERoutineContext, StorageEntry storageEntry, Collection<Integer> collection, Long l2) {
        this.ctx = iERoutineContext;
        this.entry = storageEntry;
        this.filters = Lists.reverse(new ArrayList<Integer>(collection));
        this.loc = l2 == null ? null : new ELocation(iERoutineContext, l2);
    }

    EVarCopyFinder(IERoutineContext iERoutineContext, StorageEntry storageEntry, Set<Integer> set) {
        this(iERoutineContext, storageEntry, set, null);
    }

    private void verifyDone(boolean bl) {
        if (this.done != bl) {
            throw new IllegalStateException();
        }
    }

    private void flipDone(boolean bl) {
        this.verifyDone(bl);
        this.done = !bl;
    }

    public IEGeneric getIRForSlicedReg(boolean bl) {
        this.flipDone(false);
        IEGeneric iEGeneric = this.ctx.getConverter().getRegisterVariableFromNativeRegisterId(this.entry.getValue(), this.loc);
        if (iEGeneric != null) {
            return this.retrieveVariableForRegister(iEGeneric, bl);
        }
        return null;
    }

    public IEVar getVarForRegPair(boolean bl) {
        IEGeneric iEGeneric;
        this.flipDone(false);
        Endianness endianness = this.ctx.getGlobalContext().isBigEndian() ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
        IEGeneric iEGeneric2 = this.ctx.getConverter().getRegisterVariableFromNativeRegisterId(this.entry.getValue(endianness), this.loc);
        if (iEGeneric2 instanceof IEVar && (iEGeneric = this.ctx.getConverter().getRegisterVariableFromNativeRegisterId(this.entry.getValue2(endianness), this.loc)) instanceof IEVar) {
            return this.retrieveVariableForRegisterPair((IEVar)iEGeneric2, (IEVar)iEGeneric, bl);
        }
        return null;
    }

    private Integer getSlicedVarId(IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEVar) {
            return ((IEVar)iEGeneric).getId();
        }
        if (iEGeneric instanceof IESlice && ((IESlice)iEGeneric).getWholeExpression() instanceof IEVar) {
            return ((IEVar)((IESlice)iEGeneric).getWholeExpression()).getId();
        }
        return null;
    }

    private IEGeneric genSlicedVar(int n2, IEGeneric iEGeneric) {
        IEVar iEVar = this.ctx.getVariableById(n2);
        if (iEGeneric instanceof IEVar) {
            return iEVar;
        }
        if (iEGeneric instanceof IESlice) {
            IERange iERange = ((IESlice)iEGeneric).getRange();
            return iEVar.slice(iERange);
        }
        return null;
    }

    private IEVar copySlicedVariable(IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEVar) {
            return this.ctx.copyVariable((IEVar)iEGeneric);
        }
        IESlice iESlice = (IESlice)iEGeneric;
        if (iESlice.getBitStart() != 0) {
            throw new RuntimeException();
        }
        return this.ctx.copyTruncatedVariable((IEVar)iESlice.getWholeExpression(), iESlice.getBitEnd()).getFirst();
    }

    private IEGeneric retrieveVariableForRegister(IEGeneric iEGeneric, boolean bl) {
        Integer n2 = this.getSlicedVarId(iEGeneric);
        if (n2 == null) {
            if (iEGeneric instanceof IEGroupElt) {
                return iEGeneric;
            }
            return null;
        }
        int n3 = n2;
        if (this.filters != null) {
            Object object;
            Object object2;
            if (this.filters.contains(n3)) {
                return iEGeneric;
            }
            if (iEGeneric instanceof IESlice) {
                object2 = ((IESlice)iEGeneric).getRange();
                for (int n4 : this.filters) {
                    VarSrc varSrc = this.ctx.getSourceForVariable(n4);
                    if (varSrc == null || !varSrc.isSlice() || ((Couple)(object = varSrc.getAsSlice())).getFirst() != n3 || ((Couple)object).getSecond().getFirst().intValue() != object2.getBegin() || ((Couple)object).getSecond().getSecond().intValue() != object2.getEnd()) continue;
                    return this.ctx.getVariableById(n4);
                }
            }
            object2 = this.filters.iterator();
            while (object2.hasNext()) {
                int n5 = (Integer)object2.next();
                VarSrc varSrc = this.ctx.getSourceForVariable(n5);
                if (varSrc == null || !varSrc.containsSourceId(n3)) continue;
                if (varSrc.isDuplicate() && varSrc.getAsDuplicate() == n3) {
                    return this.genSlicedVar(n5, iEGeneric);
                }
                if (varSrc.isSlice()) {
                    if (!varSrc.isTruncated() || varSrc.getAsTruncated().getFirst() != n3) continue;
                    return this.genSlicedVar(n5, iEGeneric);
                }
                if (varSrc.isPair()) {
                    int n6 = varSrc.getAsPair().getFirst();
                    if (n6 == n3 && iEGeneric instanceof IEVar) {
                        object = this.ctx.getVariableById(n5);
                        return object.part(object.getBitsize() / 2);
                    }
                    n6 = varSrc.getAsPair().getSecond();
                    if (n6 == n3) {
                        object = this.ctx.getVariableById(n5);
                        return object.slice(object.getBitsize() / 2);
                    }
                }
                return null;
            }
        }
        if (bl) {
            this.created = true;
            return this.copySlicedVariable(iEGeneric);
        }
        return null;
    }

    private IEVar retrieveVariableForRegisterPair(IEVar iEVar, IEVar iEVar2, boolean bl) {
        if (iEVar == null || iEVar2 == null) {
            throw new IllegalArgumentException("Need 2x EVar");
        }
        if (this.filters != null) {
            IEGeneric iEGeneric;
            int n2 = iEVar.getId();
            int n3 = iEVar2.getId();
            Object object = this.filters.iterator();
            while (object.hasNext()) {
                int n4 = object.next();
                VarSrc varSrc = this.ctx.getSourceForVariable(n4);
                if (varSrc == null) continue;
                if (varSrc.isPair()) {
                    Couple<Integer, Integer> couple = varSrc.getAsPair();
                    if (couple.getFirst() != n2 || couple.getSecond() != n3) continue;
                    this.svars = new IEVar[]{iEVar, iEVar2};
                    return this.ctx.getVariableById(n4);
                }
                if (!CollectionUtil.hasIntersection(varSrc.getSourceIds(), Arrays.asList(n2, n3))) continue;
                break;
            }
            if ((object = this.retrieveVariableForRegister(iEVar, false)) != null) {
                if (object instanceof IEVar) {
                    iEVar = (IEVar)object;
                } else {
                    return null;
                }
            }
            if ((iEGeneric = this.retrieveVariableForRegister(iEVar2, false)) != null) {
                if (iEGeneric instanceof IEVar) {
                    iEVar2 = (IEVar)iEGeneric;
                } else {
                    return null;
                }
            }
        }
        if (bl) {
            this.created = true;
            this.svars = new IEVar[]{iEVar, iEVar2};
            return this.ctx.copyPairOfVariables(iEVar, iEVar2);
        }
        return null;
    }

    public boolean wasCreated() {
        this.verifyDone(true);
        return this.created;
    }

    public IEVar[] getVarsToSubstitute() {
        this.verifyDone(true);
        return this.svars;
    }

    public IEVar getVarToSubstitute(int n2) {
        return this.getVarsToSubstitute()[n2];
    }
}

