/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.CFGUtil;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableProvider;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.EvaluationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.ECFGFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EDefUseInfo;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJumpWithOptionalCondition;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IENop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESwitch;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVisitor;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardTypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jebglobal.alg;
import com.pnfsoftware.jebglobal.alj;
import com.pnfsoftware.jebglobal.alk;
import com.pnfsoftware.jebglobal.all;
import com.pnfsoftware.jebglobal.alp;
import com.pnfsoftware.jebglobal.ama;
import com.pnfsoftware.jebglobal.amg;
import com.pnfsoftware.jebglobal.amx;
import com.pnfsoftware.jebglobal.anz;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EUtil {
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);

    public static String formatStatements(List<? extends IEStatement> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (IEStatement iEStatement : list) {
            Strings.ff(stringBuilder, "%04X : %s  [LLA=%s]\n", n2, iEStatement.format(null), Longs.formatHexCollection(iEStatement.getLowerLevelAddresses()));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String formatIR(IERoutineContext iERoutineContext) {
        return EUtil.formatIR(iERoutineContext, true, true, true);
    }

    public static String formatIR(IERoutineContext iERoutineContext, boolean bl, boolean bl2, final boolean bl3) {
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        amg amg2 = (amg)iERoutineContext;
        ECFGFormatter eCFGFormatter = new ECFGFormatter(cFG, (IVariableProvider)new amx(iERoutineContext), amg2.hG());
        eCFGFormatter.setContext(iERoutineContext);
        IDFA<IEStatement> iDFA = null;
        if (bl2) {
            iDFA = cFG.doDataFlowAnalysis();
        }
        IFormattingContextFactory<IEStatement> iFormattingContextFactory = new IFormattingContextFactory<IEStatement>(){

            @Override
            public Object createFormattingContext(IEStatement iEStatement) {
                return new all(true, true, bl3);
            }
        };
        return eCFGFormatter.format(bl, bl2, bl2, iDFA, iFormattingContextFactory);
    }

    public static void dump(CFG<IEStatement> cFG, String string) {
        EUtil.dump(cFG, string, null);
    }

    public static void dump(CFG<IEStatement> cFG, String object, String object2) {
        try {
            if (object == null || ((String)object).isEmpty()) {
                throw new RuntimeException("Provide a name!");
            }
            if (!((String)object).endsWith(".dot")) {
                object = (String)object + ".dot";
            }
            if (object2 == null) {
                object2 = object;
            }
            CFGUtil.toDot(cFG, IO.createTempFile(IO.sanitizePathUnsafe((String)object)), (String)object2, null, -1);
        }
        catch (IOException iOException) {}
    }

    public static void verify(IERoutineContext iERoutineContext) {
        new alg(iERoutineContext).verify();
    }

    public static void verify(CFG<IEStatement> cFG) {
        new alg(cFG).verify();
    }

    public static boolean isPCAssign(IEStatement iEStatement) {
        IEAssign iEAssign;
        if (iEStatement instanceof IEAssign && (iEAssign = iEStatement.asAssign()).getDstOperand().isVar()) {
            IEVar iEVar = iEStatement.getContext().getProgramCounter();
            IEVar iEVar2 = iEAssign.getDstOperand().asVar();
            return iEVar2 == iEVar;
        }
        return false;
    }

    public static boolean isSPAssign(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign) {
            IEAssign iEAssign = iEStatement.asAssign();
            if (iEAssign.getDstOperand().isVar()) {
                IEVar iEVar = iEStatement.getContext().getStackPointer();
                IEVar iEVar2 = iEAssign.getDstOperand().asVar();
                return iEVar2 == iEVar;
            }
            if (iEAssign.getDstOperand().isSlice()) {
                IEVar iEVar = iEStatement.getContext().getStackPointer();
                IESlice iESlice = iEAssign.getDstOperand().asSlice();
                return iESlice.getWholeExpression() == iEVar;
            }
        }
        return false;
    }

    public static boolean isSPAssignOrPCAssign(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign) {
            IEAssign iEAssign = iEStatement.asAssign();
            if (iEAssign.getDstOperand().isVar()) {
                IEVar iEVar = iEStatement.getContext().getStackPointer();
                IEVar iEVar2 = iEStatement.getContext().getProgramCounter();
                IEVar iEVar3 = iEAssign.getDstOperand().asVar();
                return iEVar3 == iEVar || iEVar3 == iEVar2;
            }
            if (iEAssign.getDstOperand().isSlice()) {
                IEVar iEVar = iEStatement.getContext().getStackPointer();
                IESlice iESlice = iEAssign.getDstOperand().asSlice();
                return iESlice.getWholeExpression() == iEVar;
            }
        }
        return false;
    }

    public static IEImm imm(long l2, int n2) {
        return alp.ce(l2, n2);
    }

    public static IEImm imm(byte[] byArray, int n2) {
        return alp.ce(byArray, n2);
    }

    public static IEImm imm(BigInteger bigInteger, int n2) {
        return alp.ce(bigInteger, n2);
    }

    public static IEImm imm(String string, int n2) {
        return alp.ce(string, n2);
    }

    public static IEImm one(int n2) {
        return EUtil.imm(1L, n2);
    }

    public static IEImm zero(int n2) {
        return EUtil.imm(0L, n2);
    }

    public static IEImm minusOne(int n2) {
        return EUtil.imm(-1L, n2);
    }

    public static IEImm mask(int n2, int n3) {
        Assert.a(n3 <= n2);
        return EUtil.imm(-1L, n2)._shr(n2 - n3);
    }

    public static IEImm mask(int n2, int n3, int n4) {
        int n5 = n4 - n3;
        return EUtil.imm(-1L, n2)._shr(n2 - n5)._shl(n3);
    }

    @Deprecated
    public static IEGeneric compose(IEGeneric ... iEGenericArray) {
        if (iEGenericArray.length == 1) {
            return iEGenericArray[0];
        }
        return new alj(iEGenericArray);
    }

    public static IEGeneric compose(IERoutineContext iERoutineContext, IEGeneric ... iEGenericArray) {
        if (iEGenericArray.length == 1) {
            return iEGenericArray[0];
        }
        return iERoutineContext.createCompose(iEGenericArray);
    }

    public static IEGeneric compose(IERoutineContext iERoutineContext, Collection<IEGeneric> collection) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return iERoutineContext.createCompose(collection);
    }

    public static IEGeneric checkTrue(IEGeneric iEGeneric) {
        if (iEGeneric.getBitsize() == 1) {
            return iEGeneric;
        }
        return EUtil.op(OperationType.LOG_NEQ, iEGeneric, EUtil.zero(iEGeneric.getBitsize()));
    }

    public static IEGeneric checkFalse(IEGeneric iEGeneric) {
        if (iEGeneric.getBitsize() == 1) {
            return EUtil.op(OperationType.LOG_NOT, iEGeneric);
        }
        return EUtil.op(OperationType.LOG_EQ, iEGeneric, EUtil.zero(iEGeneric.getBitsize()));
    }

    public static boolean isOperation(IEGeneric iEGeneric, OperationType operationType) {
        return iEGeneric instanceof IEOperation && iEGeneric.asOperation().getOperationType() == operationType;
    }

    public static boolean isOperation(IEGeneric iEGeneric, OperationType ... operationTypeArray) {
        return EUtil.getOperation(iEGeneric, operationTypeArray) != null;
    }

    public static boolean isLogicalOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isStrictLogicalOperation(iEGeneric.asOperation()) || EUtil.isComparableOperation(iEGeneric.asOperation());
    }

    public static boolean isComparableOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isComparableOperation(iEGeneric.asOperation());
    }

    public static boolean isComparableOperation(IEOperation iEOperation) {
        return EUtil.isComparableOperation(iEOperation, true, true);
    }

    public static boolean isComparableIntegerOperation(IEOperation iEOperation) {
        return EUtil.isComparableOperation(iEOperation, true, false);
    }

    public static boolean isComparableSignedOperation(IEOperation iEOperation) {
        return EUtil.isComparableOperation(iEOperation, false, false);
    }

    public static boolean isComparableOperation(IEOperation iEOperation, boolean bl, boolean bl2) {
        OperationType operationType = iEOperation.getOperationType();
        switch (operationType) {
            case LOG_EQ: 
            case LOG_NEQ: 
            case GE_S: 
            case GT_S: 
            case LE_S: 
            case LT_S: {
                return true;
            }
            case GE_U: 
            case GT_U: 
            case LE_U: 
            case LT_U: {
                return bl;
            }
            case FEQ: 
            case FNE: 
            case FGE: 
            case FGT: 
            case FLE: 
            case FLT: {
                return bl2;
            }
        }
        return false;
    }

    public static boolean isStrictLogicalOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isStrictLogicalOperation(iEGeneric.asOperation());
    }

    public static boolean isStrictLogicalOperation(IEOperation iEOperation) {
        OperationType operationType = iEOperation.getOperationType();
        return operationType.isAnyOf(OperationType.LOG_AND, OperationType.LOG_NOT, OperationType.LOG_OR);
    }

    public static OperationType getOperation(IEGeneric iEGeneric, OperationType ... operationTypeArray) {
        return iEGeneric instanceof IEOperation ? EUtil.getOperation(iEGeneric.asOperation(), operationTypeArray) : null;
    }

    public static OperationType getOperation(IEOperation iEOperation, OperationType ... operationTypeArray) {
        OperationType operationType = iEOperation.getOperationType();
        for (OperationType operationType2 : operationTypeArray) {
            if (operationType2 != operationType) continue;
            return operationType;
        }
        return null;
    }

    public static boolean isOperationSize(IEGeneric iEGeneric, int n2) {
        return iEGeneric instanceof IEOperation && iEGeneric.asOperation().getBitsize() == n2;
    }

    public static OperationType getReverseOperation(OperationType operationType) {
        if (operationType == null) {
            return null;
        }
        switch (operationType) {
            case LOG_EQ: {
                return OperationType.LOG_NEQ;
            }
            case LOG_NEQ: {
                return OperationType.LOG_EQ;
            }
            case GE_S: {
                return OperationType.LT_S;
            }
            case GE_U: {
                return OperationType.LT_U;
            }
            case GT_S: {
                return OperationType.LE_S;
            }
            case GT_U: {
                return OperationType.LE_U;
            }
            case LE_S: {
                return OperationType.GT_S;
            }
            case LE_U: {
                return OperationType.GT_U;
            }
            case LT_S: {
                return OperationType.GE_S;
            }
            case LT_U: {
                return OperationType.GE_U;
            }
            case FEQ: {
                return OperationType.FNE;
            }
            case FNE: {
                return OperationType.FEQ;
            }
            case FLT: {
                return OperationType.FGE;
            }
            case FGT: {
                return OperationType.FLE;
            }
            case FLE: {
                return OperationType.FGT;
            }
            case FGE: {
                return OperationType.FLT;
            }
        }
        return null;
    }

    public static OperationType getMirrorOperation(OperationType operationType) {
        if (operationType == null) {
            return null;
        }
        switch (operationType) {
            case LOG_EQ: {
                return OperationType.LOG_EQ;
            }
            case LOG_NEQ: {
                return OperationType.LOG_NEQ;
            }
            case GE_S: {
                return OperationType.LE_S;
            }
            case GE_U: {
                return OperationType.LE_U;
            }
            case GT_S: {
                return OperationType.LT_S;
            }
            case GT_U: {
                return OperationType.LT_U;
            }
            case LE_S: {
                return OperationType.GE_S;
            }
            case LE_U: {
                return OperationType.GE_U;
            }
            case LT_S: {
                return OperationType.GT_S;
            }
            case LT_U: {
                return OperationType.GT_U;
            }
            case FEQ: {
                return OperationType.FEQ;
            }
            case FNE: {
                return OperationType.FNE;
            }
            case FLT: {
                return OperationType.FGT;
            }
            case FGT: {
                return OperationType.FLT;
            }
            case FLE: {
                return OperationType.FGE;
            }
            case FGE: {
                return OperationType.FLE;
            }
        }
        return null;
    }

    public static boolean isVar(IEGeneric iEGeneric, int n2) {
        return iEGeneric instanceof IEVar && iEGeneric.asVar().getId() == n2;
    }

    public static boolean isVarOrVarSlice(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEVar || iEGeneric instanceof IESlice && iEGeneric.asSlice().getWholeExpression().isVar();
    }

    public static IEVar getVarSlice(IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEVar) {
            return iEGeneric.asVar();
        }
        if (iEGeneric instanceof IESlice && iEGeneric.asSlice().getWholeExpression().isVar()) {
            return iEGeneric.asSlice().getWholeExpression().asVar();
        }
        return null;
    }

    public static Integer getVarSliceId(IEGeneric iEGeneric) {
        IEVar iEVar = EUtil.getVarSlice(iEGeneric);
        return iEVar == null ? null : Integer.valueOf(iEVar.getId());
    }

    public static boolean isZero(IEGeneric iEGeneric) {
        return EUtil.isImmZero(iEGeneric) || iEGeneric instanceof IESlice && EUtil.isImmZero(iEGeneric.asSlice().getWholeExpression());
    }

    public static boolean isOne(IEGeneric iEGeneric) {
        return EUtil.isImmValue(iEGeneric, BigInteger.ONE);
    }

    public static boolean isMinusOne(IEGeneric iEGeneric) {
        return EUtil.isImmValue(iEGeneric, MINUS_ONE);
    }

    public static boolean isBitOne(IEGeneric iEGeneric) {
        return iEGeneric.getBitsize() == 1 && iEGeneric instanceof IEImm && iEGeneric.asImm().getValue().longValue() == -1L;
    }

    public static boolean isBitZero(IEGeneric iEGeneric) {
        return iEGeneric.getBitsize() == 1 && iEGeneric instanceof IEImm && iEGeneric.asImm().getValue().longValue() == 0L;
    }

    public static boolean isImmSize(IEGeneric iEGeneric, int n2) {
        return iEGeneric instanceof IEImm && iEGeneric.asImm().getBitsize() == n2;
    }

    public static boolean isImmValue(IEGeneric iEGeneric, long l2) {
        return EUtil.isImmValue(iEGeneric, BigInteger.valueOf(l2));
    }

    public static boolean isImmValue(IEGeneric iEGeneric, BigInteger bigInteger) {
        return iEGeneric instanceof IEImm && iEGeneric.asImm().getValue().equals(bigInteger);
    }

    public static boolean isImmZero(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEImm && iEGeneric.asImm()._signum() == 0;
    }

    public static boolean isImmNonZero(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEImm && iEGeneric.asImm()._signum() != 0;
    }

    public static boolean isCondEAssign(IEStatement iEStatement) {
        return iEStatement instanceof IEAssign && iEStatement.asAssign().getSrcOperand() instanceof IECond;
    }

    public static boolean isJump(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEJump;
    }

    public static boolean isUnconditionalJump(IEStatement iEStatement) {
        return iEStatement instanceof IEJump && iEStatement.asJump().getCondition() == null;
    }

    public static boolean isConditionalJump(IEStatement iEStatement) {
        return iEStatement instanceof IEJump && iEStatement.asJump().getCondition() != null;
    }

    public static void makeUncond(IEJumpWithOptionalCondition iEJumpWithOptionalCondition) {
        if (EUtil.containsUndeterminedInvocations(iEJumpWithOptionalCondition.getCondition())) {
            throw new RuntimeException("Tried to remove an EJump condition containing undetermined calls");
        }
        iEJumpWithOptionalCondition.setCondition(null);
    }

    public static boolean isAssignedIn(BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric) {
        boolean bl = false;
        for (IEStatement iEStatement : basicBlock) {
            if (!iEStatement.isAssign() || !iEGeneric.equals(iEStatement.asAssign().getLeftOperand())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static List<IEGeneric> getSubExpressions(IEGeneric iEGeneric) {
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        return arrayList;
    }

    public static int countSubExpressions(IEGeneric iEGeneric) {
        return EUtil.getSubExpressions(iEGeneric).size();
    }

    public static int sameBitsize(IEGeneric ... iEGenericArray) {
        int n2 = 0;
        for (IEGeneric iEGeneric : iEGenericArray) {
            if (iEGeneric == null) {
                return 0;
            }
            if (n2 == 0) {
                n2 = iEGeneric.getBitsize();
                continue;
            }
            if (n2 == iEGeneric.getBitsize()) continue;
            return 0;
        }
        return n2;
    }

    public static int sameBitsizeAllowNulls(IEGeneric ... iEGenericArray) {
        int n2 = 0;
        for (IEGeneric iEGeneric : iEGenericArray) {
            if (iEGeneric == null) continue;
            if (n2 == 0) {
                n2 = iEGeneric.getBitsize();
                continue;
            }
            if (n2 == iEGeneric.getBitsize()) continue;
            return 0;
        }
        return n2;
    }

    public static int countVariableUse(IEGeneric iEGeneric) {
        return iEGeneric.getUsed().size();
    }

    public static int calculateComplexity(IEGeneric iEGeneric) {
        int n2 = 1;
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        for (IEGeneric iEGeneric2 : arrayList) {
            n2 += EUtil.calculateComplexity(iEGeneric2);
        }
        return n2;
    }

    public static int countVariablePresence(IEGeneric iEGeneric, IEVar iEVar) {
        if (iEGeneric == iEVar) {
            return 1;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        int n2 = 0;
        for (IEGeneric iEGeneric2 : arrayList) {
            n2 += EUtil.countVariablePresence(iEGeneric2, iEVar);
        }
        return n2;
    }

    public static int countExpressionPresence(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        int n2 = 0;
        if (iEGeneric2.equals(iEGeneric)) {
            ++n2;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        for (IEGeneric iEGeneric3 : arrayList) {
            n2 += EUtil.countExpressionPresence(iEGeneric3, iEGeneric2);
        }
        return n2;
    }

    public static void countExpressionsPresence(IEGeneric iEGeneric, List<IEGeneric> list, int[] nArray) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(iEGeneric)) continue;
            int n2 = i;
            nArray[n2] = nArray[n2] + 1;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        for (IEGeneric iEGeneric2 : arrayList) {
            EUtil.countExpressionsPresence(iEGeneric2, list, nArray);
        }
    }

    public static Set<Integer> getUsedVarIds(IEGeneric iEGeneric) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        iEGeneric.getUsed().collectVarIds(hashSet);
        return hashSet;
    }

    public static Set<IEVar> collectVars(IEGeneric iEGeneric) {
        HashSet<IEVar> hashSet = new HashSet<IEVar>();
        EUtil.collectVars(iEGeneric, hashSet);
        return hashSet;
    }

    public static void collectVars(IEGeneric iEGeneric, Collection<IEVar> collection) {
        if (iEGeneric instanceof IEVar) {
            collection.add(iEGeneric.asVar());
            return;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.collectSubExpressions(arrayList);
        for (IEGeneric iEGeneric2 : arrayList) {
            EUtil.collectVars(iEGeneric2, collection);
        }
    }

    public static boolean hasExplicitlyUsedVar(IEGeneric iEGeneric, IEVar iEVar) {
        EDefUseInfo eDefUseInfo = new EDefUseInfo();
        iEGeneric.getExplicitlyUsed(eDefUseInfo);
        return eDefUseInfo.getUse().containsVarPart(iEVar);
    }

    public static boolean isTrampoline(BasicBlock<IEStatement> basicBlock) {
        if (basicBlock.outsize() != 1) {
            return false;
        }
        for (int i = 0; i < basicBlock.size() - 1; ++i) {
            if (basicBlock.get(i) instanceof IENop) continue;
            return false;
        }
        AddressableInstruction<IEStatement> addressableInstruction = basicBlock.getLast2();
        return addressableInstruction.getBreakingFlow().isBroken() || addressableInstruction.getInstruction().isNop();
    }

    public static IEGeneric reversePredicate(IEGeneric iEGeneric) {
        return EUtil.op(OperationType.LOG_NOT, iEGeneric);
    }

    public static boolean containsUndeterminedInvocations(IEGeneric iEGeneric) {
        return !iEGeneric.visitDepthPre(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric2, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric instanceof IECall || iEGeneric instanceof IEJumpFar || iEGeneric instanceof IEUntranslatedInstruction) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static boolean containsMemoryAccess(IEGeneric iEGeneric) {
        return !iEGeneric.visitDepthPre(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric2, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric.isMem()) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static boolean contains(IEGeneric iEGeneric, final IEGeneric iEGeneric2) {
        return !iEGeneric.visitDepthPre(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric22, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric.equals(iEGeneric2)) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static IEOperation buildStrictLogicalOperation(IEOperation iEOperation) {
        if (!EUtil.isStrictLogicalOperation(iEOperation)) {
            return iEOperation;
        }
        return EUtil.buildLogicalOperation(iEOperation);
    }

    public static IEOperation buildLogicalOperation(IEOperation iEOperation) {
        boolean bl = false;
        IEGeneric iEGeneric = iEOperation.getOperand1();
        IEGeneric iEGeneric2 = iEOperation.getOperand2();
        if (!EUtil.isLogicalOperation(iEGeneric)) {
            iEGeneric = EUtil.ne(iEGeneric, EUtil.zero(iEGeneric.getBitsize()));
            bl = true;
        }
        if (iEGeneric2 != null && !EUtil.isLogicalOperation(iEGeneric2)) {
            iEGeneric2 = EUtil.ne(iEGeneric2, EUtil.zero(iEGeneric2.getBitsize()));
            bl = true;
        }
        if (bl) {
            return EUtil.op(iEOperation.getOperationType(), iEGeneric, iEGeneric2);
        }
        return iEOperation;
    }

    public static IECond buildStrictLogicalECond(IECond iECond) {
        IEGeneric iEGeneric = iECond.getCondition();
        if (!EUtil.isLogicalOperation(iEGeneric)) {
            return new alk(EUtil.ne(iEGeneric, EUtil.zero(iEGeneric.getBitsize())), iECond.getExpressionTrue(), iECond.getExpressionFalse());
        }
        return iECond;
    }

    public static IEOperation op(OperationType operationType, IEGeneric iEGeneric) {
        return new ama(operationType, iEGeneric);
    }

    public static IEOperation op(OperationType operationType, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new ama(operationType, iEGeneric, iEGeneric2);
    }

    public static IEOperation ltS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LT_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation leS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LE_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation gtS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.GT_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation geS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.GE_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation ltU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LT_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation leU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LE_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation gtU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.GT_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation geU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.GE_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation eq(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LOG_EQ, iEGeneric, iEGeneric2);
    }

    public static IEOperation ne(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LOG_NEQ, iEGeneric, iEGeneric2);
    }

    public static IEOperation andL(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LOG_AND, iEGeneric, iEGeneric2);
    }

    public static IEOperation orL(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.LOG_OR, iEGeneric, iEGeneric2);
    }

    public static IEGeneric notL(IEGeneric iEGeneric) {
        return EUtil.notL(iEGeneric, true);
    }

    public static IEGeneric notL(IEGeneric iEGeneric, boolean bl) {
        if (bl && iEGeneric instanceof IEOperation) {
            OperationType operationType = iEGeneric.asOperation().getOperationType();
            if (operationType == OperationType.LOG_NOT) {
                return iEGeneric.asOperation().getOperand1();
            }
            OperationType operationType2 = EUtil.getReverseOperation(operationType);
            if (operationType2 != null) {
                return EUtil.op(operationType2, iEGeneric.asOperation().getOperand1(), iEGeneric.asOperation().getOperand2());
            }
        }
        return EUtil.op(OperationType.LOG_NOT, iEGeneric);
    }

    public static IEGeneric identL(IEGeneric iEGeneric) {
        if (EUtil.isImmZero(iEGeneric)) {
            return EUtil.zero(1);
        }
        if (EUtil.isImmNonZero(iEGeneric)) {
            return EUtil.one(1);
        }
        if (iEGeneric instanceof IEOperation && iEGeneric.asOperation().getOperationType() == OperationType.LOG_NOT) {
            IEGeneric iEGeneric2 = iEGeneric.asOperation().getOperand1();
            return EUtil.op(OperationType.LOG_EQ, iEGeneric2, EUtil.zero(iEGeneric2.getBitsize()));
        }
        return EUtil.op(OperationType.LOG_NEQ, iEGeneric, EUtil.zero(iEGeneric.getBitsize()));
    }

    public static IEOperation andB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.AND, iEGeneric, iEGeneric2);
    }

    public static IEOperation orB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.OR, iEGeneric, iEGeneric2);
    }

    public static IEOperation xorB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.XOR, iEGeneric, iEGeneric2);
    }

    public static IEGeneric notB(IEGeneric iEGeneric) {
        if (EUtil.isOperation(iEGeneric, OperationType.NOT)) {
            return iEGeneric.asOperation().getOperand1();
        }
        return EUtil.op(OperationType.NOT, iEGeneric);
    }

    public static IEOperation add(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.ADD, iEGeneric, iEGeneric2);
    }

    public static IEOperation add(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        return EUtil.add(EUtil.add(iEGeneric, iEGeneric2), iEGeneric3);
    }

    public static IEOperation sub(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.SUB, iEGeneric, iEGeneric2);
    }

    public static IEOperation mul(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.MUL, iEGeneric, iEGeneric2);
    }

    public static IEOperation div(IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean bl) {
        return bl ? EUtil.divS(iEGeneric, iEGeneric2) : EUtil.divU(iEGeneric, iEGeneric2);
    }

    public static IEOperation divS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.DIV_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation divU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.DIV_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation remS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.REM_S, iEGeneric, iEGeneric2);
    }

    public static IEOperation remU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.REM_U, iEGeneric, iEGeneric2);
    }

    public static IEOperation shl(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.SHL, iEGeneric, iEGeneric2);
    }

    public static IEOperation shr(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.SHR, iEGeneric, iEGeneric2);
    }

    public static IEOperation sar(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.SAR, iEGeneric, iEGeneric2);
    }

    public static IEOperation pow(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.op(OperationType.POW, iEGeneric, iEGeneric2);
    }

    public static IECond min(IERoutineContext iERoutineContext, IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean bl) {
        return iERoutineContext.createCond(iERoutineContext.createOperation(bl ? OperationType.GT_S : OperationType.GT_U, iEGeneric, iEGeneric2), iEGeneric2, iEGeneric);
    }

    public static IECond max(IERoutineContext iERoutineContext, IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean bl) {
        return iERoutineContext.createCond(iERoutineContext.createOperation(bl ? OperationType.GT_S : OperationType.GT_U, iEGeneric, iEGeneric2), iEGeneric, iEGeneric2);
    }

    public static IECond abs(IERoutineContext iERoutineContext, IEGeneric iEGeneric) {
        IEImm iEImm = iERoutineContext.createImm(0L, iEGeneric.getBitsize());
        return iERoutineContext.createCond(iERoutineContext.createOperation(OperationType.LT_S, iEGeneric, (IEGeneric)iEImm), EUtil.sub(iEImm, iEGeneric), iEGeneric);
    }

    public static IECond fmin(IERoutineContext iERoutineContext, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return iERoutineContext.createCond(iERoutineContext.createOperation(OperationType.FGT, iEGeneric, iEGeneric2), iEGeneric2, iEGeneric);
    }

    public static IECond fmax(IERoutineContext iERoutineContext, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return iERoutineContext.createCond(iERoutineContext.createOperation(OperationType.FGT, iEGeneric, iEGeneric2), iEGeneric, iEGeneric2);
    }

    public static IECond fabs(IERoutineContext iERoutineContext, IEGeneric iEGeneric) {
        IEImm iEImm = iERoutineContext.createImm(0L, iEGeneric.getBitsize());
        return iERoutineContext.createCond(iERoutineContext.createOperation(OperationType.FLT, iEGeneric, (IEGeneric)iEImm), EUtil.op(OperationType.FSUB, iEImm, iEGeneric), iEGeneric);
    }

    public static IEGeneric extend(IEGeneric iEGeneric, int n2, boolean bl) {
        if (iEGeneric == null) {
            return null;
        }
        return bl ? iEGeneric.signExtend(n2) : iEGeneric.zeroExtend(n2);
    }

    public static IEGeneric safeExtend(IEGeneric iEGeneric, int n2, boolean bl) {
        if (iEGeneric == null) {
            return null;
        }
        if (n2 == iEGeneric.getBitsize()) {
            return iEGeneric;
        }
        if (n2 < iEGeneric.getBitsize()) {
            return iEGeneric.part(n2);
        }
        return bl ? iEGeneric.signExtend(n2) : iEGeneric.zeroExtend(n2);
    }

    public static boolean isNotPredicate(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric instanceof IEOperation && iEGeneric2 instanceof IEOperation) {
            IEOperation iEOperation = iEGeneric.asOperation();
            IEOperation iEOperation2 = iEGeneric2.asOperation();
            OperationType operationType = iEOperation.getOperationType();
            OperationType operationType2 = EUtil.getReverseOperation(operationType);
            if (operationType2 == null) {
                return false;
            }
            if (operationType2 == iEOperation2.getOperationType() && iEOperation.getOperand1().equals(iEOperation2.getOperand1()) && iEOperation.getOperand2().equals(iEOperation2.getOperand2())) {
                return true;
            }
            if ((operationType2 = EUtil.getMirrorOperation(operationType2)) != null && operationType2 == iEOperation2.getOperationType() && iEOperation.getOperand1().equals(iEOperation2.getOperand2()) && iEOperation.getOperand2().equals(iEOperation2.getOperand1())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFirstBit(IESlice iESlice) {
        return iESlice.getBitsize() == 1 && iESlice.getBitStart() == 0;
    }

    public static boolean isLastBit(IESlice iESlice) {
        return iESlice.getBitsize() == 1 && iESlice.getBitEnd() == iESlice.getWholeExpression().getBitsize();
    }

    public static boolean isNBit(IESlice iESlice, int n2) {
        return iESlice.getBitsize() == 1 && iESlice.getBitStart() == n2;
    }

    private static int getFloatingExponentSize(int n2) {
        switch (n2) {
            case 16: {
                return 5;
            }
            case 32: {
                return 8;
            }
            case 64: {
                return 11;
            }
            case 128: {
                return 15;
            }
            case 256: {
                return 19;
            }
        }
        throw new RuntimeException("Illegal Bitsize for float: " + n2);
    }

    public static IEGeneric isNaN(IEGeneric iEGeneric) {
        int n2 = EUtil.getFloatingExponentSize(iEGeneric.getBitsize());
        int n3 = iEGeneric.getBitsize() - n2 - 1;
        return EUtil.andL(EUtil.eq(iEGeneric.slice(n3, n3 + n2), EUtil.imm(MathUtil.makeMask(n2), n2)), EUtil.ne(iEGeneric.part(n3), EUtil.imm(0L, n3)));
    }

    @Deprecated
    public static IEGeneric ltFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.ltS(iEGeneric, iEGeneric2));
    }

    @Deprecated
    public static IEGeneric gtFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.gtS(iEGeneric, iEGeneric2));
    }

    @Deprecated
    public static IEGeneric eqFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.eq(iEGeneric.part(iEGeneric.getBitsize() - 1), iEGeneric2.part(iEGeneric2.getBitsize() - 1)));
    }

    public static IEGeneric cmpFloat(OperationType operationType, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.op(operationType, iEGeneric, iEGeneric2));
    }

    public static IEOperation createResizeOperation(IEGeneric iEGeneric, int n2, boolean bl) {
        return ama.ce(iEGeneric, n2, bl);
    }

    public static IEOperation createConversionOperation(OperationType operationType, IEGeneric iEGeneric, int n2) {
        return ama.ce(operationType, iEGeneric, n2);
    }

    public static IEGeneric truncate(IEGeneric iEGeneric, int n2) {
        if (n2 > iEGeneric.getBitsize()) {
            throw new IllegalArgumentException();
        }
        if (n2 == iEGeneric.getBitsize()) {
            return iEGeneric;
        }
        return EUtil.createResizeOperation(iEGeneric, n2, false);
    }

    public static IEGeneric zeroExt(IEGeneric iEGeneric, int n2) {
        if (n2 < iEGeneric.getBitsize()) {
            throw new IllegalArgumentException();
        }
        if (n2 == iEGeneric.getBitsize()) {
            return iEGeneric;
        }
        return EUtil.createResizeOperation(iEGeneric, n2, false);
    }

    public static IEGeneric signExt(IEGeneric iEGeneric, int n2) {
        if (n2 < iEGeneric.getBitsize()) {
            throw new IllegalArgumentException();
        }
        if (n2 == iEGeneric.getBitsize()) {
            return iEGeneric;
        }
        return EUtil.createResizeOperation(iEGeneric, n2, true);
    }

    public static boolean looksLikeSignExtension(IECompose iECompose) {
        return EUtil.getSignExtensionBase(iECompose) != null;
    }

    public static IEGeneric getSignExtensionBase(IEGeneric iEGeneric) {
        return iEGeneric instanceof IECompose ? EUtil.getSignExtensionBase(iEGeneric.asCompose()) : null;
    }

    public static IEGeneric getSignExtensionBase(IECompose iECompose) {
        return iECompose.getPartsCount() == 2 ? EUtil.getSignExtensionBase(iECompose.getLowPart(), iECompose.getHighPart()) : null;
    }

    public static IEGeneric getSignExtensionBase(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric2 instanceof IECond) {
            IEGeneric iEGeneric3 = iEGeneric2.asCond().getCondition();
            IEGeneric iEGeneric4 = iEGeneric2.asCond().getExpressionTrue();
            IEGeneric iEGeneric5 = iEGeneric2.asCond().getExpressionFalse();
            if (EUtil.isImmValue(iEGeneric4, -1L) && EUtil.isImmZero(iEGeneric5) && iEGeneric3 instanceof IESlice && EUtil.isNBit((IESlice)iEGeneric3, iEGeneric.getBitsize() - 1) && EUtil.isWholeExpressionOf((IESlice)iEGeneric3, iEGeneric)) {
                return iEGeneric;
            }
        }
        return null;
    }

    private static boolean isWholeExpressionOf(IESlice iESlice, IEGeneric iEGeneric) {
        if (iESlice.getWholeExpression().equals(iEGeneric)) {
            return true;
        }
        if (iEGeneric instanceof IESlice) {
            IESlice iESlice2 = iEGeneric.asSlice();
            return iESlice2.getBitStart() == 0 && iESlice.getWholeExpression().equals(iESlice2.getWholeExpression());
        }
        return false;
    }

    public static boolean isZeroExtend(IEGeneric iEGeneric) {
        return iEGeneric instanceof IECompose && EUtil.isZeroExtend(iEGeneric.asCompose());
    }

    public static boolean isZeroExtend(IECompose iECompose) {
        return iECompose.getPartsCount() == 2 && EUtil.isZero(iECompose.getHighPart());
    }

    public static IEGeneric buildCarryFlag(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                return EUtil.op(OperationType.CARRY, iEGeneric, iEGeneric2);
            }
            return EUtil.ltU(iEGeneric, iEGeneric2);
        }
        IEOperation iEOperation = EUtil.xorB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate()), iEGeneric3.duplicate());
        IEOperation iEOperation2 = EUtil.xorB(iEGeneric.duplicate(), iEGeneric3.duplicate());
        IEGeneric iEGeneric4 = bl ? EUtil.notB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate())) : EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate());
        IEOperation iEOperation3 = EUtil.xorB(iEOperation, EUtil.andB(iEOperation2, iEGeneric4));
        return iEOperation3.msb();
    }

    public static IEGeneric buildOverflowFlag(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3, boolean bl) {
        IEOperation iEOperation = EUtil.xorB(iEGeneric.duplicate(), iEGeneric3.duplicate());
        IEGeneric iEGeneric4 = bl ? EUtil.notB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate())) : EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate());
        IEOperation iEOperation2 = EUtil.andB(iEOperation, iEGeneric4);
        return iEOperation2.msb();
    }

    public static boolean isLongImmediate(IEGeneric iEGeneric) {
        return EUtil.isLongImmediate(iEGeneric, false);
    }

    public static boolean isLongImmediate(IEGeneric iEGeneric, boolean bl) {
        if (!(iEGeneric instanceof IEImm)) {
            return false;
        }
        if (bl) {
            return iEGeneric.asImm().canReadAsUnsignedLong();
        }
        return iEGeneric.asImm().canReadAsLong();
    }

    public static boolean isLikeLongImmediate(IEGeneric iEGeneric) {
        return EUtil.isLikeLongImmediate(iEGeneric, false);
    }

    public static boolean isLikeLongImmediate(IEGeneric iEGeneric, boolean bl) {
        return EUtil.isLongImmediate(iEGeneric, bl) || EUtil.isEComposeLongImm(iEGeneric, bl) || EUtil.isESliceLongImm(iEGeneric, bl);
    }

    private static boolean isESliceLongImm(IEGeneric iEGeneric, boolean bl) {
        return iEGeneric instanceof IESlice && EUtil.isLikeLongImmediate(iEGeneric.asSlice().getWholeExpression(), bl);
    }

    private static boolean isEComposeLongImm(IEGeneric iEGeneric, boolean bl) {
        if (!(iEGeneric instanceof IECompose)) {
            return false;
        }
        for (IEGeneric iEGeneric2 : iEGeneric.asCompose()) {
            if (EUtil.isLikeLongImmediate(iEGeneric2, bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean isImmediate(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEImm;
    }

    public static boolean isLikeImmediate(IEGeneric iEGeneric) {
        return EUtil.isImmediate(iEGeneric) || EUtil.isEComposeImm(iEGeneric) || EUtil.isESliceImm(iEGeneric);
    }

    private static boolean isESliceImm(IEGeneric iEGeneric) {
        return iEGeneric instanceof IESlice && EUtil.isLikeImmediate(iEGeneric.asSlice().getWholeExpression());
    }

    private static boolean isEComposeImm(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IECompose)) {
            return false;
        }
        for (IEGeneric iEGeneric2 : iEGeneric.asCompose()) {
            if (EUtil.isLikeImmediate(iEGeneric2)) continue;
            return false;
        }
        return true;
    }

    public static List<IEGeneric> getParents(IEGeneric iEGeneric, final IEGeneric iEGeneric2) {
        final ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.visitDepthPre(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric22, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric == iEGeneric2) {
                    arrayList.add(iEGeneric22);
                    iVisitResults.skipChildren();
                }
            }
        });
        return arrayList;
    }

    public static int evalAsSaturatedPositiveInt(IEImm iEImm) {
        long l2 = iEImm.getValueAsUnsignedLong();
        if (l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        return Integer.MAX_VALUE;
    }

    public static int evalAsPositiveInt(IEImm iEImm) {
        return (int)(iEImm.getValueAsLong() & Integer.MAX_VALUE);
    }

    public static IEImm evaluate_preVerified(IEGeneric iEGeneric, EState eState) {
        try {
            return iEGeneric.evaluate(eState);
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static IEImm evaluate_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluate_preVerified(iEGeneric, null);
    }

    public static long evaluateUnsignedLong_preVerified(IEGeneric iEGeneric, EState eState) {
        try {
            return iEGeneric.evaluate(eState).getValueAsUnsignedLong();
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static long evaluateUnsignedLong_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluateUnsignedLong_preVerified(iEGeneric, null);
    }

    public static long evaluateAddress_preVerified(IEGeneric iEGeneric, EState eState) {
        try {
            return iEGeneric.evaluate(eState).getValueAsAddress();
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static long evaluateAddress_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluateAddress_preVerified(iEGeneric, null);
    }

    public static IEGeneric replaceSubExpressionRecursive(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        return EUtil.replaceSubExpressionRecursive(iEGeneric, iEGeneric2, iEGeneric3, null);
    }

    public static IEGeneric replaceSubExpressionRecursive(IEGeneric iEGeneric, final IEGeneric iEGeneric2, final IEGeneric iEGeneric3, EVisitResults eVisitResults) {
        if (iEGeneric.equals(iEGeneric2)) {
            return iEGeneric3;
        }
        if (eVisitResults == null) {
            eVisitResults = new EVisitResults();
        }
        iEGeneric.visitDepthPost(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric22, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric2.equals(iEGeneric)) {
                    iEGeneric22.replaceSubExpression(iEGeneric, iEGeneric3.duplicate());
                    iVisitResults.setVisitResult(false);
                }
            }
        }, null, eVisitResults);
        return iEGeneric;
    }

    public static boolean resolveExpressionsBackward(Object object, IEConverter<?> iEConverter, List<IEStatement> list, IEGeneric ... iEGenericArray) {
        if (list.size() == 0) {
            return true;
        }
        if (iEGenericArray == null) {
            return false;
        }
        for (int i = 0; i < iEGenericArray.length; ++i) {
            int n2 = list.size() - 1;
            if (list.get(n2) instanceof IEJump || list.get(n2) instanceof IEJumpFar) {
                // empty if block
            }
            for (int j = --n2; j >= 0; --j) {
                IEStatement iEStatement = list.get(j);
                if (iEStatement instanceof IENop) continue;
                if (iEStatement instanceof IEUntranslatedInstruction) {
                    if (!EUtil.isExpressionModified(iEStatement, iEGenericArray[i], true)) continue;
                    return false;
                }
                if (!(iEStatement instanceof IEAssign)) {
                    return false;
                }
                IEAssign iEAssign = iEStatement.asAssign();
                if (!iEAssign.getLeftOperand().isVar()) {
                    iEGenericArray[i] = EUtil.replaceSubExpressionRecursive(iEGenericArray[i], iEAssign.getLeftOperand(), iEAssign.getRightOperand().duplicate());
                    if (!EUtil.isExpressionModified(iEStatement, iEGenericArray[i], false)) continue;
                    return false;
                }
                IEGeneric iEGeneric = iEAssign.getRightOperand();
                if (iEGenericArray[i].equals(iEAssign.getLeftOperand())) {
                    iEGenericArray[i] = iEGeneric;
                    continue;
                }
                if (iEConverter.getStackPointer().equals(iEAssign.getLeftOperand())) {
                    List<Integer> list2 = iEGenericArray[i].getUsed().getVarIds();
                    for (int n3 : list2) {
                        if (iEConverter.getStackPointer().getId() != n3) continue;
                        return false;
                    }
                }
                iEGenericArray[i].replaceVar(iEAssign.getLeftOperand().asVar(), iEGeneric.duplicate());
            }
        }
        return true;
    }

    public static boolean isExpressionModified(IEStatement iEStatement, IEGeneric iEGeneric, boolean bl) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            iEStatement.getDefUse(arrayList, arrayList2, null);
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return false;
            }
            List<Integer> list = iEGeneric.getUsed().getVarIds();
            for (int n2 : list) {
                if (arrayList.contains(n2)) {
                    return true;
                }
                if (!bl || !arrayList2.contains(n2)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isMatchDuaryOperation(IEGeneric iEGeneric, OperationType operationType, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        IEGeneric iEGeneric4;
        IEGeneric iEGeneric5;
        return EUtil.isOperation(iEGeneric, operationType) && ((iEGeneric5 = iEGeneric.asOperation().getOperand1()) == null && iEGeneric2 == null || iEGeneric5 != null && iEGeneric5.equals(iEGeneric2)) && ((iEGeneric4 = iEGeneric.asOperation().getOperand2()) == null && iEGeneric3 == null || iEGeneric4 != null && iEGeneric4.equals(iEGeneric3));
    }

    public static IEMem getAssigningToMemory(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign && iEStatement.asAssign().getDstOperand().isMem()) {
            return iEStatement.asAssign().getDstOperand().asMem();
        }
        return null;
    }

    public static IEMem getAssigningFromMemory(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign && iEStatement.asAssign().getSrcOperand().isMem()) {
            return iEStatement.asAssign().getSrcOperand().asMem();
        }
        return null;
    }

    public static boolean hasLinearControlFlow(IERoutineContext iERoutineContext) {
        for (BasicBlock<IEStatement> basicBlock : iERoutineContext.getCfg().getBlocks()) {
            if (basicBlock.allinsize() <= 1 && basicBlock.alloutsize() <= 1) continue;
            return false;
        }
        return true;
    }

    public static List<IEVar> getVars(IERoutineContext iERoutineContext, Collection<Integer> collection) {
        ArrayList<IEVar> arrayList = new ArrayList<IEVar>(collection.size());
        for (int n2 : collection) {
            IEVar iEVar = iERoutineContext.getVariableById(n2);
            if (iEVar == null) {
                throw new IllegalArgumentException("Unknown variable id: " + n2);
            }
            arrayList.add(iEVar);
        }
        return arrayList;
    }

    public static String formatVars(IERoutineContext iERoutineContext, Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (iERoutineContext != null) {
                IEVar iEVar = iERoutineContext.getVariableById(n3);
                if (iEVar == null) {
                    throw new IllegalArgumentException("Unknown variable id: " + n3);
                }
                stringBuilder.append(iEVar.getName());
            } else {
                stringBuilder.append(n3);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String formatVars(IERoutineContext iERoutineContext, int ... nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : nArray) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (iERoutineContext != null) {
                IEVar iEVar = iERoutineContext.getVariableById(n3);
                if (iEVar == null) {
                    throw new IllegalArgumentException("Unknown variable id: " + n3);
                }
                stringBuilder.append(iEVar.getName());
            } else {
                stringBuilder.append(n3);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean isVariableAssigned(IEStatement iEStatement, IEVar iEVar) {
        if (iEStatement instanceof IEAssign) {
            IEGeneric iEGeneric = iEStatement.asAssign().getDstOperand();
            return iEGeneric == iEVar || iEGeneric instanceof IESlice && iEGeneric.asSlice().getWholeExpression() == iEVar;
        }
        return false;
    }

    public static boolean hasTypeInfo(IEGeneric iEGeneric) {
        return iEGeneric.getType() != null && !iEGeneric.getType().isUndefined();
    }

    public static boolean hasNoTypeInfo(IEGeneric iEGeneric) {
        return iEGeneric.getType() == null || iEGeneric.getType().isUndefined();
    }

    public static boolean hasSameType(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.isSameType(iEGeneric.getType(), iEGeneric2.getType());
    }

    public static boolean isSameType(IWildcardType iWildcardType, IWildcardType iWildcardType2) {
        if ((iWildcardType == null || iWildcardType.isUndefined()) && (iWildcardType2 == null || iWildcardType2.isUndefined())) {
            return true;
        }
        if (iWildcardType == null && iWildcardType2 != null) {
            return false;
        }
        if (iWildcardType != null && iWildcardType2 == null) {
            return false;
        }
        return iWildcardType.resolveA().equals(iWildcardType2.resolveA());
    }

    public static IWildcardType getBestType(IWildcardType iWildcardType, IWildcardType iWildcardType2) {
        if (iWildcardType != null) {
            if (iWildcardType2 != null) {
                int n2 = iWildcardType.compareTo(iWildcardType2);
                if (n2 > 0) {
                    return iWildcardType;
                }
                if (n2 < 0) {
                    return iWildcardType2;
                }
                return null;
            }
            return iWildcardType;
        }
        return iWildcardType2;
    }

    public static boolean requiresExplicitCast(IWildcardType iWildcardType, IWildcardType iWildcardType2) {
        if ((iWildcardType == null || iWildcardType.isUndefined()) && (iWildcardType2 == null || iWildcardType2.isUndefined())) {
            return false;
        }
        if (iWildcardType == null && iWildcardType2 != null) {
            return true;
        }
        if (iWildcardType != null && iWildcardType2 == null) {
            return true;
        }
        if ((iWildcardType = iWildcardType.resolveA()).equals(iWildcardType2 = iWildcardType2.resolveA())) {
            return false;
        }
        if (iWildcardType != null && iWildcardType.isResolved() && iWildcardType2 != null && iWildcardType2.isResolved()) {
            INativeType iNativeType = iWildcardType.getNativeType();
            INativeType iNativeType2 = iWildcardType2.getNativeType();
            if ((iNativeType = TypeUtil.getNonAlias(iNativeType)).equals(iNativeType2 = TypeUtil.getNonAlias(iNativeType2))) {
                return false;
            }
            if (iNativeType2 instanceof IReferenceType && iNativeType.getName().equals("void*")) {
                return false;
            }
            int n2 = 10;
            while (n2-- > 0 && iNativeType instanceof IReferenceType && iNativeType2 instanceof IReferenceType) {
                IReferenceType iReferenceType = (IReferenceType)iNativeType;
                IReferenceType iReferenceType2 = (IReferenceType)iNativeType2;
                if (iReferenceType.getReferenceCount() != iReferenceType2.getReferenceCount()) break;
                INativeType iNativeType3 = iReferenceType.getReferencedType();
                INativeType iNativeType4 = iReferenceType2.getReferencedType();
                iNativeType = TypeUtil.getNonAlias(iNativeType3);
                if (!iNativeType.equals(iNativeType2 = TypeUtil.getNonAlias(iNativeType4))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<IWildcardType> getWildcardTypes(IWildcardTypeManager iWildcardTypeManager, Collection<IEGeneric> collection) {
        ArrayList<IWildcardType> arrayList = new ArrayList<IWildcardType>(collection.size());
        for (IEGeneric iEGeneric : collection) {
            arrayList.add(iEGeneric.getSafeType(iWildcardTypeManager));
        }
        return arrayList;
    }

    public static List<IWildcardType> gatherArgumentTypes(IWildcardPrototype iWildcardPrototype, Collection<IWildcardType> collection) {
        ArrayList<IWildcardType> arrayList = new ArrayList<IWildcardType>(iWildcardPrototype.getParameterTypes());
        if (iWildcardPrototype.isVariableArgument() && collection != null) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static int determineArgumentStackSlotCount(IWildcardPrototype iWildcardPrototype, Collection<IWildcardType> collection) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        int n2 = 0;
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
        for (IWildcardType iWildcardType : EUtil.gatherArgumentTypes(iWildcardPrototype, collection)) {
            StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
            if (storageEntry.getType() != StorageEntry.Type.STACK) continue;
            n2 += iWildcardType.getSlotCount();
        }
        return n2;
    }

    public static int determineReturnValuesStackSlotCount(IWildcardPrototype iWildcardPrototype, int n2) {
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        int n3 = 0;
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getOutputsGenerator(n2);
        for (IWildcardType iWildcardType : iWildcardPrototype.getReturnTypes()) {
            StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
            if (storageEntry.getType() != StorageEntry.Type.STACK) continue;
            n3 += storageEntry.getSlotCount();
        }
        return n3;
    }

    public static IEGeneric getAssignmentSource(IEStatement iEStatement) {
        if (!(iEStatement instanceof IEAssign)) {
            return null;
        }
        return iEStatement.asAssign().getSrcOperand();
    }

    public static IEGeneric getAssignmentDestination(IEStatement iEStatement) {
        if (!(iEStatement instanceof IEAssign)) {
            return null;
        }
        return iEStatement.asAssign().getDstOperand();
    }

    public static boolean hasNoSideEffect(IEGeneric iEGeneric) {
        return !(iEGeneric instanceof IEStatement);
    }

    public static boolean hasSideEffect(IEGeneric iEGeneric) {
        return !EUtil.hasNoSideEffect(iEGeneric);
    }

    public static Boolean checkCallReturnAddress(IERoutineContext iERoutineContext, CFG<IEStatement> cFG, BasicBlock<IEStatement> basicBlock, int n2) {
        long l2;
        long l3;
        IEStatement iEStatement;
        IEGeneric iEGeneric;
        IECall iECall = (IECall)basicBlock.get(n2);
        IEGeneric iEGeneric2 = iECall.getReturnLocation();
        if (iEGeneric2 == null) {
            return null;
        }
        Long l4 = null;
        if (iEGeneric2 instanceof IEImm) {
            iEGeneric = (IEImm)iEGeneric2;
            if (iEGeneric.canReadAsAddress()) {
                l4 = iEGeneric.getValueAsAddress();
            }
        } else if (iEGeneric2 instanceof IEVar && (iEGeneric = (IEVar)iEGeneric2).isGlobalReference()) {
            l4 = iEGeneric.getAddress();
        }
        if (l4 != null && (iEStatement = cFG.getInstruction(l3 = (l2 = basicBlock.getAddressOfInstruction(n2)) + (long)iECall.getSize())) != null) {
            long l5 = iERoutineContext.getConverter().sanitizeNativeAddress(l4);
            if (iEStatement.getLowerLevelAddresses().contains(l5)) {
                return true;
            }
        }
        return false;
    }

    public static CFG<IEStatement> expandStatementSize(IERoutineContext iERoutineContext, final IEStatement iEStatement, final int n2) {
        anz anz2;
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        if (iEStatement.getSize() < n2 && (anz2 = new anz(iERoutineContext){

            @Override
            public IEStatement[] processStatement(IEStatement iEStatement2, int n22) {
                if (iEStatement2 == iEStatement) {
                    iEStatement2.setSize(n2);
                }
                return new IEStatement[]{iEStatement2};
            }
        }).process(false, false, true)) {
            cFG = anz2.getCfg();
        }
        return cFG;
    }

    public static CFG<IEStatement> expandStatementSizes(IERoutineContext iERoutineContext, Collection<IEStatement> collection, final int n2) {
        anz anz2;
        CFG<IEStatement> cFG = iERoutineContext.getCfg();
        final Set set = collection.stream().filter(iEStatement -> iEStatement.getSize() < n2).collect(Collectors.toSet());
        if (!set.isEmpty() && (anz2 = new anz(iERoutineContext){

            @Override
            public IEStatement[] processStatement(IEStatement iEStatement, int n22) {
                if (set.contains(iEStatement)) {
                    iEStatement.setSize(n2);
                }
                return new IEStatement[]{iEStatement};
            }
        }).process(false, false, true)) {
            cFG = anz2.getCfg();
        }
        return cFG;
    }

    public static int adjustBranchToIRInstruction(IEStatement iEStatement, int n2, int n3) {
        int n4 = 0;
        if (iEStatement.isJump()) {
            IEJump iEJump = iEStatement.asJump();
            if (iEJump.getBranchAddress() == n2) {
                iEJump.setBranchAddress(n3);
                ++n4;
            }
        } else if (iEStatement.isSwitch()) {
            IESwitch iESwitch = iEStatement.asSwitch();
            if (iESwitch.getDefaultAddress() == n2) {
                iESwitch.setDefaultAddress(n3);
                ++n4;
            }
            for (Couple<IEGeneric, Integer> couple : iESwitch.getCases()) {
                if (couple.getSecond() != n2) continue;
                couple.setSecond(n3);
                ++n4;
            }
        }
        return n4;
    }

    public static boolean expandCalls(IERoutineContext iERoutineContext, final boolean bl) {
        boolean bl2 = false;
        for (IEStatement iEStatement : iERoutineContext.getCfg().instructions()) {
            if (iEStatement.getSize() != 1 || !(iEStatement instanceof IECall) && (!bl || !EUtil.isPCAssign(iEStatement))) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return true;
        }
        anz anz2 = new anz(iERoutineContext){

            @Override
            public IEStatement[] processStatement(IEStatement iEStatement, int n2) {
                if (iEStatement.getSize() == 1 && (iEStatement instanceof IECall || bl && EUtil.isPCAssign(iEStatement))) {
                    iEStatement.adjustSize(1);
                }
                return new IEStatement[]{iEStatement};
            }
        };
        return anz2.process(false, false, true);
    }

    public static void setLowerLevelAddress(long l2, List<IEStatement> list) {
        list.forEach(iEStatement -> iEStatement.setLowerLevelAddress(l2));
    }

    public static void setLowerLevelAddress(long l2, List<IEStatement> list, int n2, int n3) {
        list.subList(n2, n3).forEach(iEStatement -> iEStatement.setLowerLevelAddress(l2));
    }

    public static void setLowerLevelAddressIfNone(long l2, List<IEStatement> list) {
        list.forEach(iEStatement -> {
            if (iEStatement.getLowerLevelAddresses().isEmpty()) {
                iEStatement.setLowerLevelAddress(l2);
            }
        });
    }

    public static void setLowerLevelAddressIfNone(long l2, List<IEStatement> list, int n2, int n3) {
        list.subList(n2, n3).forEach(iEStatement -> {
            if (iEStatement.getLowerLevelAddresses().isEmpty()) {
                iEStatement.setLowerLevelAddress(l2);
            }
        });
    }

    public static boolean isLegalSignedImmediate(IEImm iEImm, int n2) {
        int n3 = iEImm.getBitsize();
        if (n2 <= 0 || n2 > n3) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        IEImm iEImm2 = iEImm._sar(n2 - 1);
        return iEImm2.isZero() || iEImm2.isOnes();
    }

    public static boolean isLegalUnsignedImmediate(IEImm iEImm, int n2) {
        int n3 = iEImm.getBitsize();
        if (n2 <= 0 || n2 > n3) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        IEImm iEImm2 = iEImm._shr(n2);
        return iEImm2.isZero();
    }
}

