/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardTypeManager;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public class ETypeInfo {
    IERoutineContext ectx;
    IWildcardTypeManager etypeman;
    List<Entry> list = new ArrayList<Entry>();
    int unchanged;
    int changed;
    boolean allowApplyComplexTypes;

    public ETypeInfo(IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
        this.etypeman = iERoutineContext.getWildcardTypeManager();
    }

    public IERoutineContext getContext() {
        return this.ectx;
    }

    public IWildcardTypeManager getWildcardTypeManager() {
        return this.etypeman;
    }

    public boolean isAllowApplyComplexTypes() {
        return this.allowApplyComplexTypes;
    }

    public void setAllowApplyComplexTypes(boolean bl) {
        this.allowApplyComplexTypes = bl;
    }

    public void recordConflict(String string, IEGeneric iEGeneric, IWildcardType iWildcardType, IWildcardType iWildcardType2) {
        Entry entry = new Entry(string, iEGeneric, iWildcardType, iWildcardType2);
        this.list.add(entry);
    }

    public void resetCounters() {
        this.changed = 0;
        this.unchanged = 0;
    }

    public int recordChanged() {
        ++this.changed;
        return this.changed;
    }

    public int getChangedCounter() {
        return this.changed;
    }

    public int recordUnchanged() {
        ++this.unchanged;
        return this.unchanged;
    }

    public int getUnchangedCounter() {
        return this.unchanged;
    }

    public List<Entry> getConflicts() {
        return this.list;
    }

    public int getConflictsCount() {
        return this.list.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Entry entry : this.list) {
            if (n2 >= 1) {
                stringBuilder.append("\n");
            }
            Strings.ff(stringBuilder, "- CONFLICT: %s", entry);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static class Entry {
        String msg;
        IEGeneric elt;
        IWildcardType currentType;
        IWildcardType wantedType;

        public Entry(String string, IEGeneric iEGeneric, IWildcardType iWildcardType, IWildcardType iWildcardType2) {
            this.msg = string;
            this.elt = iEGeneric;
            this.currentType = iWildcardType;
            this.wantedType = iWildcardType2;
        }

        public String getMessage() {
            return this.msg;
        }

        public IEGeneric getElement() {
            return this.elt;
        }

        public IWildcardType getCurrentType() {
            return this.currentType;
        }

        public IWildcardType getWantedType() {
            return this.wantedType;
        }

        public String toString() {
            return Strings.ff("%s: target=\"%s\", current_type=%s, wanted_type=%s", this.msg, this.elt, this.currentType, this.wantedType);
        }
    }
}

