/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;

public class EStateDumper {
    EState state;

    public EStateDumper(EState eState) {
        this.state = eState;
    }

    public void dumpTo(File file) throws IOException {
        IVirtualMemory iVirtualMemory = this.state.getMemory();
        VirtualMemoryUtil.dumpToImageFiles(iVirtualMemory, file, "img_", "");
        IEGlobalContext iEGlobalContext = this.state.getGlobalContext();
        ProcessorType processorType = iEGlobalContext.getNativeContext().getProcessor().getType();
        if (processorType != ProcessorType.ARM64) {
            throw new IllegalArgumentException("Limited to aarch64 for now");
        }
        String[] stringArray = new String[]{"PC", "X0", "X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8", "X9", "X10", "X11", "X12", "X13", "X14", "X15", "X16", "X17", "X18", "X19", "X20", "X21", "X22", "X23", "X24", "X25", "X26", "X27", "X28", "X29", "X30", "XSP", "V0", "V1", "V2", "V3"};
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            IEVar iEVar = iEGlobalContext.getVariableByName(string);
            if (iEVar == null) {
                throw new RuntimeException("Cannot find register: " + string);
            }
            String string2 = this.state.getValue(iEVar).toHexString();
            Strings.ff(stringBuilder, "%s=%s\n", string, string2);
        }
        IO.writeFile(new File(file, "registers"), Strings.encodeUTF8(stringBuilder.toString()));
    }
}

