/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.EvaluationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStateHooks;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IMergeController;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.StandardMergeController;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.EEmulator;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.aeb;
import com.pnfsoftware.jebglobal.ayr;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@SerDisabled
public class EState {
    private static final StructuredLogger logger = aeb.ce(EState.class);
    private static final int maxStackDepth = 30;
    private IEGlobalContext gctx;
    private boolean bigEndian;
    private int maxEvalcnt = 100;
    private int evalcnt;
    private Map<Integer, Long> segmentBases;
    private IVirtualMemory vm;
    private IVirtualMemory bad_vm;
    private IERoutineContext ectx;
    private int virtualPC;
    private Map<Integer, IEImm> gvars;
    private long nativeStackStart = -1L;
    private long nativeStackEnd = -1L;
    private Deque<Frame> frameStack;
    private boolean executeSubRoutines;
    private Map<Long, Integer> memwriteHitmap;
    private boolean recordBadWrites = false;
    private boolean memAutoAllocOnWrite = true;
    private EEmulator primaryEmulator;
    private List<IEStateHooks> memhooks = new ArrayList<IEStateHooks>();
    private boolean disabledHooks;
    public static final int MEMREAD_OK = 0;
    public static final int MEMREAD_FAILED = -1;
    public static final int MEMREAD_BADDATA = -2;
    private byte[] tmp2 = new byte[2];
    private byte[] tmp4 = new byte[4];
    private byte[] tmp8 = new byte[8];
    public static final int POLICY_MEMWRITE_BADHIT_DEFAULT = 0;
    public static final int POLICY_MEMWRITE_BADHIT_FORCE_RECORDING = 1;
    public static final int POLICY_MEMWRITE_BADHIT_FORCE_NO_RECORDING = 2;
    public static final int POLICY_MEMWRITE_BADHIT_NEED_STACK_ADDRESS = 3;
    private PointerSanitizer pointerSanitizer;

    public void pushFrame() {
        if (this.frameStack == null) {
            this.frameStack = new ArrayDeque<Frame>();
        } else if (this.frameStack.size() >= 30) {
            throw new EvaluationException("Exceeded recursion limits (maxStackDepth=30)");
        }
        Frame frame = new Frame(this.ectx, this.virtualPC, this.gvars, this.nativeStackStart, this.nativeStackEnd);
        this.frameStack.push(frame);
        this.ectx = null;
        this.virtualPC = 0;
        this.gvars = frame.gvars == null ? null : new HashMap<Integer, IEImm>(frame.gvars);
        this.nativeStackStart = -1L;
        this.nativeStackEnd = -1L;
    }

    public Frame popFrame() {
        if (this.frameStack == null || this.frameStack.isEmpty()) {
            return null;
        }
        Frame frame = new Frame(this.ectx, this.virtualPC, this.gvars, this.nativeStackStart, this.nativeStackEnd);
        Frame frame2 = this.frameStack.pop();
        this.ectx = frame2.ectx;
        this.virtualPC = frame2.virtualPC;
        this.gvars = frame2.gvars;
        this.nativeStackStart = frame2.nativeStackStart;
        this.nativeStackEnd = frame2.nativeStackEnd;
        return frame;
    }

    public int countFrames() {
        return this.frameStack == null ? 0 : this.frameStack.size();
    }

    public EState(IEGlobalContext iEGlobalContext) {
        this.gctx = iEGlobalContext;
        this.vm = new ayr(iEGlobalContext.getAddressBitsize());
        this.bigEndian = iEGlobalContext.isBigEndian();
        this.vm.setStandardEndianness(this.bigEndian ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN);
        this.gvars = new HashMap<Integer, IEImm>();
    }

    public EState(Endianness endianness) {
        this.bigEndian = endianness.isBig();
        this.gvars = new HashMap<Integer, IEImm>();
    }

    public EState(EState eState) {
        this(eState, true);
    }

    public EState(EState eState, boolean bl) {
        this.gctx = eState.gctx;
        this.bigEndian = eState.bigEndian;
        this.maxEvalcnt = eState.maxEvalcnt;
        this.evalcnt = eState.evalcnt;
        HashMap<Integer, Long> hashMap = this.segmentBases = eState.segmentBases == null ? null : new HashMap<Integer, Long>(eState.segmentBases);
        IVirtualMemory iVirtualMemory = !bl ? eState.vm : (this.vm = eState.vm == null ? null : eState.vm.duplicate());
        this.bad_vm = !bl ? eState.bad_vm : (eState.bad_vm == null ? null : eState.bad_vm.duplicate());
        this.ectx = eState.ectx;
        this.virtualPC = eState.virtualPC;
        this.gvars = eState.gvars == null ? null : new HashMap<Integer, IEImm>(eState.gvars);
        this.nativeStackStart = eState.nativeStackStart;
        this.nativeStackEnd = eState.nativeStackEnd;
        this.frameStack = null;
        if (eState.frameStack != null) {
            this.frameStack = new ArrayDeque<Frame>(eState.frameStack.size());
            for (Frame frame : eState.frameStack) {
                this.frameStack.add(new Frame(frame.ectx, frame.virtualPC, frame.gvars == null ? null : new HashMap<Integer, IEImm>(frame.gvars), frame.nativeStackStart, frame.nativeStackEnd));
            }
        }
        this.executeSubRoutines = eState.executeSubRoutines;
        this.memwriteHitmap = eState.memwriteHitmap == null ? null : new HashMap<Long, Integer>(eState.memwriteHitmap);
        this.recordBadWrites = eState.recordBadWrites;
        this.memAutoAllocOnWrite = eState.memAutoAllocOnWrite;
    }

    public void setExecuteSubRoutines(boolean bl) {
        this.executeSubRoutines = bl;
    }

    public boolean isExecuteSubRoutines() {
        return this.executeSubRoutines;
    }

    public int adjustVirtualPC(int n2) {
        this.virtualPC += n2;
        return this.virtualPC;
    }

    public void setVirtualPC(int n2) {
        this.virtualPC = n2;
    }

    public int getVirtualPC() {
        return this.virtualPC;
    }

    public void setRoutineContext(IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
    }

    public IERoutineContext getRoutineContext() {
        return this.ectx;
    }

    public IEGlobalContext getGlobalContext() {
        return this.gctx;
    }

    public void setMaxEvaluationCount(int n2) {
        this.maxEvalcnt = n2;
    }

    public int getMaxEvaluationCount() {
        return this.maxEvalcnt;
    }

    public boolean incrementEvaluationCount() {
        ++this.evalcnt;
        return this.evalcnt <= this.maxEvalcnt;
    }

    public int getEvaluationCount() {
        return this.evalcnt;
    }

    public void enableMemoryWriteHitmap(boolean bl, boolean bl2) {
        if (bl) {
            this.memwriteHitmap = new HashMap<Long, Integer>();
            this.recordBadWrites = bl2;
        } else {
            this.memwriteHitmap = null;
            this.recordBadWrites = false;
        }
    }

    public void setRecordBadWrites(boolean bl) {
        this.recordBadWrites = bl;
    }

    public boolean isRecordBadWrites() {
        return this.recordBadWrites;
    }

    public Map<Long, Integer> getMemoryWriteHitmap() {
        return this.memwriteHitmap;
    }

    public void setPrimaryEmulator(EEmulator eEmulator) {
        this.primaryEmulator = eEmulator;
    }

    public EEmulator getPrimaryEmulator() {
        return this.primaryEmulator;
    }

    public void registerHooks(IEStateHooks iEStateHooks, boolean bl) {
        int n2;
        int n3;
        if (iEStateHooks == null) {
            return;
        }
        int n4 = -1;
        int n5 = iEStateHooks.getPriority();
        for (n3 = 0; n3 < this.memhooks.size() && (n2 = this.memhooks.get(n3).getPriority()) >= n5; ++n3) {
            if (n2 != n5 || n4 != -1) continue;
            n4 = n3;
        }
        if (!bl || n4 < 0) {
            this.memhooks.add(n3, iEStateHooks);
        } else {
            this.memhooks.add(n4, iEStateHooks);
        }
    }

    public void unregisterHooks(IEStateHooks iEStateHooks) {
        if (iEStateHooks == null) {
            return;
        }
        this.memhooks.remove(iEStateHooks);
    }

    @Deprecated
    public void addHooks(IEStateHooks iEStateHooks) {
        this.registerHooks(iEStateHooks, false);
    }

    @Deprecated
    public void removeHooks(IEStateHooks iEStateHooks) {
        this.unregisterHooks(iEStateHooks);
    }

    public boolean setDisabledHooks(boolean bl) {
        boolean bl2 = this.disabledHooks;
        this.disabledHooks = bl;
        return bl2;
    }

    public boolean isDisabledHooks() {
        return this.disabledHooks;
    }

    public int mergeWith(EState eState, IMergeController iMergeController, Set<Integer> set, Set<Integer> set2) {
        if (eState.bigEndian != this.bigEndian) {
            throw new IllegalStateException("States cannot be merged, endianness differs");
        }
        if (iMergeController == null) {
            iMergeController = new StandardMergeController();
        }
        Object[] objectArray = new Object[]{this, eState};
        Map<Integer, IEImm> map = this.gvars;
        Map<Integer, IEImm> map2 = eState.gvars;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        int n3 = 0;
        for (int n4 : map2.keySet()) {
            if (map.containsKey(n4)) {
                hashSet.add(n4);
                IEImm iEImm = map.get(n4);
                IEImm iEImm2 = map2.get(n4);
                if (iEImm == null || iEImm2 == null || !iEImm.equals(iEImm2)) {
                    if (iMergeController.onMismatch(n4)) {
                        map.remove(n4);
                    }
                    ++n2;
                    if (set == null) continue;
                    set.add(n4);
                    continue;
                }
                iMergeController.onMatch(n4);
                continue;
            }
            if (!iMergeController.onOutputOnly(n4)) continue;
            map.put(n4, map2.get(n4));
            ++n3;
            if (set2 == null) continue;
            set2.add(n4);
        }
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n4;
            n4 = iterator.next();
            if (hashSet.contains(n4) || !iMergeController.onInputOnly(n4)) continue;
            iterator.remove();
            ++n2;
            if (set == null) continue;
            set.add(n4);
        }
        return n2 + n3;
    }

    public int mergeWithOld(EState eState, Collection<Integer> collection, boolean bl, Collection<Integer> collection2, Collection<Integer> collection3) {
        if (eState.bigEndian != this.bigEndian) {
            throw new IllegalStateException("States cannot be merged, endianness differs");
        }
        Object[] objectArray = new Object[]{this, eState};
        Map<Integer, IEImm> map = this.gvars;
        Map<Integer, IEImm> map2 = eState.gvars;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        int n3 = 0;
        for (int n4 : map2.keySet()) {
            if (map.containsKey(n4)) {
                hashSet.add(n4);
                if (map.get(n4).equals(map2.get(n4))) continue;
                map.remove(n4);
                ++n2;
                if (collection3 == null) continue;
                collection3.add(n4);
                continue;
            }
            if (!bl || collection2 != null && collection2.contains(n4)) continue;
            map.put(n4, map2.get(n4));
            ++n3;
        }
        if (collection != null) {
            Iterator<Integer> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int n4;
                n4 = iterator.next();
                if (hashSet.contains(n4) || !collection.contains(n4)) continue;
                iterator.remove();
                ++n2;
                if (collection3 == null) continue;
                collection3.add(n4);
            }
        }
        return n2 + n3;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public Map<Integer, IEImm> getVariables() {
        return this.gvars;
    }

    public void setVariables(Map<Integer, IEImm> map) {
        this.gvars = map;
    }

    public IEImm getValueSafe(IEVar iEVar) {
        return this.getValueInternal(iEVar.getId());
    }

    public IEImm getValueSafe(int n2) {
        return this.getValueInternal(n2);
    }

    public IEImm getValue(IEVar iEVar) {
        return this.getValue(iEVar.getId());
    }

    public IEImm getValue(int n2) {
        IEImm iEImm = this.getValueInternal(n2);
        if (iEImm == null) {
            throw new EvaluationException("Variable is uninitialized or does not exist: " + EUtil.formatVars(this.ectx, n2));
        }
        return iEImm;
    }

    public long getValueAsLong(int n2) {
        return this.getValue(n2).getValueAsLong();
    }

    public Long getValueAsLongSafe(int n2) {
        IEImm iEImm = this.getValueSafe(n2);
        if (iEImm == null) {
            return null;
        }
        return iEImm.getValueAsLong();
    }

    public long getValueAsUnsignedLong(int n2) {
        return this.getValue(n2).getValueAsUnsignedLong();
    }

    private IEImm getValueInternal(int n2) {
        return this.gvars.get(n2);
    }

    public void setValue(int n2, long l2) {
        IEVar iEVar = this.ectx != null ? this.ectx.getVariableById(n2) : this.gctx.getVar(n2);
        this.setValue(iEVar, l2);
    }

    public void setValue(IEVar iEVar, long l2) {
        this.setValueInternal(iEVar.getId(), EUtil.imm(l2, iEVar.getBitsize()));
    }

    public void setValue(IEVar iEVar, IEImm iEImm) {
        if (iEImm != null && iEVar.getBitsize() != iEImm.getBitsize()) {
            throw new IllegalArgumentException("Unexpected bitsize for value, doe not match variable's!");
        }
        this.setValueInternal(iEVar.getId(), iEImm);
    }

    private void setValueInternal(int n2, IEImm iEImm) {
        this.gvars.put(n2, iEImm);
    }

    public boolean removeValue(int n2) {
        return this.gvars.remove(n2) != null;
    }

    public boolean hasValue(int n2) {
        return this.gvars.get(n2) != null;
    }

    public boolean hasBadValue(int n2) {
        return this.gvars.containsKey(n2) && this.gvars.get(n2) == null;
    }

    public IEImm getProgramCounter() {
        IEVar iEVar = this.gctx.getConverter().getProgramCounter();
        return this.getValue(iEVar);
    }

    public void setProgramCounter(IEImm iEImm) {
        IEVar iEVar = this.gctx.getConverter().getProgramCounter();
        this.setValue(iEVar, iEImm);
    }

    public IEImm getStackPointer() {
        IEVar iEVar = this.gctx.getConverter().getStackPointer();
        return this.getValue(iEVar);
    }

    public void setStackPointer(IEImm iEImm) {
        IEVar iEVar = this.gctx.getConverter().getStackPointer();
        this.setValue(iEVar, iEImm);
    }

    public boolean hasSegmentBases() {
        return this.segmentBases != null;
    }

    public void setSegmentBase(int n2, long l2) {
        if (this.segmentBases == null) {
            this.segmentBases = new HashMap<Integer, Long>();
        }
        this.segmentBases.put(n2, l2);
    }

    public long getSegmentBase(int n2) {
        if (this.segmentBases == null) {
            return 0L;
        }
        Long l2 = this.segmentBases.get(n2);
        if (l2 == null) {
            return 0L;
        }
        return l2;
    }

    public void setSegmentMapping(String string, int n2, long l2) {
        IEVar iEVar = this.gctx.getVariableByName(string);
        this.setValue(iEVar, (long)n2);
        this.setSegmentBase(n2, l2);
    }

    public IVirtualMemory getMemory() {
        return this.vm;
    }

    public void setMemory(IVirtualMemory iVirtualMemory) {
        this.vm = iVirtualMemory;
    }

    public void setNativeStackStart(long l2) {
        this.nativeStackStart = l2;
    }

    public long getNativeStackStart() {
        return this.nativeStackStart;
    }

    public void setNativeStackEnd(long l2) {
        this.nativeStackEnd = l2;
    }

    public long getNativeStackEnd() {
        return this.nativeStackEnd;
    }

    public void setSoftFailMode(boolean bl) {
        if (bl) {
            IVirtualMemory iVirtualMemory = this.getMemory();
            if (iVirtualMemory == null) {
                throw new IllegalStateException("Soft-fail mode requires a vmem!");
            }
            this.bad_vm = VirtualMemoryUtil.createMemory(iVirtualMemory.getSpaceBits(), iVirtualMemory.getPageBits(), iVirtualMemory.getStandardEndianess());
        } else {
            this.bad_vm = null;
        }
    }

    public boolean isSoftFailMode() {
        return this.bad_vm != null;
    }

    public IVirtualMemory getBadMemory() {
        return this.bad_vm;
    }

    public void setBadMemory(IVirtualMemory iVirtualMemory) {
        this.bad_vm = iVirtualMemory;
    }

    public void setMemoryAutoAllocOnWrite(boolean bl) {
        this.memAutoAllocOnWrite = bl;
    }

    public boolean isMemoryAutoAllocOnWrite() {
        return this.memAutoAllocOnWrite;
    }

    public boolean readMemory(long l2, byte[] byArray) {
        return this.readMemory2(l2, byArray) == 0;
    }

    public int readMemory2(long l2, byte[] byArray) {
        if (!this.disabledHooks) {
            for (IEStateHooks object : this.memhooks) {
                Integer n2 = object.onReadMemory(this, l2, byArray);
                if (n2 == null) continue;
                return n2;
            }
        }
        int n2 = this.readMemoryInternal(l2, byArray);
        if (!this.disabledHooks) {
            for (IEStateHooks iEStateHooks : this.memhooks) {
                Integer n3 = iEStateHooks.onReadMemoryPost(this, l2, byArray, n2);
                if (n3 == null) continue;
                return n3;
            }
        }
        return n2;
    }

    private int readMemoryInternal(long l2, byte[] byArray) {
        boolean bl = VirtualMemoryUtil.readSafe(this.vm, l2, byArray);
        if (this.bad_vm == null || !bl) {
            return bl ? 0 : -1;
        }
        byte[] byArray2 = new byte[byArray.length];
        boolean bl2 = VirtualMemoryUtil.readSafe(this.bad_vm, l2, byArray2);
        if (!bl2) {
            return bl ? 0 : -1;
        }
        for (byte by : byArray2) {
            if (by != -1) continue;
            return -2;
        }
        return bl ? 0 : -1;
    }

    private void memhit(long l2, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.memwriteHitmap.put(l2 + (long)i, this.evalcnt);
        }
    }

    public synchronized boolean writeMemoryShort(long l2, short s2) {
        if (this.vm.getStandardEndianess().isLittle()) {
            EndianUtil.shortToLEBytes(s2, this.tmp2);
        } else if (this.vm.getStandardEndianess().isBig()) {
            EndianUtil.shortToBEBytes(s2, this.tmp2);
        } else {
            return false;
        }
        return this.writeMemory(l2, this.tmp2);
    }

    public synchronized boolean writeMemoryInt(long l2, int n2) {
        if (this.vm.getStandardEndianess().isLittle()) {
            EndianUtil.intToLEBytes(n2, this.tmp4);
        } else if (this.vm.getStandardEndianess().isBig()) {
            EndianUtil.intToBEBytes(n2, this.tmp4);
        } else {
            return false;
        }
        return this.writeMemory(l2, this.tmp4);
    }

    public synchronized boolean writeMemoryLong(long l2, long l3) {
        if (this.vm.getStandardEndianess().isLittle()) {
            EndianUtil.longToLEBytes(l3, this.tmp8);
        } else if (this.vm.getStandardEndianess().isBig()) {
            EndianUtil.longToBEBytes(l3, this.tmp8);
        } else {
            return false;
        }
        return this.writeMemory(l2, this.tmp8);
    }

    public synchronized boolean writeMemoryPointer(long l2, long l3) {
        int n2 = this.vm.getSpaceBits();
        if (n2 == 16) {
            return this.writeMemoryShort(l2, (short)l3);
        }
        if (n2 == 32) {
            return this.writeMemoryInt(l2, (int)l3);
        }
        if (n2 == 64) {
            return this.writeMemoryLong(l2, l3);
        }
        if (n2 > 64) {
            byte[] byArray = new byte[n2 / 8];
            if (this.vm.getStandardEndianess().isLittle()) {
                EndianUtil.longToLEBytes(l3, byArray);
            } else if (this.vm.getStandardEndianess().isBig()) {
                EndianUtil.longToBEBytes(l3, byArray);
            } else {
                return false;
            }
            return this.writeMemory(l2, byArray);
        }
        return false;
    }

    public boolean writeMemory(long l2, byte[] byArray) {
        if (!this.disabledHooks) {
            for (IEStateHooks iEStateHooks : this.memhooks) {
                Boolean bl = iEStateHooks.onWriteMemory(this, l2, byArray);
                if (bl == null) continue;
                return bl;
            }
        }
        return this.writeMemoryInternal(l2, byArray);
    }

    private boolean writeMemoryInternal(long l2, byte[] byArray) {
        if (this.memwriteHitmap != null) {
            this.memhit(l2, byArray.length);
        }
        if (!this.memAutoAllocOnWrite && this.vm.check(l2, byArray.length, 2) < byArray.length) {
            return false;
        }
        VirtualMemoryUtil.allocateFillGaps(this.vm, l2, byArray.length, 7);
        boolean bl = VirtualMemoryUtil.writeSafe(this.vm, l2, byArray);
        if (this.bad_vm == null || !bl) {
            return bl;
        }
        byte[] byArray2 = new byte[byArray.length];
        Arrays.fill(byArray2, (byte)0);
        VirtualMemoryUtil.allocateFillGaps(this.bad_vm, l2, byArray2.length, 7);
        return VirtualMemoryUtil.writeSafe(this.bad_vm, l2, byArray2);
    }

    public boolean writeMemoryBad(long l2, int n2) {
        return this.writeMemoryBad(l2, n2, 0);
    }

    public boolean writeMemoryBad(long l2, int n2, int n3) {
        if (this.memwriteHitmap != null) {
            boolean bl;
            switch (n3) {
                case 0: {
                    bl = this.recordBadWrites;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = this.recordBadWrites && l2 >= this.nativeStackStart && l2 < this.nativeStackEnd;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                this.memhit(l2, n2 / 8);
            }
        }
        if (this.bad_vm == null) {
            return false;
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        Arrays.fill(byArray, (byte)-1);
        VirtualMemoryUtil.allocateFillGaps(this.bad_vm, l2, byArray.length, 7);
        return VirtualMemoryUtil.writeSafe(this.bad_vm, l2, byArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "VPC:0x%X ", this.getVirtualPC());
        Strings.ff(stringBuilder, "{%s}", EState.formatVars(this.gvars, this.gctx, this.ectx, null, null, true));
        Strings.ff(stringBuilder, " hasMem=%b", this.getMemory() != null);
        return stringBuilder.toString();
    }

    public String formatVars(boolean bl) {
        return EState.formatVars(this.gvars, this.gctx, this.ectx, null, null, bl).toString();
    }

    public static CharSequence formatVars(Map<Integer, IEImm> map, IEGlobalContext iEGlobalContext, IERoutineContext iERoutineContext) {
        return EState.formatVars(map, iEGlobalContext, iERoutineContext, null, null, false);
    }

    public static CharSequence formatVars(Map<Integer, IEImm> map, IEGlobalContext iEGlobalContext, IERoutineContext iERoutineContext, Collection<Integer> collection, Collection<Integer> collection2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<Integer, IEImm> treeMap = new TreeMap<Integer, IEImm>(map);
        int n2 = 0;
        for (Map.Entry<Integer, IEImm> entry : treeMap.entrySet()) {
            Object object;
            int n3 = entry.getKey();
            if (collection != null && !collection.contains(n3) || collection2 != null && collection2.contains(n3)) continue;
            IEImm iEImm = entry.getValue();
            Object object2 = null;
            if (iERoutineContext != null) {
                object2 = iERoutineContext.getVariableById(n3).getName();
            } else if (iEGlobalContext != null && (object = iEGlobalContext.getVarSafe(n3)) != null) {
                object2 = object.getName();
            }
            if (object2 == null) {
                object2 = "r" + n3;
            }
            if (iEImm == null) {
                object = "BAD!";
            } else {
                if (bl && iEImm.isZero()) continue;
                object = iEImm.toHexString().toUpperCase();
            }
            if (n2 >= 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)object2).append(":").append((String)object);
            ++n2;
        }
        return stringBuilder;
    }

    public void setPointerSanitizer(PointerSanitizer pointerSanitizer) {
        this.pointerSanitizer = pointerSanitizer;
    }

    public PointerSanitizer getPointerSanitizer() {
        return this.pointerSanitizer;
    }

    public long generateAddressFromPointer(long l2) {
        if (this.pointerSanitizer != null) {
            return this.pointerSanitizer.process(l2);
        }
        return l2;
    }

    public static interface PointerSanitizer {
        public long process(long var1);
    }

    public static class Frame {
        IERoutineContext ectx;
        int virtualPC;
        Map<Integer, IEImm> gvars;
        long nativeStackStart;
        long nativeStackEnd;

        Frame(IERoutineContext iERoutineContext, int n2, Map<Integer, IEImm> map, long l2, long l3) {
            this.ectx = iERoutineContext;
            this.virtualPC = n2;
            this.gvars = map;
            this.nativeStackStart = l2;
            this.nativeStackEnd = l3;
        }

        public IERoutineContext getRoutineContext() {
            return this.ectx;
        }

        public int getVirtualPC() {
            return this.virtualPC;
        }

        public Map<Integer, IEImm> getVars() {
            return this.gvars;
        }
    }
}

