/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.DecompilerException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EVarCopyFinder;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEPrototypeHandler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStackManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardPrototype;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStorageEntryGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import com.pnfsoftware.jebglobal.amt;
import com.pnfsoftware.jebglobal.anr;
import com.pnfsoftware.jebglobal.anz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class EPrototypeHandler
implements IEPrototypeHandler {
    private static final StructuredLogger logger = aeb.ce(EPrototypeHandler.class);
    protected IERoutineContext ctx;

    public EPrototypeHandler(IERoutineContext iERoutineContext) {
        this.ctx = iERoutineContext;
    }

    @Override
    public boolean applyKnownPrototype(boolean bl) {
        int n2;
        Object object;
        IDFA<IEStatement> iDFA;
        StorageEntry storageEntry;
        IDFA<IEStatement> iDFA2;
        IWildcardPrototype iWildcardPrototype = this.ctx.getPrototype();
        if (iWildcardPrototype == null) {
            return false;
        }
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        CFG<IEStatement> cFG = this.ctx.getCfg();
        IEStackManager iEStackManager = this.ctx.getStackManager();
        int n3 = iEStackManager.getNormalSlotSize();
        int n4 = 0;
        Collection<Integer> collection = null;
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
        int n5 = 0;
        for (IWildcardType object22 : iWildcardPrototype.getParameterTypes()) {
            IEVar iEVar;
            iDFA2 = cFG.getDataFlowAnalysis();
            if (iDFA2 == null) {
                iDFA2 = cFG.doDataFlowAnalysis();
                collection = null;
            }
            if (collection == null) {
                collection = iDFA2.getInputs();
            }
            if ((iEVar = this.ctx.getConverter().getInputVariableByIndex(this.ctx, n5)) != null) {
                ++n5;
                continue;
            }
            storageEntry = iStorageEntryGenerator.next(object22.getLayoutInfo());
            switch (storageEntry.getType()) {
                case REGISTER: {
                    EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                    IEGeneric iEGeneric = eVarCopyFinder.getIRForSlicedReg(bl);
                    if (iEGeneric == null) break;
                    if (eVarCopyFinder.wasCreated()) {
                        (new Object[1])[0] = iEGeneric;
                    }
                    this.ctx.setTypeForSame(iEGeneric, object22);
                    break;
                }
                case REGISTER_PAIR: {
                    EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                    IEVar iEVar2 = eVarCopyFinder.getVarForRegPair(bl);
                    if (iEVar2 != null) {
                        if (eVarCopyFinder.wasCreated()) {
                            (new Object[1])[0] = iEVar2;
                        }
                        iEVar2.setType(object22);
                    }
                    if (!bl) break;
                    IEVar iEVar3 = eVarCopyFinder.getVarToSubstitute(0);
                    iDFA = eVarCopyFinder.getVarToSubstitute(1);
                    object = new anr(this.ctx, cFG);
                    ((anr)object).ce(-1L, iEVar3.getId(), true);
                    ((anr)object).ce(iEVar3, iEVar2.part(iEVar3.getBitsize()));
                    ((anr)object).ce(-1L, iDFA.getId(), true);
                    ((anr)object).ce((IEVar)((Object)iDFA), iEVar2.slice(iEVar3.getBitsize()));
                    cFG.invalidateDataFlowAnalysis();
                    break;
                }
                case STACK: {
                    if (!bl) break;
                    n2 = storageEntry.getValueAsStackIndex();
                    int n6 = n2 * n3;
                    IEVar iEVar4 = iEStackManager.createStackItem(n6, object22.getBitsize());
                    if (iEVar4 == null) {
                        throw new RuntimeException("Unexpected: stack parameter item cannot be created");
                    }
                    iEVar4.setType(object22);
                    ++n4;
                    break;
                }
                case MIXED: {
                    break;
                }
                default: {
                    throw new DecompilerException("Input storage type not supported: " + storageEntry.getType());
                }
            }
            n2 = object22.getSlotCount();
            n5 = storageEntry.nextSlotIndex(n5, n2);
        }
        collection = null;
        if (n4 > 0) {
            cFG.invalidateDataFlowAnalysis();
        }
        int n7 = EUtil.determineArgumentStackSlotCount(iWildcardPrototype, null);
        iStorageEntryGenerator = iCallingConvention.getOutputsGenerator(n7);
        final HashMap<Integer, IEAssign> hashMap = new HashMap<Integer, IEAssign>();
        n5 = 0;
        for (IWildcardType iWildcardType : iWildcardPrototype.getReturnTypes()) {
            storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
            if (storageEntry == null) {
                ++n5;
                continue;
            }
            block13: for (BasicBlock<IEStatement> basicBlock : cFG.getExitBlocks()) {
                iDFA = cFG.getDataFlowAnalysis();
                if (iDFA == null) {
                    iDFA = cFG.doDataFlowAnalysis();
                    collection = null;
                }
                if (collection == null) {
                    collection = iDFA.getOutputs(basicBlock);
                }
                switch (storageEntry.getType()) {
                    case REGISTER: {
                        EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, basicBlock.getLastAddress());
                        object = eVarCopyFinder.getIRForSlicedReg(false);
                        if (object == null) {
                            logger.debug("Unexpected: return variable not found, we cannot apply the return type: " + iWildcardType, new Object[0]);
                            continue block13;
                        }
                        this.ctx.setTypeForSame((IEGeneric)object, iWildcardType);
                        continue block13;
                    }
                    case REGISTER_PAIR: {
                        EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, basicBlock.getLastAddress());
                        object = eVarCopyFinder.getVarForRegPair(bl);
                        if (bl) {
                            IEVar iEVar = eVarCopyFinder.getVarToSubstitute(0);
                            IEVar iEVar5 = eVarCopyFinder.getVarToSubstitute(1);
                            IEAssign iEAssign = this.ctx.createAssign((IEGeneric)object, this.ctx.createCompose(iEVar, iEVar5));
                            iEAssign.setFlags(2);
                            iEAssign.copyLowerLevelAddresses(basicBlock.getLast());
                            hashMap.put((int)basicBlock.getLastAddress(), iEAssign);
                        }
                        if (object == null) continue block13;
                        object.setType(iWildcardType);
                        continue block13;
                    }
                    case STACK: {
                        if (!bl) continue block13;
                        int n8 = storageEntry.getValueAsStackIndex();
                        int n9 = n8 * n3;
                        object = iEStackManager.createStackItem(n9, iWildcardType.getBitsize());
                        if (object == null) {
                            throw new RuntimeException("Unexpected: stack parameter item cannot be created");
                        }
                        object.setType(iWildcardType);
                        ++n4;
                        continue block13;
                    }
                }
                throw new DecompilerException("Output storage type not supported: " + storageEntry.getType());
            }
            n2 = iWildcardType.getSlotCount();
            n5 = storageEntry.nextSlotIndex(n5, n2);
        }
        if (!hashMap.isEmpty()) {
            iDFA2 = new anz(this.ctx){

                @Override
                public IEStatement[] processStatement(IEStatement iEStatement, int n2) {
                    IEStatement iEStatement2 = (IEStatement)hashMap.get(n2);
                    if (iEStatement2 != null) {
                        return new IEStatement[]{iEStatement2, iEStatement};
                    }
                    return new IEStatement[]{iEStatement};
                }
            };
            ((anz)((Object)iDFA2)).process(true, true, true);
            cFG = this.ctx.getCfg();
            cFG.invalidateDataFlowAnalysis();
        }
        if (n4 > 0) {
            cFG.invalidateDataFlowAnalysis();
        }
        return true;
    }

    @Override
    public boolean retrieveFromPrototype(List<IEGeneric> list, List<IWildcardType> list2) {
        IWildcardPrototype iWildcardPrototype = this.ctx.getPrototype();
        if (iWildcardPrototype == null) {
            return false;
        }
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        CFG<IEStatement> cFG = this.ctx.getCfg();
        IEStackManager iEStackManager = this.ctx.getStackManager();
        int n2 = iEStackManager.getNormalSlotSize();
        Collection<Integer> collection = null;
        if (list != null) {
            IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
            int n3 = 0;
            for (IWildcardType iWildcardType : iWildcardPrototype.getParameterTypes()) {
                IEGeneric iEGeneric;
                IDFA<IEStatement> iDFA = cFG.getDataFlowAnalysis();
                if (iDFA == null) {
                    iDFA = cFG.doDataFlowAnalysis();
                    collection = null;
                }
                if (collection == null) {
                    collection = iDFA.getInputs();
                }
                if ((iEGeneric = this.ctx.getConverter().getInputVariableByIndex(this.ctx, n3)) != null) {
                    ++n3;
                } else {
                    int n4;
                    StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
                    switch (storageEntry.getType()) {
                        case REGISTER: {
                            EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                            iEGeneric = eVarCopyFinder.getIRForSlicedReg(true);
                            if (!eVarCopyFinder.wasCreated()) break;
                            this.ctx.setTypeForSame(iEGeneric, iWildcardType);
                            break;
                        }
                        case REGISTER_PAIR: {
                            EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                            iEGeneric = eVarCopyFinder.getVarForRegPair(true);
                            if (!eVarCopyFinder.wasCreated()) break;
                            iEGeneric.setType(iWildcardType);
                            break;
                        }
                        case STACK: {
                            n4 = storageEntry.getValueAsStackIndex();
                            int n5 = n4 * n2;
                            iEGeneric = iEStackManager.getVariable(n5);
                            if (iEGeneric != null) break;
                            throw new RuntimeException("EVar for stack parameter should exist at this point");
                        }
                        case MIXED: {
                            iEGeneric = amt.ce(iWildcardType.getBitsize(), iWildcardType, null);
                            break;
                        }
                        default: {
                            throw new DecompilerException("Input storage type not supported: " + storageEntry.getType());
                        }
                    }
                    n4 = iWildcardType.getSlotCount();
                    n3 = storageEntry.nextSlotIndex(n3, n4);
                }
                list.add(iEGeneric);
            }
        }
        if (list2 != null) {
            list2.addAll(iWildcardPrototype.getReturnTypes());
        }
        return true;
    }

    @Override
    public boolean refinePrototype() {
        Object object;
        Object object2;
        BasicBlock<IEStatement> basicBlock22;
        IDFA<IEStatement> iDFA;
        INativeMethodItem iNativeMethodItem = this.ctx.getRoutine();
        if (iNativeMethodItem.getPrototype() != null && !iNativeMethodItem.isAutoGeneratedPrototype()) {
            return false;
        }
        IWildcardPrototype iWildcardPrototype = this.ctx.getPrototype();
        if (iWildcardPrototype == null) {
            throw new IllegalStateException("Prototype discovery must be performed first");
        }
        ICallingConvention iCallingConvention = iWildcardPrototype.getCallingConvention();
        CFG<IEStatement> cFG = this.ctx.getCfg();
        IEStackManager iEStackManager = this.ctx.getStackManager();
        int n2 = iEStackManager.getNormalSlotSize();
        Collection<Integer> collection = null;
        int n3 = 0;
        (new Object[1])[0] = iCallingConvention;
        ArrayList<IWildcardType> arrayList = new ArrayList<IWildcardType>();
        IStorageEntryGenerator iStorageEntryGenerator = iCallingConvention.getInputsGenerator();
        int n4 = 0;
        for (IWildcardType iWildcardType : iWildcardPrototype.getParameterTypes()) {
            iDFA = cFG.getDataFlowAnalysis();
            if (iDFA == null) {
                iDFA = cFG.doDataFlowAnalysis();
                collection = null;
            }
            if (collection == null) {
                collection = iDFA.getInputs();
            }
            if ((basicBlock22 = this.ctx.getConverter().getInputVariableByIndex(this.ctx, n4)) != null) {
                ++n4;
            } else {
                int n5;
                StorageEntry storageEntry = iStorageEntryGenerator.next(iWildcardType.getLayoutInfo());
                switch (storageEntry.getType()) {
                    case REGISTER: {
                        EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                        basicBlock22 = eVarCopyFinder.getIRForSlicedReg(false);
                        break;
                    }
                    case REGISTER_PAIR: {
                        EVarCopyFinder eVarCopyFinder = this.ctx.copyFinder(storageEntry, collection, 0L);
                        basicBlock22 = eVarCopyFinder.getVarForRegPair(false);
                        break;
                    }
                    case STACK: {
                        n5 = storageEntry.getValueAsStackIndex();
                        int n6 = n5 * n2;
                        basicBlock22 = iEStackManager.getVariable(n6);
                        if (basicBlock22 != null || (basicBlock22 = iEStackManager.createStackItem(n6, n2 * 8)) == null) break;
                        basicBlock22.setType(this.ctx.getWildcardTypeManager().createWithSlotcount(1));
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                n5 = iWildcardType.getSlotCount();
                n4 = storageEntry.nextSlotIndex(n4, n5);
            }
            if (basicBlock22 != null) {
                IWildcardType iWildcardType2 = basicBlock22.getType();
                if (iWildcardType2 != null && iWildcardType.isLessSpecializedThan(iWildcardType2)) {
                    arrayList.add(iWildcardType2);
                    ++n3;
                    continue;
                }
                arrayList.add(iWildcardType);
                continue;
            }
            arrayList.add(iWildcardType);
        }
        if (iWildcardPrototype.getReturnTypes().size() == 1) {
            Object object3;
            boolean bl = true;
            int n7 = -1;
            iDFA = new ArrayList();
            block6: for (BasicBlock basicBlock : cFG.getBlocks()) {
                AddressableInstruction addressableInstruction = basicBlock.getLast2();
                if (!(addressableInstruction.getInstruction() instanceof IEReturn)) continue;
                IEReturn iEReturn = (IEReturn)addressableInstruction.getInstruction();
                if (iEReturn.getValue() instanceof IEImm) {
                    iDFA.add(iEReturn.getValue().asImm());
                    continue;
                }
                if (!(iEReturn.getValue() instanceof IEVar)) {
                    bl = false;
                    break;
                }
                object3 = (IEVar)iEReturn.getValue();
                if (object3.getType() == null || object3.getType().getEffectiveBitsize() != 0) {
                    bl = false;
                    break;
                }
                int n8 = object3.getId();
                object2 = cFG.getDataFlowAnalysis();
                if (object2 == null) {
                    object2 = cFG.doDataFlowAnalysis();
                }
                object = object2.getUseDefs(addressableInstruction.getOffset(), n8);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    IEStatement iEStatement = cFG.getInstruction(l2);
                    if (iEStatement == null || !iEStatement.isAssignTo((IEVar)object3)) {
                        bl = false;
                        break block6;
                    }
                    IEGeneric iEGeneric = iEStatement.asAssign().getSrcOperand();
                    if (iEGeneric instanceof IEImm) {
                        iDFA.add(iEGeneric.asImm());
                        continue;
                    }
                    if (!EUtil.isZeroExtend(iEGeneric)) continue;
                    int n9 = ((IECompose)iEGeneric).getLowPart().getBitsize();
                    if (n7 == -1) {
                        n7 = n9;
                        continue;
                    }
                    if (n7 == n9) continue;
                    bl = false;
                    break block6;
                }
            }
            if (bl && n7 > 0 && !iDFA.isEmpty()) {
                basicBlock22 = iDFA.iterator();
                while (basicBlock22.hasNext()) {
                    IEImm iEImm = (IEImm)((Object)basicBlock22.next());
                    if (iEImm.getBitsize() >= n7 && EUtil.isZero(iEImm.slice(n7))) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (BasicBlock basicBlock : cFG.getBlocks()) {
                        IEReturn iEReturn;
                        AddressableInstruction addressableInstruction = basicBlock.getLast2();
                        if (!(addressableInstruction.getInstruction() instanceof IEReturn) || !((iEReturn = (IEReturn)addressableInstruction.getInstruction()).getValue() instanceof IEVar)) continue;
                        object3 = iEReturn.getValue().asVar();
                        object3.setType(object3.getType().updateEffectiveBitsize(n7));
                    }
                }
            }
        }
        ArrayList arrayList2 = new ArrayList();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (BasicBlock<IEStatement> basicBlock22 : cFG.getBlocks()) {
            AddressableInstruction<IEStatement> addressableInstruction = basicBlock22.getLast2();
            if (!(addressableInstruction.getInstruction() instanceof IEReturn)) continue;
            IEReturn iEReturn = (IEReturn)addressableInstruction.getInstruction();
            int n10 = 0;
            for (IEGeneric iEGeneric : iEReturn.getValues()) {
                object2 = iEGeneric.getType();
                if (object2 != null) {
                    object = (IWildcardType)Lists.get(arrayList2, n10);
                    if (object == null) {
                        if (!hashSet.contains(n10)) {
                            Lists.set(arrayList2, n10, object2);
                        }
                    } else if (object != object2) {
                        Lists.set(arrayList2, n10, null);
                        hashSet.add(n10);
                    }
                }
                ++n10;
            }
        }
        iDFA = new ArrayList();
        n4 = 0;
        for (IWildcardType iWildcardType : iWildcardPrototype.getReturnTypes()) {
            IWildcardType iWildcardType3 = (IWildcardType)Lists.get(arrayList2, n4);
            if (iWildcardType3 != null && iWildcardType.isLessSpecializedThan(iWildcardType3)) {
                iDFA.add(iWildcardType3);
                ++n3;
                continue;
            }
            iDFA.add(iWildcardType);
        }
        if (n3 <= 0) {
            return false;
        }
        basicBlock22 = this.ctx.getWildcardTypeManager().createPrototype(iWildcardPrototype.getCallingConvention(), (List<IWildcardType>)((Object)iDFA), arrayList, iWildcardPrototype.getPrototypeAttributes());
        this.ctx.setPrototype((IWildcardPrototype)((Object)basicBlock22));
        return true;
    }
}

