/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.DefUseInfo;
import com.pnfsoftware.jeb.core.units.code.IVariable;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EDefUseInfo
extends DefUseInfo {
    public IERoutineContext ctx;
    private PotFilter potTester = new PotFilter();

    public EDefUseInfo() {
    }

    public EDefUseInfo(int n2, IERoutineContext iERoutineContext) {
        super(n2);
        if (iERoutineContext == null) {
            throw new IllegalArgumentException("Please provide an routine context or use the other constructor");
        }
        this.ctx = iERoutineContext;
    }

    public IERoutineContext getContext() {
        return this.ctx;
    }

    @Override
    public boolean shouldCollectPotentials() {
        return this.ctx != null && super.shouldCollectPotentials();
    }

    @Override
    public boolean shouldCollectSpoiled() {
        return this.ctx != null && super.shouldCollectSpoiled();
    }

    public void addDefined(IEVar iEVar) {
        this.def.add(iEVar);
    }

    public void addDefined(Collection<IEVar> collection) {
        this.def.addAll(collection);
    }

    public void addUsed(IEVar iEVar) {
        this.use.add(iEVar);
    }

    public void addUsed(Collection<IEVar> collection) {
        this.use.addAll(collection);
    }

    public void add(IEVar iEVar, boolean bl) {
        if (bl) {
            this.addDefined(iEVar);
        } else {
            this.addUsed(iEVar);
        }
    }

    public void add(Collection<IEVar> collection, boolean bl) {
        if (bl) {
            this.addDefined(collection);
        } else {
            this.addUsed(collection);
        }
    }

    public void addPotentialDefined(IEVar iEVar) {
        if (this.potTester.test(iEVar) && !this.def.containsVarFull(iEVar.getId())) {
            this.defpot.add(iEVar);
        }
    }

    public void addPotentialDefined(Collection<IEVar> collection) {
        collection = collection.stream().filter(this.potTester).collect(Collectors.toList());
        this.defpot.addAll((Collection<? extends IVariable>)collection, this.def);
    }

    public void addPotentialUsed(IEVar iEVar) {
        if (this.potTester.test(iEVar) && !this.use.containsVarFull(iEVar.getId())) {
            this.usepot.add(iEVar);
        }
    }

    public void addPotentialUsed(Collection<IEVar> collection) {
        collection = collection.stream().filter(this.potTester).collect(Collectors.toList());
        this.usepot.addAll((Collection<? extends IVariable>)collection, this.use);
    }

    public void addPotential(IEVar iEVar, boolean bl) {
        if (bl) {
            this.addPotentialDefined(iEVar);
        } else {
            this.addPotentialUsed(iEVar);
        }
    }

    public void addPotential(Collection<IEVar> collection, boolean bl) {
        if (bl) {
            this.addPotentialDefined(collection);
        } else {
            this.addPotentialUsed(collection);
        }
    }

    public void addSpoiled(IEVar iEVar) {
        if (!this.def.containsVarFull(iEVar.getId())) {
            this.spoiled.add(iEVar);
        }
    }

    public void addSpoiled(Collection<IEVar> collection) {
        this.spoiled.addAll(collection, this.def);
    }

    private static class PotFilter
    implements Predicate<IEVar> {
        private PotFilter() {
        }

        @Override
        public boolean test(IEVar iEVar) {
            return (iEVar.getFlags() & 0x60) == 0;
        }
    }
}

