/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFGFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableProvider;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ECFGFormatter
extends CFGFormatter<IEStatement> {
    private IERoutineContext ectx;
    private boolean hasStackDeltas;

    public ECFGFormatter(CFG<IEStatement> cFG) {
        super(cFG);
    }

    public ECFGFormatter(CFG<IEStatement> cFG, IVariableProvider iVariableProvider, boolean bl) {
        super(cFG, iVariableProvider, bl);
    }

    public void setContext(IERoutineContext iERoutineContext) {
        this.ectx = iERoutineContext;
    }

    @Override
    public String format(boolean bl, boolean bl2, boolean bl3, IDFA<IEStatement> iDFA, IFormattingContextFactory<IEStatement> iFormattingContextFactory) {
        this.hasStackDeltas = false;
        for (IEStatement iEStatement : this.getCfg().instructions()) {
            Integer n2 = iEStatement.getSPDelta();
            if (n2 == null) continue;
            this.hasStackDeltas = true;
            break;
        }
        return super.format(bl, bl2, bl3, iDFA, iFormattingContextFactory);
    }

    @Override
    protected void genPreAddress(StringBuilder stringBuilder, long l2, IEStatement iEStatement) {
        if (this.ectx == null) {
            return;
        }
        Collection<Long> collection = iEStatement.getLowerLevelAddresses();
        if (collection.isEmpty()) {
            return;
        }
        long l3 = collection.iterator().next();
        char c2 = collection.size() == 1 ? (char)'<' : '*';
        List<Long> list = this.ectx.getIntermediateOffsetsMappingToNativeAddresses(collection);
        Assert.a(list.contains(l2));
        char c3 = list.size() == 1 ? (char)'>' : '*';
        Strings.ff(stringBuilder, "%08X%c%c", l3, Character.valueOf(c2), Character.valueOf(c3));
    }

    @Override
    protected void genAddress(StringBuilder stringBuilder, long l2, IEStatement iEStatement) {
        Strings.ff(stringBuilder, "%04X/%X", l2, iEStatement.getSize());
    }

    @Override
    protected void genPostAddress(StringBuilder stringBuilder, long l2, IEStatement iEStatement) {
        if (this.hasStackDeltas) {
            Integer n2 = iEStatement.getSPDelta();
            if (n2 == null) {
                stringBuilder.append(" [?]");
            } else if (n2 <= 0) {
                Strings.ff(stringBuilder, " [%X]", -n2.intValue());
            } else {
                Strings.ff(stringBuilder, " [-%X]", n2);
            }
        }
        super.genPostAddress(stringBuilder, l2, iEStatement);
    }

    @Override
    protected void genPostInstruction(StringBuilder stringBuilder, long l2, IEStatement iEStatement) {
        int n2 = iEStatement.getFlags();
        if (n2 != 0) {
            stringBuilder.append("  [");
            if ((n2 & 4) != 0) {
                stringBuilder.append("PROLOGUE ");
            }
            if ((n2 & 8) != 0) {
                stringBuilder.append("EPILOGUE ");
            }
            if ((n2 & 1) != 0) {
                stringBuilder.append("NO_PROP ");
            }
            if ((n2 & 2) != 0) {
                stringBuilder.append("NO_SUBST ");
            }
            stringBuilder.append("]");
        }
        if (iEStatement instanceof IEAssign && ((IEAssign)iEStatement).isRoutineCall()) {
            stringBuilder.append("  [SUB]");
        }
        super.genPostInstruction(stringBuilder, l2, iEStatement);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void genEOL(StringBuilder stringBuilder, long l2, IEStatement iEStatement) {
        Iterable<Object> iterable;
        Collection<Object> collection = iEStatement.getBreakingFlow(l2);
        if (collection != null && collection.isBroken()) {
            if (collection.isBrokenKnown()) {
                Strings.ff(stringBuilder, "[BRK] ", new Object[0]);
            } else if (collection.isBrokenKnown()) {
                Strings.ff(stringBuilder, "[BRK-UNK] ", new Object[0]);
            } else {
                Strings.ff(stringBuilder, "[BRK-MIX] ", new Object[0]);
            }
        }
        if ((collection = iEStatement.getRoutineCall(l2)) != null && collection.isBroken()) {
            if (collection.isBrokenKnown()) {
                Strings.ff(stringBuilder, "[SUB] ", new Object[0]);
            } else if (collection.isBrokenKnown()) {
                Strings.ff(stringBuilder, "[SUB-UNK] ", new Object[0]);
            } else {
                Strings.ff(stringBuilder, "[SUB-MIX] ", new Object[0]);
            }
        }
        if ((iterable = this.getCfg().getBlockByLastAddress(l2)) != null) {
            Strings.ff(stringBuilder, "blk_ouputs={%s} ", Longs.formatHexCollection(((BasicBlock)iterable).getOutputOffsets()));
        }
        if (iEStatement instanceof IEAssign && ((IEAssign)iEStatement).isBranching()) {
            collection = ((IEAssign)iEStatement).getBranchDetails();
            if (collection != null) {
                stringBuilder.append("potential_targets={ ");
                int n2 = 0;
                for (IBranchTarget iBranchTarget : collection.getDynamicTargetCandidates()) {
                    if (n2 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(iBranchTarget.toString());
                    ++n2;
                }
                if (!collection.isIncludeUnknownTarget()) {
                    if (n2 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("unknown");
                }
                stringBuilder.append(" }");
            }
        } else if (iEStatement instanceof IEJumpFar) {
            collection = ((IEJumpFar)iEStatement).getPossibleTargets();
            if (collection != null && !collection.isEmpty()) {
                stringBuilder.append("potential_targets={ ");
                int n3 = 0;
                for (ICodePointer iCodePointer : collection) {
                    if (n3 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(iCodePointer.toString());
                    ++n3;
                }
                stringBuilder.append(" }");
            }
        } else if (iEStatement instanceof IECall) {
            collection = ((IECall)iEStatement).getSpoiledExpressions();
            if (collection != null && !collection.isEmpty()) {
                stringBuilder.append("spoiled={ ");
                int n4 = 0;
                for (IEGeneric iEGeneric : collection) {
                    if (n4 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(iEGeneric.format(iEStatement, l2));
                    ++n4;
                }
                stringBuilder.append(" }");
            }
        } else if (iEStatement instanceof IEUntranslatedInstruction) {
            Set<IEVar> set;
            collection = ((IEUntranslatedInstruction)iEStatement).getSideEffectDefinedVariables();
            if (collection != null && !collection.isEmpty()) {
                stringBuilder.append("idef={ ");
                int n5 = 0;
                for (IEGeneric object : collection) {
                    if (n5 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(object.format(iEStatement, l2));
                    ++n5;
                }
                stringBuilder.append(" }");
            }
            if ((iterable = ((IEUntranslatedInstruction)iEStatement).getSideEffectUsedVariables()) != null && !iterable.isEmpty()) {
                stringBuilder.append("iuse={ ");
                int n6 = 0;
                for (Object object : iterable) {
                    if (n6 >= 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(object.format(iEStatement, l2));
                    ++n6;
                }
                stringBuilder.append(" }");
            }
            if ((set = ((IEUntranslatedInstruction)iEStatement).getSideEffectSpoiledVariables()) != null && !set.isEmpty()) {
                stringBuilder.append("spoiled={ ");
                boolean bl = false;
                for (IEGeneric iEGeneric : set) {
                    void var8_23;
                    if (var8_23 >= true) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(iEGeneric.format(iEStatement, l2));
                    ++var8_23;
                }
                stringBuilder.append(" }");
            }
        }
        collection = iEStatement.getLowerLevelAddresses();
        if (collection.size() >= 2) {
            Strings.ff(stringBuilder, "  ADD.LLA[%s]", Longs.formatHexCollection(new ArrayList<Object>(collection).subList(1, collection.size())));
        }
        super.genEOL(stringBuilder, l2, iEStatement);
    }
}

