/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEBranchDetails;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.PreRoutineInvocationDetails;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.SPDC;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.SPDDeterminer;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Ser
public class EBranchDetails
implements IEBranchDetails {
    @SerId(value=1)
    private List<IEVar> def;
    @SerId(value=2)
    private List<IEVar> use;
    @SerId(value=3)
    private List<IEVar> spoiled;
    @SerId(value=4)
    private List<IBranchTarget> dynamicTargetCandidates;
    @SerId(value=5)
    private boolean includeUnknownTarget;
    @SerId(value=6)
    private SPDDeterminer spdd = new SPDDeterminer();
    @SerId(value=7)
    private IPrototypeItem nativePrototypeHint;
    @SerId(value=8)
    private PreRoutineInvocationDetails preInvocationDetails;

    public EBranchDetails(List<IEVar> list, List<IEVar> list2, List<IEVar> list3, int n2, IPrototypeItem iPrototypeItem, List<IBranchTarget> list4) {
        this.def = list == null ? new ArrayList<IEVar>() : new ArrayList<IEVar>(list);
        this.use = list2 == null ? new ArrayList<IEVar>() : new ArrayList<IEVar>(list2);
        this.spoiled = list3 == null ? new ArrayList<IEVar>() : new ArrayList<IEVar>(list3);
        this.spdd.add(n2, 0, 0);
        this.nativePrototypeHint = iPrototypeItem;
        this.dynamicTargetCandidates = list4 == null ? new ArrayList<IBranchTarget>() : new ArrayList<IBranchTarget>(list4);
    }

    public EBranchDetails() {
        this(null, null, null, 0, null, null);
    }

    public EBranchDetails(IEBranchDetails iEBranchDetails) {
        this.def = new ArrayList<IEVar>(iEBranchDetails.getDef());
        this.use = new ArrayList<IEVar>(iEBranchDetails.getUse());
        this.spoiled = new ArrayList<IEVar>(iEBranchDetails.getSpoiled());
        this.dynamicTargetCandidates = new ArrayList<IBranchTarget>(iEBranchDetails.getDynamicTargetCandidates());
        this.includeUnknownTarget = iEBranchDetails.isIncludeUnknownTarget();
        this.nativePrototypeHint = iEBranchDetails.getNativePrototypeHint();
        this.spdd = iEBranchDetails.getStackPointerDeltaDeterminer().clone();
    }

    @Override
    public List<IEVar> getDef() {
        return Collections.unmodifiableList(this.def);
    }

    @Override
    public List<IEVar> getUse() {
        return Collections.unmodifiableList(this.use);
    }

    @Override
    public List<IEVar> getSpoiled() {
        return Collections.unmodifiableList(this.spoiled);
    }

    @Override
    public SPDDeterminer getStackPointerDeltaDeterminer() {
        return this.spdd;
    }

    @Override
    public SPDC getStackPointerDelta() {
        return this.spdd.getBestCandidate();
    }

    @Override
    public int getStackPointerDeltaValue() {
        return this.spdd.getBestValue();
    }

    @Override
    public List<IBranchTarget> getDynamicTargetCandidates() {
        return Collections.unmodifiableList(this.dynamicTargetCandidates);
    }

    @Override
    public boolean addCandidate(IBranchTarget iBranchTarget) {
        return this.addCandidate(this.dynamicTargetCandidates.size(), iBranchTarget);
    }

    @Override
    public boolean addCandidate(int n2, IBranchTarget iBranchTarget) {
        if (n2 < 0) {
            n2 += this.dynamicTargetCandidates.size() + 1;
        }
        if (this.dynamicTargetCandidates.contains(iBranchTarget)) {
            return false;
        }
        if (iBranchTarget.isInternal()) {
            ICodePointer iCodePointer = iBranchTarget.getInternalAddress();
            for (int i = 0; i < this.dynamicTargetCandidates.size(); ++i) {
                ICodePointer iCodePointer2;
                IBranchTarget iBranchTarget2 = this.dynamicTargetCandidates.get(i);
                if (!iBranchTarget2.isInternal() || (iCodePointer2 = iBranchTarget2.getInternalAddress()).getAddress() != iCodePointer.getAddress()) continue;
                if (iCodePointer.getMode() == 0) {
                    return false;
                }
                if (iCodePointer2.getMode() == 0) {
                    this.dynamicTargetCandidates.set(i, iBranchTarget);
                    return true;
                }
                throw new RuntimeException(Strings.ff("Invalid candidate has conflict processor modes (%d vs %d) with existing target %xh", iCodePointer.getMode(), iCodePointer2.getMode(), iCodePointer2.getAddress()));
            }
        }
        this.dynamicTargetCandidates.add(n2, iBranchTarget);
        return true;
    }

    @Override
    public boolean addCandidates(List<? extends IBranchTarget> list) {
        int n2 = 0;
        for (IBranchTarget iBranchTarget : list) {
            if (!this.addCandidate(iBranchTarget)) continue;
            ++n2;
        }
        return n2 > 0;
    }

    @Override
    public boolean setIncludeUnknownTarget(boolean bl) {
        if (this.includeUnknownTarget == bl) {
            return false;
        }
        this.includeUnknownTarget = bl;
        return true;
    }

    @Override
    public boolean isIncludeUnknownTarget() {
        return this.includeUnknownTarget;
    }

    @Override
    public IPrototypeItem getNativePrototypeHint() {
        return this.nativePrototypeHint;
    }

    @Override
    public boolean setNativePrototypeHint(IPrototypeItem iPrototypeItem) {
        if (this.nativePrototypeHint == iPrototypeItem) {
            return false;
        }
        this.nativePrototypeHint = iPrototypeItem;
        return true;
    }

    @Override
    public PreRoutineInvocationDetails getPreInvocationDetails() {
        return this.preInvocationDetails;
    }

    @Override
    public boolean setPreInvocationDetails(PreRoutineInvocationDetails preRoutineInvocationDetails) {
        if (this.preInvocationDetails == preRoutineInvocationDetails) {
            return false;
        }
        this.preInvocationDetails = preRoutineInvocationDetails;
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.use == null ? 0 : this.use.hashCode());
        n2 = 31 * n2 + (this.def == null ? 0 : this.def.hashCode());
        n2 = 31 * n2 + (this.spoiled == null ? 0 : this.spoiled.hashCode());
        n2 = 31 * n2 + (this.dynamicTargetCandidates == null ? 0 : this.dynamicTargetCandidates.hashCode());
        n2 = 31 * n2 + (this.nativePrototypeHint == null ? 0 : this.nativePrototypeHint.hashCode());
        n2 = 31 * n2 + (this.spdd == null ? 0 : this.spdd.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EBranchDetails eBranchDetails = (EBranchDetails)object;
        if (this.use == null ? eBranchDetails.use != null : !this.use.equals(eBranchDetails.use)) {
            return false;
        }
        if (this.def == null ? eBranchDetails.def != null : !this.def.equals(eBranchDetails.def)) {
            return false;
        }
        if (this.spoiled == null ? eBranchDetails.spoiled != null : !this.spoiled.equals(eBranchDetails.spoiled)) {
            return false;
        }
        if (this.dynamicTargetCandidates == null ? eBranchDetails.dynamicTargetCandidates != null : !this.dynamicTargetCandidates.equals(eBranchDetails.dynamicTargetCandidates)) {
            return false;
        }
        if (this.nativePrototypeHint == null ? eBranchDetails.nativePrototypeHint != null : !this.nativePrototypeHint.equals(eBranchDetails.nativePrototypeHint)) {
            return false;
        }
        return !(this.spdd == null ? eBranchDetails.spdd != null : !this.spdd.equals(eBranchDetails.spdd));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "def=%s,use=%s,spoiled=%s", this.def, this.use, this.spoiled);
        Strings.ff(stringBuilder, ",spdd=%s", this.spdd);
        if (!this.dynamicTargetCandidates.isEmpty()) {
            Strings.ff(stringBuilder, ",targets=%s", this.dynamicTargetCandidates);
        }
        if (this.nativePrototypeHint != null) {
            Strings.ff(stringBuilder, ",protoHint=%s", this.nativePrototypeHint);
        }
        return stringBuilder.toString();
    }
}

