/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AddressConversionLists {
    Map<Long, Integer> nativeToInter;
    Map<Integer, Long> interToNative;

    public AddressConversionLists(Map<Long, Integer> map, Map<Integer, Long> map2) {
        if (map == null) {
            map = new HashMap<Long, Integer>();
        }
        if (map2 == null) {
            map2 = new HashMap<Integer, Long>();
        }
        this.nativeToInter = map;
        this.interToNative = map2;
    }

    public void record(long l2, int n2) {
        if (this.nativeToInter.get(l2) == null) {
            this.nativeToInter.put(l2, n2);
        }
        if (this.interToNative.get(n2) == null) {
            this.interToNative.put(n2, l2);
        }
    }

    public Map<Long, Integer> getNativeToInter() {
        return this.nativeToInter;
    }

    public Integer convertNativeAddress(long l2) {
        return this.nativeToInter.get(l2);
    }

    public Map<Integer, Long> getInterToNative() {
        return this.interToNative;
    }

    public Long convertIntermediateOffset(int n2) {
        return this.interToNative.get(n2);
    }

    public List<Integer> getIntermediateOffsetsMappingToNativeAddress(long l2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, Long> entry : this.interToNative.entrySet()) {
            if (entry.getValue() != l2) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public List<Long> getNativeAddressesMappingToIntermediateOffset(int n2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Map.Entry<Long, Integer> entry : this.nativeToInter.entrySet()) {
            if (entry.getValue() != n2) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public String toString() {
        return AddressConversionLists.formatConversionLists(this.interToNative, this.nativeToInter);
    }

    public static String formatConversionLists(Map<Integer, Long> map, Map<Long, Integer> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            stringBuilder.append("IR to Native:\n");
            for (Map.Entry<Number, Number> entry : new TreeMap<Integer, Long>(map).entrySet()) {
                Strings.ff(stringBuilder, "%X->%X\n", entry.getKey(), entry.getValue());
            }
        }
        if (map2 != null) {
            stringBuilder.append("Native to IR:\n");
            for (Map.Entry<Number, Number> entry : new TreeMap<Long, Integer>(map2).entrySet()) {
                Strings.ff(stringBuilder, "%X->%X\n", entry.getKey(), entry.getValue());
            }
        }
        return stringBuilder.toString();
    }

    public static AddressConversionLists generateFromCFG(CFG<IEStatement> cFG) {
        if (cFG.getFirstAddress() != 0L || cFG.getEntryAddress() != 0L) {
            throw new IllegalArgumentException();
        }
        return AddressConversionLists.generate(cFG.addressableInstructions());
    }

    public static AddressConversionLists generateFromList(List<IEStatement> list) {
        ArrayList<AddressableInstruction<IEStatement>> arrayList = new ArrayList<AddressableInstruction<IEStatement>>(list.size());
        int n2 = 0;
        for (IEStatement iEStatement : list) {
            arrayList.add(new AddressableInstruction<IEStatement>(n2, iEStatement));
            n2 += iEStatement.getSize();
        }
        return AddressConversionLists.generate(arrayList);
    }

    private static AddressConversionLists generate(Iterable<AddressableInstruction<IEStatement>> iterable) {
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        TreeMap<Integer, Long> treeMap2 = new TreeMap<Integer, Long>();
        for (AddressableInstruction<IEStatement> addressableInstruction : iterable) {
            int n2 = (int)addressableInstruction.getOffset();
            IEStatement iEStatement = addressableInstruction.getInstruction();
            Collection<Long> collection = iEStatement.getLowerLevelAddresses();
            collection.isEmpty();
            int n3 = 0;
            for (Long l2 : collection) {
                if (n3 == 0 && treeMap2.put(n2, l2) != null) {
                    throw new RuntimeException();
                }
                Integer n4 = treeMap.put(l2, n2);
                if (n4 != null && n4 < n2) {
                    treeMap.put(l2, n4);
                }
                ++n3;
            }
            iEStatement.getSize();
        }
        return new AddressConversionLists(treeMap, treeMap2);
    }
}

