/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CEnvironment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CMethodSimulator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CMethodState;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.ahy;
import java.util.ArrayList;
import java.util.List;

public class CSimulationLogger {
    private List<ICStatement> stmtsFlatList;
    private List<Integer> executionTrace;
    private CMethodState finalState;
    private CEnvironment finalEnvironment;

    public CSimulationLogger(CMethodSimulator cMethodSimulator) {
        this.stmtsFlatList = cMethodSimulator.getStmtsFlatList();
        this.executionTrace = new ArrayList<Integer>();
    }

    public void logExecutedIndex(int n2) {
        this.executionTrace.add(n2);
    }

    public void setFinalState(CMethodState cMethodState) {
        this.finalState = cMethodState;
    }

    public CMethodState getFinalState() {
        return this.finalState;
    }

    public List<Integer> getExecutionTrace() {
        return this.executionTrace;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CSimulationResult:");
        stringBuilder.append(Strings.LINESEP);
        stringBuilder.append("   final state: ");
        stringBuilder.append(this.finalState);
        stringBuilder.append(Strings.LINESEP);
        stringBuilder.append("   ");
        stringBuilder.append("executionTrace: ");
        stringBuilder.append(Strings.LINESEP);
        for (Integer n2 : this.executionTrace) {
            stringBuilder.append("      ");
            stringBuilder.append(n2);
            stringBuilder.append(" ");
            ICStatement iCStatement = this.finalState.getStatements().get(n2);
            if (!(iCStatement instanceof ahy)) {
                stringBuilder.append(iCStatement);
            }
            stringBuilder.append(Strings.LINESEP);
        }
        stringBuilder.append("   final environment:");
        stringBuilder.append(Strings.LINESEP);
        stringBuilder.append(this.finalEnvironment);
        return stringBuilder.toString();
    }

    public List<ICStatement> getStmtsFlatList() {
        return this.stmtsFlatList;
    }

    public CEnvironment getFinalEnvironment() {
        return this.finalEnvironment;
    }

    public void setFinalEnvironment(CEnvironment cEnvironment) {
        this.finalEnvironment = cEnvironment;
    }
}

