/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDecl;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIdentifier;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CEnvironment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CSimulationException;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CMethodState {
    private static final StructuredLogger logger = aeb.ce(CMethodState.class);
    private final List<ICStatement> statements;
    private ControlWord controlWord;
    private int controlWordIndex;
    private Map<ICIdentifier, Long> localVarValues = new HashMap<ICIdentifier, Long>();
    private Long returnValue;
    private boolean methodParametersSpoiled = true;

    public CMethodState(List<ICStatement> list) {
        this.statements = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(ICElement iCElement, Long l2, CEnvironment cEnvironment) {
        ICIdentifier iCIdentifier = this.getIdentifier(iCElement);
        if (iCIdentifier == null) throw new CSimulationException(Strings.ff("cannot set value (%s)", iCElement));
        if (iCIdentifier.getIdentifierClass().isLocal()) {
            this.localVarValues.put(iCIdentifier, l2);
            return;
        } else {
            if (!iCIdentifier.getIdentifierClass().isGlobal()) throw new CSimulationException(Strings.ff("cannot set value (%s)", iCElement));
            cEnvironment.setGlobalVarValue(iCIdentifier, l2);
        }
    }

    public void setLocalVarValue(ICIdentifier iCIdentifier, Long l2) {
        this.localVarValues.put(iCIdentifier, l2);
    }

    public ICIdentifier getIdentifier(ICElement iCElement) {
        if (iCElement instanceof ICIdentifier) {
            return (ICIdentifier)iCElement;
        }
        if (iCElement instanceof ICDecl) {
            return ((ICDecl)iCElement).getIdentifier();
        }
        return null;
    }

    public Long getLocalVarValue(ICElement iCElement) {
        return this.localVarValues.get(iCElement);
    }

    public List<ICStatement> getStatements() {
        return this.statements;
    }

    public static boolean areEquivalent(CMethodState cMethodState, CMethodState cMethodState2, boolean bl, boolean bl2) {
        if (!CMethodState.areReturnValuesTheSame(cMethodState, cMethodState2)) {
            return false;
        }
        if (bl && !CMethodState.areSameValuesProduced(cMethodState, cMethodState2)) {
            return false;
        }
        return !bl2 || CMethodState.areControlWordsTheSame(cMethodState, cMethodState2);
    }

    private static boolean areControlWordsTheSame(CMethodState cMethodState, CMethodState cMethodState2) {
        return cMethodState.getControlWord().equals((Object)cMethodState2.getControlWord());
    }

    private static boolean areReturnValuesTheSame(CMethodState cMethodState, CMethodState cMethodState2) {
        return cMethodState.getReturnValue() == null && cMethodState2.getReturnValue() == null || cMethodState.getReturnValue() != null && cMethodState.getReturnValue().equals(cMethodState2.getReturnValue());
    }

    private static boolean areSameValuesProduced(CMethodState cMethodState, CMethodState cMethodState2) {
        HashSet<Long> hashSet = new HashSet<Long>(cMethodState.getLocalVarValues().values());
        hashSet.add(cMethodState.getReturnValue());
        HashSet<Long> hashSet2 = new HashSet<Long>(cMethodState2.getLocalVarValues().values());
        hashSet2.add(cMethodState2.getReturnValue());
        return hashSet.equals(hashSet2);
    }

    public ControlWord getControlWord() {
        return this.controlWord;
    }

    public void setControlWord(ControlWord controlWord) {
        this.controlWord = controlWord;
    }

    public String toString() {
        return "CMethodState [controlWord=" + this.controlWord + ", values=" + this.localVarValues + ", ret_val=" + this.returnValue + "]";
    }

    public Long getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Long l2) {
        this.returnValue = l2;
    }

    public Map<ICIdentifier, Long> getLocalVarValues() {
        return this.localVarValues;
    }

    public int getControlWordIndex() {
        return this.controlWordIndex;
    }

    public void setControlWordIndex(int n2) {
        this.controlWordIndex = n2;
    }

    public boolean isMethodParametersSpoiled() {
        return this.methodParametersSpoiled;
    }

    public void setMethodParametersSpoiled(boolean bl) {
        this.methodParametersSpoiled = bl;
    }

    public static enum ControlWord {
        GOTO_NEXT_INS,
        GOTO_END_OF_METHOD,
        SKIP_NEXT_BLOCK,
        GOTO_PREV_BLOCK,
        GOTO_INDEX;

    }
}

