/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBreak;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICContinue;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDecl;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGoto;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICLabel;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CEnvironment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CMethodState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CSimulationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CSimulationLogger;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.ahg;
import com.pnfsoftware.jebglobal.ahh;
import com.pnfsoftware.jebglobal.ahi;
import com.pnfsoftware.jebglobal.ahj;
import com.pnfsoftware.jebglobal.ahk;
import com.pnfsoftware.jebglobal.ahl;
import com.pnfsoftware.jebglobal.ahm;
import com.pnfsoftware.jebglobal.ahn;
import com.pnfsoftware.jebglobal.aho;
import com.pnfsoftware.jebglobal.ahp;
import com.pnfsoftware.jebglobal.ahs;
import com.pnfsoftware.jebglobal.aht;
import com.pnfsoftware.jebglobal.ahu;
import com.pnfsoftware.jebglobal.ahv;
import com.pnfsoftware.jebglobal.ahw;
import com.pnfsoftware.jebglobal.ahx;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMethodSimulator {
    private int traceMaxSize = 0x1000000;
    private final CEnvironment environment;
    private final List<ICStatement> stmtsFlatList;
    private final boolean strictMode;
    private Map<Integer, Integer> uncondBranchTo = new HashMap<Integer, Integer>();

    public CMethodSimulator(ICMethod iCMethod, CEnvironment cEnvironment) {
        this(iCMethod, cEnvironment, true);
    }

    public CMethodSimulator(ICMethod iCMethod, CEnvironment cEnvironment, int n2) {
        this(iCMethod, cEnvironment, true);
        this.traceMaxSize = n2;
    }

    public CMethodSimulator(ICMethod iCMethod, CEnvironment cEnvironment, boolean bl) {
        Assert.a(iCMethod != null && cEnvironment != null);
        this.stmtsFlatList = iCMethod.toFlatList();
        this.environment = cEnvironment;
        this.strictMode = bl;
        if (!this.strictMode) {
            this.setFlexibleMode(cEnvironment);
        }
        this.setParametersValues(iCMethod, cEnvironment);
    }

    private void setFlexibleMode(CEnvironment cEnvironment) {
        cEnvironment.setDefaultPointedSize(4);
        cEnvironment.setAutoGenerateUndefinedIdentifierValue(true);
    }

    private void setParametersValues(ICMethod iCMethod, CEnvironment cEnvironment) {
        if (iCMethod.getParameters() != null) {
            for (ICDecl iCDecl : iCMethod.getParameters()) {
                if (cEnvironment.isParameterValueSet(iCDecl.getIdentifier())) continue;
                cEnvironment.setAutoGeneratedParameterValue(iCDecl.getIdentifier());
            }
        }
    }

    public CSimulationLogger simulate() {
        CMethodState cMethodState = new CMethodState(this.stmtsFlatList);
        return this.simulate(cMethodState);
    }

    public CSimulationLogger simulate(CMethodState cMethodState) {
        Assert.a(cMethodState != null);
        this.buildUnconditionalControlFlow();
        CSimulationLogger cSimulationLogger = new CSimulationLogger(this);
        CMethodState cMethodState2 = cMethodState;
        int n2 = 0;
        while (this.isNotTerminated(n2)) {
            n2 = this.visitUncondBranches(n2, cSimulationLogger);
            this.emulateStatement(n2, cMethodState2, cSimulationLogger);
            n2 = this.updateControlFlow(n2, cMethodState2);
        }
        cSimulationLogger.setFinalState(cMethodState2);
        cSimulationLogger.setFinalEnvironment(CEnvironment.copy(this.environment));
        return cSimulationLogger;
    }

    private boolean isNotTerminated(int n2) {
        return n2 < this.stmtsFlatList.size();
    }

    private void registerExecutedAddress(int n2, CSimulationLogger cSimulationLogger) {
        this.checkForInfiniteLoop(cSimulationLogger);
        cSimulationLogger.logExecutedIndex(n2);
    }

    private void checkForInfiniteLoop(CSimulationLogger cSimulationLogger) {
        if (cSimulationLogger.getExecutionTrace().size() >= this.traceMaxSize) {
            throw new CSimulationException("simulation too long");
        }
    }

    private int visitUncondBranches(int n2, CSimulationLogger cSimulationLogger) {
        int n3 = n2;
        while (this.uncondBranchTo.containsKey(n3)) {
            this.registerExecutedAddress(n3, cSimulationLogger);
            n3 = this.uncondBranchTo.get(n3);
        }
        return n3;
    }

    private void emulateStatement(int n2, CMethodState cMethodState, CSimulationLogger cSimulationLogger) {
        ICStatement iCStatement = this.stmtsFlatList.get(n2);
        if (iCStatement != null) {
            Long l2 = iCStatement.evaluate(cMethodState, this.environment);
            this.registerExecutedAddress(n2, cSimulationLogger);
            if (iCStatement instanceof ahs) {
                this.processSwitchControlFlow(n2, cMethodState, (ahs)iCStatement, BigInteger.valueOf(l2));
            }
        } else {
            throw new CSimulationException("no statement at this index");
        }
    }

    private void processSwitchControlFlow(int n2, CMethodState cMethodState, ahs ahs2, BigInteger bigInteger) {
        cMethodState.setControlWord(CMethodState.ControlWord.GOTO_INDEX);
        Integer n3 = this.findCorrespondingSwitchCase(n2, bigInteger);
        if (n3 != null) {
            cMethodState.setControlWordIndex(n3);
        } else {
            cMethodState.setControlWordIndex(this.findCorrespondingSwitchEnd(n2));
        }
    }

    private int updateControlFlow(int n2, CMethodState cMethodState) {
        int n3 = n2;
        CMethodState.ControlWord controlWord = cMethodState.getControlWord();
        switch (controlWord) {
            case GOTO_END_OF_METHOD: {
                n3 = this.stmtsFlatList.size();
                break;
            }
            case GOTO_NEXT_INS: {
                ++n3;
                break;
            }
            case SKIP_NEXT_BLOCK: {
                n3 = this.findCorrespondingBlockEnd(n2 + 1) + 1;
                break;
            }
            case GOTO_PREV_BLOCK: {
                n3 = this.findCorrespondingBlockStart(n2 - 1);
                break;
            }
            case GOTO_INDEX: {
                n3 = cMethodState.getControlWordIndex();
                break;
            }
            default: {
                throw new CSimulationException(Strings.ff("TBI: control-word (%s)", new Object[]{controlWord}));
            }
        }
        return n3;
    }

    public static boolean areEquivalentSimulations(CSimulationLogger cSimulationLogger, CSimulationLogger cSimulationLogger2) {
        if (!CMethodState.areEquivalent(cSimulationLogger.getFinalState(), cSimulationLogger2.getFinalState(), true, true)) {
            return false;
        }
        if (!CEnvironment.areEquivalent(cSimulationLogger.getFinalEnvironment(), cSimulationLogger2.getFinalEnvironment())) {
            return false;
        }
        return CMethodSimulator.areMethodCallsTheSame(cSimulationLogger, cSimulationLogger2);
    }

    private static boolean areMethodCallsTheSame(CSimulationLogger cSimulationLogger, CSimulationLogger cSimulationLogger2) {
        List<String> list = CMethodSimulator.extractMethodCallNames(cSimulationLogger);
        List<String> list2 = CMethodSimulator.extractMethodCallNames(cSimulationLogger2);
        return list.equals(list2);
    }

    private static List<String> extractMethodCallNames(CSimulationLogger cSimulationLogger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n2 : cSimulationLogger.getExecutionTrace()) {
            ICMethod iCMethod;
            ICStatement iCStatement = cSimulationLogger.getStmtsFlatList().get(n2);
            if (!(iCStatement instanceof ICCall) || (iCMethod = ((ICCall)iCStatement).getMethod()) == null) continue;
            arrayList.add(iCMethod.getName());
        }
        return arrayList;
    }

    private int findCorrespondingBlockEnd(int n2) {
        Assert.a(this.stmtsFlatList.get(n2) instanceof ahg);
        int n3 = 0;
        int n4 = n2;
        while (true) {
            ICStatement iCStatement;
            if ((iCStatement = this.stmtsFlatList.get(n4)) instanceof ahg) {
                ++n3;
            }
            if (iCStatement instanceof ahh && --n3 == 0) break;
            ++n4;
        }
        return n4;
    }

    private int findCorrespondingBlockStart(int n2) {
        ICStatement iCStatement;
        Assert.a(this.stmtsFlatList.get(n2) instanceof ahh);
        int n3 = 0;
        int n4 = n2;
        while (!((iCStatement = this.stmtsFlatList.get(n4)) instanceof ahg) || --n3 != 0) {
            if (iCStatement instanceof ahh) {
                ++n3;
            }
            --n4;
        }
        return n4;
    }

    private int findCorrespondingSwitchEnd(int n2) {
        Assert.a(this.stmtsFlatList.get(n2) instanceof ahs);
        int n3 = 0;
        int n4 = n2;
        while (true) {
            ICStatement iCStatement;
            if ((iCStatement = this.stmtsFlatList.get(n4)) instanceof ahs) {
                ++n3;
            }
            if (iCStatement instanceof ahv && --n3 == 0) break;
            ++n4;
        }
        return n4;
    }

    private Integer findCorrespondingSwitchCase(int n2, BigInteger bigInteger) {
        Assert.a(this.stmtsFlatList.get(n2) instanceof ahs);
        int n3 = 0;
        int n4 = n2 + 1;
        while (true) {
            ICStatement iCStatement;
            if ((iCStatement = this.stmtsFlatList.get(n4)) instanceof ahs) {
                ++n3;
            }
            if (iCStatement instanceof ahv && --n3 < 0) {
                return null;
            }
            if (iCStatement instanceof aht && n3 == 0 && ((aht)iCStatement).mm().contains(bigInteger) || iCStatement instanceof ahu && n3 == 0) break;
            ++n4;
        }
        return n4;
    }

    private void buildUnconditionalControlFlow() {
        this.buildGotoUncondBranches();
        this.buildIfsUncondBranches();
        this.buildLoopsSwitchesUncondBranches();
    }

    private void buildGotoUncondBranches() {
        HashMap<ICLabel, Integer> hashMap = new HashMap<ICLabel, Integer>();
        int n2 = 0;
        for (ICStatement iCStatement : this.stmtsFlatList) {
            if (iCStatement instanceof ICLabel) {
                Assert.a(!hashMap.containsKey(iCStatement));
                hashMap.put((ICLabel)iCStatement, n2);
            }
            ++n2;
        }
        n2 = 0;
        for (ICStatement iCStatement : this.stmtsFlatList) {
            if (iCStatement instanceof ICGoto) {
                ICLabel iCLabel = ((ICGoto)iCStatement).getLabel();
                Assert.a(hashMap.containsKey(iCLabel));
                this.uncondBranchTo.put(n2, (Integer)hashMap.get(iCLabel));
            }
            ++n2;
        }
    }

    private void buildIfsUncondBranches() {
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        HashMap hashMap = new HashMap();
        int n2 = 0;
        for (ICStatement iCStatement : this.stmtsFlatList) {
            if (iCStatement instanceof ahm) {
                arrayDeque.push(n2);
                hashMap.put(n2, new ArrayList());
            } else if (iCStatement instanceof ahp) {
                Assert.a(!arrayDeque.isEmpty());
                Integer n3 = (Integer)arrayDeque.pop();
                for (Integer n4 : (List)hashMap.get(n3)) {
                    this.uncondBranchTo.put(n4, n2);
                }
            } else if (iCStatement instanceof ahn || iCStatement instanceof aho) {
                Assert.a(!arrayDeque.isEmpty());
                Assert.a(this.stmtsFlatList.get(n2 - 1) instanceof ahh);
                ((List)hashMap.get(arrayDeque.peek())).add(n2 - 1);
            }
            ++n2;
        }
    }

    private void buildLoopsSwitchesUncondBranches() {
        int n2 = 0;
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        ArrayDeque<Integer> arrayDeque2 = new ArrayDeque<Integer>();
        for (ICStatement iCStatement : this.stmtsFlatList) {
            int n3;
            if (iCStatement instanceof ahw || iCStatement instanceof ahk) {
                n3 = this.findCorrespondingBlockEnd(n2 + 1);
                this.uncondBranchTo.put(n3, n2);
                arrayDeque.push(n3);
                arrayDeque2.push(n3);
            }
            if (iCStatement instanceof ahi) {
                n3 = this.findCorrespondingBlockEnd(n2 + 1);
                arrayDeque.push(n3);
                arrayDeque2.push(n3);
            }
            if (iCStatement instanceof ahs) {
                n3 = this.findCorrespondingSwitchEnd(n2);
                arrayDeque2.push(n3 - 1);
            }
            if (iCStatement instanceof ICBreak) {
                this.uncondBranchTo.put(n2, (Integer)arrayDeque2.peek() + 2);
            }
            if (iCStatement instanceof ICContinue) {
                this.uncondBranchTo.put(n2, (Integer)arrayDeque.peek());
            }
            if (iCStatement instanceof ahx || iCStatement instanceof ahl || iCStatement instanceof ahj) {
                arrayDeque.pop();
                arrayDeque2.pop();
            }
            if (iCStatement instanceof ahv) {
                arrayDeque2.pop();
            }
            ++n2;
        }
    }

    public List<ICStatement> getStmtsFlatList() {
        return this.stmtsFlatList;
    }
}

