/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CIdentifierClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIdentifier;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.simulator.CSimulationException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CEnvironment {
    private static final long ROUTINE_CALL_DEFAULT_RETURN_VALUE = 7L;
    private static final long ARGUMENT_DEFAULT_VALUE = 13L;
    private Map<String, Long> parameterValues = new HashMap<String, Long>();
    private Map<String, Long> rtnReturnValues = new HashMap<String, Long>();
    private Map<String, Long> memoryAddress = new HashMap<String, Long>();
    private INativeCodeUnit<?> nativeUnit;
    private ITypeManager typeManager;
    private Endianness endianness;
    private Integer defaultPointedSize;
    private boolean autoGenerateUndefinedIdentifierValue;
    private long routinePassedParametersValue = 13L;
    private Map<Long, Long> dummyWrittenMemory = new HashMap<Long, Long>();
    private Map<Long, Long> globalVarValues = new HashMap<Long, Long>();

    public CEnvironment(INativeCodeUnit<?> iNativeCodeUnit) {
        if (iNativeCodeUnit != null) {
            this.nativeUnit = iNativeCodeUnit;
            this.endianness = iNativeCodeUnit.getProcessor().getEndianness();
            this.typeManager = iNativeCodeUnit.getTypeManager();
        }
    }

    public static CEnvironment copy(CEnvironment cEnvironment) {
        CEnvironment cEnvironment2 = new CEnvironment(cEnvironment.nativeUnit);
        cEnvironment2.nativeUnit = cEnvironment.nativeUnit;
        cEnvironment2.endianness = cEnvironment.endianness;
        cEnvironment2.typeManager = cEnvironment.typeManager;
        cEnvironment2.parameterValues = cEnvironment.parameterValues;
        cEnvironment2.rtnReturnValues = cEnvironment.rtnReturnValues;
        cEnvironment2.defaultPointedSize = cEnvironment.defaultPointedSize;
        cEnvironment2.autoGenerateUndefinedIdentifierValue = cEnvironment.autoGenerateUndefinedIdentifierValue;
        cEnvironment2.globalVarValues = new HashMap<Long, Long>(cEnvironment.globalVarValues);
        cEnvironment2.dummyWrittenMemory = new HashMap<Long, Long>(cEnvironment.dummyWrittenMemory);
        return cEnvironment2;
    }

    public int getBaseTypeSize(ICType iCType) {
        String string = iCType.getSignature();
        if (string.endsWith("*")) {
            INativeType iNativeType = this.typeManager.getType(iCType.getBaseTypeSignature());
            if (iNativeType == null) {
                throw new CSimulationException(Strings.ff("unknown base type (%s)", string));
            }
            return iNativeType.getSize();
        }
        if (this.defaultPointedSize != null) {
            return this.defaultPointedSize;
        }
        throw new CSimulationException(Strings.ff("not a pointer type (%s)", string));
    }

    public int getTypeSize(ICType iCType) {
        String string = iCType.getSignature();
        INativeType iNativeType = this.typeManager.getType(string);
        if (iNativeType == null) {
            throw new CSimulationException(Strings.ff("unknown type (%s)", string));
        }
        return iNativeType.getSize();
    }

    public void setParameterValue(ICIdentifier iCIdentifier, long l2) {
        this.parameterValues.put(iCIdentifier.getName(), l2);
    }

    public void setAutoGeneratedParameterValue(ICIdentifier iCIdentifier) {
        this.parameterValues.put(iCIdentifier.getName(), this.generateParameterValue(iCIdentifier.getType()));
    }

    public boolean isParameterValueSet(ICIdentifier iCIdentifier) {
        return this.parameterValues.containsKey(iCIdentifier.getName());
    }

    public Long getParameterValue(ICIdentifier iCIdentifier) {
        return this.getParameterValue(iCIdentifier, this.autoGenerateUndefinedIdentifierValue);
    }

    public Long getParameterValue(ICIdentifier iCIdentifier, boolean bl) {
        Long l2 = this.parameterValues.get(iCIdentifier.getName());
        if (l2 == null && bl) {
            this.setAutoGeneratedParameterValue(iCIdentifier);
            l2 = this.parameterValues.get(iCIdentifier.getName());
        }
        return l2;
    }

    private Long generateParameterValue(ICType iCType) {
        return 13L;
    }

    public void setRoutineReturnValue(ICMethod iCMethod, long l2) {
        this.rtnReturnValues.put(iCMethod.getName(), l2);
    }

    public void setAutoGeneratedRoutineReturnValue(ICMethod iCMethod) {
        String string = iCMethod.getName();
        this.rtnReturnValues.put(string, this.generateRoutineReturnValue(string));
    }

    public Long getRoutineReturnValue(ICMethod iCMethod, boolean bl) {
        String string = iCMethod.getName();
        Long l2 = this.rtnReturnValues.get(string);
        if (l2 == null && bl) {
            this.setAutoGeneratedRoutineReturnValue(iCMethod);
            l2 = this.rtnReturnValues.get(string);
        }
        return l2;
    }

    public Long getRoutineDefaultReturnValue() {
        return 7L;
    }

    private Long generateRoutineReturnValue(String string) {
        return this.getRoutineDefaultReturnValue();
    }

    public void setGlobalVarValue(ICIdentifier iCIdentifier, long l2) {
        this.globalVarValues.put(iCIdentifier.getAddress(), l2);
    }

    public Long getGlobalVarValue(ICIdentifier iCIdentifier, boolean bl) {
        Assert.a(iCIdentifier.getIdentifierClass() == CIdentifierClass.GLOBAL);
        long l2 = iCIdentifier.getAddress();
        Long l3 = this.globalVarValues.get(l2);
        if (l3 == null && bl) {
            l3 = this.readMemory(l2, this.getTypeSize(iCIdentifier.getType()));
            this.globalVarValues.put(l2, l3);
        }
        return l3;
    }

    public void writeMemory(long l2, long l3) {
        this.dummyWrittenMemory.put(l2, l3);
    }

    public Long readMemory(long l2, int n2) {
        Long l3 = this.dummyWrittenMemory.get(l2);
        if (l3 != null) {
            return l3;
        }
        Long.valueOf(0L);
        byte[] byArray = new byte[n2];
        try {
            this.nativeUnit.getMemory().read(l2, n2, byArray, 0);
            switch (n2) {
                case 8: {
                    l3 = ByteBuffer.wrap(byArray).order(this.endianness.toByteOrder()).getLong();
                    break;
                }
                case 4: {
                    l3 = (long)ByteBuffer.wrap(byArray).order(this.endianness.toByteOrder()).getInt() & 0xFFFFFFFFL;
                    break;
                }
                default: {
                    throw new CSimulationException(Strings.ff("TBI: global var size (%d)", n2));
                }
            }
        }
        catch (MemoryException memoryException) {
            throw new CSimulationException("error when reading gvar value");
        }
        return l3;
    }

    public void setVarAddress(ICIdentifier iCIdentifier, long l2) {
        this.memoryAddress.put(iCIdentifier.getName(), l2);
    }

    public Long getVarAddress(ICIdentifier iCIdentifier) {
        String string = iCIdentifier.getName();
        Long l2 = this.memoryAddress.get(string);
        if (l2 == null) {
            if (iCIdentifier.getIdentifierClass() == CIdentifierClass.LOCAL || iCIdentifier.getIdentifierClass() == CIdentifierClass.GLOBAL) {
                l2 = iCIdentifier.getAddress();
                this.memoryAddress.put(string, l2);
            } else {
                throw new CSimulationException(Strings.ff("TBI: get address for var (%s)", iCIdentifier));
            }
        }
        return l2;
    }

    public Integer getDefaultPointedSize() {
        return this.defaultPointedSize;
    }

    public void setDefaultPointedSize(Integer n2) {
        this.defaultPointedSize = n2;
    }

    public boolean isAutoGenerateUndefinedIdentifierValue() {
        return this.autoGenerateUndefinedIdentifierValue;
    }

    public void setAutoGenerateUndefinedIdentifierValue(boolean bl) {
        this.autoGenerateUndefinedIdentifierValue = bl;
    }

    public long getPassedParameterValue(ICIdentifier iCIdentifier) {
        this.routinePassedParametersValue *= 2L;
        return this.routinePassedParametersValue;
    }

    public static boolean areEquivalent(CEnvironment cEnvironment, CEnvironment cEnvironment2) {
        if (!cEnvironment.dummyWrittenMemory.equals(cEnvironment2.dummyWrittenMemory)) {
            return false;
        }
        return cEnvironment.globalVarValues.equals(cEnvironment2.globalVarValues);
    }

    public void clearState() {
        this.dummyWrittenMemory.clear();
        this.globalVarValues.clear();
    }

    public String toString() {
        return "CEnvironment [dummyWrittenMemory=" + this.dummyWrittenMemory + ", globalVarValues=" + this.globalVarValues + "]";
    }
}

