/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.opt;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.opt.AbstractCBlockOptimizer;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;

public abstract class AbstractCElementOptimizer
extends AbstractCBlockOptimizer {
    private static final StructuredLogger logger = aeb.ce(AbstractCElementOptimizer.class);
    private boolean innerReplacement = false;

    public AbstractCElementOptimizer() {
        this(false);
    }

    public AbstractCElementOptimizer(boolean bl) {
        this.innerReplacement = bl;
    }

    @Override
    protected final int optimizeBlock(ICBlock iCBlock) {
        return this.optimizeSubElements(iCBlock);
    }

    private int optimizeSubElements(ICElement iCElement) {
        if (CUtil.isClassMethodField(iCElement)) {
            return 0;
        }
        int n2 = 0;
        for (ICElement iCElement2 : iCElement.getSubElements()) {
            n2 += this.optimizeSubElements(iCElement2);
            ICElement iCElement3 = this.optimizeElement(iCElement2, iCElement);
            if (iCElement3 == null) continue;
            if (this.innerReplacement || iCElement.replaceSubElement(iCElement2, iCElement3)) {
                ++n2;
                continue;
            }
            logger.error("Error while replacing %s by %s", iCElement2, iCElement3);
        }
        return n2;
    }

    protected abstract ICElement optimizeElement(ICElement var1, ICElement var2);
}

